/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.mtp.MtpDeviceInfo;
import android.mtp.MtpEvent;
import android.mtp.MtpObjectInfo;
import android.mtp.MtpStorageInfo;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import com.android.internal.util.Preconditions;
import java.io.IOException;

public final class MtpDevice {
    private static final String TAG = "MtpDevice";
    private final UsbDevice mDevice;
    private long mNativeContext;

    public MtpDevice(UsbDevice device) {
        this.mDevice = device;
    }

    public boolean open(UsbDeviceConnection connection) {
        boolean result = this.native_open(this.mDevice.getDeviceName(), connection.getFileDescriptor());
        if (!result) {
            connection.close();
        }
        return result;
    }

    public void close() {
        this.native_close();
    }

    protected void finalize() throws Throwable {
        try {
            this.native_close();
        }
        finally {
            super.finalize();
        }
    }

    public String getDeviceName() {
        return this.mDevice.getDeviceName();
    }

    public int getDeviceId() {
        return this.mDevice.getDeviceId();
    }

    public String toString() {
        return this.mDevice.getDeviceName();
    }

    public MtpDeviceInfo getDeviceInfo() {
        return this.native_get_device_info();
    }

    public int[] getStorageIds() {
        return this.native_get_storage_ids();
    }

    public int[] getObjectHandles(int storageId, int format, int objectHandle) {
        return this.native_get_object_handles(storageId, format, objectHandle);
    }

    public byte[] getObject(int objectHandle, int objectSize) {
        Preconditions.checkArgumentNonnegative(objectSize, "objectSize should not be negative");
        return this.native_get_object(objectHandle, objectSize);
    }

    public long getPartialObject(int objectHandle, long offset, long size, byte[] buffer) throws IOException {
        return this.native_get_partial_object(objectHandle, offset, size, buffer);
    }

    public long getPartialObject64(int objectHandle, long offset, long size, byte[] buffer) throws IOException {
        return this.native_get_partial_object_64(objectHandle, offset, size, buffer);
    }

    public byte[] getThumbnail(int objectHandle) {
        return this.native_get_thumbnail(objectHandle);
    }

    public MtpStorageInfo getStorageInfo(int storageId) {
        return this.native_get_storage_info(storageId);
    }

    public MtpObjectInfo getObjectInfo(int objectHandle) {
        return this.native_get_object_info(objectHandle);
    }

    public boolean deleteObject(int objectHandle) {
        return this.native_delete_object(objectHandle);
    }

    public long getParent(int objectHandle) {
        return this.native_get_parent(objectHandle);
    }

    public long getStorageId(int objectHandle) {
        return this.native_get_storage_id(objectHandle);
    }

    public boolean importFile(int objectHandle, String destPath) {
        return this.native_import_file(objectHandle, destPath);
    }

    public boolean importFile(int objectHandle, ParcelFileDescriptor descriptor) {
        return this.native_import_file(objectHandle, descriptor.getFd());
    }

    public boolean sendObject(int objectHandle, long size, ParcelFileDescriptor descriptor) {
        return this.native_send_object(objectHandle, size, descriptor.getFd());
    }

    public MtpObjectInfo sendObjectInfo(MtpObjectInfo info) {
        return this.native_send_object_info(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MtpEvent readEvent(CancellationSignal signal) throws IOException {
        final int handle = this.native_submit_event_request();
        Preconditions.checkState(handle >= 0, "Other thread is reading an event.");
        if (signal != null) {
            signal.setOnCancelListener(new CancellationSignal.OnCancelListener(){

                @Override
                public void onCancel() {
                    MtpDevice.this.native_discard_event_request(handle);
                }
            });
        }
        try {
            MtpEvent mtpEvent = this.native_reap_event_request(handle);
            return mtpEvent;
        }
        finally {
            if (signal != null) {
                signal.setOnCancelListener(null);
            }
        }
    }

    public long getObjectSizeLong(int handle, int format) throws IOException {
        return this.native_get_object_size_long(handle, format);
    }

    private native boolean native_open(String var1, int var2);

    private native void native_close();

    private native MtpDeviceInfo native_get_device_info();

    private native int[] native_get_storage_ids();

    private native MtpStorageInfo native_get_storage_info(int var1);

    private native int[] native_get_object_handles(int var1, int var2, int var3);

    private native MtpObjectInfo native_get_object_info(int var1);

    private native byte[] native_get_object(int var1, long var2);

    private native long native_get_partial_object(int var1, long var2, long var4, byte[] var6) throws IOException;

    private native int native_get_partial_object_64(int var1, long var2, long var4, byte[] var6) throws IOException;

    private native byte[] native_get_thumbnail(int var1);

    private native boolean native_delete_object(int var1);

    private native int native_get_parent(int var1);

    private native int native_get_storage_id(int var1);

    private native boolean native_import_file(int var1, String var2);

    private native boolean native_import_file(int var1, int var2);

    private native boolean native_send_object(int var1, long var2, int var4);

    private native MtpObjectInfo native_send_object_info(MtpObjectInfo var1);

    private native int native_submit_event_request() throws IOException;

    private native MtpEvent native_reap_event_request(int var1) throws IOException;

    private native void native_discard_event_request(int var1);

    private native long native_get_object_size_long(int var1, int var2) throws IOException;

    static {
        System.loadLibrary("media_jni");
    }
}

