/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.mtp.MtpDatabase;
import android.mtp.MtpStorage;

public class MtpServer
implements Runnable {
    private long mNativeContext;
    private final MtpDatabase mDatabase;

    public MtpServer(MtpDatabase database, boolean usePtp) {
        this.mDatabase = database;
        this.native_setup(database, usePtp);
        database.setServer(this);
    }

    public void start() {
        Thread thread = new Thread((Runnable)this, "MtpServer");
        thread.start();
    }

    @Override
    public void run() {
        this.native_run();
        this.native_cleanup();
        this.mDatabase.close();
    }

    public void sendObjectAdded(int handle) {
        this.native_send_object_added(handle);
    }

    public void sendObjectRemoved(int handle) {
        this.native_send_object_removed(handle);
    }

    public void sendDevicePropertyChanged(int property) {
        this.native_send_device_property_changed(property);
    }

    public void addStorage(MtpStorage storage) {
        this.native_add_storage(storage);
    }

    public void removeStorage(MtpStorage storage) {
        this.native_remove_storage(storage.getStorageId());
    }

    private final native void native_setup(MtpDatabase var1, boolean var2);

    private final native void native_run();

    private final native void native_cleanup();

    private final native void native_send_object_added(int var1);

    private final native void native_send_object_removed(int var1);

    private final native void native_send_device_property_changed(int var1);

    private final native void native_add_storage(MtpStorage var1);

    private final native void native_remove_storage(int var1);

    static {
        System.loadLibrary("media_jni");
    }
}

