/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.net.ConnectivityMetricsEvent;
import android.net.IConnectivityMetricsLogger;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class ConnectivityMetricsLogger {
    private static String TAG = "ConnectivityMetricsLogger";
    private static final boolean DBG = true;
    public static final String CONNECTIVITY_METRICS_LOGGER_SERVICE = "connectivity_metrics_logger";
    public static final int COMPONENT_TAG_CONNECTIVITY = 0;
    public static final int COMPONENT_TAG_BLUETOOTH = 1;
    public static final int COMPONENT_TAG_WIFI = 2;
    public static final int COMPONENT_TAG_TELECOM = 3;
    public static final int COMPONENT_TAG_TELEPHONY = 4;
    public static final int NUMBER_OF_COMPONENTS = 5;
    public static final int TAG_SKIPPED_EVENTS = -1;
    public static final String DATA_KEY_EVENTS_COUNT = "count";
    protected IConnectivityMetricsLogger mService;
    protected volatile long mServiceUnblockedTimestampMillis;
    private int mNumSkippedEvents;

    public ConnectivityMetricsLogger() {
        this(IConnectivityMetricsLogger.Stub.asInterface(ServiceManager.getService(CONNECTIVITY_METRICS_LOGGER_SERVICE)));
    }

    public ConnectivityMetricsLogger(IConnectivityMetricsLogger service) {
        this.mService = service;
    }

    protected boolean checkLoggerService() {
        if (this.mService != null) {
            return true;
        }
        this.mService = IConnectivityMetricsLogger.Stub.asInterface(ServiceManager.getService(CONNECTIVITY_METRICS_LOGGER_SERVICE));
        return this.mService != null;
    }

    public void logEvent(long timestamp, int componentTag, int eventTag, Parcelable data) {
        if (this.mService == null) {
            Log.d(TAG, "logEvent(" + componentTag + "," + eventTag + ") Service not ready");
            return;
        }
        if (this.mServiceUnblockedTimestampMillis > 0L && System.currentTimeMillis() < this.mServiceUnblockedTimestampMillis) {
            ++this.mNumSkippedEvents;
            return;
        }
        ConnectivityMetricsEvent skippedEventsEvent = null;
        if (this.mNumSkippedEvents > 0) {
            Bundle b = new Bundle();
            b.putInt(DATA_KEY_EVENTS_COUNT, this.mNumSkippedEvents);
            skippedEventsEvent = new ConnectivityMetricsEvent(this.mServiceUnblockedTimestampMillis, componentTag, -1, b);
            this.mServiceUnblockedTimestampMillis = 0L;
        }
        ConnectivityMetricsEvent event = new ConnectivityMetricsEvent(timestamp, componentTag, eventTag, data);
        try {
            long result = skippedEventsEvent == null ? this.mService.logEvent(event) : this.mService.logEvents(new ConnectivityMetricsEvent[]{skippedEventsEvent, event});
            if (result == 0L) {
                this.mNumSkippedEvents = 0;
            } else {
                ++this.mNumSkippedEvents;
                if (result > 0L) {
                    this.mServiceUnblockedTimestampMillis = result;
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error logging event", e);
        }
    }

    public ConnectivityMetricsEvent[] getEvents(ConnectivityMetricsEvent.Reference reference) {
        try {
            return this.mService.getEvents(reference);
        }
        catch (RemoteException e) {
            Log.e(TAG, "IConnectivityMetricsLogger.getEvents", e);
            return null;
        }
    }

    public boolean register(PendingIntent newEventsIntent) {
        try {
            return this.mService.register(newEventsIntent);
        }
        catch (RemoteException e) {
            Log.e(TAG, "IConnectivityMetricsLogger.register", e);
            return false;
        }
    }

    public boolean unregister(PendingIntent newEventsIntent) {
        try {
            this.mService.unregister(newEventsIntent);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "IConnectivityMetricsLogger.unregister", e);
            return false;
        }
    }
}

