/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public final class NetworkCapabilities
implements Parcelable {
    private long mNetworkCapabilities;
    public static final int NET_CAPABILITY_MMS = 0;
    public static final int NET_CAPABILITY_SUPL = 1;
    public static final int NET_CAPABILITY_DUN = 2;
    public static final int NET_CAPABILITY_FOTA = 3;
    public static final int NET_CAPABILITY_IMS = 4;
    public static final int NET_CAPABILITY_CBS = 5;
    public static final int NET_CAPABILITY_WIFI_P2P = 6;
    public static final int NET_CAPABILITY_IA = 7;
    public static final int NET_CAPABILITY_RCS = 8;
    public static final int NET_CAPABILITY_XCAP = 9;
    public static final int NET_CAPABILITY_EIMS = 10;
    public static final int NET_CAPABILITY_NOT_METERED = 11;
    public static final int NET_CAPABILITY_INTERNET = 12;
    public static final int NET_CAPABILITY_NOT_RESTRICTED = 13;
    public static final int NET_CAPABILITY_TRUSTED = 14;
    public static final int NET_CAPABILITY_NOT_VPN = 15;
    public static final int NET_CAPABILITY_VALIDATED = 16;
    public static final int NET_CAPABILITY_CAPTIVE_PORTAL = 17;
    private static final int MIN_NET_CAPABILITY = 0;
    private static final int MAX_NET_CAPABILITY = 17;
    private static final long MUTABLE_CAPABILITIES = 212992L;
    public static final String MATCH_ALL_REQUESTS_NETWORK_SPECIFIER = "*";
    private static final long NON_REQUESTABLE_CAPABILITIES = 196608L;
    private static final long DEFAULT_CAPABILITIES = 57344L;
    private static final long RESTRICTED_CAPABILITIES = 1980L;
    private long mTransportTypes;
    public static final int TRANSPORT_CELLULAR = 0;
    public static final int TRANSPORT_WIFI = 1;
    public static final int TRANSPORT_BLUETOOTH = 2;
    public static final int TRANSPORT_ETHERNET = 3;
    public static final int TRANSPORT_VPN = 4;
    private static final int MIN_TRANSPORT = 0;
    private static final int MAX_TRANSPORT = 4;
    private int mLinkUpBandwidthKbps;
    private int mLinkDownBandwidthKbps;
    private String mNetworkSpecifier;
    public static final int SIGNAL_STRENGTH_UNSPECIFIED = Integer.MIN_VALUE;
    private int mSignalStrength;
    public static final Parcelable.Creator<NetworkCapabilities> CREATOR = new Parcelable.Creator<NetworkCapabilities>(){

        @Override
        public NetworkCapabilities createFromParcel(Parcel in) {
            NetworkCapabilities netCap = new NetworkCapabilities();
            netCap.mNetworkCapabilities = in.readLong();
            netCap.mTransportTypes = in.readLong();
            netCap.mLinkUpBandwidthKbps = in.readInt();
            netCap.mLinkDownBandwidthKbps = in.readInt();
            netCap.mNetworkSpecifier = in.readString();
            netCap.mSignalStrength = in.readInt();
            return netCap;
        }

        public NetworkCapabilities[] newArray(int size) {
            return new NetworkCapabilities[size];
        }
    };

    public NetworkCapabilities() {
        this.clearAll();
        this.mNetworkCapabilities = 57344L;
    }

    public NetworkCapabilities(NetworkCapabilities nc) {
        if (nc != null) {
            this.mNetworkCapabilities = nc.mNetworkCapabilities;
            this.mTransportTypes = nc.mTransportTypes;
            this.mLinkUpBandwidthKbps = nc.mLinkUpBandwidthKbps;
            this.mLinkDownBandwidthKbps = nc.mLinkDownBandwidthKbps;
            this.mNetworkSpecifier = nc.mNetworkSpecifier;
            this.mSignalStrength = nc.mSignalStrength;
        }
    }

    public void clearAll() {
        this.mTransportTypes = 0L;
        this.mNetworkCapabilities = 0L;
        this.mLinkDownBandwidthKbps = 0;
        this.mLinkUpBandwidthKbps = 0;
        this.mNetworkSpecifier = null;
        this.mSignalStrength = Integer.MIN_VALUE;
    }

    public NetworkCapabilities addCapability(int capability) {
        if (capability < 0 || capability > 17) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities |= (long)(1 << capability);
        return this;
    }

    public NetworkCapabilities removeCapability(int capability) {
        if (capability < 0 || capability > 17) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities &= (long)(~(1 << capability));
        return this;
    }

    public int[] getCapabilities() {
        return this.enumerateBits(this.mNetworkCapabilities);
    }

    public boolean hasCapability(int capability) {
        if (capability < 0 || capability > 17) {
            return false;
        }
        return (this.mNetworkCapabilities & (long)(1 << capability)) != 0L;
    }

    private int[] enumerateBits(long val) {
        int size = Long.bitCount(val);
        int[] result = new int[size];
        int index = 0;
        int resource = 0;
        while (val > 0L) {
            if ((val & 1L) == 1L) {
                result[index++] = resource;
            }
            val >>= 1;
            ++resource;
        }
        return result;
    }

    private void combineNetCapabilities(NetworkCapabilities nc) {
        this.mNetworkCapabilities |= nc.mNetworkCapabilities;
    }

    public String describeFirstNonRequestableCapability() {
        if (this.hasCapability(16)) {
            return "NET_CAPABILITY_VALIDATED";
        }
        if (this.hasCapability(17)) {
            return "NET_CAPABILITY_CAPTIVE_PORTAL";
        }
        if ((this.mNetworkCapabilities & 0x30000L) != 0L) {
            return "unknown non-requestable capabilities " + Long.toHexString(this.mNetworkCapabilities);
        }
        if (this.mLinkUpBandwidthKbps != 0 || this.mLinkDownBandwidthKbps != 0) {
            return "link bandwidth";
        }
        if (this.hasSignalStrength()) {
            return "signalStrength";
        }
        return null;
    }

    private boolean satisfiedByNetCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        long networkCapabilities = this.mNetworkCapabilities;
        if (onlyImmutable) {
            networkCapabilities &= 0xFFFFFFFFFFFCBFFFL;
        }
        return (nc.mNetworkCapabilities & networkCapabilities) == networkCapabilities;
    }

    public boolean equalsNetCapabilities(NetworkCapabilities nc) {
        return nc.mNetworkCapabilities == this.mNetworkCapabilities;
    }

    private boolean equalsNetCapabilitiesImmutable(NetworkCapabilities that) {
        return (this.mNetworkCapabilities & 0xFFFFFFFFFFFCBFFFL) == (that.mNetworkCapabilities & 0xFFFFFFFFFFFCBFFFL);
    }

    public void maybeMarkCapabilitiesRestricted() {
        if ((this.mNetworkCapabilities & 0xFFFFFFFFFFFF1843L) == 0L && (this.mNetworkCapabilities & 0x7BCL) != 0L) {
            this.removeCapability(13);
        }
    }

    public NetworkCapabilities addTransportType(int transportType) {
        if (transportType < 0 || transportType > 4) {
            throw new IllegalArgumentException("TransportType out of range");
        }
        this.mTransportTypes |= (long)(1 << transportType);
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public NetworkCapabilities removeTransportType(int transportType) {
        if (transportType < 0 || transportType > 4) {
            throw new IllegalArgumentException("TransportType out of range");
        }
        this.mTransportTypes &= (long)(~(1 << transportType));
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public int[] getTransportTypes() {
        return this.enumerateBits(this.mTransportTypes);
    }

    public boolean hasTransport(int transportType) {
        if (transportType < 0 || transportType > 4) {
            return false;
        }
        return (this.mTransportTypes & (long)(1 << transportType)) != 0L;
    }

    private void combineTransportTypes(NetworkCapabilities nc) {
        this.mTransportTypes |= nc.mTransportTypes;
    }

    private boolean satisfiedByTransportTypes(NetworkCapabilities nc) {
        return this.mTransportTypes == 0L || (this.mTransportTypes & nc.mTransportTypes) != 0L;
    }

    public boolean equalsTransportTypes(NetworkCapabilities nc) {
        return nc.mTransportTypes == this.mTransportTypes;
    }

    public void setLinkUpstreamBandwidthKbps(int upKbps) {
        this.mLinkUpBandwidthKbps = upKbps;
    }

    public int getLinkUpstreamBandwidthKbps() {
        return this.mLinkUpBandwidthKbps;
    }

    public void setLinkDownstreamBandwidthKbps(int downKbps) {
        this.mLinkDownBandwidthKbps = downKbps;
    }

    public int getLinkDownstreamBandwidthKbps() {
        return this.mLinkDownBandwidthKbps;
    }

    private void combineLinkBandwidths(NetworkCapabilities nc) {
        this.mLinkUpBandwidthKbps = Math.max(this.mLinkUpBandwidthKbps, nc.mLinkUpBandwidthKbps);
        this.mLinkDownBandwidthKbps = Math.max(this.mLinkDownBandwidthKbps, nc.mLinkDownBandwidthKbps);
    }

    private boolean satisfiedByLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps <= nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps <= nc.mLinkDownBandwidthKbps;
    }

    private boolean equalsLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps == nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps == nc.mLinkDownBandwidthKbps;
    }

    public NetworkCapabilities setNetworkSpecifier(String networkSpecifier) {
        if (!TextUtils.isEmpty(networkSpecifier) && Long.bitCount(this.mTransportTypes) != 1) {
            throw new IllegalStateException("Must have a single transport specified to use setNetworkSpecifier");
        }
        this.mNetworkSpecifier = networkSpecifier;
        return this;
    }

    public String getNetworkSpecifier() {
        return this.mNetworkSpecifier;
    }

    private void combineSpecifiers(NetworkCapabilities nc) {
        String otherSpecifier = nc.getNetworkSpecifier();
        if (TextUtils.isEmpty(otherSpecifier)) {
            return;
        }
        if (!TextUtils.isEmpty(this.mNetworkSpecifier)) {
            throw new IllegalStateException("Can't combine two networkSpecifiers");
        }
        this.setNetworkSpecifier(otherSpecifier);
    }

    private boolean satisfiedBySpecifier(NetworkCapabilities nc) {
        return TextUtils.isEmpty(this.mNetworkSpecifier) || this.mNetworkSpecifier.equals(nc.mNetworkSpecifier) || MATCH_ALL_REQUESTS_NETWORK_SPECIFIER.equals(nc.mNetworkSpecifier);
    }

    private boolean equalsSpecifier(NetworkCapabilities nc) {
        if (TextUtils.isEmpty(this.mNetworkSpecifier)) {
            return TextUtils.isEmpty(nc.mNetworkSpecifier);
        }
        return this.mNetworkSpecifier.equals(nc.mNetworkSpecifier);
    }

    public void setSignalStrength(int signalStrength) {
        this.mSignalStrength = signalStrength;
    }

    public boolean hasSignalStrength() {
        return this.mSignalStrength > Integer.MIN_VALUE;
    }

    public int getSignalStrength() {
        return this.mSignalStrength;
    }

    private void combineSignalStrength(NetworkCapabilities nc) {
        this.mSignalStrength = Math.max(this.mSignalStrength, nc.mSignalStrength);
    }

    private boolean satisfiedBySignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength <= nc.mSignalStrength;
    }

    private boolean equalsSignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength == nc.mSignalStrength;
    }

    public void combineCapabilities(NetworkCapabilities nc) {
        this.combineNetCapabilities(nc);
        this.combineTransportTypes(nc);
        this.combineLinkBandwidths(nc);
        this.combineSpecifiers(nc);
        this.combineSignalStrength(nc);
    }

    private boolean satisfiedByNetworkCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        return !(nc == null || !this.satisfiedByNetCapabilities(nc, onlyImmutable) || !this.satisfiedByTransportTypes(nc) || !onlyImmutable && !this.satisfiedByLinkBandwidths(nc) || !this.satisfiedBySpecifier(nc) || !onlyImmutable && !this.satisfiedBySignalStrength(nc));
    }

    public boolean satisfiedByNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, false);
    }

    public boolean satisfiedByImmutableNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, true);
    }

    public boolean equalImmutableCapabilities(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        return this.equalsNetCapabilitiesImmutable(nc) && this.equalsTransportTypes(nc) && this.equalsSpecifier(nc);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkCapabilities)) {
            return false;
        }
        NetworkCapabilities that = (NetworkCapabilities)obj;
        return this.equalsNetCapabilities(that) && this.equalsTransportTypes(that) && this.equalsLinkBandwidths(that) && this.equalsSignalStrength(that) && this.equalsSpecifier(that);
    }

    public int hashCode() {
        return (int)(this.mNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) + (int)(this.mNetworkCapabilities >> 32) * 3 + (int)(this.mTransportTypes & 0xFFFFFFFFFFFFFFFFL) * 5 + (int)(this.mTransportTypes >> 32) * 7 + this.mLinkUpBandwidthKbps * 11 + this.mLinkDownBandwidthKbps * 13 + (TextUtils.isEmpty(this.mNetworkSpecifier) ? 0 : this.mNetworkSpecifier.hashCode() * 17) + this.mSignalStrength * 19;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mNetworkCapabilities);
        dest.writeLong(this.mTransportTypes);
        dest.writeInt(this.mLinkUpBandwidthKbps);
        dest.writeInt(this.mLinkDownBandwidthKbps);
        dest.writeString(this.mNetworkSpecifier);
        dest.writeInt(this.mSignalStrength);
    }

    public String toString() {
        int[] types = this.getTransportTypes();
        String transports = types.length > 0 ? " Transports: " + NetworkCapabilities.transportNamesOf(types) : "";
        types = this.getCapabilities();
        String capabilities = types.length > 0 ? " Capabilities: " : "";
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 0: {
                    capabilities = capabilities + "MMS";
                    break;
                }
                case 1: {
                    capabilities = capabilities + "SUPL";
                    break;
                }
                case 2: {
                    capabilities = capabilities + "DUN";
                    break;
                }
                case 3: {
                    capabilities = capabilities + "FOTA";
                    break;
                }
                case 4: {
                    capabilities = capabilities + "IMS";
                    break;
                }
                case 5: {
                    capabilities = capabilities + "CBS";
                    break;
                }
                case 6: {
                    capabilities = capabilities + "WIFI_P2P";
                    break;
                }
                case 7: {
                    capabilities = capabilities + "IA";
                    break;
                }
                case 8: {
                    capabilities = capabilities + "RCS";
                    break;
                }
                case 9: {
                    capabilities = capabilities + "XCAP";
                    break;
                }
                case 10: {
                    capabilities = capabilities + "EIMS";
                    break;
                }
                case 11: {
                    capabilities = capabilities + "NOT_METERED";
                    break;
                }
                case 12: {
                    capabilities = capabilities + "INTERNET";
                    break;
                }
                case 13: {
                    capabilities = capabilities + "NOT_RESTRICTED";
                    break;
                }
                case 14: {
                    capabilities = capabilities + "TRUSTED";
                    break;
                }
                case 15: {
                    capabilities = capabilities + "NOT_VPN";
                    break;
                }
                case 16: {
                    capabilities = capabilities + "VALIDATED";
                    break;
                }
                case 17: {
                    capabilities = capabilities + "CAPTIVE_PORTAL";
                }
            }
            if (++i >= types.length) continue;
            capabilities = capabilities + "&";
        }
        String upBand = this.mLinkUpBandwidthKbps > 0 ? " LinkUpBandwidth>=" + this.mLinkUpBandwidthKbps + "Kbps" : "";
        String dnBand = this.mLinkDownBandwidthKbps > 0 ? " LinkDnBandwidth>=" + this.mLinkDownBandwidthKbps + "Kbps" : "";
        String specifier = this.mNetworkSpecifier == null ? "" : " Specifier: <" + this.mNetworkSpecifier + ">";
        String signalStrength = this.hasSignalStrength() ? " SignalStrength: " + this.mSignalStrength : "";
        return "[" + transports + capabilities + upBand + dnBand + specifier + signalStrength + "]";
    }

    public static String transportNamesOf(int[] types) {
        String transports = "";
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 0: {
                    transports = transports + "CELLULAR";
                    break;
                }
                case 1: {
                    transports = transports + "WIFI";
                    break;
                }
                case 2: {
                    transports = transports + "BLUETOOTH";
                    break;
                }
                case 3: {
                    transports = transports + "ETHERNET";
                    break;
                }
                case 4: {
                    transports = transports + "VPN";
                }
            }
            if (++i >= types.length) continue;
            transports = transports + "|";
        }
        return transports;
    }
}

