/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.ConnectivityMetricsEvent;
import android.net.ConnectivityMetricsLogger;
import android.net.IConnectivityMetricsLogger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;

public class IpConnectivityLog
extends ConnectivityMetricsLogger {
    private static String TAG = "IpConnectivityMetricsLogger";
    private static final boolean DBG = true;

    public IpConnectivityLog() {
    }

    public IpConnectivityLog(IConnectivityMetricsLogger service) {
        super(service);
    }

    public boolean log(long timestamp, Parcelable data) {
        if (!this.checkLoggerService()) {
            Log.d(TAG, "connectivity_metrics_logger service was not ready");
            return false;
        }
        if (System.currentTimeMillis() < this.mServiceUnblockedTimestampMillis) {
            Log.d(TAG, "skipping logging due to throttling for IpConnectivity component");
            return false;
        }
        try {
            ConnectivityMetricsEvent event = new ConnectivityMetricsEvent(timestamp, 0, 0, data);
            long result = this.mService.logEvent(event);
            if (result >= 0L) {
                this.mServiceUnblockedTimestampMillis = result;
            }
            return result == 0L;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error logging event", e);
            return false;
        }
    }

    public void log(Parcelable event) {
        this.log(System.currentTimeMillis(), event);
    }
}

