/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.android.internal.util.MessageUtils;

public final class ValidationProbeEvent
implements Parcelable {
    public static final int PROBE_DNS = 0;
    public static final int PROBE_HTTP = 1;
    public static final int PROBE_HTTPS = 2;
    public static final int PROBE_PAC = 3;
    public static final int DNS_FAILURE = 0;
    public static final int DNS_SUCCESS = 1;
    public final int netId;
    public final long durationMs;
    public final int probeType;
    public final int returnCode;
    public static final Parcelable.Creator<ValidationProbeEvent> CREATOR = new Parcelable.Creator<ValidationProbeEvent>(){

        @Override
        public ValidationProbeEvent createFromParcel(Parcel in) {
            return new ValidationProbeEvent(in);
        }

        public ValidationProbeEvent[] newArray(int size) {
            return new ValidationProbeEvent[size];
        }
    };

    public ValidationProbeEvent(int netId, long durationMs, int probeType, int returnCode) {
        this.netId = netId;
        this.durationMs = durationMs;
        this.probeType = probeType;
        this.returnCode = returnCode;
    }

    private ValidationProbeEvent(Parcel in) {
        this.netId = in.readInt();
        this.durationMs = in.readLong();
        this.probeType = in.readInt();
        this.returnCode = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.netId);
        out.writeLong(this.durationMs);
        out.writeInt(this.probeType);
        out.writeInt(this.returnCode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static String getProbeName(int probeType) {
        return Decoder.constants.get(probeType, "PROBE_???");
    }

    public static void logEvent(int netId, long durationMs, int probeType, int returnCode) {
    }

    public String toString() {
        return String.format("ValidationProbeEvent(%d, %s:%d, %dms)", this.netId, ValidationProbeEvent.getProbeName(this.probeType), this.returnCode, this.durationMs);
    }

    static final class Decoder {
        static final SparseArray<String> constants = MessageUtils.findMessageNames(new Class[]{ValidationProbeEvent.class}, new String[]{"PROBE_"});

        Decoder() {
        }
    }
}

