/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Slog;

public class AvoidBadWifiTracker {
    private static String TAG = AvoidBadWifiTracker.class.getSimpleName();
    private final Context mContext;
    private final Handler mHandler;
    private final Runnable mReevaluateRunnable;
    private final SettingObserver mSettingObserver;
    private volatile boolean mAvoidBadWifi = true;

    public AvoidBadWifiTracker(Context ctx, Handler handler) {
        this(ctx, handler, null);
    }

    public AvoidBadWifiTracker(Context ctx, Handler handler, Runnable cb) {
        this.mContext = ctx;
        this.mHandler = handler;
        this.mReevaluateRunnable = () -> {
            if (this.update() && cb != null) {
                cb.run();
            }
        };
        this.mSettingObserver = new SettingObserver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                AvoidBadWifiTracker.this.reevaluate();
            }
        }, UserHandle.ALL, intentFilter, null, null);
        this.update();
    }

    public boolean currentValue() {
        return this.mAvoidBadWifi;
    }

    public boolean configRestrictsAvoidBadWifi() {
        return this.mContext.getResources().getInteger(0x10E0011) == 0;
    }

    public boolean shouldNotifyWifiUnvalidated() {
        return this.configRestrictsAvoidBadWifi() && this.getSettingsValue() == null;
    }

    public String getSettingsValue() {
        ContentResolver resolver = this.mContext.getContentResolver();
        return Settings.Global.getString(resolver, "network_avoid_bad_wifi");
    }

    public void reevaluate() {
        this.mHandler.post(this.mReevaluateRunnable);
    }

    public boolean update() {
        boolean settingAvoidBadWifi = "1".equals(this.getSettingsValue());
        boolean prev = this.mAvoidBadWifi;
        this.mAvoidBadWifi = settingAvoidBadWifi || !this.configRestrictsAvoidBadWifi();
        return this.mAvoidBadWifi != prev;
    }

    private class SettingObserver
    extends ContentObserver {
        private final Uri mUri;

        public SettingObserver() {
            super(null);
            this.mUri = Settings.Global.getUriFor("network_avoid_bad_wifi");
            ContentResolver resolver = AvoidBadWifiTracker.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.mUri, false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            Slog.wtf(TAG, "Should never be reached.");
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (!this.mUri.equals(uri)) {
                return;
            }
            AvoidBadWifiTracker.this.reevaluate();
        }
    }
}

