/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nan;

import android.net.wifi.nan.TlvBufferUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public class PublishData
implements Parcelable {
    public final String mServiceName;
    public final int mServiceSpecificInfoLength;
    public final byte[] mServiceSpecificInfo;
    public final int mTxFilterLength;
    public final byte[] mTxFilter;
    public final int mRxFilterLength;
    public final byte[] mRxFilter;
    public static final Parcelable.Creator<PublishData> CREATOR = new Parcelable.Creator<PublishData>(){

        public PublishData[] newArray(int size) {
            return new PublishData[size];
        }

        @Override
        public PublishData createFromParcel(Parcel in) {
            String serviceName = in.readString();
            int ssiLength = in.readInt();
            byte[] ssi = new byte[ssiLength];
            if (ssiLength != 0) {
                in.readByteArray(ssi);
            }
            int txFilterLength = in.readInt();
            byte[] txFilter = new byte[txFilterLength];
            if (txFilterLength != 0) {
                in.readByteArray(txFilter);
            }
            int rxFilterLength = in.readInt();
            byte[] rxFilter = new byte[rxFilterLength];
            if (rxFilterLength != 0) {
                in.readByteArray(rxFilter);
            }
            return new PublishData(serviceName, ssi, ssiLength, txFilter, txFilterLength, rxFilter, rxFilterLength);
        }
    };

    private PublishData(String serviceName, byte[] serviceSpecificInfo, int serviceSpecificInfoLength, byte[] txFilter, int txFilterLength, byte[] rxFilter, int rxFilterLength) {
        this.mServiceName = serviceName;
        this.mServiceSpecificInfoLength = serviceSpecificInfoLength;
        this.mServiceSpecificInfo = serviceSpecificInfo;
        this.mTxFilterLength = txFilterLength;
        this.mTxFilter = txFilter;
        this.mRxFilterLength = rxFilterLength;
        this.mRxFilter = rxFilter;
    }

    public String toString() {
        return "PublishData [mServiceName='" + this.mServiceName + "', mServiceSpecificInfo='" + new String(this.mServiceSpecificInfo, 0, this.mServiceSpecificInfoLength) + "', mTxFilter=" + new TlvBufferUtils.TlvIterable(0, 1, this.mTxFilter, this.mTxFilterLength).toString() + ", mRxFilter=" + new TlvBufferUtils.TlvIterable(0, 1, this.mRxFilter, this.mRxFilterLength).toString() + "']";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mServiceName);
        dest.writeInt(this.mServiceSpecificInfoLength);
        if (this.mServiceSpecificInfoLength != 0) {
            dest.writeByteArray(this.mServiceSpecificInfo, 0, this.mServiceSpecificInfoLength);
        }
        dest.writeInt(this.mTxFilterLength);
        if (this.mTxFilterLength != 0) {
            dest.writeByteArray(this.mTxFilter, 0, this.mTxFilterLength);
        }
        dest.writeInt(this.mRxFilterLength);
        if (this.mRxFilterLength != 0) {
            dest.writeByteArray(this.mRxFilter, 0, this.mRxFilterLength);
        }
    }

    public boolean equals(Object o) {
        int i;
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishData)) {
            return false;
        }
        PublishData lhs = (PublishData)o;
        if (!this.mServiceName.equals(lhs.mServiceName) || this.mServiceSpecificInfoLength != lhs.mServiceSpecificInfoLength || this.mTxFilterLength != lhs.mTxFilterLength || this.mRxFilterLength != lhs.mRxFilterLength) {
            return false;
        }
        if (this.mServiceSpecificInfo != null && lhs.mServiceSpecificInfo != null) {
            for (i = 0; i < this.mServiceSpecificInfoLength; ++i) {
                if (this.mServiceSpecificInfo[i] == lhs.mServiceSpecificInfo[i]) continue;
                return false;
            }
        } else if (this.mServiceSpecificInfoLength != 0) {
            return false;
        }
        if (this.mTxFilter != null && lhs.mTxFilter != null) {
            for (i = 0; i < this.mTxFilterLength; ++i) {
                if (this.mTxFilter[i] == lhs.mTxFilter[i]) continue;
                return false;
            }
        } else if (this.mTxFilterLength != 0) {
            return false;
        }
        if (this.mRxFilter != null && lhs.mRxFilter != null) {
            for (i = 0; i < this.mRxFilterLength; ++i) {
                if (this.mRxFilter[i] == lhs.mRxFilter[i]) continue;
                return false;
            }
        } else if (this.mRxFilterLength != 0) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.mServiceName.hashCode();
        result = 31 * result + this.mServiceSpecificInfoLength;
        result = 31 * result + Arrays.hashCode(this.mServiceSpecificInfo);
        result = 31 * result + this.mTxFilterLength;
        result = 31 * result + Arrays.hashCode(this.mTxFilter);
        result = 31 * result + this.mRxFilterLength;
        result = 31 * result + Arrays.hashCode(this.mRxFilter);
        return result;
    }

    public static final class Builder {
        private String mServiceName;
        private int mServiceSpecificInfoLength;
        private byte[] mServiceSpecificInfo = new byte[0];
        private int mTxFilterLength;
        private byte[] mTxFilter = new byte[0];
        private int mRxFilterLength;
        private byte[] mRxFilter = new byte[0];

        public Builder setServiceName(String serviceName) {
            this.mServiceName = serviceName;
            return this;
        }

        public Builder setServiceSpecificInfo(byte[] serviceSpecificInfo, int serviceSpecificInfoLength) {
            if (serviceSpecificInfoLength != 0 && (serviceSpecificInfo == null || serviceSpecificInfo.length < serviceSpecificInfoLength)) {
                throw new IllegalArgumentException("Non-matching combination of serviceSpecificInfo and serviceSpecificInfoLength");
            }
            this.mServiceSpecificInfoLength = serviceSpecificInfoLength;
            this.mServiceSpecificInfo = serviceSpecificInfo;
            return this;
        }

        public Builder setServiceSpecificInfo(String serviceSpecificInfoStr) {
            this.mServiceSpecificInfoLength = serviceSpecificInfoStr.length();
            this.mServiceSpecificInfo = serviceSpecificInfoStr.getBytes();
            return this;
        }

        public Builder setTxFilter(byte[] txFilter, int txFilterLength) {
            if (txFilterLength != 0 && (txFilter == null || txFilter.length < txFilterLength)) {
                throw new IllegalArgumentException("Non-matching combination of txFilter and txFilterLength");
            }
            this.mTxFilter = txFilter;
            this.mTxFilterLength = txFilterLength;
            return this;
        }

        public Builder setRxFilter(byte[] rxFilter, int rxFilterLength) {
            if (rxFilterLength != 0 && (rxFilter == null || rxFilter.length < rxFilterLength)) {
                throw new IllegalArgumentException("Non-matching combination of rxFilter and rxFilterLength");
            }
            this.mRxFilter = rxFilter;
            this.mRxFilterLength = rxFilterLength;
            return this;
        }

        public PublishData build() {
            return new PublishData(this.mServiceName, this.mServiceSpecificInfo, this.mServiceSpecificInfoLength, this.mTxFilter, this.mTxFilterLength, this.mRxFilter, this.mRxFilterLength);
        }
    }
}

