/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nan;

import android.os.Parcel;
import android.os.Parcelable;

public class SubscribeSettings
implements Parcelable {
    public static final int SUBSCRIBE_TYPE_PASSIVE = 0;
    public static final int SUBSCRIBE_TYPE_ACTIVE = 1;
    public final int mSubscribeType;
    public final int mSubscribeCount;
    public final int mTtlSec;
    public static final Parcelable.Creator<SubscribeSettings> CREATOR = new Parcelable.Creator<SubscribeSettings>(){

        public SubscribeSettings[] newArray(int size) {
            return new SubscribeSettings[size];
        }

        @Override
        public SubscribeSettings createFromParcel(Parcel in) {
            int subscribeType = in.readInt();
            int subscribeCount = in.readInt();
            int ttlSec = in.readInt();
            return new SubscribeSettings(subscribeType, subscribeCount, ttlSec);
        }
    };

    private SubscribeSettings(int subscribeType, int publichCount, int ttlSec) {
        this.mSubscribeType = subscribeType;
        this.mSubscribeCount = publichCount;
        this.mTtlSec = ttlSec;
    }

    public String toString() {
        return "SubscribeSettings [mSubscribeType=" + this.mSubscribeType + ", mSubscribeCount=" + this.mSubscribeCount + ", mTtlSec=" + this.mTtlSec + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSubscribeType);
        dest.writeInt(this.mSubscribeCount);
        dest.writeInt(this.mTtlSec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscribeSettings)) {
            return false;
        }
        SubscribeSettings lhs = (SubscribeSettings)o;
        return this.mSubscribeType == lhs.mSubscribeType && this.mSubscribeCount == lhs.mSubscribeCount && this.mTtlSec == lhs.mTtlSec;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.mSubscribeType;
        result = 31 * result + this.mSubscribeCount;
        result = 31 * result + this.mTtlSec;
        return result;
    }

    public static final class Builder {
        int mSubscribeType;
        int mSubscribeCount;
        int mTtlSec;

        public Builder setSubscribeType(int subscribeType) {
            if (subscribeType < 0 || subscribeType > 1) {
                throw new IllegalArgumentException("Invalid subscribeType - " + subscribeType);
            }
            this.mSubscribeType = subscribeType;
            return this;
        }

        public Builder setSubscribeCount(int subscribeCount) {
            if (subscribeCount < 0) {
                throw new IllegalArgumentException("Invalid subscribeCount - must be non-negative");
            }
            this.mSubscribeCount = subscribeCount;
            return this;
        }

        public Builder setTtlSec(int ttlSec) {
            if (ttlSec < 0) {
                throw new IllegalArgumentException("Invalid ttlSec - must be non-negative");
            }
            this.mTtlSec = ttlSec;
            return this;
        }

        public SubscribeSettings build() {
            return new SubscribeSettings(this.mSubscribeType, this.mSubscribeCount, this.mTtlSec);
        }
    }
}

