/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.nan;

import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.util.Iterator;
import libcore.io.Memory;

public class TlvBufferUtils {
    private TlvBufferUtils() {
    }

    public static class TlvIterable
    implements Iterable<TlvElement> {
        private int mTypeSize;
        private int mLengthSize;
        private byte[] mArray;
        private int mArrayLength;

        public TlvIterable(int typeSize, int lengthSize, byte[] array2, int length) {
            if (typeSize < 0 || typeSize > 2 || lengthSize <= 0 || lengthSize > 2) {
                throw new IllegalArgumentException("Invalid sizes - typeSize=" + typeSize + ", lengthSize=" + lengthSize);
            }
            this.mTypeSize = typeSize;
            this.mLengthSize = lengthSize;
            this.mArray = array2;
            this.mArrayLength = length;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            boolean first = true;
            for (TlvElement tlv : this) {
                if (!first) {
                    builder.append(",");
                }
                first = false;
                builder.append(" (");
                if (this.mTypeSize != 0) {
                    builder.append("T=" + tlv.mType + ",");
                }
                builder.append("L=" + tlv.mLength + ") ");
                if (tlv.mLength == 0) {
                    builder.append("<null>");
                } else if (tlv.mLength == 1) {
                    builder.append(tlv.getByte());
                } else if (tlv.mLength == 2) {
                    builder.append(tlv.getShort());
                } else if (tlv.mLength == 4) {
                    builder.append(tlv.getInt());
                } else {
                    builder.append("<bytes>");
                }
                if (tlv.mLength == 0) continue;
                builder.append(" (S='" + tlv.getString() + "')");
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public Iterator<TlvElement> iterator() {
            return new Iterator<TlvElement>(){
                private int mOffset = 0;

                @Override
                public boolean hasNext() {
                    return this.mOffset < mArrayLength;
                }

                @Override
                public TlvElement next() {
                    short type = 0;
                    if (mTypeSize == 1) {
                        type = mArray[this.mOffset];
                    } else if (mTypeSize == 2) {
                        type = Memory.peekShort(mArray, this.mOffset, ByteOrder.BIG_ENDIAN);
                    }
                    this.mOffset += mTypeSize;
                    short length = 0;
                    if (mLengthSize == 1) {
                        length = mArray[this.mOffset];
                    } else if (mLengthSize == 2) {
                        length = Memory.peekShort(mArray, this.mOffset, ByteOrder.BIG_ENDIAN);
                    }
                    this.mOffset += mLengthSize;
                    TlvElement tlv = new TlvElement(type, length, mArray, this.mOffset);
                    this.mOffset += length;
                    return tlv;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class TlvElement {
        public int mType;
        public int mLength;
        public byte[] mRefArray;
        public int mOffset;

        private TlvElement(int type, int length, byte[] refArray, int offset) {
            this.mType = type;
            this.mLength = length;
            this.mRefArray = refArray;
            this.mOffset = offset;
        }

        public byte getByte() {
            if (this.mLength != 1) {
                throw new IllegalArgumentException("Accesing a byte from a TLV element of length " + this.mLength);
            }
            return this.mRefArray[this.mOffset];
        }

        public short getShort() {
            if (this.mLength != 2) {
                throw new IllegalArgumentException("Accesing a short from a TLV element of length " + this.mLength);
            }
            return Memory.peekShort(this.mRefArray, this.mOffset, ByteOrder.BIG_ENDIAN);
        }

        public int getInt() {
            if (this.mLength != 4) {
                throw new IllegalArgumentException("Accesing an int from a TLV element of length " + this.mLength);
            }
            return Memory.peekInt(this.mRefArray, this.mOffset, ByteOrder.BIG_ENDIAN);
        }

        public String getString() {
            return new String(this.mRefArray, this.mOffset, this.mLength);
        }
    }

    public static class TlvConstructor {
        private int mTypeSize;
        private int mLengthSize;
        private byte[] mArray;
        private int mArrayLength;
        private int mPosition;

        public TlvConstructor(int typeSize, int lengthSize) {
            if (typeSize < 0 || typeSize > 2 || lengthSize <= 0 || lengthSize > 2) {
                throw new IllegalArgumentException("Invalid sizes - typeSize=" + typeSize + ", lengthSize=" + lengthSize);
            }
            this.mTypeSize = typeSize;
            this.mLengthSize = lengthSize;
        }

        public TlvConstructor wrap(byte[] array2) {
            this.mArray = array2;
            this.mArrayLength = array2.length;
            return this;
        }

        public TlvConstructor allocate(int capacity) {
            this.mArray = new byte[capacity];
            this.mArrayLength = capacity;
            return this;
        }

        public TlvConstructor putByte(int type, byte b) {
            this.checkLength(1);
            this.addHeader(type, 1);
            this.mArray[this.mPosition++] = b;
            return this;
        }

        public TlvConstructor putByteArray(int type, byte[] array2, int offset, int length) {
            this.checkLength(length);
            this.addHeader(type, length);
            System.arraycopy((byte[])array2, (int)offset, (byte[])this.mArray, (int)this.mPosition, (int)length);
            this.mPosition += length;
            return this;
        }

        public TlvConstructor putByteArray(int type, byte[] array2) {
            return this.putByteArray(type, array2, 0, array2.length);
        }

        public TlvConstructor putZeroLengthElement(int type) {
            this.checkLength(0);
            this.addHeader(type, 0);
            return this;
        }

        public TlvConstructor putShort(int type, short data) {
            this.checkLength(2);
            this.addHeader(type, 2);
            Memory.pokeShort(this.mArray, this.mPosition, data, ByteOrder.BIG_ENDIAN);
            this.mPosition += 2;
            return this;
        }

        public TlvConstructor putInt(int type, int data) {
            this.checkLength(4);
            this.addHeader(type, 4);
            Memory.pokeInt(this.mArray, this.mPosition, data, ByteOrder.BIG_ENDIAN);
            this.mPosition += 4;
            return this;
        }

        public TlvConstructor putString(int type, String data) {
            return this.putByteArray(type, data.getBytes(), 0, data.length());
        }

        public byte[] getArray() {
            return this.mArray;
        }

        public int getActualLength() {
            return this.mPosition;
        }

        private void checkLength(int dataLength) {
            if (this.mPosition + this.mTypeSize + this.mLengthSize + dataLength > this.mArrayLength) {
                throw new BufferOverflowException();
            }
        }

        private void addHeader(int type, int length) {
            if (this.mTypeSize == 1) {
                this.mArray[this.mPosition] = (byte)type;
            } else if (this.mTypeSize == 2) {
                Memory.pokeShort(this.mArray, this.mPosition, (short)type, ByteOrder.BIG_ENDIAN);
            }
            this.mPosition += this.mTypeSize;
            if (this.mLengthSize == 1) {
                this.mArray[this.mPosition] = (byte)length;
            } else if (this.mLengthSize == 2) {
                Memory.pokeShort(this.mArray, this.mPosition, (short)length, ByteOrder.BIG_ENDIAN);
            }
            this.mPosition += this.mLengthSize;
        }
    }
}

