/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.MathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;

public class BaseBundle {
    private static final String TAG = "Bundle";
    static final boolean DEBUG = false;
    static final int BUNDLE_MAGIC = 1279544898;
    static final int FLAG_DEFUSABLE = 1;
    private static final boolean LOG_DEFUSABLE = false;
    private static volatile boolean sShouldDefuse = false;
    ArrayMap<String, Object> mMap = null;
    Parcel mParcelledData = null;
    private ClassLoader mClassLoader;
    int mFlags;

    public static void setShouldDefuse(boolean shouldDefuse) {
        sShouldDefuse = shouldDefuse;
    }

    BaseBundle(ClassLoader loader, int capacity) {
        this.mMap = capacity > 0 ? new ArrayMap(capacity) : new ArrayMap();
        this.mClassLoader = loader == null ? this.getClass().getClassLoader() : loader;
    }

    BaseBundle() {
        this((ClassLoader)null, 0);
    }

    BaseBundle(Parcel parcelledData) {
        this.readFromParcelInner(parcelledData);
    }

    BaseBundle(Parcel parcelledData, int length) {
        this.readFromParcelInner(parcelledData, length);
    }

    BaseBundle(ClassLoader loader) {
        this(loader, 0);
    }

    BaseBundle(int capacity) {
        this((ClassLoader)null, capacity);
    }

    BaseBundle(BaseBundle b) {
        if (b.mParcelledData != null) {
            if (b.isEmptyParcel()) {
                this.mParcelledData = NoImagePreloadHolder.EMPTY_PARCEL;
            } else {
                this.mParcelledData = Parcel.obtain();
                this.mParcelledData.appendFrom(b.mParcelledData, 0, b.mParcelledData.dataSize());
                this.mParcelledData.setDataPosition(0);
            }
        } else {
            this.mParcelledData = null;
        }
        this.mMap = b.mMap != null ? new ArrayMap<String, Object>(b.mMap) : null;
        this.mClassLoader = b.mClassLoader;
    }

    public String getPairValue() {
        this.unparcel();
        int size = this.mMap.size();
        if (size > 1) {
            Log.w(TAG, "getPairValue() used on Bundle with multiple pairs.");
        }
        if (size == 0) {
            return null;
        }
        Object o = this.mMap.valueAt(0);
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            this.typeWarning("getPairValue()", o, "String", e);
            return null;
        }
    }

    void setClassLoader(ClassLoader loader) {
        this.mClassLoader = loader;
    }

    ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void unparcel() {
        BaseBundle baseBundle = this;
        synchronized (baseBundle) {
            block16: {
                Parcel parcelledData = this.mParcelledData;
                if (parcelledData == null) {
                    return;
                }
                if (this.isEmptyParcel()) {
                    if (this.mMap == null) {
                        this.mMap = new ArrayMap(1);
                    } else {
                        this.mMap.erase();
                    }
                    this.mParcelledData = null;
                    return;
                }
                int N = parcelledData.readInt();
                if (N < 0) {
                    return;
                }
                ArrayMap<String, Object> map = this.mMap;
                if (map == null) {
                    map = new ArrayMap(N);
                } else {
                    map.erase();
                    map.ensureCapacity(N);
                }
                try {
                    parcelledData.readArrayMapInternal(map, N, this.mClassLoader);
                }
                catch (BadParcelableException e) {
                    if (sShouldDefuse) {
                        Log.w(TAG, "Failed to parse Bundle, but defusing quietly", e);
                        map.erase();
                        break block16;
                    }
                    throw e;
                }
                finally {
                    this.mMap = map;
                    parcelledData.recycle();
                    this.mParcelledData = null;
                }
            }
        }
    }

    public boolean isParcelled() {
        return this.mParcelledData != null;
    }

    public boolean isEmptyParcel() {
        return this.mParcelledData == NoImagePreloadHolder.EMPTY_PARCEL;
    }

    ArrayMap<String, Object> getMap() {
        this.unparcel();
        return this.mMap;
    }

    public int size() {
        this.unparcel();
        return this.mMap.size();
    }

    public boolean isEmpty() {
        this.unparcel();
        return this.mMap.isEmpty();
    }

    public void clear() {
        this.unparcel();
        this.mMap.clear();
    }

    public boolean containsKey(String key) {
        this.unparcel();
        return this.mMap.containsKey(key);
    }

    public Object get(String key) {
        this.unparcel();
        return this.mMap.get(key);
    }

    public void remove(String key) {
        this.unparcel();
        this.mMap.remove(key);
    }

    public void putAll(PersistableBundle bundle) {
        this.unparcel();
        bundle.unparcel();
        this.mMap.putAll(bundle.mMap);
    }

    void putAll(ArrayMap map) {
        this.unparcel();
        this.mMap.putAll(map);
    }

    public Set<String> keySet() {
        this.unparcel();
        return this.mMap.keySet();
    }

    public void putBoolean(String key, boolean value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putByte(String key, byte value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putChar(String key, char value) {
        this.unparcel();
        this.mMap.put(key, Character.valueOf(value));
    }

    void putShort(String key, short value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putInt(String key, int value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putLong(String key, long value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putFloat(String key, float value) {
        this.unparcel();
        this.mMap.put(key, Float.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putString(String key, String value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putCharSequence(String key, CharSequence value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putIntegerArrayList(String key, ArrayList<Integer> value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putStringArrayList(String key, ArrayList<String> value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putCharSequenceArrayList(String key, ArrayList<CharSequence> value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putSerializable(String key, Serializable value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putBooleanArray(String key, boolean[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putByteArray(String key, byte[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putShortArray(String key, short[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putCharArray(String key, char[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putIntArray(String key, int[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putLongArray(String key, long[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putFloatArray(String key, float[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putDoubleArray(String key, double[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public void putStringArray(String key, String[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    void putCharSequenceArray(String key, CharSequence[] value) {
        this.unparcel();
        this.mMap.put(key, value);
    }

    public boolean getBoolean(String key) {
        this.unparcel();
        return this.getBoolean(key, false);
    }

    void typeWarning(String key, Object value, String className, Object defaultValue, ClassCastException e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key ");
        sb.append(key);
        sb.append(" expected ");
        sb.append(className);
        sb.append(" but value was a ");
        sb.append(value.getClass().getName());
        sb.append(".  The default value ");
        sb.append(defaultValue);
        sb.append(" was returned.");
        Log.w(TAG, sb.toString());
        Log.w(TAG, "Attempt to cast generated internal exception:", e);
    }

    void typeWarning(String key, Object value, String className, ClassCastException e) {
        this.typeWarning(key, value, className, "<null>", e);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Boolean)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Boolean", defaultValue, e);
            return defaultValue;
        }
    }

    byte getByte(String key) {
        this.unparcel();
        return this.getByte(key, (byte)0);
    }

    Byte getByte(String key, byte defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Byte)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Byte", defaultValue, e);
            return defaultValue;
        }
    }

    char getChar(String key) {
        this.unparcel();
        return this.getChar(key, '\u0000');
    }

    char getChar(String key, char defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Character)o).charValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Character", Character.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    short getShort(String key) {
        this.unparcel();
        return this.getShort(key, (short)0);
    }

    short getShort(String key, short defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Short)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Short", defaultValue, e);
            return defaultValue;
        }
    }

    public int getInt(String key) {
        this.unparcel();
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Integer)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Integer", defaultValue, e);
            return defaultValue;
        }
    }

    public long getLong(String key) {
        this.unparcel();
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Long)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Long", defaultValue, e);
            return defaultValue;
        }
    }

    float getFloat(String key) {
        this.unparcel();
        return this.getFloat(key, 0.0f);
    }

    float getFloat(String key, float defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Float)o).floatValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Float", Float.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        this.unparcel();
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return (Double)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Double", defaultValue, e);
            return defaultValue;
        }
    }

    public String getString(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String", e);
            return null;
        }
    }

    public String getString(String key, String defaultValue) {
        String s = this.getString(key);
        return s == null ? defaultValue : s;
    }

    CharSequence getCharSequence(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        try {
            return (CharSequence)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence", e);
            return null;
        }
    }

    CharSequence getCharSequence(String key, CharSequence defaultValue) {
        CharSequence cs = this.getCharSequence(key);
        return cs == null ? defaultValue : cs;
    }

    Serializable getSerializable(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Serializable)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Serializable", e);
            return null;
        }
    }

    ArrayList<Integer> getIntegerArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<Integer>", e);
            return null;
        }
    }

    ArrayList<String> getStringArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<String>", e);
            return null;
        }
    }

    ArrayList<CharSequence> getCharSequenceArrayList(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<CharSequence>", e);
            return null;
        }
    }

    public boolean[] getBooleanArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (boolean[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    byte[] getByteArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (byte[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    short[] getShortArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (short[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "short[]", e);
            return null;
        }
    }

    char[] getCharArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (char[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "char[]", e);
            return null;
        }
    }

    public int[] getIntArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (int[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "int[]", e);
            return null;
        }
    }

    public long[] getLongArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (long[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "long[]", e);
            return null;
        }
    }

    float[] getFloatArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (float[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "float[]", e);
            return null;
        }
    }

    public double[] getDoubleArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (double[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "double[]", e);
            return null;
        }
    }

    public String[] getStringArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (String[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String[]", e);
            return null;
        }
    }

    CharSequence[] getCharSequenceArray(String key) {
        this.unparcel();
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (CharSequence[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence[]", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToParcelInner(Parcel parcel, int flags) {
        Parcel parcelledData;
        BaseBundle baseBundle = this;
        synchronized (baseBundle) {
            parcelledData = this.mParcelledData;
        }
        if (parcelledData != null) {
            if (this.isEmptyParcel()) {
                parcel.writeInt(0);
            } else {
                int length = parcelledData.dataSize();
                parcel.writeInt(length);
                parcel.writeInt(1279544898);
                parcel.appendFrom(parcelledData, 0, length);
            }
        } else {
            if (this.mMap == null || this.mMap.size() <= 0) {
                parcel.writeInt(0);
                return;
            }
            int lengthPos = parcel.dataPosition();
            parcel.writeInt(-1);
            parcel.writeInt(1279544898);
            int startPos = parcel.dataPosition();
            parcel.writeArrayMapInternal(this.mMap);
            int endPos = parcel.dataPosition();
            parcel.setDataPosition(lengthPos);
            int length = endPos - startPos;
            parcel.writeInt(length);
            parcel.setDataPosition(endPos);
        }
    }

    void readFromParcelInner(Parcel parcel) {
        int length = parcel.readInt();
        this.readFromParcelInner(parcel, length);
    }

    private void readFromParcelInner(Parcel parcel, int length) {
        if (length < 0) {
            throw new RuntimeException("Bad length in parcel: " + length);
        }
        if (length == 0) {
            this.mParcelledData = NoImagePreloadHolder.EMPTY_PARCEL;
            return;
        }
        int magic = parcel.readInt();
        if (magic != 1279544898) {
            throw new IllegalStateException("Bad magic number for Bundle: 0x" + Integer.toHexString(magic));
        }
        int offset = parcel.dataPosition();
        parcel.setDataPosition(MathUtils.addOrThrow(offset, length));
        Parcel p = Parcel.obtain();
        p.setDataPosition(0);
        p.appendFrom(parcel, offset, length);
        p.setDataPosition(0);
        this.mParcelledData = p;
    }

    static final class NoImagePreloadHolder {
        public static final Parcel EMPTY_PARCEL = Parcel.obtain();

        NoImagePreloadHolder() {
        }
    }
}

