/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.StrictMode;
import android.os.TransactionTracker;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import libcore.io.IoUtils;

public class Binder
implements IBinder {
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    private static final boolean CHECK_PARCEL_SIZE = false;
    static final String TAG = "Binder";
    public static boolean LOG_RUNTIME_EXCEPTION = false;
    private static String sDumpDisabled = null;
    private static TransactionTracker sTransactionTracker = null;
    private static boolean sTracingEnabled = false;
    private long mObject;
    private IInterface mOwner;
    private String mDescriptor;

    public static void enableTracing() {
        sTracingEnabled = true;
    }

    public static void disableTracing() {
        sTracingEnabled = false;
    }

    public static boolean isTracingEnabled() {
        return sTracingEnabled;
    }

    public static synchronized TransactionTracker getTransactionTracker() {
        if (sTransactionTracker == null) {
            sTransactionTracker = new TransactionTracker();
        }
        return sTransactionTracker;
    }

    public static final native int getCallingPid();

    public static final native int getCallingUid();

    public static final UserHandle getCallingUserHandle() {
        return UserHandle.of(UserHandle.getUserId(Binder.getCallingUid()));
    }

    public static final native long clearCallingIdentity();

    public static final native void restoreCallingIdentity(long var0);

    public static final native void setThreadStrictModePolicy(int var0);

    public static final native int getThreadStrictModePolicy();

    public static final native void flushPendingCommands();

    public static final native void joinThreadPool();

    public static final boolean isProxy(IInterface iface) {
        return iface.asBinder() != iface;
    }

    public static final native void blockUntilThreadAvailable();

    public Binder() {
        this.init();
    }

    public void attachInterface(IInterface owner, String descriptor) {
        this.mOwner = owner;
        this.mDescriptor = descriptor;
    }

    @Override
    public String getInterfaceDescriptor() {
        return this.mDescriptor;
    }

    @Override
    public boolean pingBinder() {
        return true;
    }

    @Override
    public boolean isBinderAlive() {
        return true;
    }

    @Override
    public IInterface queryLocalInterface(String descriptor) {
        if (this.mDescriptor.equals(descriptor)) {
            return this.mOwner;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDumpDisabled(String msg) {
        Class<Binder> clazz = Binder.class;
        synchronized (Binder.class) {
            sDumpDisabled = msg;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == 1598968902) {
            reply.writeString(this.getInterfaceDescriptor());
            return true;
        }
        if (code == 1598311760) {
            ParcelFileDescriptor fd = data.readFileDescriptor();
            String[] args = data.readStringArray();
            if (fd != null) {
                try {
                    this.dump(fd.getFileDescriptor(), args);
                }
                finally {
                    IoUtils.closeQuietly(fd);
                }
            }
            if (reply != null) {
                reply.writeNoException();
            } else {
                StrictMode.clearGatheredViolations();
            }
            return true;
        }
        if (code == 1598246212) {
            ParcelFileDescriptor in = data.readFileDescriptor();
            ParcelFileDescriptor out = data.readFileDescriptor();
            ParcelFileDescriptor err = data.readFileDescriptor();
            String[] args = data.readStringArray();
            ResultReceiver resultReceiver = ResultReceiver.CREATOR.createFromParcel(data);
            try {
                if (out != null) {
                    this.shellCommand(in != null ? in.getFileDescriptor() : null, out.getFileDescriptor(), err != null ? err.getFileDescriptor() : out.getFileDescriptor(), args, resultReceiver);
                }
            }
            finally {
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(out);
                IoUtils.closeQuietly(err);
                if (reply != null) {
                    reply.writeNoException();
                } else {
                    StrictMode.clearGatheredViolations();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        try {
            this.doDump(fd, pw, args);
        }
        finally {
            ((PrintWriter)pw).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDump(FileDescriptor fd, PrintWriter pw, String[] args) {
        Class<Binder> clazz = Binder.class;
        synchronized (Binder.class) {
            String disabled = sDumpDisabled;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (disabled == null) {
                try {
                    this.dump(fd, pw, args);
                }
                catch (SecurityException e) {
                    pw.println("Security exception: " + e.getMessage());
                    throw e;
                }
                catch (Throwable e) {
                    pw.println();
                    pw.println("Exception occurred while dumping:");
                    e.printStackTrace(pw);
                }
            } else {
                pw.println(sDumpDisabled);
            }
            return;
        }
    }

    @Override
    public void dumpAsync(final FileDescriptor fd, final String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        final FastPrintWriter pw = new FastPrintWriter(fout);
        Thread thr = new Thread("Binder.dumpAsync"){

            @Override
            public void run() {
                try {
                    Binder.this.dump(fd, pw, args);
                }
                finally {
                    pw.flush();
                }
            }
        };
        thr.start();
    }

    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
    }

    @Override
    public void shellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ResultReceiver resultReceiver) throws RemoteException {
        this.onShellCommand(in, out, err, args, resultReceiver);
    }

    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ResultReceiver resultReceiver) throws RemoteException {
        FileOutputStream fout = new FileOutputStream(err != null ? err : out);
        FastPrintWriter pw = new FastPrintWriter(fout);
        pw.println("No shell command implementation.");
        ((PrintWriter)pw).flush();
        resultReceiver.send(0, null);
    }

    @Override
    public final boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (data != null) {
            data.setDataPosition(0);
        }
        boolean r = this.onTransact(code, data, reply, flags);
        if (reply != null) {
            reply.setDataPosition(0);
        }
        return r;
    }

    @Override
    public void linkToDeath(IBinder.DeathRecipient recipient, int flags) {
    }

    @Override
    public boolean unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    static void checkParcel(IBinder obj, int code, Parcel parcel, String msg) {
    }

    private final native void init();

    private final native void destroy();

    private boolean execTransact(int code, long dataObj, long replyObj, int flags) {
        boolean res;
        Parcel data = Parcel.obtain(dataObj);
        Parcel reply = Parcel.obtain(replyObj);
        try {
            res = this.onTransact(code, data, reply, flags);
        }
        catch (RemoteException | RuntimeException e) {
            if (LOG_RUNTIME_EXCEPTION) {
                Log.w(TAG, "Caught a RuntimeException from the binder stub implementation.", e);
            }
            if ((flags & 1) != 0) {
                if (e instanceof RemoteException) {
                    Log.w(TAG, "Binder call failed.", e);
                } else {
                    Log.w(TAG, "Caught a RuntimeException from the binder stub implementation.", e);
                }
            } else {
                reply.setDataPosition(0);
                reply.writeException(e);
            }
            res = true;
        }
        catch (OutOfMemoryError e) {
            Log.e(TAG, "Caught an OutOfMemoryError from the binder stub implementation.", e);
            RuntimeException re = new RuntimeException("Out of memory", e);
            reply.setDataPosition(0);
            reply.writeException(re);
            res = true;
        }
        Binder.checkParcel(this, code, reply, "Unreasonably large binder reply buffer");
        reply.recycle();
        data.recycle();
        StrictMode.clearGatheredViolations();
        return res;
    }
}

