/*
 * Decompiled with CFR 0.152.
 */
package android.os;

public abstract class PowerManagerInternal {
    public static final int WAKEFULNESS_ASLEEP = 0;
    public static final int WAKEFULNESS_AWAKE = 1;
    public static final int WAKEFULNESS_DREAMING = 2;
    public static final int WAKEFULNESS_DOZING = 3;
    public static final int POWER_HINT_INTERACTION = 2;
    public static final int POWER_HINT_SUSTAINED_PERFORMANCE_MODE = 6;
    public static final int POWER_HINT_LAUNCH = 8;

    public static String wakefulnessToString(int wakefulness) {
        switch (wakefulness) {
            case 0: {
                return "Asleep";
            }
            case 1: {
                return "Awake";
            }
            case 2: {
                return "Dreaming";
            }
            case 3: {
                return "Dozing";
            }
        }
        return Integer.toString(wakefulness);
    }

    public static boolean isInteractive(int wakefulness) {
        return wakefulness == 1 || wakefulness == 2;
    }

    public abstract void setScreenBrightnessOverrideFromWindowManager(int var1);

    public abstract void setButtonBrightnessOverrideFromWindowManager(int var1);

    public abstract void setUserActivityTimeoutOverrideFromWindowManager(long var1);

    public abstract void setUserInactiveOverrideFromWindowManager();

    public abstract void setMaximumScreenOffTimeoutFromDeviceAdmin(int var1);

    public abstract void setDozeOverrideFromDreamManager(int var1, int var2);

    public abstract boolean getLowPowerModeEnabled();

    public abstract void registerLowPowerModeObserver(LowPowerModeListener var1);

    public abstract boolean setDeviceIdleMode(boolean var1);

    public abstract boolean setLightDeviceIdleMode(boolean var1);

    public abstract void setDeviceIdleWhitelist(int[] var1);

    public abstract void setDeviceIdleTempWhitelist(int[] var1);

    public abstract void updateUidProcState(int var1, int var2);

    public abstract void uidGone(int var1);

    public abstract void powerHint(int var1, int var2);

    public static interface LowPowerModeListener {
        public void onLowPowerModeChanged(boolean var1);
    }
}

