/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;

public final class Trace {
    private static final String TAG = "Trace";
    public static final long TRACE_TAG_NEVER = 0L;
    public static final long TRACE_TAG_ALWAYS = 1L;
    public static final long TRACE_TAG_GRAPHICS = 2L;
    public static final long TRACE_TAG_INPUT = 4L;
    public static final long TRACE_TAG_VIEW = 8L;
    public static final long TRACE_TAG_WEBVIEW = 16L;
    public static final long TRACE_TAG_WINDOW_MANAGER = 32L;
    public static final long TRACE_TAG_ACTIVITY_MANAGER = 64L;
    public static final long TRACE_TAG_SYNC_MANAGER = 128L;
    public static final long TRACE_TAG_AUDIO = 256L;
    public static final long TRACE_TAG_VIDEO = 512L;
    public static final long TRACE_TAG_CAMERA = 1024L;
    public static final long TRACE_TAG_HAL = 2048L;
    public static final long TRACE_TAG_APP = 4096L;
    public static final long TRACE_TAG_RESOURCES = 8192L;
    public static final long TRACE_TAG_DALVIK = 16384L;
    public static final long TRACE_TAG_RS = 32768L;
    public static final long TRACE_TAG_BIONIC = 65536L;
    public static final long TRACE_TAG_POWER = 131072L;
    public static final long TRACE_TAG_PACKAGE_MANAGER = 262144L;
    public static final long TRACE_TAG_SYSTEM_SERVER = 524288L;
    public static final long TRACE_TAG_DATABASE = 0x100000L;
    private static final long TRACE_TAG_NOT_READY = Long.MIN_VALUE;
    private static final int MAX_SECTION_NAME_LEN = 127;
    private static volatile long sEnabledTags = Long.MIN_VALUE;

    private static native long nativeGetEnabledTags();

    private static native void nativeTraceCounter(long var0, String var2, int var3);

    private static native void nativeTraceBegin(long var0, String var2);

    private static native void nativeTraceEnd(long var0);

    private static native void nativeAsyncTraceBegin(long var0, String var2, int var3);

    private static native void nativeAsyncTraceEnd(long var0, String var2, int var3);

    private static native void nativeSetAppTracingAllowed(boolean var0);

    private static native void nativeSetTracingEnabled(boolean var0);

    private Trace() {
    }

    private static long cacheEnabledTags() {
        long tags;
        sEnabledTags = tags = Trace.nativeGetEnabledTags();
        return tags;
    }

    public static boolean isTagEnabled(long traceTag) {
        long tags = sEnabledTags;
        if (tags == Long.MIN_VALUE) {
            tags = Trace.cacheEnabledTags();
        }
        return (tags & traceTag) != 0L;
    }

    public static void traceCounter(long traceTag, String counterName, int counterValue) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceCounter(traceTag, counterName, counterValue);
        }
    }

    public static void setAppTracingAllowed(boolean allowed) {
        Trace.nativeSetAppTracingAllowed(allowed);
        Trace.cacheEnabledTags();
    }

    public static void setTracingEnabled(boolean enabled) {
        Trace.nativeSetTracingEnabled(enabled);
        Trace.cacheEnabledTags();
    }

    public static void traceBegin(long traceTag, String methodName) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceBegin(traceTag, methodName);
        }
    }

    public static void traceEnd(long traceTag) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceEnd(traceTag);
        }
    }

    public static void asyncTraceBegin(long traceTag, String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceBegin(traceTag, methodName, cookie);
        }
    }

    public static void asyncTraceEnd(long traceTag, String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceEnd(traceTag, methodName, cookie);
        }
    }

    public static void beginSection(String sectionName) {
        if (Trace.isTagEnabled(4096L)) {
            if (sectionName.length() > 127) {
                throw new IllegalArgumentException("sectionName is too long");
            }
            Trace.nativeTraceBegin(4096L, sectionName);
        }
    }

    public static void endSection() {
        if (Trace.isTagEnabled(4096L)) {
            Trace.nativeTraceEnd(4096L);
        }
    }

    static {
        SystemProperties.addChangeCallback(new Runnable(){

            @Override
            public void run() {
                Trace.cacheEnabledTags();
            }
        });
    }
}

