/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import java.util.ArrayList;
import java.util.HashMap;

public abstract class UEventObserver {
    private static final String TAG = "UEventObserver";
    private static final boolean DEBUG = false;
    private static UEventThread sThread;

    private static native void nativeSetup();

    private static native String nativeWaitForNextEvent();

    private static native void nativeAddMatch(String var0);

    private static native void nativeRemoveMatch(String var0);

    protected void finalize() throws Throwable {
        try {
            this.stopObserving();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UEventThread getThread() {
        Class<UEventObserver> clazz = UEventObserver.class;
        synchronized (UEventObserver.class) {
            if (sThread == null) {
                sThread = new UEventThread();
                sThread.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UEventThread peekThread() {
        Class<UEventObserver> clazz = UEventObserver.class;
        synchronized (UEventObserver.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sThread;
        }
    }

    public final void startObserving(String match) {
        if (match == null || match.isEmpty()) {
            throw new IllegalArgumentException("match substring must be non-empty");
        }
        UEventThread t = UEventObserver.getThread();
        t.addObserver(match, this);
    }

    public final void stopObserving() {
        UEventThread t = UEventObserver.getThread();
        if (t != null) {
            t.removeObserver(this);
        }
    }

    public abstract void onUEvent(UEvent var1);

    private static final class UEventThread
    extends Thread {
        private final ArrayList<Object> mKeysAndObservers = new ArrayList();
        private final ArrayList<UEventObserver> mTempObserversToSignal = new ArrayList();

        public UEventThread() {
            super(UEventObserver.TAG);
        }

        @Override
        public void run() {
            UEventObserver.nativeSetup();
            while (true) {
                String message;
                if ((message = UEventObserver.nativeWaitForNextEvent()) == null) {
                    continue;
                }
                this.sendEvent(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendEvent(String message) {
            int i;
            int N;
            ArrayList<Object> arrayList = this.mKeysAndObservers;
            synchronized (arrayList) {
                N = this.mKeysAndObservers.size();
                for (i = 0; i < N; i += 2) {
                    String key = (String)this.mKeysAndObservers.get(i);
                    if (!message.contains(key)) continue;
                    UEventObserver observer = (UEventObserver)this.mKeysAndObservers.get(i + 1);
                    this.mTempObserversToSignal.add(observer);
                }
            }
            if (!this.mTempObserversToSignal.isEmpty()) {
                UEvent event = new UEvent(message);
                N = this.mTempObserversToSignal.size();
                for (i = 0; i < N; ++i) {
                    UEventObserver observer = this.mTempObserversToSignal.get(i);
                    observer.onUEvent(event);
                }
                this.mTempObserversToSignal.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObserver(String match, UEventObserver observer) {
            ArrayList<Object> arrayList = this.mKeysAndObservers;
            synchronized (arrayList) {
                this.mKeysAndObservers.add(match);
                this.mKeysAndObservers.add(observer);
                UEventObserver.nativeAddMatch(match);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeObserver(UEventObserver observer) {
            ArrayList<Object> arrayList = this.mKeysAndObservers;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.mKeysAndObservers.size()) {
                    if (this.mKeysAndObservers.get(i + 1) == observer) {
                        this.mKeysAndObservers.remove(i + 1);
                        String match = (String)this.mKeysAndObservers.remove(i);
                        UEventObserver.nativeRemoveMatch(match);
                        continue;
                    }
                    i += 2;
                }
            }
        }
    }

    public static final class UEvent {
        private final HashMap<String, String> mMap = new HashMap();

        public UEvent(String message) {
            int offset = 0;
            int length = message.length();
            while (offset < length) {
                int equals = message.indexOf(61, offset);
                int at = message.indexOf(0, offset);
                if (at < 0) break;
                if (equals > offset && equals < at) {
                    this.mMap.put(message.substring(offset, equals), message.substring(equals + 1, at));
                }
                offset = at + 1;
            }
        }

        public String get(String key) {
            return this.mMap.get(key);
        }

        public String get(String key, String defaultValue) {
            String result = this.mMap.get(key);
            return result == null ? defaultValue : result;
        }

        public String toString() {
            return this.mMap.toString();
        }
    }
}

