/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.ConfigSource;
import android.security.net.config.Domain;
import android.security.net.config.NetworkSecurityConfig;
import android.security.net.config.RootTrustManager;
import android.util.Pair;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.net.ssl.X509TrustManager;

public final class ApplicationConfig {
    private static ApplicationConfig sInstance;
    private static Object sLock;
    private Set<Pair<Domain, NetworkSecurityConfig>> mConfigs;
    private NetworkSecurityConfig mDefaultConfig;
    private X509TrustManager mTrustManager;
    private ConfigSource mConfigSource;
    private boolean mInitialized;
    private final Object mLock = new Object();

    public ApplicationConfig(ConfigSource configSource) {
        this.mConfigSource = configSource;
        this.mInitialized = false;
    }

    public boolean hasPerDomainConfigs() {
        this.ensureInitialized();
        return this.mConfigs != null && !this.mConfigs.isEmpty();
    }

    public NetworkSecurityConfig getConfigForHostname(String hostname) {
        this.ensureInitialized();
        if (hostname == null || hostname.isEmpty() || this.mConfigs == null) {
            return this.mDefaultConfig;
        }
        if (hostname.charAt(0) == '.') {
            throw new IllegalArgumentException("hostname must not begin with a .");
        }
        if ((hostname = hostname.toLowerCase(Locale.US)).charAt(hostname.length() - 1) == '.') {
            hostname = hostname.substring(0, hostname.length() - 1);
        }
        Pair<Domain, NetworkSecurityConfig> bestMatch = null;
        for (Pair<Domain, NetworkSecurityConfig> entry : this.mConfigs) {
            Domain domain = (Domain)entry.first;
            NetworkSecurityConfig config = (NetworkSecurityConfig)entry.second;
            if (domain.hostname.equals(hostname)) {
                return config;
            }
            if (!domain.subdomainsIncluded || !hostname.endsWith(domain.hostname) || hostname.charAt(hostname.length() - domain.hostname.length() - 1) != '.') continue;
            if (bestMatch == null) {
                bestMatch = entry;
                continue;
            }
            if (domain.hostname.length() <= ((Domain)bestMatch.first).hostname.length()) continue;
            bestMatch = entry;
        }
        if (bestMatch != null) {
            return (NetworkSecurityConfig)bestMatch.second;
        }
        return this.mDefaultConfig;
    }

    public X509TrustManager getTrustManager() {
        this.ensureInitialized();
        return this.mTrustManager;
    }

    public boolean isCleartextTrafficPermitted() {
        this.ensureInitialized();
        if (this.mConfigs != null) {
            for (Pair<Domain, NetworkSecurityConfig> entry : this.mConfigs) {
                if (((NetworkSecurityConfig)entry.second).isCleartextTrafficPermitted()) continue;
                return false;
            }
        }
        return this.mDefaultConfig.isCleartextTrafficPermitted();
    }

    public boolean isCleartextTrafficPermitted(String hostname) {
        return this.getConfigForHostname(hostname).isCleartextTrafficPermitted();
    }

    public void handleTrustStorageUpdate() {
        this.ensureInitialized();
        this.mDefaultConfig.handleTrustStorageUpdate();
        if (this.mConfigs != null) {
            HashSet updatedConfigs = new HashSet(this.mConfigs.size());
            for (Pair<Domain, NetworkSecurityConfig> entry : this.mConfigs) {
                if (!updatedConfigs.add(entry.second)) continue;
                ((NetworkSecurityConfig)entry.second).handleTrustStorageUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
            this.mConfigs = this.mConfigSource.getPerDomainConfigs();
            this.mDefaultConfig = this.mConfigSource.getDefaultConfig();
            this.mConfigSource = null;
            this.mTrustManager = new RootTrustManager(this);
            this.mInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultInstance(ApplicationConfig config) {
        Object object = sLock;
        synchronized (object) {
            sInstance = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationConfig getDefaultInstance() {
        Object object = sLock;
        synchronized (object) {
            return sInstance;
        }
    }

    static {
        sLock = new Object();
    }
}

