/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.CertificateSource;
import android.util.ArraySet;
import com.android.org.conscrypt.Hex;
import com.android.org.conscrypt.NativeCrypto;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import libcore.io.IoUtils;

abstract class DirectoryCertificateSource
implements CertificateSource {
    private final File mDir;
    private final Object mLock = new Object();
    private final CertificateFactory mCertFactory;
    private Set<X509Certificate> mCertificates;

    protected DirectoryCertificateSource(File caDir) {
        this.mDir = caDir;
        try {
            this.mCertFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
    }

    protected abstract boolean isCertMarkedAsRemoved(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<X509Certificate> getCertificates() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCertificates != null) {
                return this.mCertificates;
            }
            ArraySet<X509Certificate> certs = new ArraySet<X509Certificate>();
            if (this.mDir.isDirectory()) {
                for (String caFile : this.mDir.list()) {
                    X509Certificate cert;
                    if (this.isCertMarkedAsRemoved(caFile) || (cert = this.readCertificate(caFile)) == null) continue;
                    certs.add(cert);
                }
            }
            this.mCertificates = certs;
            return this.mCertificates;
        }
    }

    @Override
    public X509Certificate findBySubjectAndPublicKey(final X509Certificate cert) {
        return this.findCert(cert.getSubjectX500Principal(), new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                return ca.getPublicKey().equals(cert.getPublicKey());
            }
        });
    }

    @Override
    public X509Certificate findByIssuerAndSignature(final X509Certificate cert) {
        return this.findCert(cert.getIssuerX500Principal(), new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                try {
                    cert.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    @Override
    public Set<X509Certificate> findAllByIssuerAndSignature(final X509Certificate cert) {
        return this.findCerts(cert.getIssuerX500Principal(), new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                try {
                    cert.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTrustStorageUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCertificates = null;
        }
    }

    private Set<X509Certificate> findCerts(X500Principal subj, CertSelector selector) {
        String fileName;
        String hash = this.getHash(subj);
        Set<X509Certificate> certs = null;
        for (int index = 0; index >= 0 && new File(this.mDir, fileName = hash + "." + index).exists(); ++index) {
            X509Certificate cert;
            if (this.isCertMarkedAsRemoved(fileName) || !subj.equals((cert = this.readCertificate(fileName)).getSubjectX500Principal()) || !selector.match(cert)) continue;
            if (certs == null) {
                certs = new ArraySet<X509Certificate>();
            }
            certs.add(cert);
        }
        return certs != null ? certs : Collections.emptySet();
    }

    private X509Certificate findCert(X500Principal subj, CertSelector selector) {
        String fileName;
        String hash = this.getHash(subj);
        for (int index = 0; index >= 0 && new File(this.mDir, fileName = hash + "." + index).exists(); ++index) {
            X509Certificate cert;
            if (this.isCertMarkedAsRemoved(fileName) || !subj.equals((cert = this.readCertificate(fileName)).getSubjectX500Principal()) || !selector.match(cert)) continue;
            return cert;
        }
        return null;
    }

    private String getHash(X500Principal name) {
        int hash = NativeCrypto.X509_NAME_hash_old(name);
        return Hex.intToHexString(hash, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate readCertificate(String file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(new File(this.mDir, file)));
            X509Certificate x509Certificate = (X509Certificate)this.mCertFactory.generateCertificate(is);
            IoUtils.closeQuietly(is);
            return x509Certificate;
        }
        catch (IOException | CertificateException e) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    private static interface CertSelector {
        public boolean match(X509Certificate var1);
    }
}

