/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.INotificationManager;
import android.app.Service;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.util.Log;

public abstract class ConditionProviderService
extends Service {
    private final String TAG = ConditionProviderService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    private final H mHandler = new H();
    private Provider mProvider;
    private INotificationManager mNoMan;
    public static final String SERVICE_INTERFACE = "android.service.notification.ConditionProviderService";
    public static final String META_DATA_RULE_TYPE = "android.service.zen.automatic.ruleType";
    public static final String META_DATA_CONFIGURATION_ACTIVITY = "android.service.zen.automatic.configurationActivity";
    public static final String META_DATA_RULE_INSTANCE_LIMIT = "android.service.zen.automatic.ruleInstanceLimit";
    public static final String EXTRA_RULE_ID = "android.service.notification.extra.RULE_ID";

    public abstract void onConnected();

    public void onRequestConditions(int relevance) {
    }

    public abstract void onSubscribe(Uri var1);

    public abstract void onUnsubscribe(Uri var1);

    private final INotificationManager getNotificationInterface() {
        if (this.mNoMan == null) {
            this.mNoMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        }
        return this.mNoMan;
    }

    public final void notifyCondition(Condition condition) {
        if (condition == null) {
            return;
        }
        this.notifyConditions(condition);
    }

    public final void notifyConditions(Condition ... conditions) {
        if (!this.isBound() || conditions == null) {
            return;
        }
        try {
            this.getNotificationInterface().notifyConditions(this.getPackageName(), this.mProvider, conditions);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (this.mProvider == null) {
            this.mProvider = new Provider();
        }
        return this.mProvider;
    }

    private boolean isBound() {
        if (this.mProvider == null) {
            Log.w(this.TAG, "Condition provider service not yet bound.");
            return false;
        }
        return true;
    }

    private final class H
    extends Handler {
        private static final int ON_CONNECTED = 1;
        private static final int ON_SUBSCRIBE = 3;
        private static final int ON_UNSUBSCRIBE = 4;

        private H() {
        }

        @Override
        public void handleMessage(Message msg) {
            String name = null;
            try {
                switch (msg.what) {
                    case 1: {
                        name = "onConnected";
                        ConditionProviderService.this.onConnected();
                        break;
                    }
                    case 3: {
                        name = "onSubscribe";
                        ConditionProviderService.this.onSubscribe((Uri)msg.obj);
                        break;
                    }
                    case 4: {
                        name = "onUnsubscribe";
                        ConditionProviderService.this.onUnsubscribe((Uri)msg.obj);
                    }
                }
            }
            catch (Throwable t) {
                Log.w(ConditionProviderService.this.TAG, "Error running " + name, t);
            }
        }
    }

    private final class Provider
    extends IConditionProvider.Stub {
        private Provider() {
        }

        @Override
        public void onConnected() {
            ConditionProviderService.this.mHandler.obtainMessage(1).sendToTarget();
        }

        @Override
        public void onSubscribe(Uri conditionId) {
            ConditionProviderService.this.mHandler.obtainMessage(3, conditionId).sendToTarget();
        }

        @Override
        public void onUnsubscribe(Uri conditionId) {
            ConditionProviderService.this.mHandler.obtainMessage(4, conditionId).sendToTarget();
        }
    }
}

