/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.INotificationManager;
import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.notification.INotificationListener;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.StatusBarNotification;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.widget.RemoteViews;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.SomeArgs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class NotificationListenerService
extends Service {
    private final String TAG = NotificationListenerService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    public static final int INTERRUPTION_FILTER_ALL = 1;
    public static final int INTERRUPTION_FILTER_PRIORITY = 2;
    public static final int INTERRUPTION_FILTER_NONE = 3;
    public static final int INTERRUPTION_FILTER_ALARMS = 4;
    public static final int INTERRUPTION_FILTER_UNKNOWN = 0;
    public static final int HINT_HOST_DISABLE_EFFECTS = 1;
    public static final int HINT_HOST_DISABLE_NOTIFICATION_EFFECTS = 2;
    public static final int HINT_HOST_DISABLE_CALL_EFFECTS = 4;
    public static final int SUPPRESSED_EFFECT_SCREEN_OFF = 1;
    public static final int SUPPRESSED_EFFECT_SCREEN_ON = 2;
    public static final int TRIM_FULL = 0;
    public static final int TRIM_LIGHT = 1;
    private final Object mLock = new Object();
    private Handler mHandler;
    protected NotificationListenerWrapper mWrapper = null;
    private boolean isConnected = false;
    @GuardedBy(value="mLock")
    private RankingMap mRankingMap;
    private INotificationManager mNoMan;
    protected int mCurrentUser;
    protected Context mSystemContext;
    public static final String SERVICE_INTERFACE = "android.service.notification.NotificationListenerService";

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new MyHandler(this.getMainLooper());
    }

    public void onNotificationPosted(StatusBarNotification sbn) {
    }

    public void onNotificationPosted(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationPosted(sbn);
    }

    public void onNotificationRemoved(StatusBarNotification sbn) {
    }

    public void onNotificationRemoved(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationRemoved(sbn);
    }

    public void onListenerConnected() {
    }

    public void onListenerDisconnected() {
    }

    public void onNotificationRankingUpdate(RankingMap rankingMap) {
    }

    public void onListenerHintsChanged(int hints) {
    }

    public void onInterruptionFilterChanged(int interruptionFilter) {
    }

    protected final INotificationManager getNotificationInterface() {
        if (this.mNoMan == null) {
            this.mNoMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        }
        return this.mNoMan;
    }

    public final void cancelNotification(String pkg, String tag, int id2) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationFromListener(this.mWrapper, pkg, tag, id2);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void cancelNotification(String key) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, new String[]{key});
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void cancelAllNotifications() {
        this.cancelNotifications(null);
    }

    public final void cancelNotifications(String[] keys) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, keys);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void setNotificationsShown(String[] keys) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().setNotificationsShownFromListener(this.mWrapper, keys);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void setOnNotificationPostedTrim(int trim) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().setOnNotificationPostedTrimFromListener(this.mWrapper, trim);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public StatusBarNotification[] getActiveNotifications() {
        return this.getActiveNotifications(null, 0);
    }

    public StatusBarNotification[] getActiveNotifications(int trim) {
        return this.getActiveNotifications(null, trim);
    }

    public StatusBarNotification[] getActiveNotifications(String[] keys) {
        return this.getActiveNotifications(keys, 0);
    }

    public StatusBarNotification[] getActiveNotifications(String[] keys, int trim) {
        if (!this.isBound()) {
            return null;
        }
        try {
            ParceledListSlice parceledList = this.getNotificationInterface().getActiveNotificationsFromListener(this.mWrapper, keys, trim);
            List<StatusBarNotification> list = parceledList.getList();
            ArrayList<StatusBarNotification> corruptNotifications = null;
            int N = list.size();
            for (int i = 0; i < N; ++i) {
                StatusBarNotification sbn = (StatusBarNotification)list.get(i);
                Notification notification = sbn.getNotification();
                try {
                    this.createLegacyIconExtras(notification);
                    this.maybePopulateRemoteViews(notification);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    if (corruptNotifications == null) {
                        corruptNotifications = new ArrayList<StatusBarNotification>(N);
                    }
                    corruptNotifications.add(sbn);
                    Log.w(this.TAG, "onNotificationPosted: can't rebuild notification from " + sbn.getPackageName());
                }
            }
            if (corruptNotifications != null) {
                list.removeAll(corruptNotifications);
            }
            return list.toArray(new StatusBarNotification[list.size()]);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return null;
        }
    }

    public final int getCurrentListenerHints() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getHintsFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    public final int getCurrentInterruptionFilter() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getInterruptionFilterFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    public final void requestListenerHints(int hints) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestHintsFromListener(this.mWrapper, hints);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void requestInterruptionFilter(int interruptionFilter) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestInterruptionFilterFromListener(this.mWrapper, interruptionFilter);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RankingMap getCurrentRanking() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRankingMap;
        }
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationListenerWrapper();
        }
        return this.mWrapper;
    }

    protected boolean isBound() {
        if (this.mWrapper == null) {
            Log.w(this.TAG, "Notification listener service not yet bound.");
            return false;
        }
        return true;
    }

    @Override
    public void onDestroy() {
        this.onListenerDisconnected();
        super.onDestroy();
    }

    public void registerAsSystemService(Context context, ComponentName componentName, int currentUser) throws RemoteException {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationListenerWrapper();
        }
        this.mSystemContext = context;
        INotificationManager noMan = this.getNotificationInterface();
        this.mHandler = new MyHandler(context.getMainLooper());
        this.mCurrentUser = currentUser;
        noMan.registerListener(this.mWrapper, componentName, currentUser);
    }

    public void unregisterAsSystemService() throws RemoteException {
        if (this.mWrapper != null) {
            INotificationManager noMan = this.getNotificationInterface();
            noMan.unregisterListener(this.mWrapper, this.mCurrentUser);
        }
    }

    public static void requestRebind(ComponentName componentName) {
        INotificationManager noMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        try {
            noMan.requestBindListener(componentName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public final void requestUnbind() {
        if (this.mWrapper != null) {
            INotificationManager noMan = this.getNotificationInterface();
            try {
                noMan.requestUnbindListener(this.mWrapper);
                this.isConnected = false;
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    private void createLegacyIconExtras(Notification n) {
        Drawable d;
        Icon smallIcon = n.getSmallIcon();
        Icon largeIcon = n.getLargeIcon();
        if (smallIcon != null && smallIcon.getType() == 2) {
            n.extras.putInt("android.icon", smallIcon.getResId());
            n.icon = smallIcon.getResId();
        }
        if (largeIcon != null && (d = largeIcon.loadDrawable(this.getContext())) != null && d instanceof BitmapDrawable) {
            Bitmap largeIconBits = ((BitmapDrawable)d).getBitmap();
            n.extras.putParcelable("android.largeIcon", largeIconBits);
            n.largeIcon = largeIconBits;
        }
    }

    private void maybePopulateRemoteViews(Notification notification) {
        if (this.getContext().getApplicationInfo().targetSdkVersion < 24) {
            Notification.Builder builder = Notification.Builder.recoverBuilder(this.getContext(), notification);
            RemoteViews content = builder.createContentView();
            RemoteViews big = builder.createBigContentView();
            RemoteViews headsUp = builder.createHeadsUpContentView();
            notification.contentView = content;
            notification.bigContentView = big;
            notification.headsUpContentView = headsUp;
        }
    }

    private void applyUpdateLocked(NotificationRankingUpdate update) {
        this.mRankingMap = new RankingMap(update);
    }

    protected Context getContext() {
        if (this.mSystemContext != null) {
            return this.mSystemContext;
        }
        return this;
    }

    private final class MyHandler
    extends Handler {
        public static final int MSG_ON_NOTIFICATION_POSTED = 1;
        public static final int MSG_ON_NOTIFICATION_REMOVED = 2;
        public static final int MSG_ON_LISTENER_CONNECTED = 3;
        public static final int MSG_ON_NOTIFICATION_RANKING_UPDATE = 4;
        public static final int MSG_ON_LISTENER_HINTS_CHANGED = 5;
        public static final int MSG_ON_INTERRUPTION_FILTER_CHANGED = 6;

        public MyHandler(Looper looper) {
            super(looper, null, false);
        }

        @Override
        public void handleMessage(Message msg) {
            if (!NotificationListenerService.this.isConnected) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    RankingMap rankingMap = (RankingMap)args.arg2;
                    args.recycle();
                    NotificationListenerService.this.onNotificationPosted(sbn, rankingMap);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    RankingMap rankingMap = (RankingMap)args.arg2;
                    args.recycle();
                    NotificationListenerService.this.onNotificationRemoved(sbn, rankingMap);
                    break;
                }
                case 3: {
                    NotificationListenerService.this.onListenerConnected();
                    break;
                }
                case 4: {
                    RankingMap rankingMap = (RankingMap)msg.obj;
                    NotificationListenerService.this.onNotificationRankingUpdate(rankingMap);
                    break;
                }
                case 5: {
                    int hints = msg.arg1;
                    NotificationListenerService.this.onListenerHintsChanged(hints);
                    break;
                }
                case 6: {
                    int interruptionFilter = msg.arg1;
                    NotificationListenerService.this.onInterruptionFilterChanged(interruptionFilter);
                }
            }
        }
    }

    public static class RankingMap
    implements Parcelable {
        private final NotificationRankingUpdate mRankingUpdate;
        private ArrayMap<String, Integer> mRanks;
        private ArraySet<Object> mIntercepted;
        private ArrayMap<String, Integer> mVisibilityOverrides;
        private ArrayMap<String, Integer> mSuppressedVisualEffects;
        private ArrayMap<String, Integer> mImportance;
        private ArrayMap<String, String> mImportanceExplanation;
        private ArrayMap<String, String> mOverrideGroupKeys;
        public static final Parcelable.Creator<RankingMap> CREATOR = new Parcelable.Creator<RankingMap>(){

            @Override
            public RankingMap createFromParcel(Parcel source) {
                NotificationRankingUpdate rankingUpdate = (NotificationRankingUpdate)source.readParcelable(null);
                return new RankingMap(rankingUpdate);
            }

            public RankingMap[] newArray(int size) {
                return new RankingMap[size];
            }
        };

        private RankingMap(NotificationRankingUpdate rankingUpdate) {
            this.mRankingUpdate = rankingUpdate;
        }

        public String[] getOrderedKeys() {
            return this.mRankingUpdate.getOrderedKeys();
        }

        public boolean getRanking(String key, Ranking outRanking) {
            int rank = this.getRank(key);
            outRanking.populate(key, rank, !this.isIntercepted(key), this.getVisibilityOverride(key), this.getSuppressedVisualEffects(key), this.getImportance(key), this.getImportanceExplanation(key), this.getOverrideGroupKey(key));
            return rank >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getRank(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mRanks == null) {
                    this.buildRanksLocked();
                }
            }
            Integer rank = this.mRanks.get(key);
            return rank != null ? rank : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isIntercepted(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mIntercepted == null) {
                    this.buildInterceptedSetLocked();
                }
            }
            return this.mIntercepted.contains(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getVisibilityOverride(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mVisibilityOverrides == null) {
                    this.buildVisibilityOverridesLocked();
                }
            }
            Integer override = this.mVisibilityOverrides.get(key);
            if (override == null) {
                return -1000;
            }
            return override;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getSuppressedVisualEffects(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mSuppressedVisualEffects == null) {
                    this.buildSuppressedVisualEffectsLocked();
                }
            }
            Integer suppressed = this.mSuppressedVisualEffects.get(key);
            if (suppressed == null) {
                return 0;
            }
            return suppressed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getImportance(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mImportance == null) {
                    this.buildImportanceLocked();
                }
            }
            Integer importance = this.mImportance.get(key);
            if (importance == null) {
                return 3;
            }
            return importance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getImportanceExplanation(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mImportanceExplanation == null) {
                    this.buildImportanceExplanationLocked();
                }
            }
            return this.mImportanceExplanation.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getOverrideGroupKey(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mOverrideGroupKeys == null) {
                    this.buildOverrideGroupKeys();
                }
            }
            return this.mOverrideGroupKeys.get(key);
        }

        private void buildRanksLocked() {
            String[] orderedKeys = this.mRankingUpdate.getOrderedKeys();
            this.mRanks = new ArrayMap(orderedKeys.length);
            for (int i = 0; i < orderedKeys.length; ++i) {
                String key = orderedKeys[i];
                this.mRanks.put(key, i);
            }
        }

        private void buildInterceptedSetLocked() {
            String[] dndInterceptedKeys = this.mRankingUpdate.getInterceptedKeys();
            this.mIntercepted = new ArraySet(dndInterceptedKeys.length);
            Collections.addAll(this.mIntercepted, dndInterceptedKeys);
        }

        private void buildVisibilityOverridesLocked() {
            Bundle visibilityBundle = this.mRankingUpdate.getVisibilityOverrides();
            this.mVisibilityOverrides = new ArrayMap(visibilityBundle.size());
            for (String key : visibilityBundle.keySet()) {
                this.mVisibilityOverrides.put(key, visibilityBundle.getInt(key));
            }
        }

        private void buildSuppressedVisualEffectsLocked() {
            Bundle suppressedBundle = this.mRankingUpdate.getSuppressedVisualEffects();
            this.mSuppressedVisualEffects = new ArrayMap(suppressedBundle.size());
            for (String key : suppressedBundle.keySet()) {
                this.mSuppressedVisualEffects.put(key, suppressedBundle.getInt(key));
            }
        }

        private void buildImportanceLocked() {
            String[] orderedKeys = this.mRankingUpdate.getOrderedKeys();
            int[] importance = this.mRankingUpdate.getImportance();
            this.mImportance = new ArrayMap(orderedKeys.length);
            for (int i = 0; i < orderedKeys.length; ++i) {
                String key = orderedKeys[i];
                this.mImportance.put(key, importance[i]);
            }
        }

        private void buildImportanceExplanationLocked() {
            Bundle explanationBundle = this.mRankingUpdate.getImportanceExplanation();
            this.mImportanceExplanation = new ArrayMap(explanationBundle.size());
            for (String key : explanationBundle.keySet()) {
                this.mImportanceExplanation.put(key, explanationBundle.getString(key));
            }
        }

        private void buildOverrideGroupKeys() {
            Bundle overrideGroupKeys = this.mRankingUpdate.getOverrideGroupKeys();
            this.mOverrideGroupKeys = new ArrayMap(overrideGroupKeys.size());
            for (String key : overrideGroupKeys.keySet()) {
                this.mOverrideGroupKeys.put(key, overrideGroupKeys.getString(key));
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mRankingUpdate, flags);
        }
    }

    public static class Ranking {
        public static final int VISIBILITY_NO_OVERRIDE = -1000;
        public static final int IMPORTANCE_UNSPECIFIED = -1000;
        public static final int IMPORTANCE_NONE = 0;
        public static final int IMPORTANCE_MIN = 1;
        public static final int IMPORTANCE_LOW = 2;
        public static final int IMPORTANCE_DEFAULT = 3;
        public static final int IMPORTANCE_HIGH = 4;
        public static final int IMPORTANCE_MAX = 5;
        private String mKey;
        private int mRank = -1;
        private boolean mIsAmbient;
        private boolean mMatchesInterruptionFilter;
        private int mVisibilityOverride;
        private int mSuppressedVisualEffects;
        private int mImportance;
        private CharSequence mImportanceExplanation;
        private String mOverrideGroupKey;

        public String getKey() {
            return this.mKey;
        }

        public int getRank() {
            return this.mRank;
        }

        public boolean isAmbient() {
            return this.mIsAmbient;
        }

        public int getVisibilityOverride() {
            return this.mVisibilityOverride;
        }

        public int getSuppressedVisualEffects() {
            return this.mSuppressedVisualEffects;
        }

        public boolean matchesInterruptionFilter() {
            return this.mMatchesInterruptionFilter;
        }

        public int getImportance() {
            return this.mImportance;
        }

        public CharSequence getImportanceExplanation() {
            return this.mImportanceExplanation;
        }

        public String getOverrideGroupKey() {
            return this.mOverrideGroupKey;
        }

        private void populate(String key, int rank, boolean matchesInterruptionFilter, int visibilityOverride, int suppressedVisualEffects, int importance, CharSequence explanation, String overrideGroupKey) {
            this.mKey = key;
            this.mRank = rank;
            this.mIsAmbient = importance < 2;
            this.mMatchesInterruptionFilter = matchesInterruptionFilter;
            this.mVisibilityOverride = visibilityOverride;
            this.mSuppressedVisualEffects = suppressedVisualEffects;
            this.mImportance = importance;
            this.mImportanceExplanation = explanation;
            this.mOverrideGroupKey = overrideGroupKey;
        }

        public static String importanceToString(int importance) {
            switch (importance) {
                case -1000: {
                    return "UNSPECIFIED";
                }
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "MIN";
                }
                case 2: {
                    return "LOW";
                }
                case 3: {
                    return "DEFAULT";
                }
                case 4: {
                    return "HIGH";
                }
                case 5: {
                    return "MAX";
                }
            }
            return "UNKNOWN(" + String.valueOf(importance) + ")";
        }
    }

    protected class NotificationListenerWrapper
    extends INotificationListener.Stub {
        protected NotificationListenerWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationPosted(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationPosted: Error receiving StatusBarNotification", e);
                return;
            }
            try {
                NotificationListenerService.this.createLegacyIconExtras(sbn.getNotification());
                NotificationListenerService.this.maybePopulateRemoteViews(sbn.getNotification());
            }
            catch (IllegalArgumentException e) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationPosted: can't rebuild notification from " + sbn.getPackageName());
                sbn = null;
            }
            Object object = NotificationListenerService.this.mLock;
            synchronized (object) {
                NotificationListenerService.this.applyUpdateLocked(update);
                if (sbn != null) {
                    SomeArgs args = SomeArgs.obtain();
                    args.arg1 = sbn;
                    args.arg2 = NotificationListenerService.this.mRankingMap;
                    NotificationListenerService.this.mHandler.obtainMessage(1, args).sendToTarget();
                } else {
                    NotificationListenerService.this.mHandler.obtainMessage(4, NotificationListenerService.this.mRankingMap).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationRemoved(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationListenerService.this.TAG, "onNotificationRemoved: Error receiving StatusBarNotification", e);
                return;
            }
            Object object = NotificationListenerService.this.mLock;
            synchronized (object) {
                NotificationListenerService.this.applyUpdateLocked(update);
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = sbn;
                args.arg2 = NotificationListenerService.this.mRankingMap;
                NotificationListenerService.this.mHandler.obtainMessage(2, args).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onListenerConnected(NotificationRankingUpdate update) {
            Object object = NotificationListenerService.this.mLock;
            synchronized (object) {
                NotificationListenerService.this.applyUpdateLocked(update);
            }
            NotificationListenerService.this.isConnected = true;
            NotificationListenerService.this.mHandler.obtainMessage(3).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
            Object object = NotificationListenerService.this.mLock;
            synchronized (object) {
                NotificationListenerService.this.applyUpdateLocked(update);
                NotificationListenerService.this.mHandler.obtainMessage(4, NotificationListenerService.this.mRankingMap).sendToTarget();
            }
        }

        @Override
        public void onListenerHintsChanged(int hints) throws RemoteException {
            NotificationListenerService.this.mHandler.obtainMessage(5, hints, 0).sendToTarget();
        }

        @Override
        public void onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
            NotificationListenerService.this.mHandler.obtainMessage(6, interruptionFilter, 0).sendToTarget();
        }

        @Override
        public void onNotificationEnqueued(IStatusBarNotificationHolder notificationHolder, int importance, boolean user) throws RemoteException {
        }

        @Override
        public void onNotificationVisibilityChanged(String key, long time, boolean visible) throws RemoteException {
        }

        @Override
        public void onNotificationClick(String key, long time) throws RemoteException {
        }

        @Override
        public void onNotificationActionClick(String key, long time, int actionIndex) throws RemoteException {
        }

        @Override
        public void onNotificationRemovedReason(String key, long time, int reason) throws RemoteException {
        }
    }
}

