/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.service.notification.Adjustment;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import android.util.Log;
import com.android.internal.os.SomeArgs;
import java.util.List;

public abstract class NotificationRankerService
extends NotificationListenerService {
    private static final String TAG = "NotificationRankers";
    public static final String SERVICE_INTERFACE = "android.service.notification.NotificationRankerService";
    public static final int REASON_DELEGATE_CLICK = 1;
    public static final int REASON_DELEGATE_CANCEL = 2;
    public static final int REASON_DELEGATE_CANCEL_ALL = 3;
    public static final int REASON_DELEGATE_ERROR = 4;
    public static final int REASON_PACKAGE_CHANGED = 5;
    public static final int REASON_USER_STOPPED = 6;
    public static final int REASON_PACKAGE_BANNED = 7;
    public static final int REASON_APP_CANCEL = 8;
    public static final int REASON_APP_CANCEL_ALL = 9;
    public static final int REASON_LISTENER_CANCEL = 10;
    public static final int REASON_LISTENER_CANCEL_ALL = 11;
    public static final int REASON_GROUP_SUMMARY_CANCELED = 12;
    public static final int REASON_GROUP_OPTIMIZATION = 13;
    public static final int REASON_PACKAGE_SUSPENDED = 14;
    public static final int REASON_PROFILE_TURNED_OFF = 15;
    public static final int REASON_UNAUTOBUNDLED = 16;
    private Handler mHandler;

    @Override
    public void registerAsSystemService(Context context, ComponentName componentName, int currentUser) {
        throw new UnsupportedOperationException("the ranker lifecycle is managed by the system.");
    }

    @Override
    public void unregisterAsSystemService() {
        throw new UnsupportedOperationException("the ranker lifecycle is managed by the system.");
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new MyHandler(this.getContext().getMainLooper());
    }

    @Override
    public final IBinder onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationRankingServiceWrapper();
        }
        return this.mWrapper;
    }

    public abstract Adjustment onNotificationEnqueued(StatusBarNotification var1, int var2, boolean var3);

    public void onNotificationVisibilityChanged(String key, long time, boolean visible) {
    }

    public void onNotificationClick(String key, long time) {
    }

    public void onNotificationActionClick(String key, long time, int actionIndex) {
    }

    public void onNotificationRemoved(String key, long time, int reason) {
    }

    public final void adjustNotification(Adjustment adjustment) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().applyAdjustmentFromRankerService(this.mWrapper, adjustment);
        }
        catch (RemoteException ex) {
            Log.v(TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void adjustNotifications(List<Adjustment> adjustments) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().applyAdjustmentsFromRankerService(this.mWrapper, adjustments);
        }
        catch (RemoteException ex) {
            Log.v(TAG, "Unable to contact notification manager", ex);
        }
    }

    private final class MyHandler
    extends Handler {
        public static final int MSG_ON_NOTIFICATION_ENQUEUED = 1;
        public static final int MSG_ON_NOTIFICATION_VISIBILITY_CHANGED = 2;
        public static final int MSG_ON_NOTIFICATION_CLICK = 3;
        public static final int MSG_ON_NOTIFICATION_ACTION_CLICK = 4;
        public static final int MSG_ON_NOTIFICATION_REMOVED_REASON = 5;

        public MyHandler(Looper looper) {
            super(looper, null, false);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    int importance = args.argi1;
                    boolean user = args.argi2 == 1;
                    args.recycle();
                    Adjustment adjustment = NotificationRankerService.this.onNotificationEnqueued(sbn, importance, user);
                    if (adjustment == null) break;
                    NotificationRankerService.this.adjustNotification(adjustment);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    long time = (Long)args.arg2;
                    boolean visible = args.argi1 == 1;
                    args.recycle();
                    NotificationRankerService.this.onNotificationVisibilityChanged(key, time, visible);
                    break;
                }
                case 3: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    long time = (Long)args.arg2;
                    args.recycle();
                    NotificationRankerService.this.onNotificationClick(key, time);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    long time = (Long)args.arg2;
                    int actionIndex = args.argi1;
                    args.recycle();
                    NotificationRankerService.this.onNotificationActionClick(key, time, actionIndex);
                    break;
                }
                case 5: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    long time = (Long)args.arg2;
                    int reason = args.argi1;
                    args.recycle();
                    NotificationRankerService.this.onNotificationRemoved(key, time, reason);
                }
            }
        }
    }

    private class NotificationRankingServiceWrapper
    extends NotificationListenerService.NotificationListenerWrapper {
        private NotificationRankingServiceWrapper() {
        }

        @Override
        public void onNotificationEnqueued(IStatusBarNotificationHolder sbnHolder, int importance, boolean user) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationRankerService.TAG, "onNotificationEnqueued: Error receiving StatusBarNotification", e);
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = sbn;
            args.argi1 = importance;
            args.argi2 = user ? 1 : 0;
            NotificationRankerService.this.mHandler.obtainMessage(1, args).sendToTarget();
        }

        @Override
        public void onNotificationVisibilityChanged(String key, long time, boolean visible) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = time;
            args.argi1 = visible ? 1 : 0;
            NotificationRankerService.this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        @Override
        public void onNotificationClick(String key, long time) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = time;
            NotificationRankerService.this.mHandler.obtainMessage(3, args).sendToTarget();
        }

        @Override
        public void onNotificationActionClick(String key, long time, int actionIndex) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = time;
            args.argi1 = actionIndex;
            NotificationRankerService.this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        @Override
        public void onNotificationRemovedReason(String key, long time, int reason) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = time;
            args.argi1 = reason;
            NotificationRankerService.this.mHandler.obtainMessage(5, args).sendToTarget();
        }
    }
}

