/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.os.SystemClock;

abstract class AbstractEventLogger {
    protected final String mServiceApp;
    protected final int mCallerUid;
    protected final int mCallerPid;
    protected final long mReceivedTime;
    protected long mPlaybackStartTime = -1L;
    private volatile long mRequestProcessingStartTime = -1L;
    private volatile long mEngineStartTime = -1L;
    private volatile long mEngineCompleteTime = -1L;
    private boolean mLogWritten = false;

    AbstractEventLogger(int callerUid, int callerPid, String serviceApp) {
        this.mCallerUid = callerUid;
        this.mCallerPid = callerPid;
        this.mServiceApp = serviceApp;
        this.mReceivedTime = SystemClock.elapsedRealtime();
    }

    public void onRequestProcessingStart() {
        this.mRequestProcessingStartTime = SystemClock.elapsedRealtime();
    }

    public void onEngineDataReceived() {
        if (this.mEngineStartTime == -1L) {
            this.mEngineStartTime = SystemClock.elapsedRealtime();
        }
    }

    public void onEngineComplete() {
        this.mEngineCompleteTime = SystemClock.elapsedRealtime();
    }

    public void onAudioDataWritten() {
        if (this.mPlaybackStartTime == -1L) {
            this.mPlaybackStartTime = SystemClock.elapsedRealtime();
        }
    }

    public void onCompleted(int statusCode) {
        if (this.mLogWritten) {
            return;
        }
        this.mLogWritten = true;
        long completionTime = SystemClock.elapsedRealtime();
        if (statusCode != 0 || this.mPlaybackStartTime == -1L || this.mEngineCompleteTime == -1L) {
            this.logFailure(statusCode);
            return;
        }
        long audioLatency = this.mPlaybackStartTime - this.mReceivedTime;
        long engineLatency = this.mEngineStartTime - this.mRequestProcessingStartTime;
        long engineTotal = this.mEngineCompleteTime - this.mRequestProcessingStartTime;
        this.logSuccess(audioLatency, engineLatency, engineTotal);
    }

    protected abstract void logFailure(int var1);

    protected abstract void logSuccess(long var1, long var3, long var5);
}

