/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.speech.tts.ITextToSpeechCallback;
import android.speech.tts.ITextToSpeechService;
import android.speech.tts.TtsEngines;
import android.speech.tts.UtteranceProgressListener;
import android.speech.tts.Voice;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;

public class TextToSpeech {
    private static final String TAG = "TextToSpeech";
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int STOPPED = -2;
    public static final int ERROR_SYNTHESIS = -3;
    public static final int ERROR_SERVICE = -4;
    public static final int ERROR_OUTPUT = -5;
    public static final int ERROR_NETWORK = -6;
    public static final int ERROR_NETWORK_TIMEOUT = -7;
    public static final int ERROR_INVALID_REQUEST = -8;
    public static final int ERROR_NOT_INSTALLED_YET = -9;
    public static final int QUEUE_FLUSH = 0;
    public static final int QUEUE_ADD = 1;
    static final int QUEUE_DESTROY = 2;
    public static final int LANG_COUNTRY_VAR_AVAILABLE = 2;
    public static final int LANG_COUNTRY_AVAILABLE = 1;
    public static final int LANG_AVAILABLE = 0;
    public static final int LANG_MISSING_DATA = -1;
    public static final int LANG_NOT_SUPPORTED = -2;
    public static final String ACTION_TTS_QUEUE_PROCESSING_COMPLETED = "android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED";
    private final Context mContext;
    private Connection mConnectingServiceConnection;
    private Connection mServiceConnection;
    private OnInitListener mInitListener;
    private volatile UtteranceProgressListener mUtteranceProgressListener;
    private final Object mStartLock = new Object();
    private String mRequestedEngine;
    private final boolean mUseFallback;
    private final Map<String, Uri> mEarcons;
    private final Map<CharSequence, Uri> mUtterances;
    private final Bundle mParams = new Bundle();
    private final TtsEngines mEnginesHelper;
    private volatile String mCurrentEngine = null;

    public TextToSpeech(Context context, OnInitListener listener) {
        this(context, listener, null);
    }

    public TextToSpeech(Context context, OnInitListener listener, String engine) {
        this(context, listener, engine, null, true);
    }

    public TextToSpeech(Context context, OnInitListener listener, String engine, String packageName, boolean useFallback) {
        this.mContext = context;
        this.mInitListener = listener;
        this.mRequestedEngine = engine;
        this.mUseFallback = useFallback;
        this.mEarcons = new HashMap<String, Uri>();
        this.mUtterances = new HashMap<CharSequence, Uri>();
        this.mUtteranceProgressListener = null;
        this.mEnginesHelper = new TtsEngines(this.mContext);
        this.initTts();
    }

    private <R> R runActionNoReconnect(Action<R> action, R errorResult, String method, boolean onlyEstablishedConnection) {
        return this.runAction(action, errorResult, method, false, onlyEstablishedConnection);
    }

    private <R> R runAction(Action<R> action, R errorResult, String method) {
        return this.runAction(action, errorResult, method, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R runAction(Action<R> action, R errorResult, String method, boolean reconnect, boolean onlyEstablishedConnection) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mServiceConnection == null) {
                Log.w(TAG, method + " failed: not bound to TTS engine");
                return errorResult;
            }
            return this.mServiceConnection.runAction(action, errorResult, method, reconnect, onlyEstablishedConnection);
        }
    }

    private int initTts() {
        String defaultEngine;
        if (this.mRequestedEngine != null) {
            if (this.mEnginesHelper.isEngineInstalled(this.mRequestedEngine)) {
                if (this.connectToEngine(this.mRequestedEngine)) {
                    this.mCurrentEngine = this.mRequestedEngine;
                    return 0;
                }
                if (!this.mUseFallback) {
                    this.mCurrentEngine = null;
                    this.dispatchOnInit(-1);
                    return -1;
                }
            } else if (!this.mUseFallback) {
                Log.i(TAG, "Requested engine not installed: " + this.mRequestedEngine);
                this.mCurrentEngine = null;
                this.dispatchOnInit(-1);
                return -1;
            }
        }
        if ((defaultEngine = this.getDefaultEngine()) != null && !defaultEngine.equals(this.mRequestedEngine) && this.connectToEngine(defaultEngine)) {
            this.mCurrentEngine = defaultEngine;
            return 0;
        }
        String highestRanked = this.mEnginesHelper.getHighestRankedEngineName();
        if (highestRanked != null && !highestRanked.equals(this.mRequestedEngine) && !highestRanked.equals(defaultEngine) && this.connectToEngine(highestRanked)) {
            this.mCurrentEngine = highestRanked;
            return 0;
        }
        this.mCurrentEngine = null;
        this.dispatchOnInit(-1);
        return -1;
    }

    private boolean connectToEngine(String engine) {
        Connection connection = new Connection();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(engine);
        boolean bound = this.mContext.bindService(intent, connection, 1);
        if (!bound) {
            Log.e(TAG, "Failed to bind to " + engine);
            return false;
        }
        Log.i(TAG, "Sucessfully bound to " + engine);
        this.mConnectingServiceConnection = connection;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchOnInit(int result) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mInitListener != null) {
                this.mInitListener.onInit(result);
                this.mInitListener = null;
            }
        }
    }

    private IBinder getCallerIdentity() {
        return this.mServiceConnection.getCallerIdentity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mConnectingServiceConnection != null) {
                this.mContext.unbindService(this.mConnectingServiceConnection);
                this.mConnectingServiceConnection = null;
                return;
            }
        }
        this.runActionNoReconnect(new Action<Void>(){

            @Override
            public Void run(ITextToSpeechService service) throws RemoteException {
                service.setCallback(TextToSpeech.this.getCallerIdentity(), null);
                service.stop(TextToSpeech.this.getCallerIdentity());
                TextToSpeech.this.mServiceConnection.disconnect();
                TextToSpeech.this.mServiceConnection = null;
                TextToSpeech.this.mCurrentEngine = null;
                return null;
            }
        }, null, "shutdown", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(String text, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, this.makeResourceUri(packagename, resourceId));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(CharSequence text, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, this.makeResourceUri(packagename, resourceId));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(String text, String filename) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, Uri.parse(filename));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSpeech(CharSequence text, File file) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, Uri.fromFile(file));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEarcon(String earcon, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(earcon, this.makeResourceUri(packagename, resourceId));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int addEarcon(String earcon, String filename) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(earcon, Uri.parse(filename));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEarcon(String earcon, File file) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(earcon, Uri.fromFile(file));
            return 0;
        }
    }

    private Uri makeResourceUri(String packageName, int resourceId) {
        return new Uri.Builder().scheme("android.resource").encodedAuthority(packageName).appendEncodedPath(String.valueOf(resourceId)).build();
    }

    public int speak(final CharSequence text, final int queueMode, final Bundle params, final String utteranceId) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                Uri utteranceUri = (Uri)TextToSpeech.this.mUtterances.get(text);
                if (utteranceUri != null) {
                    return service.playAudio(TextToSpeech.this.getCallerIdentity(), utteranceUri, queueMode, TextToSpeech.this.getParams(params), utteranceId);
                }
                return service.speak(TextToSpeech.this.getCallerIdentity(), text, queueMode, TextToSpeech.this.getParams(params), utteranceId);
            }
        }, -1, "speak");
    }

    @Deprecated
    public int speak(String text, int queueMode, HashMap<String, String> params) {
        return this.speak(text, queueMode, this.convertParamsHashMaptoBundle(params), params == null ? null : params.get("utteranceId"));
    }

    public int playEarcon(final String earcon, final int queueMode, final Bundle params, final String utteranceId) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                Uri earconUri = (Uri)TextToSpeech.this.mEarcons.get(earcon);
                if (earconUri == null) {
                    return -1;
                }
                return service.playAudio(TextToSpeech.this.getCallerIdentity(), earconUri, queueMode, TextToSpeech.this.getParams(params), utteranceId);
            }
        }, -1, "playEarcon");
    }

    @Deprecated
    public int playEarcon(String earcon, int queueMode, HashMap<String, String> params) {
        return this.playEarcon(earcon, queueMode, this.convertParamsHashMaptoBundle(params), params == null ? null : params.get("utteranceId"));
    }

    public int playSilentUtterance(final long durationInMs, final int queueMode, final String utteranceId) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                return service.playSilence(TextToSpeech.this.getCallerIdentity(), durationInMs, queueMode, utteranceId);
            }
        }, -1, "playSilentUtterance");
    }

    @Deprecated
    public int playSilence(long durationInMs, int queueMode, HashMap<String, String> params) {
        return this.playSilentUtterance(durationInMs, queueMode, params == null ? null : params.get("utteranceId"));
    }

    @Deprecated
    public Set<String> getFeatures(final Locale locale) {
        return this.runAction(new Action<Set<String>>(){

            @Override
            public Set<String> run(ITextToSpeechService service) throws RemoteException {
                String[] features = null;
                try {
                    features = service.getFeaturesForLanguage(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve 3 letter ISO 639-2/T language and/or ISO 3166 country code for locale: " + locale, e);
                    return null;
                }
                if (features != null) {
                    HashSet<String> featureSet = new HashSet<String>();
                    Collections.addAll(featureSet, features);
                    return featureSet;
                }
                return null;
            }
        }, null, "getFeatures");
    }

    public boolean isSpeaking() {
        return this.runAction(new Action<Boolean>(){

            @Override
            public Boolean run(ITextToSpeechService service) throws RemoteException {
                return service.isSpeaking();
            }
        }, false, "isSpeaking");
    }

    public int stop() {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                return service.stop(TextToSpeech.this.getCallerIdentity());
            }
        }, -1, "stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setSpeechRate(float speechRate) {
        int intRate;
        if (speechRate > 0.0f && (intRate = (int)(speechRate * 100.0f)) > 0) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putInt("rate", intRate);
            }
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPitch(float pitch) {
        int intPitch;
        if (pitch > 0.0f && (intPitch = (int)(pitch * 100.0f)) > 0) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putInt("pitch", intPitch);
            }
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setAudioAttributes(AudioAttributes audioAttributes) {
        if (audioAttributes != null) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putParcelable("audioAttributes", audioAttributes);
            }
            return 0;
        }
        return -1;
    }

    public String getCurrentEngine() {
        return this.mCurrentEngine;
    }

    @Deprecated
    public Locale getDefaultLanguage() {
        return this.runAction(new Action<Locale>(){

            @Override
            public Locale run(ITextToSpeechService service) throws RemoteException {
                String[] defaultLanguage = service.getClientDefaultLanguage();
                return new Locale(defaultLanguage[0], defaultLanguage[1], defaultLanguage[2]);
            }
        }, null, "getDefaultLanguage");
    }

    public int setLanguage(final Locale loc) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                if (loc == null) {
                    return -2;
                }
                String language = null;
                String country = null;
                try {
                    language = loc.getISO3Language();
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 639-2/T language code for locale: " + loc, e);
                    return -2;
                }
                try {
                    country = loc.getISO3Country();
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 3166 country code for locale: " + loc, e);
                    return -2;
                }
                String variant = loc.getVariant();
                int result = service.isLanguageAvailable(language, country, variant);
                if (result >= 0) {
                    String voiceName = service.getDefaultVoiceNameFor(language, country, variant);
                    if (TextUtils.isEmpty(voiceName)) {
                        Log.w(TextToSpeech.TAG, "Couldn't find the default voice for " + language + "-" + country + "-" + variant);
                        return -2;
                    }
                    if (service.loadVoice(TextToSpeech.this.getCallerIdentity(), voiceName) == -1) {
                        Log.w(TextToSpeech.TAG, "The service claimed " + language + "-" + country + "-" + variant + " was available with voice name " + voiceName + " but loadVoice returned ERROR");
                        return -2;
                    }
                    Voice voice = TextToSpeech.this.getVoice(service, voiceName);
                    if (voice == null) {
                        Log.w(TextToSpeech.TAG, "getDefaultVoiceNameFor returned " + voiceName + " for locale " + language + "-" + country + "-" + variant + " but getVoice returns null");
                        return -2;
                    }
                    String voiceLanguage = "";
                    try {
                        voiceLanguage = voice.getLocale().getISO3Language();
                    }
                    catch (MissingResourceException e) {
                        Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 639-2/T language code for locale: " + voice.getLocale(), e);
                    }
                    String voiceCountry = "";
                    try {
                        voiceCountry = voice.getLocale().getISO3Country();
                    }
                    catch (MissingResourceException e) {
                        Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 3166 country code for locale: " + voice.getLocale(), e);
                    }
                    TextToSpeech.this.mParams.putString("voiceName", voiceName);
                    TextToSpeech.this.mParams.putString("language", voiceLanguage);
                    TextToSpeech.this.mParams.putString("country", voiceCountry);
                    TextToSpeech.this.mParams.putString("variant", voice.getLocale().getVariant());
                }
                return result;
            }
        }, -2, "setLanguage");
    }

    @Deprecated
    public Locale getLanguage() {
        return this.runAction(new Action<Locale>(){

            @Override
            public Locale run(ITextToSpeechService service) {
                String lang = TextToSpeech.this.mParams.getString("language", "");
                String country = TextToSpeech.this.mParams.getString("country", "");
                String variant = TextToSpeech.this.mParams.getString("variant", "");
                return new Locale(lang, country, variant);
            }
        }, null, "getLanguage");
    }

    public Set<Locale> getAvailableLanguages() {
        return this.runAction(new Action<Set<Locale>>(){

            @Override
            public Set<Locale> run(ITextToSpeechService service) throws RemoteException {
                List<Voice> voices = service.getVoices();
                if (voices == null) {
                    return new HashSet<Locale>();
                }
                HashSet<Locale> locales = new HashSet<Locale>();
                for (Voice voice : voices) {
                    locales.add(voice.getLocale());
                }
                return locales;
            }
        }, null, "getAvailableLanguages");
    }

    public Set<Voice> getVoices() {
        return this.runAction(new Action<Set<Voice>>(){

            @Override
            public Set<Voice> run(ITextToSpeechService service) throws RemoteException {
                List<Voice> voices = service.getVoices();
                return voices != null ? new HashSet<Voice>(voices) : new HashSet();
            }
        }, null, "getVoices");
    }

    public int setVoice(final Voice voice) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                int result = service.loadVoice(TextToSpeech.this.getCallerIdentity(), voice.getName());
                if (result == 0) {
                    TextToSpeech.this.mParams.putString("voiceName", voice.getName());
                    String language = "";
                    try {
                        language = voice.getLocale().getISO3Language();
                    }
                    catch (MissingResourceException e) {
                        Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 639-2/T language code for locale: " + voice.getLocale(), e);
                    }
                    String country = "";
                    try {
                        country = voice.getLocale().getISO3Country();
                    }
                    catch (MissingResourceException e) {
                        Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 3166 country code for locale: " + voice.getLocale(), e);
                    }
                    TextToSpeech.this.mParams.putString("language", language);
                    TextToSpeech.this.mParams.putString("country", country);
                    TextToSpeech.this.mParams.putString("variant", voice.getLocale().getVariant());
                }
                return result;
            }
        }, -2, "setVoice");
    }

    public Voice getVoice() {
        return this.runAction(new Action<Voice>(){

            @Override
            public Voice run(ITextToSpeechService service) throws RemoteException {
                String voiceName = TextToSpeech.this.mParams.getString("voiceName", "");
                if (TextUtils.isEmpty(voiceName)) {
                    return null;
                }
                return TextToSpeech.this.getVoice(service, voiceName);
            }
        }, null, "getVoice");
    }

    private Voice getVoice(ITextToSpeechService service, String voiceName) throws RemoteException {
        List<Voice> voices = service.getVoices();
        if (voices == null) {
            Log.w(TAG, "getVoices returned null");
            return null;
        }
        for (Voice voice : voices) {
            if (!voice.getName().equals(voiceName)) continue;
            return voice;
        }
        Log.w(TAG, "Could not find voice " + voiceName + " in voice list");
        return null;
    }

    public Voice getDefaultVoice() {
        return this.runAction(new Action<Voice>(){

            @Override
            public Voice run(ITextToSpeechService service) throws RemoteException {
                String variant;
                String[] defaultLanguage = service.getClientDefaultLanguage();
                if (defaultLanguage == null || defaultLanguage.length == 0) {
                    Log.e(TextToSpeech.TAG, "service.getClientDefaultLanguage() returned empty array");
                    return null;
                }
                String language = defaultLanguage[0];
                String country = defaultLanguage.length > 1 ? defaultLanguage[1] : "";
                int result = service.isLanguageAvailable(language, country, variant = defaultLanguage.length > 2 ? defaultLanguage[2] : "");
                if (result < 0) {
                    return null;
                }
                String voiceName = service.getDefaultVoiceNameFor(language, country, variant);
                if (TextUtils.isEmpty(voiceName)) {
                    return null;
                }
                List<Voice> voices = service.getVoices();
                if (voices == null) {
                    return null;
                }
                for (Voice voice : voices) {
                    if (!voice.getName().equals(voiceName)) continue;
                    return voice;
                }
                return null;
            }
        }, null, "getDefaultVoice");
    }

    public int isLanguageAvailable(final Locale loc) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                String language = null;
                String country = null;
                try {
                    language = loc.getISO3Language();
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 639-2/T language code for locale: " + loc, e);
                    return -2;
                }
                try {
                    country = loc.getISO3Country();
                }
                catch (MissingResourceException e) {
                    Log.w(TextToSpeech.TAG, "Couldn't retrieve ISO 3166 country code for locale: " + loc, e);
                    return -2;
                }
                return service.isLanguageAvailable(language, country, loc.getVariant());
            }
        }, -2, "isLanguageAvailable");
    }

    public int synthesizeToFile(final CharSequence text, final Bundle params, final File file, final String utteranceId) {
        return this.runAction(new Action<Integer>(){

            @Override
            public Integer run(ITextToSpeechService service) throws RemoteException {
                try {
                    if (file.exists() && !file.canWrite()) {
                        Log.e(TextToSpeech.TAG, "Can't write to " + file);
                        return -1;
                    }
                    ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open(file, 0x2C000000);
                    int returnValue = service.synthesizeToFileDescriptor(TextToSpeech.this.getCallerIdentity(), text, fileDescriptor, TextToSpeech.this.getParams(params), utteranceId);
                    fileDescriptor.close();
                    return returnValue;
                }
                catch (FileNotFoundException e) {
                    Log.e(TextToSpeech.TAG, "Opening file " + file + " failed", e);
                    return -1;
                }
                catch (IOException e) {
                    Log.e(TextToSpeech.TAG, "Closing file " + file + " failed", e);
                    return -1;
                }
            }
        }, -1, "synthesizeToFile");
    }

    @Deprecated
    public int synthesizeToFile(String text, HashMap<String, String> params, String filename) {
        return this.synthesizeToFile(text, this.convertParamsHashMaptoBundle(params), new File(filename), params.get("utteranceId"));
    }

    private Bundle convertParamsHashMaptoBundle(HashMap<String, String> params) {
        if (params != null && !params.isEmpty()) {
            Bundle bundle = new Bundle();
            this.copyIntParam(bundle, params, "streamType");
            this.copyIntParam(bundle, params, "sessionId");
            this.copyStringParam(bundle, params, "utteranceId");
            this.copyFloatParam(bundle, params, "volume");
            this.copyFloatParam(bundle, params, "pan");
            this.copyStringParam(bundle, params, "networkTts");
            this.copyStringParam(bundle, params, "embeddedTts");
            this.copyIntParam(bundle, params, "networkTimeoutMs");
            this.copyIntParam(bundle, params, "networkRetriesCount");
            if (!TextUtils.isEmpty(this.mCurrentEngine)) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (key == null || !key.startsWith(this.mCurrentEngine)) continue;
                    bundle.putString(key, entry.getValue());
                }
            }
            return bundle;
        }
        return null;
    }

    private Bundle getParams(Bundle params) {
        if (params != null && !params.isEmpty()) {
            Bundle bundle = new Bundle(this.mParams);
            bundle.putAll(params);
            TextToSpeech.verifyIntegerBundleParam(bundle, "streamType");
            TextToSpeech.verifyIntegerBundleParam(bundle, "sessionId");
            TextToSpeech.verifyStringBundleParam(bundle, "utteranceId");
            TextToSpeech.verifyFloatBundleParam(bundle, "volume");
            TextToSpeech.verifyFloatBundleParam(bundle, "pan");
            TextToSpeech.verifyBooleanBundleParam(bundle, "networkTts");
            TextToSpeech.verifyBooleanBundleParam(bundle, "embeddedTts");
            TextToSpeech.verifyIntegerBundleParam(bundle, "networkTimeoutMs");
            TextToSpeech.verifyIntegerBundleParam(bundle, "networkRetriesCount");
            return bundle;
        }
        return this.mParams;
    }

    private static boolean verifyIntegerBundleParam(Bundle bundle, String key) {
        if (bundle.containsKey(key) && !(bundle.get(key) instanceof Integer) && !(bundle.get(key) instanceof Long)) {
            bundle.remove(key);
            Log.w(TAG, "Synthesis request paramter " + key + " containst value " + " with invalid type. Should be an Integer or a Long");
            return false;
        }
        return true;
    }

    private static boolean verifyStringBundleParam(Bundle bundle, String key) {
        if (bundle.containsKey(key) && !(bundle.get(key) instanceof String)) {
            bundle.remove(key);
            Log.w(TAG, "Synthesis request paramter " + key + " containst value " + " with invalid type. Should be a String");
            return false;
        }
        return true;
    }

    private static boolean verifyBooleanBundleParam(Bundle bundle, String key) {
        if (bundle.containsKey(key) && !(bundle.get(key) instanceof Boolean) && !(bundle.get(key) instanceof String)) {
            bundle.remove(key);
            Log.w(TAG, "Synthesis request paramter " + key + " containst value " + " with invalid type. Should be a Boolean or String");
            return false;
        }
        return true;
    }

    private static boolean verifyFloatBundleParam(Bundle bundle, String key) {
        if (bundle.containsKey(key) && !(bundle.get(key) instanceof Float) && !(bundle.get(key) instanceof Double)) {
            bundle.remove(key);
            Log.w(TAG, "Synthesis request paramter " + key + " containst value " + " with invalid type. Should be a Float or a Double");
            return false;
        }
        return true;
    }

    private void copyStringParam(Bundle bundle, HashMap<String, String> params, String key) {
        String value = params.get(key);
        if (value != null) {
            bundle.putString(key, value);
        }
    }

    private void copyIntParam(Bundle bundle, HashMap<String, String> params, String key) {
        String valueString = params.get(key);
        if (!TextUtils.isEmpty(valueString)) {
            try {
                int value = Integer.parseInt(valueString);
                bundle.putInt(key, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void copyFloatParam(Bundle bundle, HashMap<String, String> params, String key) {
        String valueString = params.get(key);
        if (!TextUtils.isEmpty(valueString)) {
            try {
                float value = Float.parseFloat(valueString);
                bundle.putFloat(key, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public int setOnUtteranceCompletedListener(OnUtteranceCompletedListener listener) {
        this.mUtteranceProgressListener = UtteranceProgressListener.from(listener);
        return 0;
    }

    public int setOnUtteranceProgressListener(UtteranceProgressListener listener) {
        this.mUtteranceProgressListener = listener;
        return 0;
    }

    @Deprecated
    public int setEngineByPackageName(String enginePackageName) {
        this.mRequestedEngine = enginePackageName;
        return this.initTts();
    }

    public String getDefaultEngine() {
        return this.mEnginesHelper.getDefaultEngine();
    }

    @Deprecated
    public boolean areDefaultsEnforced() {
        return false;
    }

    public List<EngineInfo> getEngines() {
        return this.mEnginesHelper.getEngines();
    }

    public static int getMaxSpeechInputLength() {
        return 4000;
    }

    public static class EngineInfo {
        public String name;
        public String label;
        public int icon;
        public boolean system;
        public int priority;

        public String toString() {
            return "EngineInfo{name=" + this.name + "}";
        }
    }

    private static interface Action<R> {
        public R run(ITextToSpeechService var1) throws RemoteException;
    }

    private class Connection
    implements ServiceConnection {
        private ITextToSpeechService mService;
        private SetupConnectionAsyncTask mOnSetupConnectionAsyncTask;
        private boolean mEstablished;
        private final ITextToSpeechCallback.Stub mCallback = new ITextToSpeechCallback.Stub(){

            @Override
            public void onStop(String utteranceId, boolean isStarted) throws RemoteException {
                UtteranceProgressListener listener = TextToSpeech.this.mUtteranceProgressListener;
                if (listener != null) {
                    listener.onStop(utteranceId, isStarted);
                }
            }

            @Override
            public void onSuccess(String utteranceId) {
                UtteranceProgressListener listener = TextToSpeech.this.mUtteranceProgressListener;
                if (listener != null) {
                    listener.onDone(utteranceId);
                }
            }

            @Override
            public void onError(String utteranceId, int errorCode) {
                UtteranceProgressListener listener = TextToSpeech.this.mUtteranceProgressListener;
                if (listener != null) {
                    listener.onError(utteranceId);
                }
            }

            @Override
            public void onStart(String utteranceId) {
                UtteranceProgressListener listener = TextToSpeech.this.mUtteranceProgressListener;
                if (listener != null) {
                    listener.onStart(utteranceId);
                }
            }

            @Override
            public void onBeginSynthesis(String utteranceId, int sampleRateInHz, int audioFormat, int channelCount) {
                UtteranceProgressListener listener = TextToSpeech.this.mUtteranceProgressListener;
                if (listener != null) {
                    listener.onBeginSynthesis(utteranceId, sampleRateInHz, audioFormat, channelCount);
                }
            }

            @Override
            public void onAudioAvailable(String utteranceId, byte[] audio) {
                UtteranceProgressListener listener = TextToSpeech.this.mUtteranceProgressListener;
                if (listener != null) {
                    listener.onAudioAvailable(utteranceId, audio);
                }
            }
        };

        private Connection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = TextToSpeech.this.mStartLock;
            synchronized (object) {
                TextToSpeech.this.mConnectingServiceConnection = null;
                Log.i(TextToSpeech.TAG, "Connected to " + name);
                if (this.mOnSetupConnectionAsyncTask != null) {
                    this.mOnSetupConnectionAsyncTask.cancel(false);
                }
                this.mService = ITextToSpeechService.Stub.asInterface(service);
                TextToSpeech.this.mServiceConnection = this;
                this.mEstablished = false;
                this.mOnSetupConnectionAsyncTask = new SetupConnectionAsyncTask(name);
                this.mOnSetupConnectionAsyncTask.execute(new Void[0]);
            }
        }

        public IBinder getCallerIdentity() {
            return this.mCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean clearServiceConnection() {
            Object object = TextToSpeech.this.mStartLock;
            synchronized (object) {
                boolean result = false;
                if (this.mOnSetupConnectionAsyncTask != null) {
                    result = this.mOnSetupConnectionAsyncTask.cancel(false);
                    this.mOnSetupConnectionAsyncTask = null;
                }
                this.mService = null;
                if (TextToSpeech.this.mServiceConnection == this) {
                    TextToSpeech.this.mServiceConnection = null;
                }
                return result;
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Log.i(TextToSpeech.TAG, "Asked to disconnect from " + name);
            if (this.clearServiceConnection()) {
                TextToSpeech.this.dispatchOnInit(-1);
            }
        }

        public void disconnect() {
            TextToSpeech.this.mContext.unbindService(this);
            this.clearServiceConnection();
        }

        public boolean isEstablished() {
            return this.mService != null && this.mEstablished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R runAction(Action<R> action, R errorResult, String method, boolean reconnect, boolean onlyEstablishedConnection) {
            Object object = TextToSpeech.this.mStartLock;
            synchronized (object) {
                try {
                    if (this.mService == null) {
                        Log.w(TextToSpeech.TAG, method + " failed: not connected to TTS engine");
                        return errorResult;
                    }
                    if (onlyEstablishedConnection && !this.isEstablished()) {
                        Log.w(TextToSpeech.TAG, method + " failed: TTS engine connection not fully set up");
                        return errorResult;
                    }
                    return action.run(this.mService);
                }
                catch (RemoteException ex) {
                    Log.e(TextToSpeech.TAG, method + " failed", ex);
                    if (reconnect) {
                        this.disconnect();
                        TextToSpeech.this.initTts();
                    }
                    return errorResult;
                }
            }
        }

        private class SetupConnectionAsyncTask
        extends AsyncTask<Void, Void, Integer> {
            private final ComponentName mName;

            public SetupConnectionAsyncTask(ComponentName name) {
                this.mName = name;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Integer doInBackground(Void ... params) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    try {
                        Connection.this.mService.setCallback(Connection.this.getCallerIdentity(), Connection.this.mCallback);
                        if (TextToSpeech.this.mParams.getString("language") == null) {
                            String[] defaultLanguage = Connection.this.mService.getClientDefaultLanguage();
                            TextToSpeech.this.mParams.putString("language", defaultLanguage[0]);
                            TextToSpeech.this.mParams.putString("country", defaultLanguage[1]);
                            TextToSpeech.this.mParams.putString("variant", defaultLanguage[2]);
                            String defaultVoiceName = Connection.this.mService.getDefaultVoiceNameFor(defaultLanguage[0], defaultLanguage[1], defaultLanguage[2]);
                            TextToSpeech.this.mParams.putString("voiceName", defaultVoiceName);
                        }
                        Log.i(TextToSpeech.TAG, "Set up connection to " + this.mName);
                        return 0;
                    }
                    catch (RemoteException re) {
                        Log.e(TextToSpeech.TAG, "Error connecting to service, setCallback() failed");
                        return -1;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onPostExecute(Integer result) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    if (Connection.this.mOnSetupConnectionAsyncTask == this) {
                        Connection.this.mOnSetupConnectionAsyncTask = null;
                    }
                    Connection.this.mEstablished = true;
                    TextToSpeech.this.dispatchOnInit(result);
                }
            }
        }
    }

    public class Engine {
        public static final int DEFAULT_RATE = 100;
        public static final int DEFAULT_PITCH = 100;
        public static final float DEFAULT_VOLUME = 1.0f;
        public static final float DEFAULT_PAN = 0.0f;
        public static final int USE_DEFAULTS = 0;
        @Deprecated
        public static final String DEFAULT_ENGINE = "com.svox.pico";
        public static final int DEFAULT_STREAM = 3;
        public static final int CHECK_VOICE_DATA_PASS = 1;
        public static final int CHECK_VOICE_DATA_FAIL = 0;
        @Deprecated
        public static final int CHECK_VOICE_DATA_BAD_DATA = -1;
        @Deprecated
        public static final int CHECK_VOICE_DATA_MISSING_DATA = -2;
        @Deprecated
        public static final int CHECK_VOICE_DATA_MISSING_VOLUME = -3;
        public static final String INTENT_ACTION_TTS_SERVICE = "android.intent.action.TTS_SERVICE";
        public static final String SERVICE_META_DATA = "android.speech.tts";
        public static final String ACTION_INSTALL_TTS_DATA = "android.speech.tts.engine.INSTALL_TTS_DATA";
        public static final String ACTION_TTS_DATA_INSTALLED = "android.speech.tts.engine.TTS_DATA_INSTALLED";
        public static final String ACTION_CHECK_TTS_DATA = "android.speech.tts.engine.CHECK_TTS_DATA";
        public static final String ACTION_GET_SAMPLE_TEXT = "android.speech.tts.engine.GET_SAMPLE_TEXT";
        public static final String EXTRA_SAMPLE_TEXT = "sampleText";
        public static final String EXTRA_AVAILABLE_VOICES = "availableVoices";
        public static final String EXTRA_UNAVAILABLE_VOICES = "unavailableVoices";
        @Deprecated
        public static final String EXTRA_VOICE_DATA_ROOT_DIRECTORY = "dataRoot";
        @Deprecated
        public static final String EXTRA_VOICE_DATA_FILES = "dataFiles";
        @Deprecated
        public static final String EXTRA_VOICE_DATA_FILES_INFO = "dataFilesInfo";
        @Deprecated
        public static final String EXTRA_CHECK_VOICE_DATA_FOR = "checkVoiceDataFor";
        @Deprecated
        public static final String EXTRA_TTS_DATA_INSTALLED = "dataInstalled";
        public static final String KEY_PARAM_RATE = "rate";
        public static final String KEY_PARAM_VOICE_NAME = "voiceName";
        public static final String KEY_PARAM_LANGUAGE = "language";
        public static final String KEY_PARAM_COUNTRY = "country";
        public static final String KEY_PARAM_VARIANT = "variant";
        public static final String KEY_PARAM_ENGINE = "engine";
        public static final String KEY_PARAM_PITCH = "pitch";
        public static final String KEY_PARAM_STREAM = "streamType";
        public static final String KEY_PARAM_AUDIO_ATTRIBUTES = "audioAttributes";
        public static final String KEY_PARAM_UTTERANCE_ID = "utteranceId";
        public static final String KEY_PARAM_VOLUME = "volume";
        public static final String KEY_PARAM_PAN = "pan";
        @Deprecated
        public static final String KEY_FEATURE_NETWORK_SYNTHESIS = "networkTts";
        @Deprecated
        public static final String KEY_FEATURE_EMBEDDED_SYNTHESIS = "embeddedTts";
        public static final String KEY_PARAM_SESSION_ID = "sessionId";
        public static final String KEY_FEATURE_NOT_INSTALLED = "notInstalled";
        public static final String KEY_FEATURE_NETWORK_TIMEOUT_MS = "networkTimeoutMs";
        public static final String KEY_FEATURE_NETWORK_RETRIES_COUNT = "networkRetriesCount";
    }

    @Deprecated
    public static interface OnUtteranceCompletedListener {
        public void onUtteranceCompleted(String var1);
    }

    public static interface OnInitListener {
        public void onInit(int var1);
    }
}

