/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.app.Service;
import android.content.Intent;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.provider.Settings;
import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.AudioPlaybackHandler;
import android.speech.tts.AudioPlaybackQueueItem;
import android.speech.tts.EventLoggerV1;
import android.speech.tts.FileSynthesisCallback;
import android.speech.tts.ITextToSpeechCallback;
import android.speech.tts.ITextToSpeechService;
import android.speech.tts.PlaybackSynthesisCallback;
import android.speech.tts.SilencePlaybackQueueItem;
import android.speech.tts.SynthesisCallback;
import android.speech.tts.SynthesisRequest;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TtsEngines;
import android.speech.tts.Voice;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

public abstract class TextToSpeechService
extends Service {
    private static final boolean DBG = false;
    private static final String TAG = "TextToSpeechService";
    private static final String SYNTH_THREAD_NAME = "SynthThread";
    private SynthHandler mSynthHandler;
    private AudioPlaybackHandler mAudioPlaybackHandler;
    private TtsEngines mEngineHelper;
    private CallbackMap mCallbacks;
    private String mPackageName;
    private final Object mVoicesInfoLock = new Object();
    private final ITextToSpeechService.Stub mBinder = new ITextToSpeechService.Stub(){

        @Override
        public int speak(IBinder caller, CharSequence text, int queueMode, Bundle params, String utteranceId) {
            if (!this.checkNonNull(caller, text, params)) {
                return -1;
            }
            SynthesisSpeechItemV1 item = new SynthesisSpeechItemV1(caller, Binder.getCallingUid(), Binder.getCallingPid(), params, utteranceId, text);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(queueMode, item);
        }

        @Override
        public int synthesizeToFileDescriptor(IBinder caller, CharSequence text, ParcelFileDescriptor fileDescriptor, Bundle params, String utteranceId) {
            if (!this.checkNonNull(caller, text, fileDescriptor, params)) {
                return -1;
            }
            ParcelFileDescriptor sameFileDescriptor = ParcelFileDescriptor.adoptFd(fileDescriptor.detachFd());
            SynthesisToFileOutputStreamSpeechItemV1 item = new SynthesisToFileOutputStreamSpeechItemV1(caller, Binder.getCallingUid(), Binder.getCallingPid(), params, utteranceId, text, new ParcelFileDescriptor.AutoCloseOutputStream(sameFileDescriptor));
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(1, item);
        }

        @Override
        public int playAudio(IBinder caller, Uri audioUri, int queueMode, Bundle params, String utteranceId) {
            if (!this.checkNonNull(caller, audioUri, params)) {
                return -1;
            }
            AudioSpeechItemV1 item = new AudioSpeechItemV1(caller, Binder.getCallingUid(), Binder.getCallingPid(), params, utteranceId, audioUri);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(queueMode, item);
        }

        @Override
        public int playSilence(IBinder caller, long duration, int queueMode, String utteranceId) {
            if (!this.checkNonNull(caller)) {
                return -1;
            }
            SilenceSpeechItem item = new SilenceSpeechItem(caller, Binder.getCallingUid(), Binder.getCallingPid(), utteranceId, duration);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(queueMode, item);
        }

        @Override
        public boolean isSpeaking() {
            return TextToSpeechService.this.mSynthHandler.isSpeaking() || TextToSpeechService.this.mAudioPlaybackHandler.isSpeaking();
        }

        @Override
        public int stop(IBinder caller) {
            if (!this.checkNonNull(caller)) {
                return -1;
            }
            return TextToSpeechService.this.mSynthHandler.stopForApp(caller);
        }

        @Override
        public String[] getLanguage() {
            return TextToSpeechService.this.onGetLanguage();
        }

        @Override
        public String[] getClientDefaultLanguage() {
            return TextToSpeechService.this.getSettingsLocale();
        }

        @Override
        public int isLanguageAvailable(String lang, String country, String variant) {
            if (!this.checkNonNull(lang)) {
                return -1;
            }
            return TextToSpeechService.this.onIsLanguageAvailable(lang, country, variant);
        }

        @Override
        public String[] getFeaturesForLanguage(String lang, String country, String variant) {
            Set<String> features = TextToSpeechService.this.onGetFeaturesForLanguage(lang, country, variant);
            String[] featuresArray = null;
            if (features != null) {
                featuresArray = new String[features.size()];
                features.toArray(featuresArray);
            } else {
                featuresArray = new String[]{};
            }
            return featuresArray;
        }

        @Override
        public int loadLanguage(IBinder caller, String lang, String country, String variant) {
            if (!this.checkNonNull(lang)) {
                return -1;
            }
            int retVal = TextToSpeechService.this.onIsLanguageAvailable(lang, country, variant);
            if (retVal == 0 || retVal == 1 || retVal == 2) {
                LoadLanguageItem item = new LoadLanguageItem(caller, Binder.getCallingUid(), Binder.getCallingPid(), lang, country, variant);
                if (TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(1, item) != 0) {
                    return -1;
                }
            }
            return retVal;
        }

        @Override
        public List<Voice> getVoices() {
            return TextToSpeechService.this.onGetVoices();
        }

        @Override
        public int loadVoice(IBinder caller, String voiceName) {
            if (!this.checkNonNull(voiceName)) {
                return -1;
            }
            int retVal = TextToSpeechService.this.onIsValidVoiceName(voiceName);
            if (retVal == 0) {
                LoadVoiceItem item = new LoadVoiceItem(caller, Binder.getCallingUid(), Binder.getCallingPid(), voiceName);
                if (TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(1, item) != 0) {
                    return -1;
                }
            }
            return retVal;
        }

        @Override
        public String getDefaultVoiceNameFor(String lang, String country, String variant) {
            if (!this.checkNonNull(lang)) {
                return null;
            }
            int retVal = TextToSpeechService.this.onIsLanguageAvailable(lang, country, variant);
            if (retVal == 0 || retVal == 1 || retVal == 2) {
                return TextToSpeechService.this.onGetDefaultVoiceNameFor(lang, country, variant);
            }
            return null;
        }

        @Override
        public void setCallback(IBinder caller, ITextToSpeechCallback cb) {
            if (!this.checkNonNull(caller)) {
                return;
            }
            TextToSpeechService.this.mCallbacks.setCallback(caller, cb);
        }

        private String intern(String in) {
            return in.intern();
        }

        private boolean checkNonNull(Object ... args) {
            for (Object o : args) {
                if (o != null) continue;
                return false;
            }
            return true;
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        SynthThread synthThread = new SynthThread();
        synthThread.start();
        this.mSynthHandler = new SynthHandler(synthThread.getLooper());
        this.mAudioPlaybackHandler = new AudioPlaybackHandler();
        this.mAudioPlaybackHandler.start();
        this.mEngineHelper = new TtsEngines(this);
        this.mCallbacks = new CallbackMap();
        this.mPackageName = this.getApplicationInfo().packageName;
        String[] defaultLocale = this.getSettingsLocale();
        this.onLoadLanguage(defaultLocale[0], defaultLocale[1], defaultLocale[2]);
    }

    @Override
    public void onDestroy() {
        this.mSynthHandler.quit();
        this.mAudioPlaybackHandler.quit();
        this.mCallbacks.kill();
        super.onDestroy();
    }

    protected abstract int onIsLanguageAvailable(String var1, String var2, String var3);

    protected abstract String[] onGetLanguage();

    protected abstract int onLoadLanguage(String var1, String var2, String var3);

    protected abstract void onStop();

    protected abstract void onSynthesizeText(SynthesisRequest var1, SynthesisCallback var2);

    protected Set<String> onGetFeaturesForLanguage(String lang, String country, String variant) {
        return new HashSet<String>();
    }

    private int getExpectedLanguageAvailableStatus(Locale locale) {
        int expectedStatus = 2;
        if (locale.getVariant().isEmpty()) {
            expectedStatus = locale.getCountry().isEmpty() ? 0 : 1;
        }
        return expectedStatus;
    }

    public List<Voice> onGetVoices() {
        ArrayList<Voice> voices = new ArrayList<Voice>();
        for (Locale locale : Locale.getAvailableLocales()) {
            int expectedStatus = this.getExpectedLanguageAvailableStatus(locale);
            try {
                int localeStatus = this.onIsLanguageAvailable(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
                if (localeStatus != expectedStatus) {
                }
            }
            catch (MissingResourceException e) {}
            continue;
            Set<String> features = this.onGetFeaturesForLanguage(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            String voiceName = this.onGetDefaultVoiceNameFor(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            voices.add(new Voice(voiceName, locale, 300, 300, false, features));
        }
        return voices;
    }

    public String onGetDefaultVoiceNameFor(String lang, String country, String variant) {
        int localeStatus = this.onIsLanguageAvailable(lang, country, variant);
        Locale iso3Locale = null;
        switch (localeStatus) {
            case 0: {
                iso3Locale = new Locale(lang);
                break;
            }
            case 1: {
                iso3Locale = new Locale(lang, country);
                break;
            }
            case 2: {
                iso3Locale = new Locale(lang, country, variant);
                break;
            }
            default: {
                return null;
            }
        }
        Locale properLocale = TtsEngines.normalizeTTSLocale(iso3Locale);
        String voiceName = properLocale.toLanguageTag();
        if (this.onIsValidVoiceName(voiceName) == 0) {
            return voiceName;
        }
        return null;
    }

    public int onLoadVoice(String voiceName) {
        Locale locale = Locale.forLanguageTag(voiceName);
        if (locale == null) {
            return -1;
        }
        int expectedStatus = this.getExpectedLanguageAvailableStatus(locale);
        try {
            int localeStatus = this.onIsLanguageAvailable(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            if (localeStatus != expectedStatus) {
                return -1;
            }
            this.onLoadLanguage(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            return 0;
        }
        catch (MissingResourceException e) {
            return -1;
        }
    }

    public int onIsValidVoiceName(String voiceName) {
        Locale locale = Locale.forLanguageTag(voiceName);
        if (locale == null) {
            return -1;
        }
        int expectedStatus = this.getExpectedLanguageAvailableStatus(locale);
        try {
            int localeStatus = this.onIsLanguageAvailable(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            if (localeStatus != expectedStatus) {
                return -1;
            }
            return 0;
        }
        catch (MissingResourceException e) {
            return -1;
        }
    }

    private int getDefaultSpeechRate() {
        return this.getSecureSettingInt("tts_default_rate", 100);
    }

    private String[] getSettingsLocale() {
        Locale locale = this.mEngineHelper.getLocalePrefForEngine(this.mPackageName);
        return TtsEngines.toOldLocaleStringFormat(locale);
    }

    private int getSecureSettingInt(String name, int defaultValue) {
        return Settings.Secure.getInt(this.getContentResolver(), name, defaultValue);
    }

    @Override
    public IBinder onBind(Intent intent) {
        if ("android.intent.action.TTS_SERVICE".equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    private class CallbackMap
    extends RemoteCallbackList<ITextToSpeechCallback> {
        private final HashMap<IBinder, ITextToSpeechCallback> mCallerToCallback = new HashMap();

        private CallbackMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCallback(IBinder caller, ITextToSpeechCallback cb) {
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                ITextToSpeechCallback old;
                if (cb != null) {
                    this.register(cb, caller);
                    old = this.mCallerToCallback.put(caller, cb);
                } else {
                    old = this.mCallerToCallback.remove(caller);
                }
                if (old != null && old != cb) {
                    this.unregister(old);
                }
            }
        }

        public void dispatchOnStop(Object callerIdentity, String utteranceId, boolean started) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onStop(utteranceId, started);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onStop failed: " + e);
            }
        }

        public void dispatchOnSuccess(Object callerIdentity, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onSuccess(utteranceId);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onDone failed: " + e);
            }
        }

        public void dispatchOnStart(Object callerIdentity, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onStart(utteranceId);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onStart failed: " + e);
            }
        }

        public void dispatchOnError(Object callerIdentity, String utteranceId, int errorCode) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onError(utteranceId, errorCode);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onError failed: " + e);
            }
        }

        public void dispatchOnBeginSynthesis(Object callerIdentity, String utteranceId, int sampleRateInHz, int audioFormat, int channelCount) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onBeginSynthesis(utteranceId, sampleRateInHz, audioFormat, channelCount);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback dispatchOnBeginSynthesis(String, int, int, int) failed: " + e);
            }
        }

        public void dispatchOnAudioAvailable(Object callerIdentity, String utteranceId, byte[] buffer) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onAudioAvailable(utteranceId, buffer);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback dispatchOnAudioAvailable(String, byte[]) failed: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallbackDied(ITextToSpeechCallback callback, Object cookie) {
            IBinder caller = (IBinder)cookie;
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                this.mCallerToCallback.remove(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void kill() {
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                this.mCallerToCallback.clear();
                super.kill();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ITextToSpeechCallback getCallbackFor(Object caller) {
            ITextToSpeechCallback cb;
            IBinder asBinder = (IBinder)caller;
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                cb = this.mCallerToCallback.get(asBinder);
            }
            return cb;
        }
    }

    private class LoadVoiceItem
    extends SpeechItem {
        private final String mVoiceName;

        public LoadVoiceItem(Object callerIdentity, int callerUid, int callerPid, String voiceName) {
            super(callerIdentity, callerUid, callerPid);
            this.mVoiceName = voiceName;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void playImpl() {
            TextToSpeechService.this.onLoadVoice(this.mVoiceName);
        }

        @Override
        protected void stopImpl() {
        }
    }

    private class LoadLanguageItem
    extends SpeechItem {
        private final String mLanguage;
        private final String mCountry;
        private final String mVariant;

        public LoadLanguageItem(Object callerIdentity, int callerUid, int callerPid, String language, String country, String variant) {
            super(callerIdentity, callerUid, callerPid);
            this.mLanguage = language;
            this.mCountry = country;
            this.mVariant = variant;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void playImpl() {
            TextToSpeechService.this.onLoadLanguage(this.mLanguage, this.mCountry, this.mVariant);
        }

        @Override
        protected void stopImpl() {
        }
    }

    private class SilenceSpeechItem
    extends UtteranceSpeechItem {
        private final long mDuration;
        private final String mUtteranceId;

        public SilenceSpeechItem(Object callerIdentity, int callerUid, int callerPid, String utteranceId, long duration) {
            super(callerIdentity, callerUid, callerPid);
            this.mUtteranceId = utteranceId;
            this.mDuration = duration;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void playImpl() {
            TextToSpeechService.this.mAudioPlaybackHandler.enqueue(new SilencePlaybackQueueItem(this, this.getCallerIdentity(), this.mDuration));
        }

        @Override
        protected void stopImpl() {
        }

        @Override
        public String getUtteranceId() {
            return this.mUtteranceId;
        }
    }

    private class AudioSpeechItemV1
    extends SpeechItemV1 {
        private final AudioPlaybackQueueItem mItem;

        public AudioSpeechItemV1(Object callerIdentity, int callerUid, int callerPid, Bundle params, String utteranceId, Uri uri) {
            super(callerIdentity, callerUid, callerPid, params, utteranceId);
            this.mItem = new AudioPlaybackQueueItem(this, this.getCallerIdentity(), TextToSpeechService.this, uri, this.getAudioParams());
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        protected void playImpl() {
            TextToSpeechService.this.mAudioPlaybackHandler.enqueue(this.mItem);
        }

        @Override
        protected void stopImpl() {
        }

        @Override
        public String getUtteranceId() {
            return this.getStringParam(this.mParams, "utteranceId", null);
        }

        @Override
        AudioOutputParams getAudioParams() {
            return AudioOutputParams.createFromV1ParamsBundle(this.mParams, false);
        }
    }

    private class SynthesisToFileOutputStreamSpeechItemV1
    extends SynthesisSpeechItemV1 {
        private final FileOutputStream mFileOutputStream;

        public SynthesisToFileOutputStreamSpeechItemV1(Object callerIdentity, int callerUid, int callerPid, Bundle params, String utteranceId, CharSequence text, FileOutputStream fileOutputStream) {
            super(callerIdentity, callerUid, callerPid, params, utteranceId, text);
            this.mFileOutputStream = fileOutputStream;
        }

        @Override
        protected AbstractSynthesisCallback createSynthesisCallback() {
            return new FileSynthesisCallback(this.mFileOutputStream.getChannel(), this, false);
        }

        @Override
        protected void playImpl() {
            this.dispatchOnStart();
            super.playImpl();
            try {
                this.mFileOutputStream.close();
            }
            catch (IOException e) {
                Log.w(TextToSpeechService.TAG, "Failed to close output file", e);
            }
        }
    }

    class SynthesisSpeechItemV1
    extends SpeechItemV1 {
        private final CharSequence mText;
        private final SynthesisRequest mSynthesisRequest;
        private final String[] mDefaultLocale;
        private AbstractSynthesisCallback mSynthesisCallback;
        private final EventLoggerV1 mEventLogger;
        private final int mCallerUid;

        public SynthesisSpeechItemV1(Object callerIdentity, int callerUid, int callerPid, Bundle params, String utteranceId, CharSequence text) {
            super(callerIdentity, callerUid, callerPid, params, utteranceId);
            this.mText = text;
            this.mCallerUid = callerUid;
            this.mSynthesisRequest = new SynthesisRequest(this.mText, this.mParams);
            this.mDefaultLocale = TextToSpeechService.this.getSettingsLocale();
            this.setRequestParams(this.mSynthesisRequest);
            this.mEventLogger = new EventLoggerV1(this.mSynthesisRequest, callerUid, callerPid, TextToSpeechService.this.mPackageName);
        }

        public CharSequence getText() {
            return this.mText;
        }

        @Override
        public boolean isValid() {
            if (this.mText == null) {
                Log.e(TextToSpeechService.TAG, "null synthesis text");
                return false;
            }
            if (this.mText.length() >= TextToSpeech.getMaxSpeechInputLength()) {
                Log.w(TextToSpeechService.TAG, "Text too long: " + this.mText.length() + " chars");
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void playImpl() {
            AbstractSynthesisCallback synthesisCallback;
            this.mEventLogger.onRequestProcessingStart();
            SynthesisSpeechItemV1 synthesisSpeechItemV1 = this;
            synchronized (synthesisSpeechItemV1) {
                if (this.isStopped()) {
                    return;
                }
                synthesisCallback = this.mSynthesisCallback = this.createSynthesisCallback();
            }
            TextToSpeechService.this.onSynthesizeText(this.mSynthesisRequest, synthesisCallback);
            if (synthesisCallback.hasStarted() && !synthesisCallback.hasFinished()) {
                synthesisCallback.done();
            }
        }

        protected AbstractSynthesisCallback createSynthesisCallback() {
            return new PlaybackSynthesisCallback(this.getAudioParams(), TextToSpeechService.this.mAudioPlaybackHandler, this, this.getCallerIdentity(), this.mEventLogger, false);
        }

        private void setRequestParams(SynthesisRequest request) {
            String voiceName = this.getVoiceName();
            request.setLanguage(this.getLanguage(), this.getCountry(), this.getVariant());
            if (!TextUtils.isEmpty(voiceName)) {
                request.setVoiceName(this.getVoiceName());
            }
            request.setSpeechRate(this.getSpeechRate());
            request.setCallerUid(this.mCallerUid);
            request.setPitch(this.getPitch());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void stopImpl() {
            AbstractSynthesisCallback synthesisCallback;
            SynthesisSpeechItemV1 synthesisSpeechItemV1 = this;
            synchronized (synthesisSpeechItemV1) {
                synthesisCallback = this.mSynthesisCallback;
            }
            if (synthesisCallback != null) {
                synthesisCallback.stop();
                TextToSpeechService.this.onStop();
            } else {
                this.dispatchOnStop();
            }
        }

        private String getCountry() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[1];
            }
            return this.getStringParam(this.mParams, "country", "");
        }

        private String getVariant() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[2];
            }
            return this.getStringParam(this.mParams, "variant", "");
        }

        public String getLanguage() {
            return this.getStringParam(this.mParams, "language", this.mDefaultLocale[0]);
        }

        public String getVoiceName() {
            return this.getStringParam(this.mParams, "voiceName", "");
        }
    }

    private abstract class SpeechItemV1
    extends UtteranceSpeechItem {
        protected final Bundle mParams;
        protected final String mUtteranceId;

        SpeechItemV1(Object callerIdentity, int callerUid, int callerPid, Bundle params, String utteranceId) {
            super(callerIdentity, callerUid, callerPid);
            this.mParams = params;
            this.mUtteranceId = utteranceId;
        }

        boolean hasLanguage() {
            return !TextUtils.isEmpty(this.getStringParam(this.mParams, "language", null));
        }

        int getSpeechRate() {
            return this.getIntParam(this.mParams, "rate", TextToSpeechService.this.getDefaultSpeechRate());
        }

        int getPitch() {
            return this.getIntParam(this.mParams, "pitch", 100);
        }

        @Override
        public String getUtteranceId() {
            return this.mUtteranceId;
        }

        AudioOutputParams getAudioParams() {
            return AudioOutputParams.createFromV1ParamsBundle(this.mParams, true);
        }
    }

    private abstract class UtteranceSpeechItem
    extends SpeechItem
    implements UtteranceProgressDispatcher {
        public UtteranceSpeechItem(Object caller, int callerUid, int callerPid) {
            super(caller, callerUid, callerPid);
        }

        @Override
        public void dispatchOnSuccess() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnSuccess(this.getCallerIdentity(), utteranceId);
            }
        }

        @Override
        public void dispatchOnStop() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnStop(this.getCallerIdentity(), utteranceId, this.isStarted());
            }
        }

        @Override
        public void dispatchOnStart() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnStart(this.getCallerIdentity(), utteranceId);
            }
        }

        @Override
        public void dispatchOnError(int errorCode) {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnError(this.getCallerIdentity(), utteranceId, errorCode);
            }
        }

        @Override
        public void dispatchOnBeginSynthesis(int sampleRateInHz, int audioFormat, int channelCount) {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnBeginSynthesis(this.getCallerIdentity(), utteranceId, sampleRateInHz, audioFormat, channelCount);
            }
        }

        @Override
        public void dispatchOnAudioAvailable(byte[] audio) {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnAudioAvailable(this.getCallerIdentity(), utteranceId, audio);
            }
        }

        public abstract String getUtteranceId();

        String getStringParam(Bundle params, String key, String defaultValue) {
            return params == null ? defaultValue : params.getString(key, defaultValue);
        }

        int getIntParam(Bundle params, String key, int defaultValue) {
            return params == null ? defaultValue : params.getInt(key, defaultValue);
        }

        float getFloatParam(Bundle params, String key, float defaultValue) {
            return params == null ? defaultValue : params.getFloat(key, defaultValue);
        }
    }

    private abstract class SpeechItem {
        private final Object mCallerIdentity;
        private final int mCallerUid;
        private final int mCallerPid;
        private boolean mStarted = false;
        private boolean mStopped = false;

        public SpeechItem(Object caller, int callerUid, int callerPid) {
            this.mCallerIdentity = caller;
            this.mCallerUid = callerUid;
            this.mCallerPid = callerPid;
        }

        public Object getCallerIdentity() {
            return this.mCallerIdentity;
        }

        public int getCallerUid() {
            return this.mCallerUid;
        }

        public int getCallerPid() {
            return this.mCallerPid;
        }

        public abstract boolean isValid();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void play() {
            SpeechItem speechItem = this;
            synchronized (speechItem) {
                if (this.mStarted) {
                    throw new IllegalStateException("play() called twice");
                }
                this.mStarted = true;
            }
            this.playImpl();
        }

        protected abstract void playImpl();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            SpeechItem speechItem = this;
            synchronized (speechItem) {
                if (this.mStopped) {
                    throw new IllegalStateException("stop() called twice");
                }
                this.mStopped = true;
            }
            this.stopImpl();
        }

        protected abstract void stopImpl();

        protected synchronized boolean isStopped() {
            return this.mStopped;
        }

        protected synchronized boolean isStarted() {
            return this.mStarted;
        }
    }

    static class AudioOutputParams {
        public final int mSessionId;
        public final float mVolume;
        public final float mPan;
        public final AudioAttributes mAudioAttributes;

        AudioOutputParams() {
            this.mSessionId = 0;
            this.mVolume = 1.0f;
            this.mPan = 0.0f;
            this.mAudioAttributes = null;
        }

        AudioOutputParams(int sessionId, float volume, float pan, AudioAttributes audioAttributes) {
            this.mSessionId = sessionId;
            this.mVolume = volume;
            this.mPan = pan;
            this.mAudioAttributes = audioAttributes;
        }

        static AudioOutputParams createFromV1ParamsBundle(Bundle paramsBundle, boolean isSpeech) {
            if (paramsBundle == null) {
                return new AudioOutputParams();
            }
            AudioAttributes audioAttributes = (AudioAttributes)paramsBundle.getParcelable("audioAttributes");
            if (audioAttributes == null) {
                int streamType = paramsBundle.getInt("streamType", 3);
                audioAttributes = new AudioAttributes.Builder().setLegacyStreamType(streamType).setContentType(isSpeech ? 1 : 4).build();
            }
            return new AudioOutputParams(paramsBundle.getInt("sessionId", 0), paramsBundle.getFloat("volume", 1.0f), paramsBundle.getFloat("pan", 0.0f), audioAttributes);
        }
    }

    static interface UtteranceProgressDispatcher {
        public void dispatchOnStop();

        public void dispatchOnSuccess();

        public void dispatchOnStart();

        public void dispatchOnError(int var1);

        public void dispatchOnBeginSynthesis(int var1, int var2, int var3);

        public void dispatchOnAudioAvailable(byte[] var1);
    }

    private class SynthHandler
    extends Handler {
        private SpeechItem mCurrentSpeechItem;
        private List<Object> mFlushedObjects;
        private int mFlushAll;

        public SynthHandler(Looper looper) {
            super(looper);
            this.mCurrentSpeechItem = null;
            this.mFlushedObjects = new ArrayList<Object>();
            this.mFlushAll = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startFlushingSpeechItems(Object callerIdentity) {
            List<Object> list = this.mFlushedObjects;
            synchronized (list) {
                if (callerIdentity == null) {
                    ++this.mFlushAll;
                } else {
                    this.mFlushedObjects.add(callerIdentity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endFlushingSpeechItems(Object callerIdentity) {
            List<Object> list = this.mFlushedObjects;
            synchronized (list) {
                if (callerIdentity == null) {
                    --this.mFlushAll;
                } else {
                    this.mFlushedObjects.remove(callerIdentity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isFlushed(SpeechItem speechItem) {
            List<Object> list = this.mFlushedObjects;
            synchronized (list) {
                return this.mFlushAll > 0 || this.mFlushedObjects.contains(speechItem.getCallerIdentity());
            }
        }

        private synchronized SpeechItem getCurrentSpeechItem() {
            return this.mCurrentSpeechItem;
        }

        private synchronized SpeechItem setCurrentSpeechItem(SpeechItem speechItem) {
            SpeechItem old = this.mCurrentSpeechItem;
            this.mCurrentSpeechItem = speechItem;
            return old;
        }

        private synchronized SpeechItem maybeRemoveCurrentSpeechItem(Object callerIdentity) {
            if (this.mCurrentSpeechItem != null && this.mCurrentSpeechItem.getCallerIdentity() == callerIdentity) {
                SpeechItem current = this.mCurrentSpeechItem;
                this.mCurrentSpeechItem = null;
                return current;
            }
            return null;
        }

        public boolean isSpeaking() {
            return this.getCurrentSpeechItem() != null;
        }

        public void quit() {
            this.getLooper().quit();
            SpeechItem current = this.setCurrentSpeechItem(null);
            if (current != null) {
                current.stop();
            }
        }

        public int enqueueSpeechItem(int queueMode, final SpeechItem speechItem) {
            UtteranceProgressDispatcher utterenceProgress = null;
            if (speechItem instanceof UtteranceProgressDispatcher) {
                utterenceProgress = (UtteranceProgressDispatcher)((Object)speechItem);
            }
            if (!speechItem.isValid()) {
                if (utterenceProgress != null) {
                    utterenceProgress.dispatchOnError(-8);
                }
                return -1;
            }
            if (queueMode == 0) {
                this.stopForApp(speechItem.getCallerIdentity());
            } else if (queueMode == 2) {
                this.stopAll();
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (SynthHandler.this.isFlushed(speechItem)) {
                        speechItem.stop();
                    } else {
                        SynthHandler.this.setCurrentSpeechItem(speechItem);
                        speechItem.play();
                        SynthHandler.this.setCurrentSpeechItem(null);
                    }
                }
            };
            Message msg = Message.obtain((Handler)this, runnable);
            msg.obj = speechItem.getCallerIdentity();
            if (this.sendMessage(msg)) {
                return 0;
            }
            Log.w(TextToSpeechService.TAG, "SynthThread has quit");
            if (utterenceProgress != null) {
                utterenceProgress.dispatchOnError(-4);
            }
            return -1;
        }

        public int stopForApp(final Object callerIdentity) {
            if (callerIdentity == null) {
                return -1;
            }
            this.startFlushingSpeechItems(callerIdentity);
            SpeechItem current = this.maybeRemoveCurrentSpeechItem(callerIdentity);
            if (current != null) {
                current.stop();
            }
            TextToSpeechService.this.mAudioPlaybackHandler.stopForApp(callerIdentity);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SynthHandler.this.endFlushingSpeechItems(callerIdentity);
                }
            };
            this.sendMessage(Message.obtain((Handler)this, runnable));
            return 0;
        }

        public int stopAll() {
            this.startFlushingSpeechItems(null);
            SpeechItem current = this.setCurrentSpeechItem(null);
            if (current != null) {
                current.stop();
            }
            TextToSpeechService.this.mAudioPlaybackHandler.stop();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SynthHandler.this.endFlushingSpeechItems(null);
                }
            };
            this.sendMessage(Message.obtain((Handler)this, runnable));
            return 0;
        }
    }

    private class SynthThread
    extends HandlerThread
    implements MessageQueue.IdleHandler {
        private boolean mFirstIdle;

        public SynthThread() {
            super(TextToSpeechService.SYNTH_THREAD_NAME, 0);
            this.mFirstIdle = true;
        }

        @Override
        protected void onLooperPrepared() {
            this.getLooper().getQueue().addIdleHandler(this);
        }

        @Override
        public boolean queueIdle() {
            if (this.mFirstIdle) {
                this.mFirstIdle = false;
            } else {
                this.broadcastTtsQueueProcessingCompleted();
            }
            return true;
        }

        private void broadcastTtsQueueProcessingCompleted() {
            Intent i = new Intent("android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED");
            TextToSpeechService.this.sendBroadcast(i);
        }
    }
}

