/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Connection;
import android.telecom.Log;
import android.telecom.ParcelableCall;

public class ConferenceParticipant
implements Parcelable {
    private final Uri mHandle;
    private final String mDisplayName;
    private final Uri mEndpoint;
    private final int mState;
    public static final Parcelable.Creator<ConferenceParticipant> CREATOR = new Parcelable.Creator<ConferenceParticipant>(){

        @Override
        public ConferenceParticipant createFromParcel(Parcel source) {
            ClassLoader classLoader = ParcelableCall.class.getClassLoader();
            Uri handle = (Uri)source.readParcelable(classLoader);
            String displayName = source.readString();
            Uri endpoint = (Uri)source.readParcelable(classLoader);
            int state = source.readInt();
            return new ConferenceParticipant(handle, displayName, endpoint, state);
        }

        public ConferenceParticipant[] newArray(int size) {
            return new ConferenceParticipant[size];
        }
    };

    public ConferenceParticipant(Uri handle, String displayName, Uri endpoint, int state) {
        this.mHandle = handle;
        this.mDisplayName = displayName;
        this.mEndpoint = endpoint;
        this.mState = state;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mHandle, 0);
        dest.writeString(this.mDisplayName);
        dest.writeParcelable(this.mEndpoint, 0);
        dest.writeInt(this.mState);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ConferenceParticipant Handle: ");
        sb.append(Log.pii(this.mHandle));
        sb.append(" DisplayName: ");
        sb.append(Log.pii(this.mDisplayName));
        sb.append(" Endpoint: ");
        sb.append(Log.pii(this.mEndpoint));
        sb.append(" State: ");
        sb.append(Connection.stateToString(this.mState));
        sb.append("]");
        return sb.toString();
    }

    public Uri getHandle() {
        return this.mHandle;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public Uri getEndpoint() {
        return this.mEndpoint;
    }

    public int getState() {
        return this.mState;
    }
}

