/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Bundle;
import android.os.RemoteException;
import android.telecom.PhoneAccountHandle;
import com.android.internal.telecom.IInCallAdapter;
import java.util.List;

public final class InCallAdapter {
    private final IInCallAdapter mAdapter;

    public InCallAdapter(IInCallAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void answerCall(String callId, int videoState) {
        try {
            this.mAdapter.answerCall(callId, videoState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void rejectCall(String callId, boolean rejectWithMessage, String textMessage) {
        try {
            this.mAdapter.rejectCall(callId, rejectWithMessage, textMessage);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void disconnectCall(String callId) {
        try {
            this.mAdapter.disconnectCall(callId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void holdCall(String callId) {
        try {
            this.mAdapter.holdCall(callId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void unholdCall(String callId) {
        try {
            this.mAdapter.unholdCall(callId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void mute(boolean shouldMute) {
        try {
            this.mAdapter.mute(shouldMute);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setAudioRoute(int route) {
        try {
            this.mAdapter.setAudioRoute(route);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void playDtmfTone(String callId, char digit) {
        try {
            this.mAdapter.playDtmfTone(callId, digit);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void stopDtmfTone(String callId) {
        try {
            this.mAdapter.stopDtmfTone(callId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void postDialContinue(String callId, boolean proceed) {
        try {
            this.mAdapter.postDialContinue(callId, proceed);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void phoneAccountSelected(String callId, PhoneAccountHandle accountHandle, boolean setDefault) {
        try {
            this.mAdapter.phoneAccountSelected(callId, accountHandle, setDefault);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void conference(String callId, String otherCallId) {
        try {
            this.mAdapter.conference(callId, otherCallId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void splitFromConference(String callId) {
        try {
            this.mAdapter.splitFromConference(callId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void mergeConference(String callId) {
        try {
            this.mAdapter.mergeConference(callId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void swapConference(String callId) {
        try {
            this.mAdapter.swapConference(callId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void pullExternalCall(String callId) {
        try {
            this.mAdapter.pullExternalCall(callId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendCallEvent(String callId, String event, Bundle extras) {
        try {
            this.mAdapter.sendCallEvent(callId, event, extras);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void putExtras(String callId, Bundle extras) {
        try {
            this.mAdapter.putExtras(callId, extras);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void putExtra(String callId, String key, boolean value) {
        try {
            Bundle bundle = new Bundle();
            bundle.putBoolean(key, value);
            this.mAdapter.putExtras(callId, bundle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void putExtra(String callId, String key, int value) {
        try {
            Bundle bundle = new Bundle();
            bundle.putInt(key, value);
            this.mAdapter.putExtras(callId, bundle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void putExtra(String callId, String key, String value) {
        try {
            Bundle bundle = new Bundle();
            bundle.putString(key, value);
            this.mAdapter.putExtras(callId, bundle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void removeExtras(String callId, List<String> keys) {
        try {
            this.mAdapter.removeExtras(callId, keys);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void turnProximitySensorOn() {
        try {
            this.mAdapter.turnOnProximitySensor();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void turnProximitySensorOff(boolean screenOnImmediately) {
        try {
            this.mAdapter.turnOffProximitySensor(screenOnImmediately);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

