/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Intent;
import android.os.Bundle;
import android.test.FlakyTest;
import android.test.RepetitiveTest;
import android.test.UiThreadTest;
import android.util.Log;
import android.view.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;

@Deprecated
public class InstrumentationTestCase
extends TestCase {
    private Instrumentation mInstrumentation;

    public void injectInstrumentation(Instrumentation instrumentation) {
        this.mInstrumentation = instrumentation;
    }

    @Deprecated
    public void injectInsrumentation(Instrumentation instrumentation) {
        this.injectInstrumentation(instrumentation);
    }

    public Instrumentation getInstrumentation() {
        return this.mInstrumentation;
    }

    public final <T extends Activity> T launchActivity(String pkg, Class<T> activityCls, Bundle extras) {
        Intent intent = new Intent("android.intent.action.MAIN");
        if (extras != null) {
            intent.putExtras(extras);
        }
        return this.launchActivityWithIntent(pkg, activityCls, intent);
    }

    public final <T extends Activity> T launchActivityWithIntent(String pkg, Class<T> activityCls, Intent intent) {
        intent.setClassName(pkg, activityCls.getName());
        intent.addFlags(0x10000000);
        Activity activity = this.getInstrumentation().startActivitySync(intent);
        this.getInstrumentation().waitForIdleSync();
        return (T)activity;
    }

    public void runTestOnUiThread(final Runnable r) throws Throwable {
        final Throwable[] exceptions = new Throwable[1];
        this.getInstrumentation().runOnMainSync(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable throwable) {
                    exceptions[0] = throwable;
                }
            }
        });
        if (exceptions[0] != null) {
            throw exceptions[0];
        }
    }

    protected void runTest() throws Throwable {
        String fName = this.getName();
        InstrumentationTestCase.assertNotNull((Object)fName);
        Method method = null;
        try {
            method = ((Object)((Object)this)).getClass().getMethod(fName, null);
        }
        catch (NoSuchMethodException e) {
            InstrumentationTestCase.fail((String)("Method \"" + fName + "\" not found"));
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            InstrumentationTestCase.fail((String)("Method \"" + fName + "\" should be public"));
        }
        int runCount = 1;
        boolean isRepetitive = false;
        if (method.isAnnotationPresent(FlakyTest.class)) {
            runCount = method.getAnnotation(FlakyTest.class).tolerance();
        } else if (method.isAnnotationPresent(RepetitiveTest.class)) {
            runCount = method.getAnnotation(RepetitiveTest.class).numIterations();
            isRepetitive = true;
        }
        if (method.isAnnotationPresent(UiThreadTest.class)) {
            final int tolerance = runCount;
            final boolean repetitive = isRepetitive;
            final Method testMethod = method;
            final Throwable[] exceptions = new Throwable[1];
            this.getInstrumentation().runOnMainSync(new Runnable(){

                @Override
                public void run() {
                    try {
                        InstrumentationTestCase.this.runMethod(testMethod, tolerance, repetitive);
                    }
                    catch (Throwable throwable) {
                        exceptions[0] = throwable;
                    }
                }
            });
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        } else {
            this.runMethod(method, runCount, isRepetitive);
        }
    }

    private void runMethod(Method runMethod, int tolerance) throws Throwable {
        this.runMethod(runMethod, tolerance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMethod(Method runMethod, int tolerance, boolean isRepetitive) throws Throwable {
        Throwable exception = null;
        int runCount = 0;
        do {
            try {
                runMethod.invoke((Object)this, (Object[])null);
                exception = null;
            }
            catch (InvocationTargetException e) {
                e.fillInStackTrace();
                exception = e.getTargetException();
            }
            catch (IllegalAccessException e) {
                e.fillInStackTrace();
                exception = e;
            }
            finally {
                ++runCount;
                if (isRepetitive) {
                    Bundle iterations = new Bundle();
                    iterations.putInt("currentiterations", runCount);
                    this.getInstrumentation().sendStatus(2, iterations);
                }
            }
        } while (runCount < tolerance && (isRepetitive || exception != null));
        if (exception != null) {
            throw exception;
        }
    }

    public void sendKeys(String keysSequence) {
        String[] keys = keysSequence.split(" ");
        int count = keys.length;
        Instrumentation instrumentation = this.getInstrumentation();
        block7: for (int i = 0; i < count; ++i) {
            int keyCount;
            String key = keys[i];
            int repeater = key.indexOf(42);
            try {
                keyCount = repeater == -1 ? 1 : Integer.parseInt(key.substring(0, repeater));
            }
            catch (NumberFormatException e) {
                Log.w("ActivityTestCase", "Invalid repeat count: " + key);
                continue;
            }
            if (repeater != -1) {
                key = key.substring(repeater + 1);
            }
            for (int j = 0; j < keyCount; ++j) {
                try {
                    Field keyCodeField = KeyEvent.class.getField("KEYCODE_" + key);
                    int keyCode = keyCodeField.getInt(null);
                    try {
                        instrumentation.sendKeyDownUpSync(keyCode);
                    }
                    catch (SecurityException securityException) {}
                    continue;
                }
                catch (NoSuchFieldException e) {
                    Log.w("ActivityTestCase", "Unknown keycode: KEYCODE_" + key);
                    continue block7;
                }
                catch (IllegalAccessException e) {
                    Log.w("ActivityTestCase", "Unknown keycode: KEYCODE_" + key);
                    continue block7;
                }
            }
        }
        instrumentation.waitForIdleSync();
    }

    public void sendKeys(int ... keys) {
        int count = keys.length;
        Instrumentation instrumentation = this.getInstrumentation();
        for (int i = 0; i < count; ++i) {
            try {
                instrumentation.sendKeyDownUpSync(keys[i]);
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        instrumentation.waitForIdleSync();
    }

    public void sendRepeatedKeys(int ... keys) {
        int count = keys.length;
        if ((count & 1) == 1) {
            throw new IllegalArgumentException("The size of the keys array must be a multiple of 2");
        }
        Instrumentation instrumentation = this.getInstrumentation();
        for (int i = 0; i < count; i += 2) {
            int keyCount = keys[i];
            int keyCode = keys[i + 1];
            for (int j = 0; j < keyCount; ++j) {
                try {
                    instrumentation.sendKeyDownUpSync(keyCode);
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        instrumentation.waitForIdleSync();
    }

    protected void tearDown() throws Exception {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        super.tearDown();
    }
}

