/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.StaticLayout;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Locale;

public class Hyphenator {
    private static String TAG = "Hyphenator";
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    static final HashMap<Locale, Hyphenator> sMap = new HashMap();
    static final Hyphenator sEmptyHyphenator = new Hyphenator(StaticLayout.nLoadHyphenator(null, 0), null);
    private final long mNativePtr;
    private final ByteBuffer mBuffer;
    private static final String[][] LOCALE_FALLBACK_DATA = new String[][]{{"en-AS", "en-US"}, {"en-GU", "en-US"}, {"en-MH", "en-US"}, {"en-MP", "en-US"}, {"en-PR", "en-US"}, {"en-UM", "en-US"}, {"en-VI", "en-US"}, {"en", "en-GB"}, {"de", "de-1996"}, {"de-LI-1901", "de-CH-1901"}, {"no", "nb"}, {"mn", "mn-Cyrl"}, {"am", "und-Ethi"}, {"byn", "und-Ethi"}, {"gez", "und-Ethi"}, {"ti", "und-Ethi"}, {"wal", "und-Ethi"}};

    private Hyphenator(long nativePtr, ByteBuffer b) {
        this.mNativePtr = nativePtr;
        this.mBuffer = b;
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hyphenator get(Locale locale) {
        Object object = sLock;
        synchronized (object) {
            Locale scriptOnlyLocale;
            Locale languageAndVariantOnlyLocale;
            Hyphenator result = sMap.get(locale);
            if (result != null) {
                return result;
            }
            String variant = locale.getVariant();
            if (!variant.isEmpty() && (result = sMap.get(languageAndVariantOnlyLocale = new Locale(locale.getLanguage(), "", variant))) != null) {
                sMap.put(locale, result);
                return result;
            }
            Locale languageOnlyLocale = new Locale(locale.getLanguage());
            result = sMap.get(languageOnlyLocale);
            if (result != null) {
                sMap.put(locale, result);
                return result;
            }
            String script = locale.getScript();
            if (!script.equals("") && (result = sMap.get(scriptOnlyLocale = new Locale.Builder().setLanguage("und").setScript(script).build())) != null) {
                sMap.put(locale, result);
                return result;
            }
            sMap.put(locale, sEmptyHyphenator);
        }
        return sEmptyHyphenator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hyphenator loadHyphenator(String languageTag) {
        Hyphenator hyphenator;
        String patternFilename = "hyph-" + languageTag.toLowerCase(Locale.US) + ".hyb";
        File patternFile = new File(Hyphenator.getSystemHyphenatorLocation(), patternFilename);
        RandomAccessFile f = new RandomAccessFile(patternFile, "r");
        try {
            FileChannel fc = f.getChannel();
            MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            long nativePtr = StaticLayout.nLoadHyphenator(buf, 0);
            hyphenator = new Hyphenator(nativePtr, buf);
        }
        catch (Throwable throwable) {
            try {
                f.close();
                throw throwable;
            }
            catch (IOException e) {
                Log.e(TAG, "error loading hyphenation " + patternFile, e);
                return null;
            }
        }
        f.close();
        return hyphenator;
    }

    private static File getSystemHyphenatorLocation() {
        return new File("/system/usr/hyphen-data");
    }

    public static void init() {
        int i;
        sMap.put(null, null);
        String[] availableLanguages = new String[]{"as", "bn", "cy", "da", "de-1901", "de-1996", "de-CH-1901", "en-GB", "en-US", "es", "et", "eu", "fr", "ga", "gu", "hi", "hr", "hu", "hy", "kn", "ml", "mn-Cyrl", "mr", "nb", "nn", "or", "pa", "pt", "sl", "ta", "te", "tk", "und-Ethi"};
        for (i = 0; i < availableLanguages.length; ++i) {
            String languageTag = availableLanguages[i];
            Hyphenator h = Hyphenator.loadHyphenator(languageTag);
            if (h == null) continue;
            sMap.put(Locale.forLanguageTag(languageTag), h);
        }
        for (i = 0; i < LOCALE_FALLBACK_DATA.length; ++i) {
            String language = LOCALE_FALLBACK_DATA[i][0];
            String fallback = LOCALE_FALLBACK_DATA[i][1];
            sMap.put(Locale.forLanguageTag(language), sMap.get(Locale.forLanguageTag(fallback)));
        }
    }
}

