/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import libcore.io.IoUtils;

public final class MemoryIntArray
implements Parcelable,
Closeable {
    private static final String TAG = "MemoryIntArray";
    private static final int MAX_SIZE = 1024;
    private final int mOwnerPid;
    private final boolean mClientWritable;
    private final long mMemoryAddr;
    private int mFd;
    public static final Parcelable.Creator<MemoryIntArray> CREATOR = new Parcelable.Creator<MemoryIntArray>(){

        @Override
        public MemoryIntArray createFromParcel(Parcel parcel) {
            try {
                return new MemoryIntArray(parcel);
            }
            catch (IOException ioe) {
                Log.e(MemoryIntArray.TAG, "Error unparceling MemoryIntArray");
                return null;
            }
        }

        public MemoryIntArray[] newArray(int size) {
            return new MemoryIntArray[size];
        }
    };

    public MemoryIntArray(int size, boolean clientWritable) throws IOException {
        if (size > 1024) {
            throw new IllegalArgumentException("Max size is 1024");
        }
        this.mOwnerPid = Process.myPid();
        this.mClientWritable = clientWritable;
        String name = UUID.randomUUID().toString();
        this.mFd = this.nativeCreate(name, size);
        this.mMemoryAddr = this.nativeOpen(this.mFd, true, clientWritable);
    }

    private MemoryIntArray(Parcel parcel) throws IOException {
        this.mOwnerPid = parcel.readInt();
        this.mClientWritable = parcel.readInt() == 1;
        ParcelFileDescriptor pfd = (ParcelFileDescriptor)parcel.readParcelable(null);
        if (pfd == null) {
            throw new IOException("No backing file descriptor");
        }
        this.mFd = pfd.detachFd();
        long memoryAddress = parcel.readLong();
        this.mMemoryAddr = this.isOwner() ? memoryAddress : this.nativeOpen(this.mFd, false, this.mClientWritable);
    }

    public boolean isWritable() {
        this.enforceNotClosed();
        return this.isOwner() || this.mClientWritable;
    }

    public int get(int index) throws IOException {
        this.enforceNotClosed();
        this.enforceValidIndex(index);
        return this.nativeGet(this.mFd, this.mMemoryAddr, index, this.isOwner());
    }

    public void set(int index, int value) throws IOException {
        this.enforceNotClosed();
        this.enforceWritable();
        this.enforceValidIndex(index);
        this.nativeSet(this.mFd, this.mMemoryAddr, index, value, this.isOwner());
    }

    public int size() throws IOException {
        this.enforceNotClosed();
        return this.nativeSize(this.mFd);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            this.nativeClose(this.mFd, this.mMemoryAddr, this.isOwner());
            this.mFd = -1;
        }
    }

    public boolean isClosed() {
        return this.mFd == -1;
    }

    protected void finalize() throws Throwable {
        IoUtils.closeQuietly(this);
        super.finalize();
    }

    @Override
    public int describeContents() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        ParcelFileDescriptor pfd = ParcelFileDescriptor.adoptFd(this.mFd);
        try {
            parcel.writeInt(this.mOwnerPid);
            parcel.writeInt(this.mClientWritable ? 1 : 0);
            parcel.writeParcelable(pfd, flags & 0xFFFFFFFE);
            parcel.writeLong(this.mMemoryAddr);
        }
        finally {
            pfd.detachFd();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryIntArray other = (MemoryIntArray)obj;
        return this.mFd == other.mFd;
    }

    public int hashCode() {
        return this.mFd;
    }

    private boolean isOwner() {
        return this.mOwnerPid == Process.myPid();
    }

    private void enforceNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cannot interact with a closed instance");
        }
    }

    private void enforceValidIndex(int index) throws IOException {
        int size = this.size();
        if (index < 0 || index > size - 1) {
            throw new IndexOutOfBoundsException(index + " not between 0 and " + (size - 1));
        }
    }

    private void enforceWritable() {
        if (!this.isWritable()) {
            throw new UnsupportedOperationException("array is not writable");
        }
    }

    private native int nativeCreate(String var1, int var2);

    private native long nativeOpen(int var1, boolean var2, boolean var3);

    private native void nativeClose(int var1, long var2, boolean var4);

    private native int nativeGet(int var1, long var2, int var4, boolean var5);

    private native void nativeSet(int var1, long var2, int var4, int var5, boolean var6);

    private native int nativeSize(int var1);

    public static int getMaxSize() {
        return 1024;
    }
}

