/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.os.Handler;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.ThreadedRenderer;

public final class PixelCopy {
    public static final int SUCCESS = 0;
    public static final int ERROR_UNKNOWN = 1;
    public static final int ERROR_TIMEOUT = 2;
    public static final int ERROR_SOURCE_NO_DATA = 3;
    public static final int ERROR_SOURCE_INVALID = 4;
    public static final int ERROR_DESTINATION_INVALID = 5;

    public static void request(SurfaceView source, Bitmap dest, OnPixelCopyFinishedListener listener, Handler listenerThread) {
        PixelCopy.request(source.getHolder().getSurface(), dest, listener, listenerThread);
    }

    public static void request(Surface source, Bitmap dest, final OnPixelCopyFinishedListener listener, Handler listenerThread) {
        PixelCopy.validateBitmapDest(dest);
        if (!source.isValid()) {
            throw new IllegalArgumentException("Surface isn't valid, source.isValid() == false");
        }
        final int result = ThreadedRenderer.copySurfaceInto(source, dest);
        listenerThread.post(new Runnable(){

            @Override
            public void run() {
                listener.onPixelCopyFinished(result);
            }
        });
    }

    private static void validateBitmapDest(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap cannot be null");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Bitmap is recycled");
        }
        if (!bitmap.isMutable()) {
            throw new IllegalArgumentException("Bitmap is immutable");
        }
    }

    private PixelCopy() {
    }

    public static interface OnPixelCopyFinishedListener {
        public void onPixelCopyFinished(int var1);
    }
}

