/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.webkit.WebViewFactory;

public abstract class WebSettings {
    public static final int LOAD_DEFAULT = -1;
    @Deprecated
    public static final int LOAD_NORMAL = 0;
    public static final int LOAD_CACHE_ELSE_NETWORK = 1;
    public static final int LOAD_NO_CACHE = 2;
    public static final int LOAD_CACHE_ONLY = 3;
    public static final int MIXED_CONTENT_ALWAYS_ALLOW = 0;
    public static final int MIXED_CONTENT_NEVER_ALLOW = 1;
    public static final int MIXED_CONTENT_COMPATIBILITY_MODE = 2;
    public static final int MENU_ITEM_NONE = 0;
    public static final int MENU_ITEM_SHARE = 1;
    public static final int MENU_ITEM_WEB_SEARCH = 2;
    public static final int MENU_ITEM_PROCESS_TEXT = 4;

    @Deprecated
    public abstract void setNavDump(boolean var1);

    @Deprecated
    public abstract boolean getNavDump();

    public abstract void setSupportZoom(boolean var1);

    public abstract boolean supportZoom();

    public abstract void setMediaPlaybackRequiresUserGesture(boolean var1);

    public abstract boolean getMediaPlaybackRequiresUserGesture();

    public abstract void setBuiltInZoomControls(boolean var1);

    public abstract boolean getBuiltInZoomControls();

    public abstract void setDisplayZoomControls(boolean var1);

    public abstract boolean getDisplayZoomControls();

    public abstract void setAllowFileAccess(boolean var1);

    public abstract boolean getAllowFileAccess();

    public abstract void setAllowContentAccess(boolean var1);

    public abstract boolean getAllowContentAccess();

    public abstract void setLoadWithOverviewMode(boolean var1);

    public abstract boolean getLoadWithOverviewMode();

    @Deprecated
    public abstract void setEnableSmoothTransition(boolean var1);

    @Deprecated
    public abstract boolean enableSmoothTransition();

    @Deprecated
    public abstract void setUseWebViewBackgroundForOverscrollBackground(boolean var1);

    @Deprecated
    public abstract boolean getUseWebViewBackgroundForOverscrollBackground();

    public abstract void setSaveFormData(boolean var1);

    public abstract boolean getSaveFormData();

    @Deprecated
    public abstract void setSavePassword(boolean var1);

    @Deprecated
    public abstract boolean getSavePassword();

    public abstract void setTextZoom(int var1);

    public abstract int getTextZoom();

    public abstract void setAcceptThirdPartyCookies(boolean var1);

    public abstract boolean getAcceptThirdPartyCookies();

    public synchronized void setTextSize(TextSize t) {
        this.setTextZoom(t.value);
    }

    public synchronized TextSize getTextSize() {
        TextSize closestSize = null;
        int smallestDelta = Integer.MAX_VALUE;
        int textSize = this.getTextZoom();
        for (TextSize size : TextSize.values()) {
            int delta = Math.abs(textSize - size.value);
            if (delta == 0) {
                return size;
            }
            if (delta >= smallestDelta) continue;
            smallestDelta = delta;
            closestSize = size;
        }
        return closestSize != null ? closestSize : TextSize.NORMAL;
    }

    @Deprecated
    public abstract void setDefaultZoom(ZoomDensity var1);

    public abstract ZoomDensity getDefaultZoom();

    @Deprecated
    public abstract void setLightTouchEnabled(boolean var1);

    @Deprecated
    public abstract boolean getLightTouchEnabled();

    @Deprecated
    public void setUseDoubleTree(boolean use) {
    }

    @Deprecated
    public boolean getUseDoubleTree() {
        return false;
    }

    @Deprecated
    public abstract void setUserAgent(int var1);

    @Deprecated
    public abstract int getUserAgent();

    public abstract void setUseWideViewPort(boolean var1);

    public abstract boolean getUseWideViewPort();

    public abstract void setSupportMultipleWindows(boolean var1);

    public abstract boolean supportMultipleWindows();

    public abstract void setLayoutAlgorithm(LayoutAlgorithm var1);

    public abstract LayoutAlgorithm getLayoutAlgorithm();

    public abstract void setStandardFontFamily(String var1);

    public abstract String getStandardFontFamily();

    public abstract void setFixedFontFamily(String var1);

    public abstract String getFixedFontFamily();

    public abstract void setSansSerifFontFamily(String var1);

    public abstract String getSansSerifFontFamily();

    public abstract void setSerifFontFamily(String var1);

    public abstract String getSerifFontFamily();

    public abstract void setCursiveFontFamily(String var1);

    public abstract String getCursiveFontFamily();

    public abstract void setFantasyFontFamily(String var1);

    public abstract String getFantasyFontFamily();

    public abstract void setMinimumFontSize(int var1);

    public abstract int getMinimumFontSize();

    public abstract void setMinimumLogicalFontSize(int var1);

    public abstract int getMinimumLogicalFontSize();

    public abstract void setDefaultFontSize(int var1);

    public abstract int getDefaultFontSize();

    public abstract void setDefaultFixedFontSize(int var1);

    public abstract int getDefaultFixedFontSize();

    public abstract void setLoadsImagesAutomatically(boolean var1);

    public abstract boolean getLoadsImagesAutomatically();

    public abstract void setBlockNetworkImage(boolean var1);

    public abstract boolean getBlockNetworkImage();

    public abstract void setBlockNetworkLoads(boolean var1);

    public abstract boolean getBlockNetworkLoads();

    public abstract void setJavaScriptEnabled(boolean var1);

    public abstract void setAllowUniversalAccessFromFileURLs(boolean var1);

    public abstract void setAllowFileAccessFromFileURLs(boolean var1);

    @Deprecated
    public abstract void setPluginsEnabled(boolean var1);

    @Deprecated
    public abstract void setPluginState(PluginState var1);

    @Deprecated
    public void setPluginsPath(String pluginsPath) {
    }

    @Deprecated
    public abstract void setDatabasePath(String var1);

    @Deprecated
    public abstract void setGeolocationDatabasePath(String var1);

    public abstract void setAppCacheEnabled(boolean var1);

    public abstract void setAppCachePath(String var1);

    @Deprecated
    public abstract void setAppCacheMaxSize(long var1);

    public abstract void setDatabaseEnabled(boolean var1);

    public abstract void setDomStorageEnabled(boolean var1);

    public abstract boolean getDomStorageEnabled();

    @Deprecated
    public abstract String getDatabasePath();

    public abstract boolean getDatabaseEnabled();

    public abstract void setGeolocationEnabled(boolean var1);

    public abstract boolean getJavaScriptEnabled();

    public abstract boolean getAllowUniversalAccessFromFileURLs();

    public abstract boolean getAllowFileAccessFromFileURLs();

    @Deprecated
    public abstract boolean getPluginsEnabled();

    @Deprecated
    public abstract PluginState getPluginState();

    @Deprecated
    public String getPluginsPath() {
        return "";
    }

    public abstract void setJavaScriptCanOpenWindowsAutomatically(boolean var1);

    public abstract boolean getJavaScriptCanOpenWindowsAutomatically();

    public abstract void setDefaultTextEncodingName(String var1);

    public abstract String getDefaultTextEncodingName();

    public abstract void setUserAgentString(String var1);

    public abstract String getUserAgentString();

    public static String getDefaultUserAgent(Context context) {
        return WebViewFactory.getProvider().getStatics().getDefaultUserAgent(context);
    }

    public abstract void setNeedInitialFocus(boolean var1);

    @Deprecated
    public abstract void setRenderPriority(RenderPriority var1);

    public abstract void setCacheMode(int var1);

    public abstract int getCacheMode();

    public abstract void setMixedContentMode(int var1);

    public abstract int getMixedContentMode();

    public abstract void setVideoOverlayForEmbeddedEncryptedVideoEnabled(boolean var1);

    public abstract boolean getVideoOverlayForEmbeddedEncryptedVideoEnabled();

    public abstract void setOffscreenPreRaster(boolean var1);

    public abstract boolean getOffscreenPreRaster();

    public abstract void setDisabledActionModeMenuItems(int var1);

    public abstract int getDisabledActionModeMenuItems();

    public static enum PluginState {
        ON,
        ON_DEMAND,
        OFF;

    }

    public static enum RenderPriority {
        NORMAL,
        HIGH,
        LOW;

    }

    public static enum ZoomDensity {
        FAR(150),
        MEDIUM(100),
        CLOSE(75);

        int value;

        private ZoomDensity(int size) {
            this.value = size;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TextSize {
        SMALLEST(50),
        SMALLER(75),
        NORMAL(100),
        LARGER(150),
        LARGEST(200);

        int value;

        private TextSize(int size) {
            this.value = size;
        }
    }

    public static enum LayoutAlgorithm {
        NORMAL,
        SINGLE_COLUMN,
        NARROW_COLUMNS,
        TEXT_AUTOSIZING;

    }
}

