/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class LinearLayout
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;
    private final boolean mAllowInconsistentMeasurement;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mBaselineAligned = true;
    @ViewDebug.ExportedProperty(category="layout")
    private int mBaselineAlignedChildIndex = -1;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mBaselineChildTop = 0;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mOrientation;
    @ViewDebug.ExportedProperty(category="measurement", flagMapping={@ViewDebug.FlagToString(mask=-1, equals=-1, name="NONE"), @ViewDebug.FlagToString(mask=0, equals=0, name="NONE"), @ViewDebug.FlagToString(mask=48, equals=48, name="TOP"), @ViewDebug.FlagToString(mask=80, equals=80, name="BOTTOM"), @ViewDebug.FlagToString(mask=3, equals=3, name="LEFT"), @ViewDebug.FlagToString(mask=5, equals=5, name="RIGHT"), @ViewDebug.FlagToString(mask=0x800003, equals=0x800003, name="START"), @ViewDebug.FlagToString(mask=0x800005, equals=0x800005, name="END"), @ViewDebug.FlagToString(mask=16, equals=16, name="CENTER_VERTICAL"), @ViewDebug.FlagToString(mask=112, equals=112, name="FILL_VERTICAL"), @ViewDebug.FlagToString(mask=1, equals=1, name="CENTER_HORIZONTAL"), @ViewDebug.FlagToString(mask=7, equals=7, name="FILL_HORIZONTAL"), @ViewDebug.FlagToString(mask=17, equals=17, name="CENTER"), @ViewDebug.FlagToString(mask=119, equals=119, name="FILL"), @ViewDebug.FlagToString(mask=0x800000, equals=0x800000, name="RELATIVE")}, formatToHexString=true)
    private int mGravity = 0x800033;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mTotalLength;
    @ViewDebug.ExportedProperty(category="layout")
    private float mWeightSum;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mUseLargestChild;
    private int[] mMaxAscent;
    private int[] mMaxDescent;
    private static final int VERTICAL_GRAVITY_COUNT = 4;
    private static final int INDEX_CENTER_VERTICAL = 0;
    private static final int INDEX_TOP = 1;
    private static final int INDEX_BOTTOM = 2;
    private static final int INDEX_FILL = 3;
    private Drawable mDivider;
    private int mDividerWidth;
    private int mDividerHeight;
    private int mShowDividers;
    private int mDividerPadding;
    private int mLayoutDirection = -1;

    public LinearLayout(Context context) {
        this(context, null);
    }

    public LinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public LinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        boolean baselineAligned;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LinearLayout, defStyleAttr, defStyleRes);
        int index = a.getInt(1, -1);
        if (index >= 0) {
            this.setOrientation(index);
        }
        if ((index = a.getInt(0, -1)) >= 0) {
            this.setGravity(index);
        }
        if (!(baselineAligned = a.getBoolean(2, true))) {
            this.setBaselineAligned(baselineAligned);
        }
        this.mWeightSum = a.getFloat(4, -1.0f);
        this.mBaselineAlignedChildIndex = a.getInt(3, -1);
        this.mUseLargestChild = a.getBoolean(6, false);
        this.setDividerDrawable(a.getDrawable(5));
        this.mShowDividers = a.getInt(7, 0);
        this.mDividerPadding = a.getDimensionPixelSize(8, 0);
        int version = context.getApplicationInfo().targetSdkVersion;
        this.mAllowInconsistentMeasurement = version <= 23;
        a.recycle();
    }

    public void setShowDividers(int showDividers) {
        if (showDividers != this.mShowDividers) {
            this.requestLayout();
        }
        this.mShowDividers = showDividers;
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    public Drawable getDividerDrawable() {
        return this.mDivider;
    }

    public void setDividerDrawable(Drawable divider) {
        if (divider == this.mDivider) {
            return;
        }
        this.mDivider = divider;
        if (divider != null) {
            this.mDividerWidth = divider.getIntrinsicWidth();
            this.mDividerHeight = divider.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        this.setWillNotDraw(divider == null);
        this.requestLayout();
    }

    public void setDividerPadding(int padding) {
        this.mDividerPadding = padding;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.drawDividersVertical(canvas);
        } else {
            this.drawDividersHorizontal(canvas);
        }
    }

    void drawDividersVertical(Canvas canvas) {
        LayoutParams lp;
        int count = this.getVirtualChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LayoutParams)child.getLayoutParams();
            int top = child.getTop() - lp.topMargin - this.mDividerHeight;
            this.drawHorizontalDivider(canvas, top);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getLastNonGoneChild();
            int bottom = 0;
            if (child == null) {
                bottom = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
            } else {
                lp = (LayoutParams)child.getLayoutParams();
                bottom = child.getBottom() + lp.bottomMargin;
            }
            this.drawHorizontalDivider(canvas, bottom);
        }
    }

    private View getLastNonGoneChild() {
        for (int i = this.getVirtualChildCount() - 1; i >= 0; --i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            return child;
        }
        return null;
    }

    void drawDividersHorizontal(Canvas canvas) {
        LayoutParams lp;
        int count = this.getVirtualChildCount();
        boolean isLayoutRtl = this.isLayoutRtl();
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LayoutParams)child.getLayoutParams();
            int position = isLayoutRtl ? child.getRight() + lp.rightMargin : child.getLeft() - lp.leftMargin - this.mDividerWidth;
            this.drawVerticalDivider(canvas, position);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            int position;
            View child = this.getLastNonGoneChild();
            if (child == null) {
                position = isLayoutRtl ? this.getPaddingLeft() : this.getWidth() - this.getPaddingRight() - this.mDividerWidth;
            } else {
                lp = (LayoutParams)child.getLayoutParams();
                position = isLayoutRtl ? child.getLeft() - lp.leftMargin - this.mDividerWidth : child.getRight() + lp.rightMargin;
            }
            this.drawVerticalDivider(canvas, position);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int top) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, top, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, top + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    public boolean isBaselineAligned() {
        return this.mBaselineAligned;
    }

    @RemotableViewMethod
    public void setBaselineAligned(boolean baselineAligned) {
        this.mBaselineAligned = baselineAligned;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    @RemotableViewMethod
    public void setMeasureWithLargestChildEnabled(boolean enabled) {
        this.mUseLargestChild = enabled;
    }

    @Override
    public int getBaseline() {
        int majorGravity;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        if (this.getChildCount() <= this.mBaselineAlignedChildIndex) {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
        View child = this.getChildAt(this.mBaselineAlignedChildIndex);
        int childBaseline = child.getBaseline();
        if (childBaseline == -1) {
            if (this.mBaselineAlignedChildIndex == 0) {
                return -1;
            }
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
        }
        int childTop = this.mBaselineChildTop;
        if (this.mOrientation == 1 && (majorGravity = this.mGravity & 0x70) != 48) {
            switch (majorGravity) {
                case 80: {
                    childTop = this.mBottom - this.mTop - this.mPaddingBottom - this.mTotalLength;
                    break;
                }
                case 16: {
                    childTop += (this.mBottom - this.mTop - this.mPaddingTop - this.mPaddingBottom - this.mTotalLength) / 2;
                }
            }
        }
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        return childTop + lp.topMargin + childBaseline;
    }

    public int getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    @RemotableViewMethod
    public void setBaselineAlignedChildIndex(int i) {
        if (i < 0 || i >= this.getChildCount()) {
            throw new IllegalArgumentException("base aligned child index out of range (0, " + this.getChildCount() + ")");
        }
        this.mBaselineAlignedChildIndex = i;
    }

    View getVirtualChildAt(int index) {
        return this.getChildAt(index);
    }

    int getVirtualChildCount() {
        return this.getChildCount();
    }

    public float getWeightSum() {
        return this.mWeightSum;
    }

    @RemotableViewMethod
    public void setWeightSum(float weightSum) {
        this.mWeightSum = Math.max(0.0f, weightSum);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOrientation == 1) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected boolean hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == this.getVirtualChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        boolean allViewsAreGoneBefore = this.allViewsAreGoneBefore(childIndex);
        if (allViewsAreGoneBefore) {
            return (this.mShowDividers & 1) != 0;
        }
        return (this.mShowDividers & 2) != 0;
    }

    private boolean allViewsAreGoneBefore(int childIndex) {
        for (int i = childIndex - 1; i >= 0; --i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            return false;
        }
        return true;
    }

    void measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        LayoutParams lp;
        View child;
        int i;
        this.mTotalLength = 0;
        int maxWidth = 0;
        int childState = 0;
        int alternativeMaxWidth = 0;
        int weightedMaxWidth = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getVirtualChildCount();
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean matchWidth = false;
        boolean skippedMeasure = false;
        int baselineChildIndex = this.mBaselineAlignedChildIndex;
        boolean useLargestChild = this.mUseLargestChild;
        int largestChildHeight = Integer.MIN_VALUE;
        int consumedExcessSpace = 0;
        for (i = 0; i < count; ++i) {
            boolean useExcessSpace;
            child = this.getVirtualChildAt(i);
            if (child == null) {
                this.mTotalLength += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) {
                i += this.getChildrenSkipCount(child, i);
                continue;
            }
            if (this.hasDividerBeforeChildAt(i)) {
                this.mTotalLength += this.mDividerHeight;
            }
            lp = (LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            boolean bl = useExcessSpace = lp.height == 0 && lp.weight > 0.0f;
            if (heightMode == 0x40000000 && useExcessSpace) {
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + lp.topMargin + lp.bottomMargin);
                skippedMeasure = true;
            } else {
                if (useExcessSpace) {
                    lp.height = -2;
                }
                int usedHeight = totalWeight == 0.0f ? this.mTotalLength : 0;
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, 0, heightMeasureSpec, usedHeight);
                int childHeight = child.getMeasuredHeight();
                if (useExcessSpace) {
                    lp.height = 0;
                    consumedExcessSpace += childHeight;
                }
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + childHeight + lp.topMargin + lp.bottomMargin + this.getNextLocationOffset(child));
                if (useLargestChild) {
                    largestChildHeight = Math.max(childHeight, largestChildHeight);
                }
            }
            if (baselineChildIndex >= 0 && baselineChildIndex == i + 1) {
                this.mBaselineChildTop = this.mTotalLength;
            }
            if (i < baselineChildIndex && lp.weight > 0.0f) {
                throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
            }
            boolean matchWidthLocally = false;
            if (widthMode != 0x40000000 && lp.width == -1) {
                matchWidth = true;
                matchWidthLocally = true;
            }
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            childState = LinearLayout.combineMeasuredStates(childState, child.getMeasuredState());
            boolean bl2 = allFillParent = allFillParent && lp.width == -1;
            if (lp.weight > 0.0f) {
                weightedMaxWidth = Math.max(weightedMaxWidth, matchWidthLocally ? margin : measuredWidth);
            } else {
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
            }
            i += this.getChildrenSkipCount(child, i);
        }
        if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(count)) {
            this.mTotalLength += this.mDividerHeight;
        }
        if (useLargestChild && (heightMode == Integer.MIN_VALUE || heightMode == 0)) {
            this.mTotalLength = 0;
            for (i = 0; i < count; ++i) {
                child = this.getVirtualChildAt(i);
                if (child == null) {
                    this.mTotalLength += this.measureNullChild(i);
                    continue;
                }
                if (child.getVisibility() == 8) {
                    i += this.getChildrenSkipCount(child, i);
                    continue;
                }
                lp = (LayoutParams)child.getLayoutParams();
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + largestChildHeight + lp.topMargin + lp.bottomMargin + this.getNextLocationOffset(child));
            }
        }
        this.mTotalLength += this.mPaddingTop + this.mPaddingBottom;
        int heightSize = this.mTotalLength;
        heightSize = Math.max(heightSize, this.getSuggestedMinimumHeight());
        int heightSizeAndState = LinearLayout.resolveSizeAndState(heightSize, heightMeasureSpec, 0);
        heightSize = heightSizeAndState & 0xFFFFFF;
        int remainingExcess = heightSize - this.mTotalLength + (this.mAllowInconsistentMeasurement ? 0 : consumedExcessSpace);
        if (skippedMeasure || remainingExcess != 0 && totalWeight > 0.0f) {
            float remainingWeightSum = this.mWeightSum > 0.0f ? this.mWeightSum : totalWeight;
            this.mTotalLength = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                View child2 = this.getVirtualChildAt(i2);
                if (child2 == null || child2.getVisibility() == 8) continue;
                LayoutParams lp2 = (LayoutParams)child2.getLayoutParams();
                float childWeight = lp2.weight;
                if (childWeight > 0.0f) {
                    int share = (int)(childWeight * (float)remainingExcess / remainingWeightSum);
                    remainingExcess -= share;
                    remainingWeightSum -= childWeight;
                    int childHeight = this.mUseLargestChild && heightMode != 0x40000000 ? largestChildHeight : (lp2.height == 0 && (!this.mAllowInconsistentMeasurement || heightMode == 0x40000000) ? share : child2.getMeasuredHeight() + share);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, childHeight), 0x40000000);
                    int childWidthMeasureSpec = LinearLayout.getChildMeasureSpec(widthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + lp2.leftMargin + lp2.rightMargin, lp2.width);
                    child2.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childState = LinearLayout.combineMeasuredStates(childState, child2.getMeasuredState() & 0xFFFFFF00);
                }
                int margin = lp2.leftMargin + lp2.rightMargin;
                int measuredWidth = child2.getMeasuredWidth() + margin;
                maxWidth = Math.max(maxWidth, measuredWidth);
                boolean matchWidthLocally = widthMode != 0x40000000 && lp2.width == -1;
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
                allFillParent = allFillParent && lp2.width == -1;
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + child2.getMeasuredHeight() + lp2.topMargin + lp2.bottomMargin + this.getNextLocationOffset(child2));
            }
            this.mTotalLength += this.mPaddingTop + this.mPaddingBottom;
        } else {
            alternativeMaxWidth = Math.max(alternativeMaxWidth, weightedMaxWidth);
            if (useLargestChild && heightMode != 0x40000000) {
                for (int i3 = 0; i3 < count; ++i3) {
                    View child3 = this.getVirtualChildAt(i3);
                    if (child3 == null || child3.getVisibility() == 8) continue;
                    LayoutParams lp3 = (LayoutParams)child3.getLayoutParams();
                    float childExtra = lp3.weight;
                    if (!(childExtra > 0.0f)) continue;
                    child3.measure(View.MeasureSpec.makeMeasureSpec(child3.getMeasuredWidth(), 0x40000000), View.MeasureSpec.makeMeasureSpec(largestChildHeight, 0x40000000));
                }
            }
        }
        if (!allFillParent && widthMode != 0x40000000) {
            maxWidth = alternativeMaxWidth;
        }
        maxWidth += this.mPaddingLeft + this.mPaddingRight;
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(LinearLayout.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), heightSizeAndState);
        if (matchWidth) {
            this.forceUniformWidth(count, heightMeasureSpec);
        }
    }

    private void forceUniformWidth(int count, int heightMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.width != -1) continue;
            int oldHeight = lp.height;
            lp.height = child.getMeasuredHeight();
            this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
            lp.height = oldHeight;
        }
    }

    void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        LayoutParams lp;
        int i;
        this.mTotalLength = 0;
        int maxHeight = 0;
        int childState = 0;
        int alternativeMaxHeight = 0;
        int weightedMaxHeight = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getVirtualChildCount();
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean matchHeight = false;
        boolean skippedMeasure = false;
        if (this.mMaxAscent == null || this.mMaxDescent == null) {
            this.mMaxAscent = new int[4];
            this.mMaxDescent = new int[4];
        }
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        maxAscent[3] = -1;
        maxAscent[2] = -1;
        maxAscent[1] = -1;
        maxAscent[0] = -1;
        maxDescent[3] = -1;
        maxDescent[2] = -1;
        maxDescent[1] = -1;
        maxDescent[0] = -1;
        boolean baselineAligned = this.mBaselineAligned;
        boolean useLargestChild = this.mUseLargestChild;
        boolean isExactly = widthMode == 0x40000000;
        int largestChildWidth = Integer.MIN_VALUE;
        int usedExcessSpace = 0;
        for (i = 0; i < count; ++i) {
            int childBaseline;
            boolean useExcessSpace;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                this.mTotalLength += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) {
                i += this.getChildrenSkipCount(child, i);
                continue;
            }
            if (this.hasDividerBeforeChildAt(i)) {
                this.mTotalLength += this.mDividerWidth;
            }
            lp = (LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            boolean bl = useExcessSpace = lp.width == 0 && lp.weight > 0.0f;
            if (widthMode == 0x40000000 && useExcessSpace) {
                if (isExactly) {
                    this.mTotalLength += lp.leftMargin + lp.rightMargin;
                } else {
                    int totalLength = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength, totalLength + lp.leftMargin + lp.rightMargin);
                }
                if (baselineAligned) {
                    int freeWidthSpec = View.MeasureSpec.makeSafeMeasureSpec(View.MeasureSpec.getSize(widthMeasureSpec), 0);
                    int freeHeightSpec = View.MeasureSpec.makeSafeMeasureSpec(View.MeasureSpec.getSize(heightMeasureSpec), 0);
                    child.measure(freeWidthSpec, freeHeightSpec);
                } else {
                    skippedMeasure = true;
                }
            } else {
                if (useExcessSpace) {
                    lp.width = -2;
                }
                int usedWidth = totalWeight == 0.0f ? this.mTotalLength : 0;
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, usedWidth, heightMeasureSpec, 0);
                int childWidth = child.getMeasuredWidth();
                if (useExcessSpace) {
                    lp.width = 0;
                    usedExcessSpace += childWidth;
                }
                if (isExactly) {
                    this.mTotalLength += childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength, totalLength + childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
                }
                if (useLargestChild) {
                    largestChildWidth = Math.max(childWidth, largestChildWidth);
                }
            }
            boolean matchHeightLocally = false;
            if (heightMode != 0x40000000 && lp.height == -1) {
                matchHeight = true;
                matchHeightLocally = true;
            }
            int margin = lp.topMargin + lp.bottomMargin;
            int childHeight = child.getMeasuredHeight() + margin;
            childState = LinearLayout.combineMeasuredStates(childState, child.getMeasuredState());
            if (baselineAligned && (childBaseline = child.getBaseline()) != -1) {
                int gravity = (lp.gravity < 0 ? this.mGravity : lp.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            maxHeight = Math.max(maxHeight, childHeight);
            boolean bl2 = allFillParent = allFillParent && lp.height == -1;
            if (lp.weight > 0.0f) {
                weightedMaxHeight = Math.max(weightedMaxHeight, matchHeightLocally ? margin : childHeight);
            } else {
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
            }
            i += this.getChildrenSkipCount(child, i);
        }
        if (this.mTotalLength > 0 && this.hasDividerBeforeChildAt(count)) {
            this.mTotalLength += this.mDividerWidth;
        }
        if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
            int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
            int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
            maxHeight = Math.max(maxHeight, ascent + descent);
        }
        if (useLargestChild && (widthMode == Integer.MIN_VALUE || widthMode == 0)) {
            this.mTotalLength = 0;
            for (i = 0; i < count; ++i) {
                View child = this.getVirtualChildAt(i);
                if (child == null) {
                    this.mTotalLength += this.measureNullChild(i);
                    continue;
                }
                if (child.getVisibility() == 8) {
                    i += this.getChildrenSkipCount(child, i);
                    continue;
                }
                lp = (LayoutParams)child.getLayoutParams();
                if (isExactly) {
                    this.mTotalLength += largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                    continue;
                }
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
            }
        }
        this.mTotalLength += this.mPaddingLeft + this.mPaddingRight;
        int widthSize = this.mTotalLength;
        widthSize = Math.max(widthSize, this.getSuggestedMinimumWidth());
        int widthSizeAndState = LinearLayout.resolveSizeAndState(widthSize, widthMeasureSpec, 0);
        widthSize = widthSizeAndState & 0xFFFFFF;
        int remainingExcess = widthSize - this.mTotalLength + (this.mAllowInconsistentMeasurement ? 0 : usedExcessSpace);
        if (skippedMeasure || remainingExcess != 0 && totalWeight > 0.0f) {
            float remainingWeightSum = this.mWeightSum > 0.0f ? this.mWeightSum : totalWeight;
            maxAscent[3] = -1;
            maxAscent[2] = -1;
            maxAscent[1] = -1;
            maxAscent[0] = -1;
            maxDescent[3] = -1;
            maxDescent[2] = -1;
            maxDescent[1] = -1;
            maxDescent[0] = -1;
            maxHeight = -1;
            this.mTotalLength = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                int childBaseline;
                View child = this.getVirtualChildAt(i2);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp2 = (LayoutParams)child.getLayoutParams();
                float childWeight = lp2.weight;
                if (childWeight > 0.0f) {
                    int share = (int)(childWeight * (float)remainingExcess / remainingWeightSum);
                    remainingExcess -= share;
                    remainingWeightSum -= childWeight;
                    int childWidth = this.mUseLargestChild && widthMode != 0x40000000 ? largestChildWidth : (lp2.width == 0 && (!this.mAllowInconsistentMeasurement || widthMode == 0x40000000) ? share : child.getMeasuredWidth() + share);
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, childWidth), 0x40000000);
                    int childHeightMeasureSpec = LinearLayout.getChildMeasureSpec(heightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp2.topMargin + lp2.bottomMargin, lp2.height);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childState = LinearLayout.combineMeasuredStates(childState, child.getMeasuredState() & 0xFF000000);
                }
                if (isExactly) {
                    this.mTotalLength += child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength, totalLength + child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child));
                }
                boolean matchHeightLocally = heightMode != 0x40000000 && lp2.height == -1;
                int margin = lp2.topMargin + lp2.bottomMargin;
                int childHeight = child.getMeasuredHeight() + margin;
                maxHeight = Math.max(maxHeight, childHeight);
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
                boolean bl = allFillParent = allFillParent && lp2.height == -1;
                if (!baselineAligned || (childBaseline = child.getBaseline()) == -1) continue;
                int gravity = (lp2.gravity < 0 ? this.mGravity : lp2.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            this.mTotalLength += this.mPaddingLeft + this.mPaddingRight;
            if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
                int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
                int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
                maxHeight = Math.max(maxHeight, ascent + descent);
            }
        } else {
            alternativeMaxHeight = Math.max(alternativeMaxHeight, weightedMaxHeight);
            if (useLargestChild && widthMode != 0x40000000) {
                for (int i3 = 0; i3 < count; ++i3) {
                    View child = this.getVirtualChildAt(i3);
                    if (child == null || child.getVisibility() == 8) continue;
                    LayoutParams lp3 = (LayoutParams)child.getLayoutParams();
                    float childExtra = lp3.weight;
                    if (!(childExtra > 0.0f)) continue;
                    child.measure(View.MeasureSpec.makeMeasureSpec(largestChildWidth, 0x40000000), View.MeasureSpec.makeMeasureSpec(child.getMeasuredHeight(), 0x40000000));
                }
            }
        }
        if (!allFillParent && heightMode != 0x40000000) {
            maxHeight = alternativeMaxHeight;
        }
        maxHeight += this.mPaddingTop + this.mPaddingBottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(widthSizeAndState | childState & 0xFF000000, LinearLayout.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        if (matchHeight) {
            this.forceUniformHeight(count, widthMeasureSpec);
        }
    }

    private void forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    int getChildrenSkipCount(View child, int index) {
        return 0;
    }

    int measureNullChild(int childIndex) {
        return 0;
    }

    void measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        this.measureChildWithMargins(child, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    int getLocationOffset(View child) {
        return 0;
    }

    int getNextLocationOffset(View child) {
        return 0;
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mOrientation == 1) {
            this.layoutVertical(l, t, r, b);
        } else {
            this.layoutHorizontal(l, t, r, b);
        }
    }

    void layoutVertical(int left, int top, int right, int bottom) {
        int paddingLeft = this.mPaddingLeft;
        int width = right - left;
        int childRight = width - this.mPaddingRight;
        int childSpace = width - paddingLeft - this.mPaddingRight;
        int count = this.getVirtualChildCount();
        int majorGravity = this.mGravity & 0x70;
        int minorGravity = this.mGravity & 0x800007;
        switch (majorGravity) {
            case 80: {
                int childTop = this.mPaddingTop + bottom - top - this.mTotalLength;
                break;
            }
            case 16: {
                int childTop = this.mPaddingTop + (bottom - top - this.mTotalLength) / 2;
                break;
            }
            default: {
                int childTop = this.mPaddingTop;
            }
        }
        for (int i = 0; i < count; ++i) {
            int childLeft;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                childTop += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = paddingLeft + (childSpace - childWidth) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = childRight - childWidth - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = paddingLeft + lp.leftMargin;
                }
            }
            if (this.hasDividerBeforeChildAt(i)) {
                childTop += this.mDividerHeight;
            }
            this.setChildFrame(child, childLeft, (childTop += lp.topMargin) + this.getLocationOffset(child), childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin + this.getNextLocationOffset(child);
            i += this.getChildrenSkipCount(child, i);
        }
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (layoutDirection != this.mLayoutDirection) {
            this.mLayoutDirection = layoutDirection;
            if (this.mOrientation == 0) {
                this.requestLayout();
            }
        }
    }

    void layoutHorizontal(int left, int top, int right, int bottom) {
        boolean isLayoutRtl = this.isLayoutRtl();
        int paddingTop = this.mPaddingTop;
        int height = bottom - top;
        int childBottom = height - this.mPaddingBottom;
        int childSpace = height - paddingTop - this.mPaddingBottom;
        int count = this.getVirtualChildCount();
        int majorGravity = this.mGravity & 0x800007;
        int minorGravity = this.mGravity & 0x70;
        boolean baselineAligned = this.mBaselineAligned;
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        int layoutDirection = this.getLayoutDirection();
        switch (Gravity.getAbsoluteGravity(majorGravity, layoutDirection)) {
            case 5: {
                int childLeft = this.mPaddingLeft + right - left - this.mTotalLength;
                break;
            }
            case 1: {
                int childLeft = this.mPaddingLeft + (right - left - this.mTotalLength) / 2;
                break;
            }
            default: {
                int childLeft = this.mPaddingLeft;
            }
        }
        int start = 0;
        int dir = 1;
        if (isLayoutRtl) {
            start = count - 1;
            dir = -1;
        }
        for (int i = 0; i < count; ++i) {
            int childTop;
            int gravity;
            int childIndex = start + dir * i;
            View child = this.getVirtualChildAt(childIndex);
            if (child == null) {
                childLeft += this.measureNullChild(childIndex);
                continue;
            }
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childBaseline = -1;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (baselineAligned && lp.height != -1) {
                childBaseline = child.getBaseline();
            }
            if ((gravity = lp.gravity) < 0) {
                gravity = minorGravity;
            }
            switch (gravity & 0x70) {
                case 48: {
                    childTop = paddingTop + lp.topMargin;
                    if (childBaseline == -1) break;
                    childTop += maxAscent[1] - childBaseline;
                    break;
                }
                case 16: {
                    childTop = paddingTop + (childSpace - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = childBottom - childHeight - lp.bottomMargin;
                    if (childBaseline == -1) break;
                    int descent = child.getMeasuredHeight() - childBaseline;
                    childTop -= maxDescent[2] - descent;
                    break;
                }
                default: {
                    childTop = paddingTop;
                }
            }
            if (this.hasDividerBeforeChildAt(childIndex)) {
                childLeft += this.mDividerWidth;
            }
            this.setChildFrame(child, (childLeft += lp.leftMargin) + this.getLocationOffset(child), childTop, childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin + this.getNextLocationOffset(child);
            i += this.getChildrenSkipCount(child, childIndex);
        }
    }

    private void setChildFrame(View child, int left, int top, int width, int height) {
        child.layout(left, top, left + width, top + height);
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.requestLayout();
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @RemotableViewMethod
    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 0x800007;
        if ((this.mGravity & 0x800007) != gravity) {
            this.mGravity = this.mGravity & 0xFF7FFFF8 | gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.mGravity & 0x70) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-2, -2);
        }
        if (this.mOrientation == 1) {
            return new LayoutParams(-1, -2);
        }
        return null;
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (sPreserveMarginParamsInLayoutParamConversion) {
            if (lp instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)lp);
            }
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
            }
        }
        return new LayoutParams(lp);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return LinearLayout.class.getName();
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("layout:baselineAligned", this.mBaselineAligned);
        encoder.addProperty("layout:baselineAlignedChildIndex", this.mBaselineAlignedChildIndex);
        encoder.addProperty("measurement:baselineChildTop", this.mBaselineChildTop);
        encoder.addProperty("measurement:orientation", this.mOrientation);
        encoder.addProperty("measurement:gravity", this.mGravity);
        encoder.addProperty("measurement:totalLength", this.mTotalLength);
        encoder.addProperty("layout:totalLength", this.mTotalLength);
        encoder.addProperty("layout:useLargestChild", this.mUseLargestChild);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        @ViewDebug.ExportedProperty(category="layout")
        public float weight;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="NONE"), @ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=48, to="TOP"), @ViewDebug.IntToString(from=80, to="BOTTOM"), @ViewDebug.IntToString(from=3, to="LEFT"), @ViewDebug.IntToString(from=5, to="RIGHT"), @ViewDebug.IntToString(from=0x800003, to="START"), @ViewDebug.IntToString(from=0x800005, to="END"), @ViewDebug.IntToString(from=16, to="CENTER_VERTICAL"), @ViewDebug.IntToString(from=112, to="FILL_VERTICAL"), @ViewDebug.IntToString(from=1, to="CENTER_HORIZONTAL"), @ViewDebug.IntToString(from=7, to="FILL_HORIZONTAL"), @ViewDebug.IntToString(from=17, to="CENTER"), @ViewDebug.IntToString(from=119, to="FILL")})
        public int gravity = -1;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.LinearLayout_Layout);
            this.weight = a.getFloat(3, 0.0f);
            this.gravity = a.getInt(0, -1);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.weight = 0.0f;
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height);
            this.weight = weight;
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super(source);
            this.weight = source.weight;
            this.gravity = source.gravity;
        }

        @Override
        public String debug(String output) {
            return output + "LinearLayout.LayoutParams={width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " weight=" + this.weight + "}";
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("layout:weight", this.weight);
            encoder.addProperty("layout:gravity", this.gravity);
        }
    }
}

