/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.icu.util.Calendar;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.TextView;

class YearPickerView
extends ListView {
    private final YearAdapter mAdapter;
    private final int mViewSize;
    private final int mChildSize;
    private OnYearSelectedListener mOnYearSelectedListener;

    public YearPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842868);
    }

    public YearPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public YearPickerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        AbsListView.LayoutParams frame = new AbsListView.LayoutParams(-1, -2);
        this.setLayoutParams(frame);
        Resources res = context.getResources();
        this.mViewSize = res.getDimensionPixelOffset(17105236);
        this.mChildSize = res.getDimensionPixelOffset(17105213);
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                int year = YearPickerView.this.mAdapter.getYearForPosition(position);
                YearPickerView.this.mAdapter.setSelection(year);
                if (YearPickerView.this.mOnYearSelectedListener != null) {
                    YearPickerView.this.mOnYearSelectedListener.onYearChanged(YearPickerView.this, year);
                }
            }
        });
        this.mAdapter = new YearAdapter(this.getContext());
        this.setAdapter(this.mAdapter);
    }

    public void setOnYearSelectedListener(OnYearSelectedListener listener) {
        this.mOnYearSelectedListener = listener;
    }

    public void setYear(final int year) {
        this.mAdapter.setSelection(year);
        this.post(new Runnable(){

            @Override
            public void run() {
                int position = YearPickerView.this.mAdapter.getPositionForYear(year);
                if (position >= 0 && position < YearPickerView.this.getCount()) {
                    YearPickerView.this.setSelectionCentered(position);
                }
            }
        });
    }

    public void setSelectionCentered(int position) {
        int offset = this.mViewSize / 2 - this.mChildSize / 2;
        this.setSelectionFromTop(position, offset);
    }

    public void setRange(Calendar min, Calendar max) {
        this.mAdapter.setRange(min, max);
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        if (event.getEventType() == 4096) {
            event.setFromIndex(0);
            event.setToIndex(0);
        }
    }

    public static interface OnYearSelectedListener {
        public void onYearChanged(YearPickerView var1, int var2);
    }

    private static class YearAdapter
    extends BaseAdapter {
        private static final int ITEM_LAYOUT = 17367309;
        private static final int ITEM_TEXT_APPEARANCE = 16974887;
        private static final int ITEM_TEXT_ACTIVATED_APPEARANCE = 16974888;
        private final LayoutInflater mInflater;
        private int mActivatedYear;
        private int mMinYear;
        private int mCount;

        public YearAdapter(Context context) {
            this.mInflater = LayoutInflater.from(context);
        }

        public void setRange(Calendar minDate, Calendar maxDate) {
            int minYear = minDate.get(1);
            int count = maxDate.get(1) - minYear + 1;
            if (this.mMinYear != minYear || this.mCount != count) {
                this.mMinYear = minYear;
                this.mCount = count;
                this.notifyDataSetInvalidated();
            }
        }

        public boolean setSelection(int year) {
            if (this.mActivatedYear != year) {
                this.mActivatedYear = year;
                this.notifyDataSetChanged();
                return true;
            }
            return false;
        }

        @Override
        public int getCount() {
            return this.mCount;
        }

        @Override
        public Integer getItem(int position) {
            return this.getYearForPosition(position);
        }

        @Override
        public long getItemId(int position) {
            return this.getYearForPosition(position);
        }

        public int getPositionForYear(int year) {
            return year - this.mMinYear;
        }

        public int getYearForPosition(int position) {
            return this.mMinYear + position;
        }

        @Override
        public boolean hasStableIds() {
            return true;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            boolean activated;
            boolean hasNewView = convertView == null;
            TextView v = hasNewView ? (TextView)this.mInflater.inflate(17367309, parent, false) : (TextView)convertView;
            int year = this.getYearForPosition(position);
            boolean bl = activated = this.mActivatedYear == year;
            if (hasNewView || v.isActivated() != activated) {
                int textAppearanceResId = activated ? 16974888 : 16974887;
                v.setTextAppearance(textAppearanceResId);
                v.setActivated(activated);
            }
            v.setText(Integer.toString(year));
            return v;
        }

        @Override
        public int getItemViewType(int position) {
            return 0;
        }

        @Override
        public int getViewTypeCount() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean areAllItemsEnabled() {
            return true;
        }

        @Override
        public boolean isEnabled(int position) {
            return true;
        }
    }
}

