/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.os.UserManager;
import android.util.Log;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class ConfirmUserCreationActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final String TAG = "CreateUser";
    private String mUserName;
    private String mAccountName;
    private String mAccountType;
    private PersistableBundle mAccountOptions;
    private boolean mCanProceed;
    private UserManager mUserManager;

    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        Intent intent = this.getIntent();
        this.mUserName = intent.getStringExtra("android.os.extra.USER_NAME");
        this.mAccountName = intent.getStringExtra("android.os.extra.USER_ACCOUNT_NAME");
        this.mAccountType = intent.getStringExtra("android.os.extra.USER_ACCOUNT_TYPE");
        this.mAccountOptions = (PersistableBundle)intent.getParcelableExtra("android.os.extra.USER_ACCOUNT_OPTIONS");
        this.mUserManager = this.getSystemService(UserManager.class);
        String message = this.checkUserCreationRequirements();
        if (message == null) {
            this.finish();
            return;
        }
        AlertController.AlertParams ap = this.mAlertParams;
        ap.mMessage = message;
        ap.mPositiveButtonText = this.getString(17039370);
        ap.mPositiveButtonListener = this;
        if (this.mCanProceed) {
            ap.mNegativeButtonText = this.getString(0x1040000);
            ap.mNegativeButtonListener = this;
        }
        this.setupAlert();
    }

    private String checkUserCreationRequirements() {
        ApplicationInfo appInfo;
        String callingPackage = this.getCallingPackage();
        if (callingPackage == null) {
            throw new SecurityException("User Creation intent must be launched with startActivityForResult");
        }
        try {
            appInfo = this.getPackageManager().getApplicationInfo(callingPackage, 0);
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            throw new SecurityException("Cannot find the calling package");
        }
        boolean cantCreateUser = this.mUserManager.hasUserRestriction("no_add_user") || !this.mUserManager.isAdminUser();
        boolean cantCreateAnyMoreUsers = !this.mUserManager.canAddMoreUsers();
        Account account = new Account(this.mAccountName, this.mAccountType);
        boolean accountExists = this.mAccountName != null && this.mAccountType != null && AccountManager.get(this).someUserHasAccount(account) | this.mUserManager.someUserHasSeedAccount(this.mAccountName, this.mAccountType);
        this.mCanProceed = true;
        String appName = appInfo.loadLabel(this.getPackageManager()).toString();
        if (cantCreateUser) {
            this.setResult(1);
            return null;
        }
        if (cantCreateAnyMoreUsers) {
            this.setResult(2);
            return null;
        }
        String message = accountExists ? this.getString(17040860, appName, this.mAccountName) : this.getString(17040861, appName, this.mAccountName);
        return message;
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        this.setResult(0);
        if (which == -1 && this.mCanProceed) {
            Log.i(TAG, "Ok, creating user");
            UserInfo user = this.mUserManager.createUser(this.mUserName, 0);
            if (user == null) {
                Log.e(TAG, "Couldn't create user");
                this.finish();
                return;
            }
            this.mUserManager.setSeedAccountData(user.id, this.mAccountName, this.mAccountType, this.mAccountOptions);
            this.setResult(-1);
        }
        this.finish();
    }
}

