/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.DebugUtils;
import android.util.Slog;

public class DumpHeapActivity
extends Activity {
    public static final String KEY_PROCESS = "process";
    public static final String KEY_SIZE = "size";
    public static final String KEY_DIRECT_LAUNCH = "direct_launch";
    public static final String ACTION_DELETE_DUMPHEAP = "com.android.server.am.DELETE_DUMPHEAP";
    public static final String EXTRA_DELAY_DELETE = "delay_delete";
    public static final Uri JAVA_URI = Uri.parse("content://com.android.server.heapdump/java");
    String mProcess;
    long mSize;
    AlertDialog mDialog;
    boolean mHandled = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mProcess = this.getIntent().getStringExtra(KEY_PROCESS);
        this.mSize = this.getIntent().getLongExtra(KEY_SIZE, 0L);
        String directLaunch = this.getIntent().getStringExtra(KEY_DIRECT_LAUNCH);
        if (directLaunch != null) {
            Intent intent = new Intent("android.app.action.REPORT_HEAP_LIMIT");
            intent.setPackage(directLaunch);
            ClipData clip = ClipData.newUri(this.getContentResolver(), "Heap Dump", JAVA_URI);
            intent.setClipData(clip);
            intent.addFlags(1);
            intent.setType(clip.getDescription().getMimeType(0));
            intent.putExtra("android.intent.extra.STREAM", JAVA_URI);
            try {
                this.startActivity(intent);
                this.scheduleDelete();
                this.mHandled = true;
                this.finish();
                return;
            }
            catch (ActivityNotFoundException e) {
                Slog.i("DumpHeapActivity", "Unable to direct launch to " + directLaunch + ": " + e.getMessage());
            }
        }
        AlertDialog.Builder b = new AlertDialog.Builder(this, 16974394);
        b.setTitle(17040321);
        b.setMessage(this.getString(17040322, this.mProcess, DebugUtils.sizeValueToString(this.mSize, null)));
        b.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialog, int which) {
                DumpHeapActivity.this.mHandled = true;
                DumpHeapActivity.this.sendBroadcast(new Intent(DumpHeapActivity.ACTION_DELETE_DUMPHEAP));
                DumpHeapActivity.this.finish();
            }
        });
        b.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            @Override
            public void onClick(DialogInterface dialog, int which) {
                DumpHeapActivity.this.mHandled = true;
                DumpHeapActivity.this.scheduleDelete();
                Intent intent = new Intent("android.intent.action.SEND");
                ClipData clip = ClipData.newUri(DumpHeapActivity.this.getContentResolver(), "Heap Dump", JAVA_URI);
                intent.setClipData(clip);
                intent.addFlags(1);
                intent.setType(clip.getDescription().getMimeType(0));
                intent.putExtra("android.intent.extra.STREAM", JAVA_URI);
                DumpHeapActivity.this.startActivity(Intent.createChooser(intent, DumpHeapActivity.this.getText(17040321)));
                DumpHeapActivity.this.finish();
            }
        });
        this.mDialog = b.show();
    }

    void scheduleDelete() {
        Intent broadcast = new Intent(ACTION_DELETE_DUMPHEAP);
        broadcast.putExtra(EXTRA_DELAY_DELETE, true);
        this.sendBroadcast(broadcast);
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (!this.isChangingConfigurations() && !this.mHandled) {
            this.sendBroadcast(new Intent(ACTION_DELETE_DUMPHEAP));
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.mDialog.dismiss();
    }
}

