/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.UserManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

public class UnlaunchableAppActivity
extends Activity
implements DialogInterface.OnDismissListener,
DialogInterface.OnClickListener {
    private static final String TAG = "UnlaunchableAppActivity";
    private static final int UNLAUNCHABLE_REASON_QUIET_MODE = 1;
    private static final String EXTRA_UNLAUNCHABLE_REASON = "unlaunchable_reason";
    private int mUserId;
    private int mReason;
    private IntentSender mTarget;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        Intent intent = this.getIntent();
        this.mReason = intent.getIntExtra(EXTRA_UNLAUNCHABLE_REASON, -1);
        this.mUserId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
        this.mTarget = (IntentSender)intent.getParcelableExtra("android.intent.extra.INTENT");
        if (this.mUserId == -10000) {
            Log.wtf(TAG, "Invalid user id: " + this.mUserId + ". Stopping.");
            this.finish();
            return;
        }
        String dialogMessage = null;
        if (this.mReason != 1) {
            Log.wtf(TAG, "Invalid unlaunchable type: " + this.mReason);
            this.finish();
            return;
        }
        String dialogTitle = this.getResources().getString(17040868);
        dialogMessage = this.getResources().getString(17040869);
        View rootView = LayoutInflater.from(this).inflate(17367298, null);
        TextView titleView = (TextView)rootView.findViewById(16909387);
        TextView messageView = (TextView)rootView.findViewById(16909388);
        titleView.setText(dialogTitle);
        messageView.setText(dialogMessage);
        AlertDialog.Builder builder = new AlertDialog.Builder(this).setView(rootView).setOnDismissListener(this);
        if (this.mReason == 1) {
            builder.setPositiveButton(17040870, (DialogInterface.OnClickListener)this).setNegativeButton(0x1040000, null);
        } else {
            builder.setPositiveButton(17039370, null);
        }
        builder.show();
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        this.finish();
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        if (this.mReason == 1 && which == -1 && UserManager.get(this).trySetQuietModeDisabled(this.mUserId, this.mTarget) && this.mTarget != null) {
            try {
                this.startIntentSenderForResult(this.mTarget, -1, null, 0, 0, 0);
            }
            catch (IntentSender.SendIntentException sendIntentException) {
                // empty catch block
            }
        }
    }

    private static final Intent createBaseIntent() {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("android", UnlaunchableAppActivity.class.getName()));
        intent.setFlags(0x10800000);
        return intent;
    }

    public static Intent createInQuietModeDialogIntent(int userId) {
        Intent intent = UnlaunchableAppActivity.createBaseIntent();
        intent.putExtra(EXTRA_UNLAUNCHABLE_REASON, 1);
        intent.putExtra("android.intent.extra.user_handle", userId);
        return intent;
    }

    public static Intent createInQuietModeDialogIntent(int userId, IntentSender target) {
        Intent intent = UnlaunchableAppActivity.createInQuietModeDialogIntent(userId);
        intent.putExtra("android.intent.extra.INTENT", target);
        return intent;
    }
}

