/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Parcel;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.DebugUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.DurationsTable;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.app.procstats.PssTable;
import com.android.internal.app.procstats.SparseMappingTable;
import java.io.PrintWriter;
import java.util.Comparator;

public final class ProcessState {
    private static final String TAG = "ProcessStats";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PARCEL = false;
    private static final int[] PROCESS_STATE_TO_STATE = new int[]{0, 0, 1, 2, 2, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13};
    public static final Comparator<ProcessState> COMPARATOR = new Comparator<ProcessState>(){

        @Override
        public int compare(ProcessState lhs, ProcessState rhs) {
            if (lhs.mTmpTotalTime < rhs.mTmpTotalTime) {
                return -1;
            }
            if (lhs.mTmpTotalTime > rhs.mTmpTotalTime) {
                return 1;
            }
            return 0;
        }
    };
    public int tmpNumInUse;
    public ProcessState tmpFoundSubProc;
    private final ProcessStats mStats;
    private final String mName;
    private final String mPackage;
    private final int mUid;
    private final int mVersion;
    private final DurationsTable mDurations;
    private final PssTable mPssTable;
    private ProcessState mCommonProcess;
    private int mCurState = -1;
    private long mStartTime;
    private int mLastPssState = -1;
    private long mLastPssTime;
    private boolean mActive;
    private int mNumActiveServices;
    private int mNumStartedServices;
    private int mNumExcessiveWake;
    private int mNumExcessiveCpu;
    private int mNumCachedKill;
    private long mMinCachedKillPss;
    private long mAvgCachedKillPss;
    private long mMaxCachedKillPss;
    private boolean mMultiPackage;
    private boolean mDead;
    private long mTmpTotalTime;

    public ProcessState(ProcessStats processStats, String pkg, int uid, int vers, String name) {
        this.mStats = processStats;
        this.mName = name;
        this.mCommonProcess = this;
        this.mPackage = pkg;
        this.mUid = uid;
        this.mVersion = vers;
        this.mDurations = new DurationsTable(processStats.mTableData);
        this.mPssTable = new PssTable(processStats.mTableData);
    }

    public ProcessState(ProcessState commonProcess, String pkg, int uid, int vers, String name, long now) {
        this.mStats = commonProcess.mStats;
        this.mName = name;
        this.mCommonProcess = commonProcess;
        this.mPackage = pkg;
        this.mUid = uid;
        this.mVersion = vers;
        this.mCurState = commonProcess.mCurState;
        this.mStartTime = now;
        this.mDurations = new DurationsTable(commonProcess.mStats.mTableData);
        this.mPssTable = new PssTable(commonProcess.mStats.mTableData);
    }

    public ProcessState clone(long now) {
        ProcessState pnew = new ProcessState(this, this.mPackage, this.mUid, this.mVersion, this.mName, now);
        pnew.mDurations.addDurations(this.mDurations);
        pnew.mPssTable.copyFrom(this.mPssTable, 7);
        pnew.mNumExcessiveWake = this.mNumExcessiveWake;
        pnew.mNumExcessiveCpu = this.mNumExcessiveCpu;
        pnew.mNumCachedKill = this.mNumCachedKill;
        pnew.mMinCachedKillPss = this.mMinCachedKillPss;
        pnew.mAvgCachedKillPss = this.mAvgCachedKillPss;
        pnew.mMaxCachedKillPss = this.mMaxCachedKillPss;
        pnew.mActive = this.mActive;
        pnew.mNumActiveServices = this.mNumActiveServices;
        pnew.mNumStartedServices = this.mNumStartedServices;
        return pnew;
    }

    public String getName() {
        return this.mName;
    }

    public ProcessState getCommonProcess() {
        return this.mCommonProcess;
    }

    public void makeStandalone() {
        this.mCommonProcess = this;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public int getUid() {
        return this.mUid;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public boolean isMultiPackage() {
        return this.mMultiPackage;
    }

    public void setMultiPackage(boolean val) {
        this.mMultiPackage = val;
    }

    public int getDurationsBucketCount() {
        return this.mDurations.getKeyCount();
    }

    public void add(ProcessState other) {
        this.mDurations.addDurations(other.mDurations);
        this.mPssTable.mergeStats(other.mPssTable);
        this.mNumExcessiveWake += other.mNumExcessiveWake;
        this.mNumExcessiveCpu += other.mNumExcessiveCpu;
        if (other.mNumCachedKill > 0) {
            this.addCachedKill(other.mNumCachedKill, other.mMinCachedKillPss, other.mAvgCachedKillPss, other.mMaxCachedKillPss);
        }
    }

    public void resetSafely(long now) {
        this.mDurations.resetTable();
        this.mPssTable.resetTable();
        this.mStartTime = now;
        this.mLastPssState = -1;
        this.mLastPssTime = 0L;
        this.mNumExcessiveWake = 0;
        this.mNumExcessiveCpu = 0;
        this.mNumCachedKill = 0;
        this.mMaxCachedKillPss = 0L;
        this.mAvgCachedKillPss = 0L;
        this.mMinCachedKillPss = 0L;
    }

    public void makeDead() {
        this.mDead = true;
    }

    private void ensureNotDead() {
        if (!this.mDead) {
            return;
        }
        Slog.w(TAG, "ProcessState dead: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
    }

    public void writeToParcel(Parcel out, long now) {
        out.writeInt(this.mMultiPackage ? 1 : 0);
        this.mDurations.writeToParcel(out);
        this.mPssTable.writeToParcel(out);
        out.writeInt(this.mNumExcessiveWake);
        out.writeInt(this.mNumExcessiveCpu);
        out.writeInt(this.mNumCachedKill);
        if (this.mNumCachedKill > 0) {
            out.writeLong(this.mMinCachedKillPss);
            out.writeLong(this.mAvgCachedKillPss);
            out.writeLong(this.mMaxCachedKillPss);
        }
    }

    public boolean readFromParcel(Parcel in, boolean fully) {
        boolean multiPackage;
        boolean bl = multiPackage = in.readInt() != 0;
        if (fully) {
            this.mMultiPackage = multiPackage;
        }
        if (!this.mDurations.readFromParcel(in)) {
            return false;
        }
        if (!this.mPssTable.readFromParcel(in)) {
            return false;
        }
        this.mNumExcessiveWake = in.readInt();
        this.mNumExcessiveCpu = in.readInt();
        this.mNumCachedKill = in.readInt();
        if (this.mNumCachedKill > 0) {
            this.mMinCachedKillPss = in.readLong();
            this.mAvgCachedKillPss = in.readLong();
            this.mMaxCachedKillPss = in.readLong();
        } else {
            this.mMaxCachedKillPss = 0L;
            this.mAvgCachedKillPss = 0L;
            this.mMinCachedKillPss = 0L;
        }
        return true;
    }

    public void makeActive() {
        this.ensureNotDead();
        this.mActive = true;
    }

    public void makeInactive() {
        this.mActive = false;
    }

    public boolean isInUse() {
        return this.mActive || this.mNumActiveServices > 0 || this.mNumStartedServices > 0 || this.mCurState != -1;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public boolean hasAnyData() {
        return this.mDurations.getKeyCount() != 0 || this.mCurState != -1 || this.mPssTable.getKeyCount() != 0;
    }

    public void setState(int state, int memFactor, long now, ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        state = state < 0 ? (this.mNumStartedServices > 0 ? 7 + memFactor * 14 : -1) : PROCESS_STATE_TO_STATE[state] + memFactor * 14;
        this.mCommonProcess.setState(state, now);
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        if (pkgList != null) {
            for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                this.pullFixedProc(pkgList, ip).setState(state, now);
            }
        }
    }

    public void setState(int state, long now) {
        this.ensureNotDead();
        if (this.mCurState != state) {
            this.commitStateTime(now);
            this.mCurState = state;
        }
    }

    public void commitStateTime(long now) {
        long dur;
        if (this.mCurState != -1 && (dur = now - this.mStartTime) > 0L) {
            this.mDurations.addDuration(this.mCurState, dur);
        }
        this.mStartTime = now;
    }

    public void incActiveServices(String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.incActiveServices(serviceName);
        }
        ++this.mNumActiveServices;
    }

    public void decActiveServices(String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.decActiveServices(serviceName);
        }
        --this.mNumActiveServices;
        if (this.mNumActiveServices < 0) {
            Slog.wtfStack(TAG, "Proc active services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " proc=" + this.mName + " service=" + serviceName);
            this.mNumActiveServices = 0;
        }
    }

    public void incStartedServices(int memFactor, long now, String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.incStartedServices(memFactor, now, serviceName);
        }
        ++this.mNumStartedServices;
        if (this.mNumStartedServices == 1 && this.mCurState == -1) {
            this.setState(7 + memFactor * 14, now);
        }
    }

    public void decStartedServices(int memFactor, long now, String serviceName) {
        if (this.mCommonProcess != this) {
            this.mCommonProcess.decStartedServices(memFactor, now, serviceName);
        }
        --this.mNumStartedServices;
        if (this.mNumStartedServices == 0 && this.mCurState % 14 == 7) {
            this.setState(-1, now);
        } else if (this.mNumStartedServices < 0) {
            Slog.wtfStack(TAG, "Proc started services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " name=" + this.mName);
            this.mNumStartedServices = 0;
        }
    }

    public void addPss(long pss, long uss, boolean always, ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        this.ensureNotDead();
        if (!always && this.mLastPssState == this.mCurState && SystemClock.uptimeMillis() < this.mLastPssTime + 30000L) {
            return;
        }
        this.mLastPssState = this.mCurState;
        this.mLastPssTime = SystemClock.uptimeMillis();
        if (this.mCurState != -1) {
            this.mCommonProcess.mPssTable.mergeStats(this.mCurState, 1, pss, pss, pss, uss, uss, uss);
            if (!this.mCommonProcess.mMultiPackage) {
                return;
            }
            if (pkgList != null) {
                for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                    this.pullFixedProc(pkgList, (int)ip).mPssTable.mergeStats(this.mCurState, 1, pss, pss, pss, uss, uss, uss);
                }
            }
        }
    }

    public void reportExcessiveWake(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        this.ensureNotDead();
        ++this.mCommonProcess.mNumExcessiveWake;
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
            ++this.pullFixedProc(pkgList, (int)ip).mNumExcessiveWake;
        }
    }

    public void reportExcessiveCpu(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList) {
        this.ensureNotDead();
        ++this.mCommonProcess.mNumExcessiveCpu;
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
            ++this.pullFixedProc(pkgList, (int)ip).mNumExcessiveCpu;
        }
    }

    private void addCachedKill(int num, long minPss, long avgPss, long maxPss) {
        if (this.mNumCachedKill <= 0) {
            this.mNumCachedKill = num;
            this.mMinCachedKillPss = minPss;
            this.mAvgCachedKillPss = avgPss;
            this.mMaxCachedKillPss = maxPss;
        } else {
            if (minPss < this.mMinCachedKillPss) {
                this.mMinCachedKillPss = minPss;
            }
            if (maxPss > this.mMaxCachedKillPss) {
                this.mMaxCachedKillPss = maxPss;
            }
            this.mAvgCachedKillPss = (long)(((double)this.mAvgCachedKillPss * (double)this.mNumCachedKill + (double)avgPss) / (double)(this.mNumCachedKill + num));
            this.mNumCachedKill += num;
        }
    }

    public void reportCachedKill(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList, long pss) {
        this.ensureNotDead();
        this.mCommonProcess.addCachedKill(1, pss, pss, pss);
        if (!this.mCommonProcess.mMultiPackage) {
            return;
        }
        for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
            this.pullFixedProc(pkgList, ip).addCachedKill(1, pss, pss, pss);
        }
    }

    public ProcessState pullFixedProc(String pkgName) {
        if (this.mMultiPackage) {
            SparseArray<ProcessStats.PackageState> vpkg = this.mStats.mPackages.get(pkgName, this.mUid);
            if (vpkg == null) {
                throw new IllegalStateException("Didn't find package " + pkgName + " / " + this.mUid);
            }
            ProcessStats.PackageState pkg = vpkg.get(this.mVersion);
            if (pkg == null) {
                throw new IllegalStateException("Didn't find package " + pkgName + " / " + this.mUid + " vers " + this.mVersion);
            }
            ProcessState proc = pkg.mProcesses.get(this.mName);
            if (proc == null) {
                throw new IllegalStateException("Didn't create per-package process " + this.mName + " in pkg " + pkgName + " / " + this.mUid + " vers " + this.mVersion);
            }
            return proc;
        }
        return this;
    }

    private ProcessState pullFixedProc(ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList, int index) {
        ProcessStats.ProcessStateHolder holder = pkgList.valueAt(index);
        ProcessState proc = holder.state;
        if (this.mDead && proc.mCommonProcess != proc) {
            Log.wtf(TAG, "Pulling dead proc: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
            proc = this.mStats.getProcessStateLocked(proc.mPackage, proc.mUid, proc.mVersion, proc.mName);
        }
        if (proc.mMultiPackage) {
            SparseArray<ProcessStats.PackageState> vpkg = this.mStats.mPackages.get(pkgList.keyAt(index), proc.mUid);
            if (vpkg == null) {
                throw new IllegalStateException("No existing package " + pkgList.keyAt(index) + "/" + proc.mUid + " for multi-proc " + proc.mName);
            }
            ProcessStats.PackageState pkg = vpkg.get(proc.mVersion);
            if (pkg == null) {
                throw new IllegalStateException("No existing package " + pkgList.keyAt(index) + "/" + proc.mUid + " for multi-proc " + proc.mName + " version " + proc.mVersion);
            }
            String savedName = proc.mName;
            proc = pkg.mProcesses.get(proc.mName);
            if (proc == null) {
                throw new IllegalStateException("Didn't create per-package process " + savedName + " in pkg " + pkg.mPackageName + "/" + pkg.mUid);
            }
            holder.state = proc;
        }
        return proc;
    }

    public long getDuration(int state, long now) {
        long time = this.mDurations.getValueForId((byte)state);
        if (this.mCurState == state) {
            time += now - this.mStartTime;
        }
        return time;
    }

    public long getPssSampleCount(int state) {
        return this.mPssTable.getValueForId((byte)state, 0);
    }

    public long getPssMinimum(int state) {
        return this.mPssTable.getValueForId((byte)state, 1);
    }

    public long getPssAverage(int state) {
        return this.mPssTable.getValueForId((byte)state, 2);
    }

    public long getPssMaximum(int state) {
        return this.mPssTable.getValueForId((byte)state, 3);
    }

    public long getPssUssMinimum(int state) {
        return this.mPssTable.getValueForId((byte)state, 4);
    }

    public long getPssUssAverage(int state) {
        return this.mPssTable.getValueForId((byte)state, 5);
    }

    public long getPssUssMaximum(int state) {
        return this.mPssTable.getValueForId((byte)state, 6);
    }

    public void aggregatePss(ProcessStats.TotalMemoryUseCollection data, long now) {
        PssAggr fgPss = new PssAggr();
        PssAggr bgPss = new PssAggr();
        PssAggr cachedPss = new PssAggr();
        boolean havePss = false;
        for (int i = 0; i < this.mDurations.getKeyCount(); ++i) {
            int key = this.mDurations.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            int procState = type % 14;
            long samples = this.getPssSampleCount(type);
            if (samples <= 0L) continue;
            long avg = this.getPssAverage(type);
            havePss = true;
            if (procState <= 2) {
                fgPss.add(avg, samples);
                continue;
            }
            if (procState <= 8) {
                bgPss.add(avg, samples);
                continue;
            }
            cachedPss.add(avg, samples);
        }
        if (!havePss) {
            return;
        }
        boolean fgHasBg = false;
        boolean fgHasCached = false;
        boolean bgHasCached = false;
        if (fgPss.samples < 3L && bgPss.samples > 0L) {
            fgHasBg = true;
            fgPss.add(bgPss.pss, bgPss.samples);
        }
        if (fgPss.samples < 3L && cachedPss.samples > 0L) {
            fgHasCached = true;
            fgPss.add(cachedPss.pss, cachedPss.samples);
        }
        if (bgPss.samples < 3L && cachedPss.samples > 0L) {
            bgHasCached = true;
            bgPss.add(cachedPss.pss, cachedPss.samples);
        }
        if (bgPss.samples < 3L && !fgHasBg && fgPss.samples > 0L) {
            bgPss.add(fgPss.pss, fgPss.samples);
        }
        if (cachedPss.samples < 3L && !bgHasCached && bgPss.samples > 0L) {
            cachedPss.add(bgPss.pss, bgPss.samples);
        }
        if (cachedPss.samples < 3L && !fgHasCached && fgPss.samples > 0L) {
            cachedPss.add(fgPss.pss, fgPss.samples);
        }
        for (int i = 0; i < this.mDurations.getKeyCount(); ++i) {
            long avg;
            int procState;
            int key = this.mDurations.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            long time = this.mDurations.getValue(key);
            if (this.mCurState == type) {
                time += now - this.mStartTime;
            }
            int n = procState = type % 14;
            data.processStateTime[n] = data.processStateTime[n] + time;
            long samples = this.getPssSampleCount(type);
            if (samples > 0L) {
                avg = this.getPssAverage(type);
            } else if (procState <= 2) {
                samples = fgPss.samples;
                avg = fgPss.pss;
            } else if (procState <= 8) {
                samples = bgPss.samples;
                avg = bgPss.pss;
            } else {
                samples = cachedPss.samples;
                avg = cachedPss.pss;
            }
            double newAvg = ((double)data.processStatePss[procState] * (double)data.processStateSamples[procState] + (double)avg * (double)samples) / (double)((long)data.processStateSamples[procState] + samples);
            data.processStatePss[procState] = (long)newAvg;
            int n2 = procState;
            data.processStateSamples[n2] = (int)((long)data.processStateSamples[n2] + samples);
            int n3 = procState;
            data.processStateWeight[n3] = data.processStateWeight[n3] + (double)avg * (double)time;
        }
    }

    public long computeProcessTimeLocked(int[] screenStates, int[] memStates, int[] procStates, long now) {
        long totalTime = 0L;
        for (int is = 0; is < screenStates.length; ++is) {
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int bucket = (screenStates[is] + memStates[im]) * 14 + procStates[ip];
                    totalTime += this.getDuration(bucket, now);
                }
            }
        }
        this.mTmpTotalTime = totalTime;
        return totalTime;
    }

    public void dumpSummary(PrintWriter pw, String prefix, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime) {
        pw.print(prefix);
        pw.print("* ");
        pw.print(this.mName);
        pw.print(" / ");
        UserHandle.formatUid(pw, this.mUid);
        pw.print(" / v");
        pw.print(this.mVersion);
        pw.println(":");
        this.dumpProcessSummaryDetails(pw, prefix, "         TOTAL: ", screenStates, memStates, procStates, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "    Persistent: ", screenStates, memStates, new int[]{0}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "           Top: ", screenStates, memStates, new int[]{1}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "        Imp Fg: ", screenStates, memStates, new int[]{2}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "        Imp Bg: ", screenStates, memStates, new int[]{3}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "        Backup: ", screenStates, memStates, new int[]{4}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "     Heavy Wgt: ", screenStates, memStates, new int[]{5}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "       Service: ", screenStates, memStates, new int[]{6}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "    Service Rs: ", screenStates, memStates, new int[]{7}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "      Receiver: ", screenStates, memStates, new int[]{8}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "        (Home): ", screenStates, memStates, new int[]{9}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "    (Last Act): ", screenStates, memStates, new int[]{10}, now, totalTime, true);
        this.dumpProcessSummaryDetails(pw, prefix, "      (Cached): ", screenStates, memStates, new int[]{11, 12, 13}, now, totalTime, true);
    }

    public void dumpProcessState(PrintWriter pw, String prefix, int[] screenStates, int[] memStates, int[] procStates, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int iscreen = screenStates[is];
                    int imem = memStates[im];
                    int bucket = (iscreen + imem) * 14 + procStates[ip];
                    long time = this.mDurations.getValueForId((byte)bucket);
                    String running = "";
                    if (this.mCurState == bucket) {
                        running = " (running)";
                    }
                    if (time == 0L) continue;
                    pw.print(prefix);
                    if (screenStates.length > 1) {
                        DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                        printedScreen = iscreen;
                    }
                    if (memStates.length > 1) {
                        DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '/');
                        printedMem = imem;
                    }
                    pw.print(DumpUtils.STATE_NAMES[procStates[ip]]);
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                    totalTime += time;
                }
            }
        }
        if (totalTime != 0L) {
            pw.print(prefix);
            if (screenStates.length > 1) {
                DumpUtils.printScreenLabel(pw, -1);
            }
            if (memStates.length > 1) {
                DumpUtils.printMemLabel(pw, -1, '/');
            }
            pw.print("TOTAL  : ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
    }

    public void dumpPss(PrintWriter pw, String prefix, int[] screenStates, int[] memStates, int[] procStates) {
        boolean printedHeader = false;
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int iscreen = screenStates[is];
                    int imem = memStates[im];
                    int bucket = (iscreen + imem) * 14 + procStates[ip];
                    long count = this.getPssSampleCount(bucket);
                    if (count <= 0L) continue;
                    if (!printedHeader) {
                        pw.print(prefix);
                        pw.print("PSS/USS (");
                        pw.print(this.mPssTable.getKeyCount());
                        pw.println(" entries):");
                        printedHeader = true;
                    }
                    pw.print(prefix);
                    pw.print("  ");
                    if (screenStates.length > 1) {
                        DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                        printedScreen = iscreen;
                    }
                    if (memStates.length > 1) {
                        DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '/');
                        printedMem = imem;
                    }
                    pw.print(DumpUtils.STATE_NAMES[procStates[ip]]);
                    pw.print(": ");
                    pw.print(count);
                    pw.print(" samples ");
                    DebugUtils.printSizeValue(pw, this.getPssMinimum(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssAverage(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssMaximum(bucket) * 1024L);
                    pw.print(" / ");
                    DebugUtils.printSizeValue(pw, this.getPssUssMinimum(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssUssAverage(bucket) * 1024L);
                    pw.print(" ");
                    DebugUtils.printSizeValue(pw, this.getPssUssMaximum(bucket) * 1024L);
                    pw.println();
                }
            }
        }
        if (this.mNumExcessiveWake != 0) {
            pw.print(prefix);
            pw.print("Killed for excessive wake locks: ");
            pw.print(this.mNumExcessiveWake);
            pw.println(" times");
        }
        if (this.mNumExcessiveCpu != 0) {
            pw.print(prefix);
            pw.print("Killed for excessive CPU use: ");
            pw.print(this.mNumExcessiveCpu);
            pw.println(" times");
        }
        if (this.mNumCachedKill != 0) {
            pw.print(prefix);
            pw.print("Killed from cached state: ");
            pw.print(this.mNumCachedKill);
            pw.print(" times from pss ");
            DebugUtils.printSizeValue(pw, this.mMinCachedKillPss * 1024L);
            pw.print("-");
            DebugUtils.printSizeValue(pw, this.mAvgCachedKillPss * 1024L);
            pw.print("-");
            DebugUtils.printSizeValue(pw, this.mMaxCachedKillPss * 1024L);
            pw.println();
        }
    }

    private void dumpProcessSummaryDetails(PrintWriter pw, String prefix, String label, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime, boolean full) {
        ProcessStats.ProcessDataCollection totals = new ProcessStats.ProcessDataCollection(screenStates, memStates, procStates);
        this.computeProcessData(totals, now);
        double percentage = (double)totals.totalTime / (double)totalTime * 100.0;
        if (percentage >= 0.005 || totals.numPss != 0L) {
            if (prefix != null) {
                pw.print(prefix);
            }
            if (label != null) {
                pw.print(label);
            }
            totals.print(pw, totalTime, full);
            if (prefix != null) {
                pw.println();
            }
        }
    }

    public void dumpInternalLocked(PrintWriter pw, String prefix, boolean dumpAll) {
        if (dumpAll) {
            pw.print(prefix);
            pw.print("myID=");
            pw.print(Integer.toHexString(System.identityHashCode(this)));
            pw.print(" mCommonProcess=");
            pw.print(Integer.toHexString(System.identityHashCode(this.mCommonProcess)));
            pw.print(" mPackage=");
            pw.println(this.mPackage);
            if (this.mMultiPackage) {
                pw.print(prefix);
                pw.print("mMultiPackage=");
                pw.println(this.mMultiPackage);
            }
            if (this != this.mCommonProcess) {
                pw.print(prefix);
                pw.print("Common Proc: ");
                pw.print(this.mCommonProcess.mName);
                pw.print("/");
                pw.print(this.mCommonProcess.mUid);
                pw.print(" pkg=");
                pw.println(this.mCommonProcess.mPackage);
            }
        }
        if (this.mActive) {
            pw.print(prefix);
            pw.print("mActive=");
            pw.println(this.mActive);
        }
        if (this.mDead) {
            pw.print(prefix);
            pw.print("mDead=");
            pw.println(this.mDead);
        }
        if (this.mNumActiveServices != 0 || this.mNumStartedServices != 0) {
            pw.print(prefix);
            pw.print("mNumActiveServices=");
            pw.print(this.mNumActiveServices);
            pw.print(" mNumStartedServices=");
            pw.println(this.mNumStartedServices);
        }
    }

    public void computeProcessData(ProcessStats.ProcessDataCollection data, long now) {
        data.totalTime = 0L;
        data.maxUss = 0L;
        data.avgUss = 0L;
        data.minUss = 0L;
        data.maxPss = 0L;
        data.avgPss = 0L;
        data.minPss = 0L;
        data.numPss = 0L;
        for (int is = 0; is < data.screenStates.length; ++is) {
            for (int im = 0; im < data.memStates.length; ++im) {
                for (int ip = 0; ip < data.procStates.length; ++ip) {
                    int bucket = (data.screenStates[is] + data.memStates[im]) * 14 + data.procStates[ip];
                    data.totalTime += this.getDuration(bucket, now);
                    long samples = this.getPssSampleCount(bucket);
                    if (samples <= 0L) continue;
                    long minPss = this.getPssMinimum(bucket);
                    long avgPss = this.getPssAverage(bucket);
                    long maxPss = this.getPssMaximum(bucket);
                    long minUss = this.getPssUssMinimum(bucket);
                    long avgUss = this.getPssUssAverage(bucket);
                    long maxUss = this.getPssUssMaximum(bucket);
                    if (data.numPss == 0L) {
                        data.minPss = minPss;
                        data.avgPss = avgPss;
                        data.maxPss = maxPss;
                        data.minUss = minUss;
                        data.avgUss = avgUss;
                        data.maxUss = maxUss;
                    } else {
                        if (minPss < data.minPss) {
                            data.minPss = minPss;
                        }
                        data.avgPss = (long)(((double)data.avgPss * (double)data.numPss + (double)avgPss * (double)samples) / (double)(data.numPss + samples));
                        if (maxPss > data.maxPss) {
                            data.maxPss = maxPss;
                        }
                        if (minUss < data.minUss) {
                            data.minUss = minUss;
                        }
                        data.avgUss = (long)(((double)data.avgUss * (double)data.numPss + (double)avgUss * (double)samples) / (double)(data.numPss + samples));
                        if (maxUss > data.maxUss) {
                            data.maxUss = maxUss;
                        }
                    }
                    data.numPss += samples;
                }
            }
        }
    }

    public void dumpCsv(PrintWriter pw, boolean sepScreenStates, int[] screenStates, boolean sepMemStates, int[] memStates, boolean sepProcStates, int[] procStates, long now) {
        int NSS = sepScreenStates ? screenStates.length : 1;
        int NMS = sepMemStates ? memStates.length : 1;
        int NPS = sepProcStates ? procStates.length : 1;
        for (int iss = 0; iss < NSS; ++iss) {
            for (int ims = 0; ims < NMS; ++ims) {
                for (int ips = 0; ips < NPS; ++ips) {
                    int vsscreen = sepScreenStates ? screenStates[iss] : 0;
                    int vsmem = sepMemStates ? memStates[ims] : 0;
                    int vsproc = sepProcStates ? procStates[ips] : 0;
                    int NSA = sepScreenStates ? 1 : screenStates.length;
                    int NMA = sepMemStates ? 1 : memStates.length;
                    int NPA = sepProcStates ? 1 : procStates.length;
                    long totalTime = 0L;
                    for (int isa = 0; isa < NSA; ++isa) {
                        for (int ima = 0; ima < NMA; ++ima) {
                            for (int ipa = 0; ipa < NPA; ++ipa) {
                                int vascreen = sepScreenStates ? 0 : screenStates[isa];
                                int vamem = sepMemStates ? 0 : memStates[ima];
                                int vaproc = sepProcStates ? 0 : procStates[ipa];
                                int bucket = (vsscreen + vascreen + vsmem + vamem) * 14 + vsproc + vaproc;
                                totalTime += this.getDuration(bucket, now);
                            }
                        }
                    }
                    pw.print("\t");
                    pw.print(totalTime);
                }
            }
        }
    }

    public void dumpPackageProcCheckin(PrintWriter pw, String pkgName, int uid, int vers, String itemName, long now) {
        pw.print("pkgproc,");
        pw.print(pkgName);
        pw.print(",");
        pw.print(uid);
        pw.print(",");
        pw.print(vers);
        pw.print(",");
        pw.print(DumpUtils.collapseString(pkgName, itemName));
        this.dumpAllStateCheckin(pw, now);
        pw.println();
        if (this.mPssTable.getKeyCount() > 0) {
            pw.print("pkgpss,");
            pw.print(pkgName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(vers);
            pw.print(",");
            pw.print(DumpUtils.collapseString(pkgName, itemName));
            this.dumpAllPssCheckin(pw);
            pw.println();
        }
        if (this.mNumExcessiveWake > 0 || this.mNumExcessiveCpu > 0 || this.mNumCachedKill > 0) {
            pw.print("pkgkills,");
            pw.print(pkgName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(vers);
            pw.print(",");
            pw.print(DumpUtils.collapseString(pkgName, itemName));
            pw.print(",");
            pw.print(this.mNumExcessiveWake);
            pw.print(",");
            pw.print(this.mNumExcessiveCpu);
            pw.print(",");
            pw.print(this.mNumCachedKill);
            pw.print(",");
            pw.print(this.mMinCachedKillPss);
            pw.print(":");
            pw.print(this.mAvgCachedKillPss);
            pw.print(":");
            pw.print(this.mMaxCachedKillPss);
            pw.println();
        }
    }

    public void dumpProcCheckin(PrintWriter pw, String procName, int uid, long now) {
        if (this.mDurations.getKeyCount() > 0) {
            pw.print("proc,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            this.dumpAllStateCheckin(pw, now);
            pw.println();
        }
        if (this.mPssTable.getKeyCount() > 0) {
            pw.print("pss,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            this.dumpAllPssCheckin(pw);
            pw.println();
        }
        if (this.mNumExcessiveWake > 0 || this.mNumExcessiveCpu > 0 || this.mNumCachedKill > 0) {
            pw.print("kills,");
            pw.print(procName);
            pw.print(",");
            pw.print(uid);
            pw.print(",");
            pw.print(this.mNumExcessiveWake);
            pw.print(",");
            pw.print(this.mNumExcessiveCpu);
            pw.print(",");
            pw.print(this.mNumCachedKill);
            pw.print(",");
            pw.print(this.mMinCachedKillPss);
            pw.print(":");
            pw.print(this.mAvgCachedKillPss);
            pw.print(":");
            pw.print(this.mMaxCachedKillPss);
            pw.println();
        }
    }

    public void dumpAllStateCheckin(PrintWriter pw, long now) {
        boolean didCurState = false;
        for (int i = 0; i < this.mDurations.getKeyCount(); ++i) {
            int key = this.mDurations.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            long time = this.mDurations.getValue(key);
            if (this.mCurState == type) {
                didCurState = true;
                time += now - this.mStartTime;
            }
            DumpUtils.printProcStateTagAndValue(pw, type, time);
        }
        if (!didCurState && this.mCurState != -1) {
            DumpUtils.printProcStateTagAndValue(pw, this.mCurState, now - this.mStartTime);
        }
    }

    public void dumpAllPssCheckin(PrintWriter pw) {
        int N = this.mPssTable.getKeyCount();
        for (int i = 0; i < N; ++i) {
            int key = this.mPssTable.getKeyAt(i);
            byte type = SparseMappingTable.getIdFromKey(key);
            pw.print(',');
            DumpUtils.printProcStateTag(pw, type);
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 0));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 1));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 2));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 3));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 4));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 5));
            pw.print(':');
            pw.print(this.mPssTable.getValue(key, 6));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ProcessState{").append(Integer.toHexString(System.identityHashCode(this))).append(" ").append(this.mName).append("/").append(this.mUid).append(" pkg=").append(this.mPackage);
        if (this.mMultiPackage) {
            sb.append(" (multi)");
        }
        if (this.mCommonProcess != this) {
            sb.append(" (sub)");
        }
        sb.append("}");
        return sb.toString();
    }

    static class PssAggr {
        long pss = 0L;
        long samples = 0L;

        PssAggr() {
        }

        void add(long newPss, long newSamples) {
            this.pss = (long)((double)this.pss * (double)this.samples + (double)newPss * (double)newSamples) / (this.samples + newSamples);
            this.samples += newSamples;
        }
    }
}

