/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import com.android.internal.app.procstats.SparseMappingTable;

public class PssTable
extends SparseMappingTable.Table {
    public PssTable(SparseMappingTable tableData) {
        super(tableData);
    }

    public void mergeStats(PssTable that) {
        int N = that.getKeyCount();
        for (int i = 0; i < N; ++i) {
            int key = that.getKeyAt(i);
            byte state = SparseMappingTable.getIdFromKey(key);
            this.mergeStats(state, (int)that.getValue(key, 0), that.getValue(key, 1), that.getValue(key, 2), that.getValue(key, 3), that.getValue(key, 4), that.getValue(key, 5), that.getValue(key, 6));
        }
    }

    public void mergeStats(int state, int inCount, long minPss, long avgPss, long maxPss, long minUss, long avgUss, long maxUss) {
        int key = this.getOrAddKey((byte)state, 7);
        long count = this.getValue(key, 0);
        if (count == 0L) {
            this.setValue(key, 0, inCount);
            this.setValue(key, 1, minPss);
            this.setValue(key, 2, avgPss);
            this.setValue(key, 3, maxPss);
            this.setValue(key, 4, minUss);
            this.setValue(key, 5, avgUss);
            this.setValue(key, 6, maxUss);
        } else {
            this.setValue(key, 0, count + (long)inCount);
            long val = this.getValue(key, 1);
            if (val > minPss) {
                this.setValue(key, 1, minPss);
            }
            val = this.getValue(key, 2);
            this.setValue(key, 2, (long)(((double)val * (double)count + (double)avgPss * (double)inCount) / (double)(count + (long)inCount)));
            val = this.getValue(key, 3);
            if (val < maxPss) {
                this.setValue(key, 3, maxPss);
            }
            if ((val = this.getValue(key, 4)) > minUss) {
                this.setValue(key, 4, minUss);
            }
            val = this.getValue(key, 5);
            this.setValue(key, 2, (long)(((double)val * (double)count + (double)avgUss * (double)inCount) / (double)(count + (long)inCount)));
            val = this.getValue(key, 6);
            if (val < maxUss) {
                this.setValue(key, 6, maxUss);
            }
        }
    }
}

