/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import libcore.io.IoUtils;
import libcore.io.Streams;

public class InstallerConnection {
    private static final String TAG = "InstallerConnection";
    private static final boolean LOCAL_DEBUG = false;
    private InputStream mIn;
    private OutputStream mOut;
    private LocalSocket mSocket;
    private volatile Object mWarnIfHeld;
    private final byte[] buf = new byte[1024];

    public void setWarnIfHeld(Object warnIfHeld) {
        Preconditions.checkState(this.mWarnIfHeld == null);
        this.mWarnIfHeld = Preconditions.checkNotNull(warnIfHeld);
    }

    public synchronized String transact(String cmd) {
        int replyLength;
        if (this.mWarnIfHeld != null && Thread.holdsLock(this.mWarnIfHeld)) {
            Slog.wtf(TAG, "Calling thread " + Thread.currentThread().getName() + " is holding 0x" + Integer.toHexString(System.identityHashCode(this.mWarnIfHeld)), new Throwable());
        }
        if (!this.connect()) {
            Slog.e(TAG, "connection failed");
            return "-1";
        }
        if (!this.writeCommand(cmd)) {
            Slog.e(TAG, "write command failed? reconnect!");
            if (!this.connect() || !this.writeCommand(cmd)) {
                return "-1";
            }
        }
        if ((replyLength = this.readReply()) > 0) {
            String s = new String(this.buf, 0, replyLength);
            return s;
        }
        return "-1";
    }

    public String[] execute(String cmd, Object ... args) throws InstallerException {
        StringBuilder builder = new StringBuilder(cmd);
        for (Object arg : args) {
            String escaped = arg == null ? "" : String.valueOf(arg);
            if (escaped.indexOf(0) != -1 || escaped.indexOf(32) != -1 || "!".equals(escaped)) {
                throw new InstallerException("Invalid argument while executing " + cmd + " " + Arrays.toString(args));
            }
            if (TextUtils.isEmpty(escaped)) {
                escaped = "!";
            }
            builder.append(' ').append(escaped);
        }
        String[] resRaw = this.transact(builder.toString()).split(" ");
        int res = -1;
        try {
            res = Integer.parseInt(resRaw[0]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            // empty catch block
        }
        if (res != 0) {
            throw new InstallerException("Failed to execute " + cmd + " " + Arrays.toString(args) + ": " + res);
        }
        return resRaw;
    }

    public void dexopt(String apkPath, int uid, String instructionSet, int dexoptNeeded, int dexFlags, String compilerFilter, String volumeUuid, String sharedLibraries) throws InstallerException {
        this.dexopt(apkPath, uid, "*", instructionSet, dexoptNeeded, null, dexFlags, compilerFilter, volumeUuid, sharedLibraries);
    }

    public void dexopt(String apkPath, int uid, String pkgName, String instructionSet, int dexoptNeeded, String outputPath, int dexFlags, String compilerFilter, String volumeUuid, String sharedLibraries) throws InstallerException {
        this.execute("dexopt", apkPath, uid, pkgName, instructionSet, dexoptNeeded, outputPath, dexFlags, compilerFilter, volumeUuid, sharedLibraries);
    }

    private boolean safeParseBooleanResult(String[] res) throws InstallerException {
        if (res == null || res.length != 2) {
            throw new InstallerException("Invalid size result: " + Arrays.toString(res));
        }
        if (!res[1].equals("true") && !res[1].equals("false")) {
            throw new InstallerException("Invalid boolean result: " + Arrays.toString(res));
        }
        return Boolean.parseBoolean(res[1]);
    }

    public boolean mergeProfiles(int uid, String pkgName) throws InstallerException {
        String[] res = this.execute("merge_profiles", uid, pkgName);
        return this.safeParseBooleanResult(res);
    }

    public boolean dumpProfiles(String gid, String packageName, String codePaths) throws InstallerException {
        String[] res = this.execute("dump_profiles", gid, packageName, codePaths);
        return this.safeParseBooleanResult(res);
    }

    private boolean connect() {
        if (this.mSocket != null) {
            return true;
        }
        Slog.i(TAG, "connecting...");
        try {
            this.mSocket = new LocalSocket();
            LocalSocketAddress address = new LocalSocketAddress("installd", LocalSocketAddress.Namespace.RESERVED);
            this.mSocket.connect(address);
            this.mIn = this.mSocket.getInputStream();
            this.mOut = this.mSocket.getOutputStream();
        }
        catch (IOException ex) {
            this.disconnect();
            return false;
        }
        return true;
    }

    public void disconnect() {
        Slog.i(TAG, "disconnecting...");
        IoUtils.closeQuietly(this.mSocket);
        IoUtils.closeQuietly(this.mIn);
        IoUtils.closeQuietly(this.mOut);
        this.mSocket = null;
        this.mIn = null;
        this.mOut = null;
    }

    private boolean readFully(byte[] buffer, int len) {
        try {
            Streams.readFully(this.mIn, buffer, 0, len);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "read exception");
            this.disconnect();
            return false;
        }
        return true;
    }

    private int readReply() {
        if (!this.readFully(this.buf, 2)) {
            return -1;
        }
        int len = this.buf[0] & 0xFF | (this.buf[1] & 0xFF) << 8;
        if (len < 1 || len > this.buf.length) {
            Slog.e(TAG, "invalid reply length (" + len + ")");
            this.disconnect();
            return -1;
        }
        if (!this.readFully(this.buf, len)) {
            return -1;
        }
        return len;
    }

    private boolean writeCommand(String cmdString) {
        byte[] cmd = cmdString.getBytes();
        int len = cmd.length;
        if (len < 1 || len > this.buf.length) {
            return false;
        }
        this.buf[0] = (byte)(len & 0xFF);
        this.buf[1] = (byte)(len >> 8 & 0xFF);
        try {
            this.mOut.write(this.buf, 0, 2);
            this.mOut.write(cmd, 0, len);
        }
        catch (IOException ex) {
            Slog.e(TAG, "write error");
            this.disconnect();
            return false;
        }
        return true;
    }

    public void waitForConnection() {
        while (true) {
            try {
                this.execute("ping", new Object[0]);
                return;
            }
            catch (InstallerException installerException) {
                Slog.w(TAG, "installd not ready");
                SystemClock.sleep(1000L);
                continue;
            }
            break;
        }
    }

    public static class InstallerException
    extends Exception {
        public InstallerException(String detailMessage) {
            super(detailMessage);
        }
    }
}

