/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import com.android.internal.util.ArrayUtils;
import java.util.HashMap;
import java.util.Map;

public class CarrierSignalAgent {
    private static final String LOG_TAG = "CarrierSignalAgent";
    private static final boolean DBG = true;
    private final Phone mPhone;
    private final HashMap<String, String[]> mCachedCarrierSignalReceiverNames = new HashMap();
    private final Map<String, String> mIntentToCarrierConfigKeyMap = new HashMap<String, String>(){
        {
            this.put("android.intent.action.CARRIER_SIGNAL_REDIRECTED", "signal_redirection_receiver_string_array");
            this.put("android.intent.action.CARRIER_SIGNAL_PCO_VALUE", "signal_pco_receiver_string_array");
            this.put("android.intent.action.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED", "signal_dcfailure_receiver_string_array");
        }
    };

    public CarrierSignalAgent(Phone phone) {
        this.mPhone = phone;
    }

    private String[] getCarrierSignalReceiverName(String intentAction) {
        String receiverType = this.mIntentToCarrierConfigKeyMap.get(intentAction);
        if (receiverType == null) {
            return null;
        }
        String[] receiverNames = this.mCachedCarrierSignalReceiverNames.get(intentAction);
        if (!this.mCachedCarrierSignalReceiverNames.containsKey(intentAction)) {
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            PersistableBundle b = null;
            if (configManager != null) {
                b = configManager.getConfig();
            }
            if (b != null && (receiverNames = b.getStringArray(receiverType)) != null) {
                for (String name : receiverNames) {
                    Rlog.d("loadCarrierSignalReceiverNames: ", name);
                }
            }
            this.mCachedCarrierSignalReceiverNames.put(intentAction, receiverNames);
        }
        return receiverNames;
    }

    public boolean hasRegisteredCarrierSignalReceivers() {
        for (String intent : this.mIntentToCarrierConfigKeyMap.keySet()) {
            if (ArrayUtils.isEmpty(this.getCarrierSignalReceiverName(intent))) continue;
            return true;
        }
        return false;
    }

    public boolean notifyCarrierSignalReceivers(Intent intent) {
        String[] receiverName = this.getCarrierSignalReceiverName(intent.getAction());
        if (receiverName == null) {
            this.loge("Carrier receiver name is null");
            return false;
        }
        PackageManager packageManager = this.mPhone.getContext().getPackageManager();
        boolean ret = false;
        for (String name : receiverName) {
            ComponentName componentName = ComponentName.unflattenFromString(name);
            if (componentName == null) {
                this.loge("Carrier receiver name could not be parsed");
                return false;
            }
            intent.setComponent(componentName);
            if (packageManager.queryBroadcastReceivers(intent, 65536).isEmpty()) {
                this.loge("Carrier signal receiver is configured, but not available: " + name);
                break;
            }
            intent.putExtra("subscription", this.mPhone.getSubId());
            intent.addFlags(0x10000000);
            try {
                this.mPhone.getContext().sendBroadcast(intent);
                this.log("send Intent to carrier signal receiver with action: " + intent.getAction());
                ret = true;
            }
            catch (ActivityNotFoundException e) {
                this.loge("sendBroadcast failed: " + e);
            }
        }
        return ret;
    }

    public void reset() {
        this.mCachedCarrierSignalReceiverNames.clear();
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void loge(String s) {
        Rlog.e(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }
}

