/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.telephony.RadioAccessFamily;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneSubInfoController;
import com.android.internal.telephony.PhoneSwitcher;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.UiccPhoneBookController;
import com.android.internal.telephony.UiccSmsController;
import com.android.internal.telephony.uicc.UiccController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class ProxyController {
    static final String LOG_TAG = "ProxyController";
    private static final int EVENT_NOTIFICATION_RC_CHANGED = 1;
    private static final int EVENT_START_RC_RESPONSE = 2;
    private static final int EVENT_APPLY_RC_RESPONSE = 3;
    private static final int EVENT_FINISH_RC_RESPONSE = 4;
    private static final int EVENT_TIMEOUT = 5;
    private static final int SET_RC_STATUS_IDLE = 0;
    private static final int SET_RC_STATUS_STARTING = 1;
    private static final int SET_RC_STATUS_STARTED = 2;
    private static final int SET_RC_STATUS_APPLYING = 3;
    private static final int SET_RC_STATUS_SUCCESS = 4;
    private static final int SET_RC_STATUS_FAIL = 5;
    private static final int SET_RC_TIMEOUT_WAITING_MSEC = 45000;
    private static ProxyController sProxyController;
    private Phone[] mPhones;
    private UiccController mUiccController;
    private CommandsInterface[] mCi;
    private Context mContext;
    private PhoneSwitcher mPhoneSwitcher;
    private UiccPhoneBookController mUiccPhoneBookController;
    private PhoneSubInfoController mPhoneSubInfoController;
    private UiccSmsController mUiccSmsController;
    PowerManager.WakeLock mWakeLock;
    private int[] mSetRadioAccessFamilyStatus;
    private int mRadioAccessFamilyStatusCounter;
    private boolean mTransactionFailed = false;
    private String[] mCurrentLogicalModemIds;
    private String[] mNewLogicalModemIds;
    private AtomicInteger mUniqueIdGenerator = new AtomicInteger(new Random().nextInt());
    private int mRadioCapabilitySessionId;
    private int[] mNewRadioAccessFamily;
    private int[] mOldRadioAccessFamily;
    private Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            ProxyController.this.logd("handleMessage msg.what=" + msg.what);
            switch (msg.what) {
                case 2: {
                    ProxyController.this.onStartRadioCapabilityResponse(msg);
                    break;
                }
                case 3: {
                    ProxyController.this.onApplyRadioCapabilityResponse(msg);
                    break;
                }
                case 1: {
                    ProxyController.this.onNotificationRadioCapabilityChanged(msg);
                    break;
                }
                case 4: {
                    ProxyController.this.onFinishRadioCapabilityResponse(msg);
                    break;
                }
                case 5: {
                    ProxyController.this.onTimeoutRadioCapability(msg);
                    break;
                }
            }
        }
    };

    public static ProxyController getInstance(Context context, Phone[] phone, UiccController uiccController, CommandsInterface[] ci, PhoneSwitcher ps) {
        if (sProxyController == null) {
            sProxyController = new ProxyController(context, phone, uiccController, ci, ps);
        }
        return sProxyController;
    }

    public static ProxyController getInstance() {
        return sProxyController;
    }

    private ProxyController(Context context, Phone[] phone, UiccController uiccController, CommandsInterface[] ci, PhoneSwitcher phoneSwitcher) {
        this.logd("Constructor - Enter");
        this.mContext = context;
        this.mPhones = phone;
        this.mUiccController = uiccController;
        this.mCi = ci;
        this.mPhoneSwitcher = phoneSwitcher;
        this.mUiccPhoneBookController = new UiccPhoneBookController(this.mPhones);
        this.mPhoneSubInfoController = new PhoneSubInfoController(this.mContext, this.mPhones);
        this.mUiccSmsController = new UiccSmsController(this.mPhones);
        this.mSetRadioAccessFamilyStatus = new int[this.mPhones.length];
        this.mNewRadioAccessFamily = new int[this.mPhones.length];
        this.mOldRadioAccessFamily = new int[this.mPhones.length];
        this.mCurrentLogicalModemIds = new String[this.mPhones.length];
        this.mNewLogicalModemIds = new String[this.mPhones.length];
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, LOG_TAG);
        this.mWakeLock.setReferenceCounted(false);
        this.clearTransaction();
        for (int i = 0; i < this.mPhones.length; ++i) {
            this.mPhones[i].registerForRadioCapabilityChanged(this.mHandler, 1, null);
        }
        this.logd("Constructor - Exit");
    }

    public void updateDataConnectionTracker(int sub) {
        this.mPhones[sub].updateDataConnectionTracker();
    }

    public void enableDataConnectivity(int sub) {
        this.mPhones[sub].setInternalDataEnabled(true, null);
    }

    public void disableDataConnectivity(int sub, Message dataCleanedUpMsg) {
        this.mPhones[sub].setInternalDataEnabled(false, dataCleanedUpMsg);
    }

    public void updateCurrentCarrierInProvider(int sub) {
        this.mPhones[sub].updateCurrentCarrierInProvider();
    }

    public void registerForAllDataDisconnected(int subId, Handler h, int what, Object obj) {
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount()) {
            this.mPhones[phoneId].registerForAllDataDisconnected(h, what, obj);
        }
    }

    public void unregisterForAllDataDisconnected(int subId, Handler h) {
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount()) {
            this.mPhones[phoneId].unregisterForAllDataDisconnected(h);
        }
    }

    public boolean isDataDisconnected(int subId) {
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        if (phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount()) {
            return this.mPhones[phoneId].mDcTracker.isDisconnected();
        }
        return true;
    }

    public int getRadioAccessFamily(int phoneId) {
        if (phoneId >= this.mPhones.length) {
            return 1;
        }
        return this.mPhones[phoneId].getRadioAccessFamily();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRadioCapability(RadioAccessFamily[] rafs) {
        if (rafs.length != this.mPhones.length) {
            throw new RuntimeException("Length of input rafs must equal to total phone count");
        }
        int[] nArray = this.mSetRadioAccessFamilyStatus;
        synchronized (this.mSetRadioAccessFamilyStatus) {
            int i;
            for (i = 0; i < this.mPhones.length; ++i) {
                if (this.mSetRadioAccessFamilyStatus[i] == 0) continue;
                this.loge("setRadioCapability: Phone[" + i + "] is not idle. Rejecting request.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            boolean same = true;
            for (i = 0; i < this.mPhones.length; ++i) {
                if (this.mPhones[i].getRadioAccessFamily() == rafs[i].getRadioAccessFamily()) continue;
                same = false;
            }
            if (same) {
                this.logd("setRadioCapability: Already in requested configuration, nothing to do.");
                return true;
            }
            this.clearTransaction();
            this.mWakeLock.acquire();
            return this.doSetRadioCapabilities(rafs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSetRadioCapabilities(RadioAccessFamily[] rafs) {
        this.mRadioCapabilitySessionId = this.mUniqueIdGenerator.getAndIncrement();
        Message msg = this.mHandler.obtainMessage(5, this.mRadioCapabilitySessionId, 0);
        this.mHandler.sendMessageDelayed(msg, 45000L);
        int[] nArray = this.mSetRadioAccessFamilyStatus;
        synchronized (this.mSetRadioAccessFamilyStatus) {
            this.logd("setRadioCapability: new request session id=" + this.mRadioCapabilitySessionId);
            this.resetRadioAccessFamilyStatusCounter();
            for (int i = 0; i < rafs.length; ++i) {
                int requestedRaf;
                int phoneId = rafs[i].getPhoneId();
                this.logd("setRadioCapability: phoneId=" + phoneId + " status=STARTING");
                this.mSetRadioAccessFamilyStatus[phoneId] = 1;
                this.mOldRadioAccessFamily[phoneId] = this.mPhones[phoneId].getRadioAccessFamily();
                this.mNewRadioAccessFamily[phoneId] = requestedRaf = rafs[i].getRadioAccessFamily();
                this.mCurrentLogicalModemIds[phoneId] = this.mPhones[phoneId].getModemUuId();
                this.mNewLogicalModemIds[phoneId] = this.getLogicalModemIdFromRaf(requestedRaf);
                this.logd("setRadioCapability: mOldRadioAccessFamily[" + phoneId + "]=" + this.mOldRadioAccessFamily[phoneId]);
                this.logd("setRadioCapability: mNewRadioAccessFamily[" + phoneId + "]=" + this.mNewRadioAccessFamily[phoneId]);
                this.sendRadioCapabilityRequest(phoneId, this.mRadioCapabilitySessionId, 1, this.mOldRadioAccessFamily[phoneId], this.mCurrentLogicalModemIds[phoneId], 0, 2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartRadioCapabilityResponse(Message msg) {
        int[] nArray = this.mSetRadioAccessFamilyStatus;
        synchronized (this.mSetRadioAccessFamilyStatus) {
            AsyncResult ar = (AsyncResult)msg.obj;
            if (ar.exception != null) {
                this.logd("onStartRadioCapabilityResponse got exception=" + ar.exception);
                this.mRadioCapabilitySessionId = this.mUniqueIdGenerator.getAndIncrement();
                Intent intent = new Intent("android.intent.action.ACTION_SET_RADIO_CAPABILITY_FAILED");
                this.mContext.sendBroadcast(intent);
                this.clearTransaction();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            RadioCapability rc = (RadioCapability)((AsyncResult)msg.obj).result;
            if (rc == null || rc.getSession() != this.mRadioCapabilitySessionId) {
                this.logd("onStartRadioCapabilityResponse: Ignore session=" + this.mRadioCapabilitySessionId + " rc=" + rc);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            --this.mRadioAccessFamilyStatusCounter;
            int id2 = rc.getPhoneId();
            if (((AsyncResult)msg.obj).exception != null) {
                this.logd("onStartRadioCapabilityResponse: Error response session=" + rc.getSession());
                this.logd("onStartRadioCapabilityResponse: phoneId=" + id2 + " status=FAIL");
                this.mSetRadioAccessFamilyStatus[id2] = 5;
                this.mTransactionFailed = true;
            } else {
                this.logd("onStartRadioCapabilityResponse: phoneId=" + id2 + " status=STARTED");
                this.mSetRadioAccessFamilyStatus[id2] = 2;
            }
            if (this.mRadioAccessFamilyStatusCounter == 0) {
                HashSet<String> modemsInUse = new HashSet<String>(this.mNewLogicalModemIds.length);
                for (String modemId : this.mNewLogicalModemIds) {
                    if (modemsInUse.add(modemId)) continue;
                    this.mTransactionFailed = true;
                    Log.wtf(LOG_TAG, "ERROR: sending down the same id for different phones");
                }
                this.logd("onStartRadioCapabilityResponse: success=" + !this.mTransactionFailed);
                if (this.mTransactionFailed) {
                    this.issueFinish(this.mRadioCapabilitySessionId);
                } else {
                    this.resetRadioAccessFamilyStatusCounter();
                    for (int i = 0; i < this.mPhones.length; ++i) {
                        this.sendRadioCapabilityRequest(i, this.mRadioCapabilitySessionId, 2, this.mNewRadioAccessFamily[i], this.mNewLogicalModemIds[i], 0, 3);
                        this.logd("onStartRadioCapabilityResponse: phoneId=" + i + " status=APPLYING");
                        this.mSetRadioAccessFamilyStatus[i] = 3;
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onApplyRadioCapabilityResponse(Message msg) {
        RadioCapability rc = (RadioCapability)((AsyncResult)msg.obj).result;
        if (rc == null || rc.getSession() != this.mRadioCapabilitySessionId) {
            this.logd("onApplyRadioCapabilityResponse: Ignore session=" + this.mRadioCapabilitySessionId + " rc=" + rc);
            return;
        }
        this.logd("onApplyRadioCapabilityResponse: rc=" + rc);
        if (((AsyncResult)msg.obj).exception != null) {
            int[] nArray = this.mSetRadioAccessFamilyStatus;
            synchronized (this.mSetRadioAccessFamilyStatus) {
                this.logd("onApplyRadioCapabilityResponse: Error response session=" + rc.getSession());
                int id2 = rc.getPhoneId();
                this.logd("onApplyRadioCapabilityResponse: phoneId=" + id2 + " status=FAIL");
                this.mSetRadioAccessFamilyStatus[id2] = 5;
                this.mTransactionFailed = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            this.logd("onApplyRadioCapabilityResponse: Valid start expecting notification rc=" + rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNotificationRadioCapabilityChanged(Message msg) {
        RadioCapability rc = (RadioCapability)((AsyncResult)msg.obj).result;
        if (rc == null || rc.getSession() != this.mRadioCapabilitySessionId) {
            this.logd("onNotificationRadioCapabilityChanged: Ignore session=" + this.mRadioCapabilitySessionId + " rc=" + rc);
            return;
        }
        int[] nArray = this.mSetRadioAccessFamilyStatus;
        synchronized (this.mSetRadioAccessFamilyStatus) {
            this.logd("onNotificationRadioCapabilityChanged: rc=" + rc);
            if (rc.getSession() != this.mRadioCapabilitySessionId) {
                this.logd("onNotificationRadioCapabilityChanged: Ignore session=" + this.mRadioCapabilitySessionId + " rc=" + rc);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            int id2 = rc.getPhoneId();
            if (((AsyncResult)msg.obj).exception != null || rc.getStatus() == 2) {
                this.logd("onNotificationRadioCapabilityChanged: phoneId=" + id2 + " status=FAIL");
                this.mSetRadioAccessFamilyStatus[id2] = 5;
                this.mTransactionFailed = true;
            } else {
                this.logd("onNotificationRadioCapabilityChanged: phoneId=" + id2 + " status=SUCCESS");
                this.mSetRadioAccessFamilyStatus[id2] = 4;
                this.mPhoneSwitcher.resendDataAllowed(id2);
                this.mPhones[id2].radioCapabilityUpdated(rc);
            }
            --this.mRadioAccessFamilyStatusCounter;
            if (this.mRadioAccessFamilyStatusCounter == 0) {
                this.logd("onNotificationRadioCapabilityChanged: APPLY URC success=" + this.mTransactionFailed);
                this.issueFinish(this.mRadioCapabilitySessionId);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFinishRadioCapabilityResponse(Message msg) {
        RadioCapability rc = (RadioCapability)((AsyncResult)msg.obj).result;
        if (rc == null || rc.getSession() != this.mRadioCapabilitySessionId) {
            this.logd("onFinishRadioCapabilityResponse: Ignore session=" + this.mRadioCapabilitySessionId + " rc=" + rc);
            return;
        }
        int[] nArray = this.mSetRadioAccessFamilyStatus;
        synchronized (this.mSetRadioAccessFamilyStatus) {
            this.logd(" onFinishRadioCapabilityResponse mRadioAccessFamilyStatusCounter=" + this.mRadioAccessFamilyStatusCounter);
            --this.mRadioAccessFamilyStatusCounter;
            if (this.mRadioAccessFamilyStatusCounter == 0) {
                this.completeRadioCapabilityTransaction();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTimeoutRadioCapability(Message msg) {
        if (msg.arg1 != this.mRadioCapabilitySessionId) {
            this.logd("RadioCapability timeout: Ignore msg.arg1=" + msg.arg1 + "!= mRadioCapabilitySessionId=" + this.mRadioCapabilitySessionId);
            return;
        }
        int[] nArray = this.mSetRadioAccessFamilyStatus;
        synchronized (this.mSetRadioAccessFamilyStatus) {
            for (int i = 0; i < this.mPhones.length; ++i) {
                this.logd("RadioCapability timeout: mSetRadioAccessFamilyStatus[" + i + "]=" + this.mSetRadioAccessFamilyStatus[i]);
            }
            int uniqueDifferentId = this.mUniqueIdGenerator.getAndIncrement();
            this.mTransactionFailed = true;
            this.issueFinish(uniqueDifferentId);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void issueFinish(int sessionId) {
        int[] nArray = this.mSetRadioAccessFamilyStatus;
        synchronized (this.mSetRadioAccessFamilyStatus) {
            for (int i = 0; i < this.mPhones.length; ++i) {
                this.logd("issueFinish: phoneId=" + i + " sessionId=" + sessionId + " mTransactionFailed=" + this.mTransactionFailed);
                ++this.mRadioAccessFamilyStatusCounter;
                this.sendRadioCapabilityRequest(i, sessionId, 4, this.mOldRadioAccessFamily[i], this.mCurrentLogicalModemIds[i], this.mTransactionFailed ? 2 : 1, 4);
                if (!this.mTransactionFailed) continue;
                this.logd("issueFinish: phoneId: " + i + " status: FAIL");
                this.mSetRadioAccessFamilyStatus[i] = 5;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void completeRadioCapabilityTransaction() {
        Intent intent;
        this.logd("onFinishRadioCapabilityResponse: success=" + !this.mTransactionFailed);
        if (!this.mTransactionFailed) {
            ArrayList<RadioAccessFamily> phoneRAFList = new ArrayList<RadioAccessFamily>();
            for (int i = 0; i < this.mPhones.length; ++i) {
                int raf = this.mPhones[i].getRadioAccessFamily();
                this.logd("radioAccessFamily[" + i + "]=" + raf);
                RadioAccessFamily phoneRC = new RadioAccessFamily(i, raf);
                phoneRAFList.add(phoneRC);
            }
            intent = new Intent("android.intent.action.ACTION_SET_RADIO_CAPABILITY_DONE");
            intent.putParcelableArrayListExtra("rafs", phoneRAFList);
            this.mRadioCapabilitySessionId = this.mUniqueIdGenerator.getAndIncrement();
            this.clearTransaction();
        } else {
            intent = new Intent("android.intent.action.ACTION_SET_RADIO_CAPABILITY_FAILED");
            this.mTransactionFailed = false;
            RadioAccessFamily[] rafs = new RadioAccessFamily[this.mPhones.length];
            for (int phoneId = 0; phoneId < this.mPhones.length; ++phoneId) {
                rafs[phoneId] = new RadioAccessFamily(phoneId, this.mOldRadioAccessFamily[phoneId]);
            }
            this.doSetRadioCapabilities(rafs);
        }
        this.mContext.sendBroadcast(intent, "android.permission.READ_PHONE_STATE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTransaction() {
        this.logd("clearTransaction");
        int[] nArray = this.mSetRadioAccessFamilyStatus;
        synchronized (this.mSetRadioAccessFamilyStatus) {
            for (int i = 0; i < this.mPhones.length; ++i) {
                this.logd("clearTransaction: phoneId=" + i + " status=IDLE");
                this.mSetRadioAccessFamilyStatus[i] = 0;
                this.mOldRadioAccessFamily[i] = 0;
                this.mNewRadioAccessFamily[i] = 0;
                this.mTransactionFailed = false;
            }
            if (this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void resetRadioAccessFamilyStatusCounter() {
        this.mRadioAccessFamilyStatusCounter = this.mPhones.length;
    }

    private void sendRadioCapabilityRequest(int phoneId, int sessionId, int rcPhase, int radioFamily, String logicalModemId, int status, int eventId) {
        RadioCapability requestRC = new RadioCapability(phoneId, sessionId, rcPhase, radioFamily, logicalModemId, status);
        this.mPhones[phoneId].setRadioCapability(requestRC, this.mHandler.obtainMessage(eventId));
    }

    public int getMaxRafSupported() {
        int[] numRafSupported = new int[this.mPhones.length];
        int maxNumRafBit = 0;
        int maxRaf = 1;
        for (int len = 0; len < this.mPhones.length; ++len) {
            numRafSupported[len] = Integer.bitCount(this.mPhones[len].getRadioAccessFamily());
            if (maxNumRafBit >= numRafSupported[len]) continue;
            maxNumRafBit = numRafSupported[len];
            maxRaf = this.mPhones[len].getRadioAccessFamily();
        }
        return maxRaf;
    }

    public int getMinRafSupported() {
        int[] numRafSupported = new int[this.mPhones.length];
        int minNumRafBit = 0;
        int minRaf = 1;
        for (int len = 0; len < this.mPhones.length; ++len) {
            numRafSupported[len] = Integer.bitCount(this.mPhones[len].getRadioAccessFamily());
            if (minNumRafBit != 0 && minNumRafBit <= numRafSupported[len]) continue;
            minNumRafBit = numRafSupported[len];
            minRaf = this.mPhones[len].getRadioAccessFamily();
        }
        return minRaf;
    }

    private String getLogicalModemIdFromRaf(int raf) {
        String modemUuid = null;
        for (int phoneId = 0; phoneId < this.mPhones.length; ++phoneId) {
            if (this.mPhones[phoneId].getRadioAccessFamily() != raf) continue;
            modemUuid = this.mPhones[phoneId].getModemUuId();
            break;
        }
        return modemUuid;
    }

    private void logd(String string2) {
        Rlog.d(LOG_TAG, string2);
    }

    private void loge(String string2) {
        Rlog.e(LOG_TAG, string2);
    }
}

