/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Binder;
import android.os.Process;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import com.android.internal.content.PackageMonitor;
import com.android.internal.logging.MetricsLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public final class SmsApplication {
    static final String LOG_TAG = "SmsApplication";
    private static final String PHONE_PACKAGE_NAME = "com.android.phone";
    private static final String BLUETOOTH_PACKAGE_NAME = "com.android.bluetooth";
    private static final String MMS_SERVICE_PACKAGE_NAME = "com.android.mms.service";
    private static final String TELEPHONY_PROVIDER_PACKAGE_NAME = "com.android.providers.telephony";
    private static final String SCHEME_SMS = "sms";
    private static final String SCHEME_SMSTO = "smsto";
    private static final String SCHEME_MMS = "mms";
    private static final String SCHEME_MMSTO = "mmsto";
    private static final boolean DEBUG_MULTIUSER = false;
    private static SmsPackageMonitor sSmsPackageMonitor = null;

    private static int getIncomingUserId(Context context) {
        int contextUserId = context.getUserId();
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) < 10000) {
            return contextUserId;
        }
        return UserHandle.getUserId(callingUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<SmsApplicationData> getApplicationCollection(Context context) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            Collection<SmsApplicationData> collection = SmsApplication.getApplicationCollectionInternal(context, userId);
            return collection;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static Collection<SmsApplicationData> getApplicationCollectionInternal(Context context, int userId) {
        String packageName;
        SmsApplicationData smsApplicationData;
        ActivityInfo activityInfo;
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.provider.Telephony.SMS_DELIVER");
        List<ResolveInfo> smsReceivers = packageManager.queryBroadcastReceiversAsUser(intent, 0, userId);
        HashMap<String, SmsApplicationData> receivers = new HashMap<String, SmsApplicationData>();
        for (ResolveInfo resolveInfo : smsReceivers) {
            String string2;
            ActivityInfo activityInfo2 = resolveInfo.activityInfo;
            if (activityInfo2 == null || !"android.permission.BROADCAST_SMS".equals(activityInfo2.permission) || receivers.containsKey(string2 = activityInfo2.packageName)) continue;
            SmsApplicationData smsApplicationData2 = new SmsApplicationData(string2, activityInfo2.applicationInfo.uid);
            smsApplicationData2.mSmsReceiverClass = activityInfo2.name;
            receivers.put(string2, smsApplicationData2);
        }
        intent = new Intent("android.provider.Telephony.WAP_PUSH_DELIVER");
        intent.setDataAndType(null, "application/vnd.wap.mms-message");
        List<ResolveInfo> mmsReceivers = packageManager.queryBroadcastReceiversAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : mmsReceivers) {
            String string3;
            SmsApplicationData smsApplicationData3;
            ActivityInfo activityInfo3 = resolveInfo.activityInfo;
            if (activityInfo3 == null || !"android.permission.BROADCAST_WAP_PUSH".equals(activityInfo3.permission) || (smsApplicationData3 = (SmsApplicationData)receivers.get(string3 = activityInfo3.packageName)) == null) continue;
            smsApplicationData3.mMmsReceiverClass = activityInfo3.name;
        }
        intent = new Intent("android.intent.action.RESPOND_VIA_MESSAGE", Uri.fromParts(SCHEME_SMSTO, "", null));
        List<ResolveInfo> list = packageManager.queryIntentServicesAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : list) {
            String packageName4;
            SmsApplicationData smsApplicationData4;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null || !"android.permission.SEND_RESPOND_VIA_MESSAGE".equals(serviceInfo.permission) || (smsApplicationData4 = (SmsApplicationData)receivers.get(packageName4 = serviceInfo.packageName)) == null) continue;
            smsApplicationData4.mRespondViaMessageClass = serviceInfo.name;
        }
        intent = new Intent("android.intent.action.SENDTO", Uri.fromParts(SCHEME_SMSTO, "", null));
        List<ResolveInfo> list2 = packageManager.queryIntentActivitiesAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : list2) {
            String packageName5;
            SmsApplicationData smsApplicationData5;
            ActivityInfo activityInfo4 = resolveInfo.activityInfo;
            if (activityInfo4 == null || (smsApplicationData5 = (SmsApplicationData)receivers.get(packageName5 = activityInfo4.packageName)) == null) continue;
            smsApplicationData5.mSendToClass = activityInfo4.name;
        }
        intent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED");
        List<ResolveInfo> list3 = packageManager.queryBroadcastReceiversAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : list3) {
            String packageName6;
            SmsApplicationData smsApplicationData6;
            ActivityInfo activityInfo5 = resolveInfo.activityInfo;
            if (activityInfo5 == null || (smsApplicationData6 = (SmsApplicationData)receivers.get(packageName6 = activityInfo5.packageName)) == null) continue;
            smsApplicationData6.mSmsAppChangedReceiverClass = activityInfo5.name;
        }
        intent = new Intent("android.provider.action.EXTERNAL_PROVIDER_CHANGE");
        List<ResolveInfo> list4 = packageManager.queryBroadcastReceiversAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : list4) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null) continue;
            smsApplicationData.mProviderChangedReceiverClass = activityInfo.name;
        }
        for (ResolveInfo resolveInfo : smsReceivers) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null || smsApplicationData.isComplete()) continue;
            receivers.remove(packageName);
        }
        return receivers.values();
    }

    private static SmsApplicationData getApplicationForPackage(Collection<SmsApplicationData> applications, String packageName) {
        if (packageName == null) {
            return null;
        }
        for (SmsApplicationData application : applications) {
            if (!application.mPackageName.contentEquals(packageName)) continue;
            return application;
        }
        return null;
    }

    private static SmsApplicationData getApplication(Context context, boolean updateIfNeeded, int userId) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (!tm.isSmsCapable()) {
            return null;
        }
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollectionInternal(context, userId);
        String defaultApplication = Settings.Secure.getStringForUser(context.getContentResolver(), "sms_default_application", userId);
        SmsApplicationData applicationData = null;
        if (defaultApplication != null) {
            applicationData = SmsApplication.getApplicationForPackage(applications, defaultApplication);
        }
        if (updateIfNeeded && applicationData == null) {
            Resources r = context.getResources();
            String defaultPackage = r.getString(17039430);
            applicationData = SmsApplication.getApplicationForPackage(applications, defaultPackage);
            if (applicationData == null && applications.size() != 0) {
                applicationData = (SmsApplicationData)applications.toArray()[0];
            }
            if (applicationData != null) {
                SmsApplication.setDefaultApplicationInternal(applicationData.mPackageName, context, userId);
            }
        }
        if (applicationData != null) {
            int mode;
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            if ((updateIfNeeded || applicationData.mUid == Process.myUid()) && (mode = appOps.checkOp(15, applicationData.mUid, applicationData.mPackageName)) != 0) {
                Rlog.e(LOG_TAG, applicationData.mPackageName + " lost OP_WRITE_SMS: " + (updateIfNeeded ? " (fixing)" : " (no permission to fix)"));
                if (updateIfNeeded) {
                    appOps.setMode(15, applicationData.mUid, applicationData.mPackageName, 0);
                } else {
                    applicationData = null;
                }
            }
            if (updateIfNeeded) {
                PackageManager packageManager = context.getPackageManager();
                SmsApplication.configurePreferredActivity(packageManager, new ComponentName(applicationData.mPackageName, applicationData.mSendToClass), userId);
                SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, PHONE_PACKAGE_NAME);
                SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, BLUETOOTH_PACKAGE_NAME);
                SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, MMS_SERVICE_PACKAGE_NAME);
                SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, TELEPHONY_PROVIDER_PACKAGE_NAME);
                SmsApplication.assignWriteSmsPermissionToSystemUid(appOps, 1001);
            }
        }
        return applicationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultApplication(String packageName, Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (!tm.isSmsCapable()) {
            return;
        }
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            SmsApplication.setDefaultApplicationInternal(packageName, context, userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static void setDefaultApplicationInternal(String packageName, Context context, int userId) {
        String oldPackageName = Settings.Secure.getStringForUser(context.getContentResolver(), "sms_default_application", userId);
        if (packageName != null && oldPackageName != null && packageName.equals(oldPackageName)) {
            return;
        }
        PackageManager packageManager = context.getPackageManager();
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        SmsApplicationData oldAppData = oldPackageName != null ? SmsApplication.getApplicationForPackage(applications, oldPackageName) : null;
        SmsApplicationData applicationData = SmsApplication.getApplicationForPackage(applications, packageName);
        if (applicationData != null) {
            ComponentName component;
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            if (oldPackageName != null) {
                try {
                    PackageInfo info = packageManager.getPackageInfo(oldPackageName, 8192);
                    appOps.setMode(15, info.applicationInfo.uid, oldPackageName, 1);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Rlog.w(LOG_TAG, "Old SMS package not found: " + oldPackageName);
                }
            }
            Settings.Secure.putStringForUser(context.getContentResolver(), "sms_default_application", applicationData.mPackageName, userId);
            SmsApplication.configurePreferredActivity(packageManager, new ComponentName(applicationData.mPackageName, applicationData.mSendToClass), userId);
            appOps.setMode(15, applicationData.mUid, applicationData.mPackageName, 0);
            SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, PHONE_PACKAGE_NAME);
            SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, BLUETOOTH_PACKAGE_NAME);
            SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, MMS_SERVICE_PACKAGE_NAME);
            SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, TELEPHONY_PROVIDER_PACKAGE_NAME);
            SmsApplication.assignWriteSmsPermissionToSystemUid(appOps, 1001);
            if (oldAppData != null && oldAppData.mSmsAppChangedReceiverClass != null) {
                Intent oldAppIntent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED");
                component = new ComponentName(oldAppData.mPackageName, oldAppData.mSmsAppChangedReceiverClass);
                oldAppIntent.setComponent(component);
                oldAppIntent.putExtra("android.provider.extra.IS_DEFAULT_SMS_APP", false);
                context.sendBroadcast(oldAppIntent);
            }
            if (applicationData.mSmsAppChangedReceiverClass != null) {
                Intent intent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED");
                component = new ComponentName(applicationData.mPackageName, applicationData.mSmsAppChangedReceiverClass);
                intent.setComponent(component);
                intent.putExtra("android.provider.extra.IS_DEFAULT_SMS_APP", true);
                context.sendBroadcast(intent);
            }
            MetricsLogger.action(context, 266, applicationData.mPackageName);
        }
    }

    private static void assignWriteSmsPermissionToSystemApp(Context context, PackageManager packageManager, AppOpsManager appOps, String packageName) {
        int result = packageManager.checkSignatures(context.getPackageName(), packageName);
        if (result != 0) {
            Rlog.e(LOG_TAG, packageName + " does not have system signature");
            return;
        }
        try {
            PackageInfo info = packageManager.getPackageInfo(packageName, 0);
            int mode = appOps.checkOp(15, info.applicationInfo.uid, packageName);
            if (mode != 0) {
                Rlog.w(LOG_TAG, packageName + " does not have OP_WRITE_SMS:  (fixing)");
                appOps.setMode(15, info.applicationInfo.uid, packageName, 0);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e(LOG_TAG, "Package not found: " + packageName);
        }
    }

    private static void assignWriteSmsPermissionToSystemUid(AppOpsManager appOps, int uid) {
        appOps.setUidMode(15, uid, 0);
    }

    public static void initSmsPackageMonitor(Context context) {
        sSmsPackageMonitor = new SmsPackageMonitor(context);
        sSmsPackageMonitor.register(context, context.getMainLooper(), UserHandle.ALL, false);
    }

    private static void configurePreferredActivity(PackageManager packageManager, ComponentName componentName, int userId) {
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, SCHEME_SMS);
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, SCHEME_SMSTO);
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, SCHEME_MMS);
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, SCHEME_MMSTO);
    }

    private static void replacePreferredActivity(PackageManager packageManager, ComponentName componentName, int userId, String scheme) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.fromParts(scheme, "", null));
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivitiesAsUser(intent, 65600, userId);
        int n = resolveInfoList.size();
        ComponentName[] set = new ComponentName[n];
        for (int i = 0; i < n; ++i) {
            ResolveInfo info = resolveInfoList.get(i);
            set[i] = new ComponentName(info.activityInfo.packageName, info.activityInfo.name);
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SENDTO");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        intentFilter.addDataScheme(scheme);
        packageManager.replacePreferredActivityAsUser(intentFilter, 0x208000, set, componentName, userId);
    }

    public static SmsApplicationData getSmsApplicationData(String packageName, Context context) {
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        return SmsApplication.getApplicationForPackage(applications, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultSmsApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSmsReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultMmsApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mMmsReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultRespondViaMessageApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mRespondViaMessageClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultSendToApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSendToClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName getDefaultExternalTelephonyProviderChangedApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null && smsApplicationData.mProviderChangedReceiverClass != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mProviderChangedReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public static boolean shouldWriteMessageForPackage(String packageName, Context context) {
        if (SmsManager.getDefault().getAutoPersisting()) {
            return true;
        }
        return !SmsApplication.isDefaultSmsApplication(context, packageName);
    }

    public static boolean isDefaultSmsApplication(Context context, String packageName) {
        if (packageName == null) {
            return false;
        }
        String defaultSmsPackage = SmsApplication.getDefaultSmsApplicationPackageName(context);
        return defaultSmsPackage != null && defaultSmsPackage.equals(packageName) || BLUETOOTH_PACKAGE_NAME.equals(packageName);
    }

    private static String getDefaultSmsApplicationPackageName(Context context) {
        ComponentName component = SmsApplication.getDefaultSmsApplication(context, false);
        if (component != null) {
            return component.getPackageName();
        }
        return null;
    }

    private static final class SmsPackageMonitor
    extends PackageMonitor {
        final Context mContext;

        public SmsPackageMonitor(Context context) {
            this.mContext = context;
        }

        @Override
        public void onPackageDisappeared(String packageName, int reason) {
            this.onPackageChanged();
        }

        @Override
        public void onPackageAppeared(String packageName, int reason) {
            this.onPackageChanged();
        }

        @Override
        public void onPackageModified(String packageName) {
            this.onPackageChanged();
        }

        private void onPackageChanged() {
            ComponentName componentName;
            PackageManager packageManager = this.mContext.getPackageManager();
            Context userContext = this.mContext;
            int userId = this.getSendingUserId();
            if (userId != 0) {
                try {
                    userContext = this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, new UserHandle(userId));
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if ((componentName = SmsApplication.getDefaultSendToApplication(userContext, true)) != null) {
                SmsApplication.configurePreferredActivity(packageManager, componentName, userId);
            }
        }
    }

    public static class SmsApplicationData {
        private String mApplicationName;
        public String mPackageName;
        public String mSmsReceiverClass;
        public String mMmsReceiverClass;
        public String mRespondViaMessageClass;
        public String mSendToClass;
        public String mSmsAppChangedReceiverClass;
        public String mProviderChangedReceiverClass;
        public int mUid;

        public boolean isComplete() {
            return this.mSmsReceiverClass != null && this.mMmsReceiverClass != null && this.mRespondViaMessageClass != null && this.mSendToClass != null;
        }

        public SmsApplicationData(String packageName, int uid) {
            this.mPackageName = packageName;
            this.mUid = uid;
        }

        public String getApplicationName(Context context) {
            if (this.mApplicationName == null) {
                ApplicationInfo appInfo;
                PackageManager pm = context.getPackageManager();
                try {
                    appInfo = pm.getApplicationInfoAsUser(this.mPackageName, 0, UserHandle.getUserId(this.mUid));
                }
                catch (PackageManager.NameNotFoundException e) {
                    return null;
                }
                if (appInfo != null) {
                    CharSequence label = pm.getApplicationLabel(appInfo);
                    this.mApplicationName = label == null ? null : label.toString();
                }
            }
            return this.mApplicationName;
        }

        public String toString() {
            return " mPackageName: " + this.mPackageName + " mSmsReceiverClass: " + this.mSmsReceiverClass + " mMmsReceiverClass: " + this.mMmsReceiverClass + " mRespondViaMessageClass: " + this.mRespondViaMessageClass + " mSendToClass: " + this.mSendToClass + " mSmsAppChangedClass: " + this.mSmsAppChangedReceiverClass + " mProviderChangedReceiverClass: " + this.mProviderChangedReceiverClass + " mUid: " + this.mUid;
        }
    }
}

