/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.IUserSwitchObserver;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.IPackageManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IRemoteCallback;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserManager;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.CarrierAppUtils;
import com.android.internal.telephony.CarrierServiceBindHelper;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RILConstants;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SubscriptionInfoUpdater
extends Handler {
    private static final String LOG_TAG = "SubscriptionInfoUpdater";
    private static final int PROJECT_SIM_NUM = TelephonyManager.getDefault().getPhoneCount();
    private static final int EVENT_SIM_LOCKED_QUERY_ICCID_DONE = 1;
    private static final int EVENT_GET_NETWORK_SELECTION_MODE_DONE = 2;
    private static final int EVENT_SIM_LOADED = 3;
    private static final int EVENT_SIM_ABSENT = 4;
    private static final int EVENT_SIM_LOCKED = 5;
    private static final int EVENT_SIM_IO_ERROR = 6;
    private static final int EVENT_SIM_UNKNOWN = 7;
    private static final int EVENT_SIM_RESTRICTED = 8;
    private static final String ICCID_STRING_FOR_NO_SIM = "";
    public static final int SIM_NOT_CHANGE = 0;
    public static final int SIM_CHANGED = -1;
    public static final int SIM_NEW = -2;
    public static final int SIM_REPOSITION = -3;
    public static final int SIM_NOT_INSERT = -99;
    public static final int STATUS_NO_SIM_INSERTED = 0;
    public static final int STATUS_SIM1_INSERTED = 1;
    public static final int STATUS_SIM2_INSERTED = 2;
    public static final int STATUS_SIM3_INSERTED = 4;
    public static final int STATUS_SIM4_INSERTED = 8;
    public static final String CURR_SUBID = "curr_subid";
    private static Phone[] mPhone;
    private static Context mContext;
    private static String[] mIccId;
    private static int[] mInsertSimState;
    private SubscriptionManager mSubscriptionManager = null;
    private IPackageManager mPackageManager;
    private UserManager mUserManager;
    private Map<Integer, Intent> rebroadcastIntentsOnUnlock = new HashMap<Integer, Intent>();
    private int mCurrentlyActiveUserId;
    private CarrierServiceBindHelper mCarrierServiceBindHelper;
    private final BroadcastReceiver sReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            SubscriptionInfoUpdater.this.logd("[Receiver]+");
            String action = intent.getAction();
            SubscriptionInfoUpdater.this.logd("Action: " + action);
            if (action.equals("android.intent.action.USER_UNLOCKED")) {
                Iterator iterator = SubscriptionInfoUpdater.this.rebroadcastIntentsOnUnlock.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry pair = iterator.next();
                    Intent i = (Intent)pair.getValue();
                    iterator.remove();
                    SubscriptionInfoUpdater.this.logd("Broadcasting intent ACTION_SIM_STATE_CHANGED for mCardIndex: " + pair.getKey());
                    ActivityManagerNative.broadcastStickyIntent(i, "android.permission.READ_PHONE_STATE", -1);
                }
                SubscriptionInfoUpdater.this.logd("[Receiver]-");
                return;
            }
            if (!action.equals("android.intent.action.SIM_STATE_CHANGED") && !action.equals("android.intent.action.internal_sim_state_changed")) {
                return;
            }
            int slotId = intent.getIntExtra("phone", -1);
            SubscriptionInfoUpdater.this.logd("slotId: " + slotId);
            if (slotId == -1) {
                return;
            }
            String simStatus = intent.getStringExtra("ss");
            SubscriptionInfoUpdater.this.logd("simStatus: " + simStatus);
            if (action.equals("android.intent.action.SIM_STATE_CHANGED")) {
                SubscriptionInfoUpdater.this.rebroadcastIntentsOnUnlock.put(slotId, intent);
                if ("ABSENT".equals(simStatus)) {
                    SubscriptionInfoUpdater.this.sendMessage(SubscriptionInfoUpdater.this.obtainMessage(4, slotId, -1));
                } else if ("UNKNOWN".equals(simStatus)) {
                    SubscriptionInfoUpdater.this.sendMessage(SubscriptionInfoUpdater.this.obtainMessage(7, slotId, -1));
                } else if ("CARD_IO_ERROR".equals(simStatus)) {
                    SubscriptionInfoUpdater.this.sendMessage(SubscriptionInfoUpdater.this.obtainMessage(6, slotId, -1));
                } else if ("CARD_RESTRICTED".equals(simStatus)) {
                    SubscriptionInfoUpdater.this.sendMessage(SubscriptionInfoUpdater.this.obtainMessage(8, slotId, -1));
                } else {
                    SubscriptionInfoUpdater.this.logd("Ignoring simStatus: " + simStatus);
                }
            } else if (action.equals("android.intent.action.internal_sim_state_changed")) {
                if ("LOCKED".equals(simStatus)) {
                    String reason = intent.getStringExtra("reason");
                    SubscriptionInfoUpdater.this.sendMessage(SubscriptionInfoUpdater.this.obtainMessage(5, slotId, -1, reason));
                } else if ("LOADED".equals(simStatus)) {
                    SubscriptionInfoUpdater.this.sendMessage(SubscriptionInfoUpdater.this.obtainMessage(3, slotId, -1));
                } else {
                    SubscriptionInfoUpdater.this.logd("Ignoring simStatus: " + simStatus);
                }
            }
            SubscriptionInfoUpdater.this.logd("[Receiver]-");
        }
    };

    public SubscriptionInfoUpdater(Context context, Phone[] phone, CommandsInterface[] ci) {
        this.logd("Constructor invoked");
        mContext = context;
        mPhone = phone;
        this.mSubscriptionManager = SubscriptionManager.from(mContext);
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        this.mUserManager = (UserManager)mContext.getSystemService("user");
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SIM_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.internal_sim_state_changed");
        intentFilter.addAction("android.intent.action.USER_UNLOCKED");
        mContext.registerReceiver(this.sReceiver, intentFilter);
        this.mCarrierServiceBindHelper = new CarrierServiceBindHelper(mContext);
        this.initializeCarrierApps();
    }

    private void initializeCarrierApps() {
        this.mCurrentlyActiveUserId = 0;
        try {
            ActivityManagerNative.getDefault().registerUserSwitchObserver(new IUserSwitchObserver.Stub(){

                @Override
                public void onUserSwitching(int newUserId, IRemoteCallback reply) throws RemoteException {
                    SubscriptionInfoUpdater.this.mCurrentlyActiveUserId = newUserId;
                    CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), SubscriptionInfoUpdater.this.mPackageManager, TelephonyManager.getDefault(), mContext.getContentResolver(), SubscriptionInfoUpdater.this.mCurrentlyActiveUserId);
                    if (reply != null) {
                        try {
                            reply.sendResult(null);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void onUserSwitchComplete(int newUserId) {
                }

                @Override
                public void onForegroundProfileSwitch(int newProfileId) throws RemoteException {
                }
            }, LOG_TAG);
            this.mCurrentlyActiveUserId = ActivityManagerNative.getDefault().getCurrentUser().id;
        }
        catch (RemoteException e) {
            this.logd("Couldn't get current user ID; guessing it's 0: " + e.getMessage());
        }
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.mPackageManager, TelephonyManager.getDefault(), mContext.getContentResolver(), this.mCurrentlyActiveUserId);
    }

    private boolean isAllIccIdQueryDone() {
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (mIccId[i] != null) continue;
            this.logd("Wait for SIM" + (i + 1) + " IccId");
            return false;
        }
        this.logd("All IccIds query complete");
        return true;
    }

    public void setDisplayNameForNewSub(String newSubName, int subId, int newNameSource) {
        SubscriptionInfo subInfo = this.mSubscriptionManager.getActiveSubscriptionInfo(subId);
        if (subInfo != null) {
            int oldNameSource = subInfo.getNameSource();
            CharSequence oldSubName = subInfo.getDisplayName();
            this.logd("[setDisplayNameForNewSub] subId = " + subInfo.getSubscriptionId() + ", oldSimName = " + oldSubName + ", oldNameSource = " + oldNameSource + ", newSubName = " + newSubName + ", newNameSource = " + newNameSource);
            if (oldSubName == null || oldNameSource == 0 && newSubName != null || oldNameSource == 1 && newSubName != null && !newSubName.equals(oldSubName)) {
                this.mSubscriptionManager.setDisplayName(newSubName, subInfo.getSubscriptionId(), newNameSource);
            }
        } else {
            this.logd("SUB" + (subId + 1) + " SubInfo not created yet");
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                QueryIccIdUserObj uObj = (QueryIccIdUserObj)ar.userObj;
                int slotId = uObj.slotId;
                this.logd("handleMessage : <EVENT_SIM_LOCKED_QUERY_ICCID_DONE> SIM" + (slotId + 1));
                if (ar.exception == null) {
                    if (ar.result != null) {
                        byte[] data = (byte[])ar.result;
                        SubscriptionInfoUpdater.mIccId[slotId] = IccUtils.bcdToString(data, 0, data.length);
                    } else {
                        this.logd("Null ar");
                        SubscriptionInfoUpdater.mIccId[slotId] = ICCID_STRING_FOR_NO_SIM;
                    }
                } else {
                    SubscriptionInfoUpdater.mIccId[slotId] = ICCID_STRING_FOR_NO_SIM;
                    this.logd("Query IccId fail: " + ar.exception);
                }
                this.logd("sIccId[" + slotId + "] = " + mIccId[slotId]);
                if (this.isAllIccIdQueryDone()) {
                    this.updateSubscriptionInfoByIccId();
                }
                this.broadcastSimStateChanged(slotId, "LOCKED", uObj.reason);
                if (ICCID_STRING_FOR_NO_SIM.equals(mIccId[slotId])) break;
                this.updateCarrierServices(slotId, "LOCKED");
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Integer slotId = (Integer)ar.userObj;
                if (ar.exception == null && ar.result != null) {
                    int[] modes = (int[])ar.result;
                    if (modes[0] != 1) break;
                    mPhone[slotId].setNetworkSelectionModeAutomatic(null);
                    break;
                }
                this.logd("EVENT_GET_NETWORK_SELECTION_MODE_DONE: error getting network mode.");
                break;
            }
            case 3: {
                this.handleSimLoaded(msg.arg1);
                break;
            }
            case 4: {
                this.handleSimAbsent(msg.arg1);
                break;
            }
            case 5: {
                this.handleSimLocked(msg.arg1, (String)msg.obj);
                break;
            }
            case 7: {
                this.updateCarrierServices(msg.arg1, "UNKNOWN");
                break;
            }
            case 6: {
                this.updateCarrierServices(msg.arg1, "CARD_IO_ERROR");
                break;
            }
            case 8: {
                this.updateCarrierServices(msg.arg1, "CARD_RESTRICTED");
                break;
            }
            default: {
                this.logd("Unknown msg:" + msg.what);
            }
        }
    }

    private void handleSimLocked(int slotId, String reason) {
        IccFileHandler fileHandler;
        if (mIccId[slotId] != null && mIccId[slotId].equals(ICCID_STRING_FOR_NO_SIM)) {
            this.logd("SIM" + (slotId + 1) + " hot plug in");
            SubscriptionInfoUpdater.mIccId[slotId] = null;
        }
        IccFileHandler iccFileHandler = fileHandler = mPhone[slotId].getIccCard() == null ? null : mPhone[slotId].getIccCard().getIccFileHandler();
        if (fileHandler != null) {
            String iccId = mIccId[slotId];
            if (iccId == null) {
                this.logd("Querying IccId");
                fileHandler.loadEFTransparent(12258, this.obtainMessage(1, new QueryIccIdUserObj(reason, slotId)));
            } else {
                this.logd("NOT Querying IccId its already set sIccid[" + slotId + "]=" + iccId);
                this.updateCarrierServices(slotId, "LOCKED");
                this.broadcastSimStateChanged(slotId, "LOCKED", reason);
            }
        } else {
            this.logd("sFh[" + slotId + "] is null, ignore");
        }
    }

    private void handleSimLoaded(int slotId) {
        this.logd("handleSimStateLoadedInternal: slotId: " + slotId);
        IccRecords records = mPhone[slotId].getIccCard().getIccRecords();
        if (records == null) {
            this.logd("onRecieve: IccRecords null");
            return;
        }
        if (records.getIccId() == null) {
            this.logd("onRecieve: IccID null");
            return;
        }
        SubscriptionInfoUpdater.mIccId[slotId] = records.getIccId();
        if (this.isAllIccIdQueryDone()) {
            this.updateSubscriptionInfoByIccId();
        }
        int subId = Integer.MAX_VALUE;
        int[] subIds = SubscriptionController.getInstance().getSubId(slotId);
        if (subIds != null) {
            subId = subIds[0];
        }
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            SharedPreferences sp;
            int storedSubId;
            TelephonyManager tm = TelephonyManager.getDefault();
            String operator = tm.getSimOperatorNumericForPhone(slotId);
            if (!TextUtils.isEmpty(operator)) {
                if (subId == SubscriptionController.getInstance().getDefaultSubId()) {
                    MccTable.updateMccMncConfiguration(mContext, operator, false);
                }
                SubscriptionController.getInstance().setMccMnc(operator, subId);
            } else {
                this.logd("EVENT_RECORDS_LOADED Operator name is null");
            }
            String msisdn = tm.getLine1Number(subId);
            ContentResolver contentResolver = mContext.getContentResolver();
            if (msisdn != null) {
                ContentValues number = new ContentValues(1);
                number.put("number", msisdn);
                contentResolver.update(SubscriptionManager.CONTENT_URI, number, "_id=" + Long.toString(subId), null);
            }
            SubscriptionInfo subInfo = this.mSubscriptionManager.getActiveSubscriptionInfo(subId);
            String simCarrierName = tm.getSimOperatorName(subId);
            ContentValues name = new ContentValues(1);
            if (subInfo != null && subInfo.getNameSource() != 2) {
                String nameToSet = !TextUtils.isEmpty(simCarrierName) ? simCarrierName : "CARD " + Integer.toString(slotId + 1);
                name.put("display_name", nameToSet);
                this.logd("sim name = " + nameToSet);
                contentResolver.update(SubscriptionManager.CONTENT_URI, name, "_id=" + Long.toString(subId), null);
            }
            if ((storedSubId = (sp = PreferenceManager.getDefaultSharedPreferences(mContext)).getInt(CURR_SUBID + slotId, -1)) != subId) {
                int networkType = RILConstants.PREFERRED_NETWORK_MODE;
                mPhone[slotId].setPreferredNetworkType(networkType, null);
                Settings.Global.putInt(mPhone[slotId].getContext().getContentResolver(), "preferred_network_mode" + subId, networkType);
                mPhone[slotId].getNetworkSelectionMode(this.obtainMessage(2, new Integer(slotId)));
                SharedPreferences.Editor editor = sp.edit();
                editor.putInt(CURR_SUBID + slotId, subId);
                editor.apply();
            }
        } else {
            this.logd("Invalid subId, could not update ContentResolver");
        }
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.mPackageManager, TelephonyManager.getDefault(), mContext.getContentResolver(), this.mCurrentlyActiveUserId);
        this.broadcastSimStateChanged(slotId, "LOADED", null);
        this.updateCarrierServices(slotId, "LOADED");
    }

    private void updateCarrierServices(int slotId, String simState) {
        CarrierConfigManager configManager = (CarrierConfigManager)mContext.getSystemService("carrier_config");
        configManager.updateConfigForPhoneId(slotId, simState);
        this.mCarrierServiceBindHelper.updateForPhoneId(slotId, simState);
    }

    private void handleSimAbsent(int slotId) {
        if (mIccId[slotId] != null && !mIccId[slotId].equals(ICCID_STRING_FOR_NO_SIM)) {
            this.logd("SIM" + (slotId + 1) + " hot plug out");
        }
        SubscriptionInfoUpdater.mIccId[slotId] = ICCID_STRING_FOR_NO_SIM;
        if (this.isAllIccIdQueryDone()) {
            this.updateSubscriptionInfoByIccId();
        }
        this.updateCarrierServices(slotId, "ABSENT");
    }

    private synchronized void updateSubscriptionInfoByIccId() {
        int i;
        int i2;
        this.logd("updateSubscriptionInfoByIccId:+ Start");
        this.mSubscriptionManager.clearSubscriptionInfo();
        for (int i3 = 0; i3 < PROJECT_SIM_NUM; ++i3) {
            SubscriptionInfoUpdater.mInsertSimState[i3] = 0;
        }
        int insertedSimCount = PROJECT_SIM_NUM;
        for (int i4 = 0; i4 < PROJECT_SIM_NUM; ++i4) {
            if (!ICCID_STRING_FOR_NO_SIM.equals(mIccId[i4])) continue;
            --insertedSimCount;
            SubscriptionInfoUpdater.mInsertSimState[i4] = -99;
        }
        this.logd("insertedSimCount = " + insertedSimCount);
        int index = 0;
        for (int i5 = 0; i5 < PROJECT_SIM_NUM; ++i5) {
            if (mInsertSimState[i5] == -99) continue;
            index = 2;
            for (int j = i5 + 1; j < PROJECT_SIM_NUM; ++j) {
                if (mInsertSimState[j] != 0 || !mIccId[i5].equals(mIccId[j])) continue;
                SubscriptionInfoUpdater.mInsertSimState[i5] = 1;
                SubscriptionInfoUpdater.mInsertSimState[j] = index++;
            }
        }
        ContentResolver contentResolver = mContext.getContentResolver();
        String[] oldIccId = new String[PROJECT_SIM_NUM];
        for (i2 = 0; i2 < PROJECT_SIM_NUM; ++i2) {
            oldIccId[i2] = null;
            List<SubscriptionInfo> oldSubInfo = SubscriptionController.getInstance().getSubInfoUsingSlotIdWithCheck(i2, false, mContext.getOpPackageName());
            if (oldSubInfo != null) {
                oldIccId[i2] = oldSubInfo.get(0).getIccId();
                this.logd("updateSubscriptionInfoByIccId: oldSubId = " + oldSubInfo.get(0).getSubscriptionId());
                if (mInsertSimState[i2] == 0 && !mIccId[i2].equals(oldIccId[i2])) {
                    SubscriptionInfoUpdater.mInsertSimState[i2] = -1;
                }
                if (mInsertSimState[i2] == 0) continue;
                ContentValues value = new ContentValues(1);
                value.put("sim_id", -1);
                contentResolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Integer.toString(oldSubInfo.get(0).getSubscriptionId()), null);
                continue;
            }
            if (mInsertSimState[i2] == 0) {
                SubscriptionInfoUpdater.mInsertSimState[i2] = -1;
            }
            oldIccId[i2] = ICCID_STRING_FOR_NO_SIM;
            this.logd("updateSubscriptionInfoByIccId: No SIM in slot " + i2 + " last time");
        }
        for (i2 = 0; i2 < PROJECT_SIM_NUM; ++i2) {
            this.logd("updateSubscriptionInfoByIccId: oldIccId[" + i2 + "] = " + oldIccId[i2] + ", sIccId[" + i2 + "] = " + mIccId[i2]);
        }
        int nNewCardCount = 0;
        int nNewSimStatus = 0;
        for (i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (mInsertSimState[i] == -99) {
                this.logd("updateSubscriptionInfoByIccId: No SIM inserted in slot " + i + " this time");
                continue;
            }
            if (mInsertSimState[i] > 0) {
                this.mSubscriptionManager.addSubscriptionInfoRecord(mIccId[i] + Integer.toString(mInsertSimState[i]), i);
                this.logd("SUB" + (i + 1) + " has invalid IccId");
            } else {
                this.mSubscriptionManager.addSubscriptionInfoRecord(mIccId[i], i);
            }
            if (!this.isNewSim(mIccId[i], oldIccId)) continue;
            ++nNewCardCount;
            switch (i) {
                case 0: {
                    nNewSimStatus |= 1;
                    break;
                }
                case 1: {
                    nNewSimStatus |= 2;
                    break;
                }
                case 2: {
                    nNewSimStatus |= 4;
                }
            }
            SubscriptionInfoUpdater.mInsertSimState[i] = -2;
        }
        for (i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (mInsertSimState[i] == -1) {
                SubscriptionInfoUpdater.mInsertSimState[i] = -3;
            }
            this.logd("updateSubscriptionInfoByIccId: sInsertSimState[" + i + "] = " + mInsertSimState[i]);
        }
        List<SubscriptionInfo> subInfos = this.mSubscriptionManager.getActiveSubscriptionInfoList();
        int nSubCount = subInfos == null ? 0 : subInfos.size();
        this.logd("updateSubscriptionInfoByIccId: nSubCount = " + nSubCount);
        for (int i6 = 0; i6 < nSubCount; ++i6) {
            SubscriptionInfo temp = subInfos.get(i6);
            String msisdn = TelephonyManager.getDefault().getLine1Number(temp.getSubscriptionId());
            if (msisdn == null) continue;
            ContentValues value = new ContentValues(1);
            value.put("number", msisdn);
            contentResolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Integer.toString(temp.getSubscriptionId()), null);
        }
        SubscriptionInfoUpdater subscriptionInfoUpdater = this;
        this.mSubscriptionManager.setDefaultDataSubId(subscriptionInfoUpdater.mSubscriptionManager.getDefaultDataSubscriptionId());
        SubscriptionController.getInstance().notifySubscriptionInfoChanged();
        this.logd("updateSubscriptionInfoByIccId:- SsubscriptionInfo update complete");
    }

    private boolean isNewSim(String iccId, String[] oldIccId) {
        boolean newSim = true;
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (!iccId.equals(oldIccId[i])) continue;
            newSim = false;
            break;
        }
        this.logd("newSim = " + newSim);
        return newSim;
    }

    private void broadcastSimStateChanged(int slotId, String state, String reason) {
        Intent i = new Intent("android.intent.action.SIM_STATE_CHANGED");
        i.addFlags(0x4000000);
        i.putExtra("phoneName", "Phone");
        i.putExtra("ss", state);
        i.putExtra("reason", reason);
        SubscriptionManager.putPhoneIdAndSubIdExtra(i, slotId);
        this.logd("Broadcasting intent ACTION_SIM_STATE_CHANGED " + state + " reason " + reason + " for mCardIndex: " + slotId);
        ActivityManagerNative.broadcastStickyIntent(i, "android.permission.READ_PHONE_STATE", -1);
        this.rebroadcastIntentsOnUnlock.put(slotId, i);
    }

    public void dispose() {
        this.logd("[dispose]");
        mContext.unregisterReceiver(this.sReceiver);
    }

    private void logd(String message) {
        Rlog.d(LOG_TAG, message);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("SubscriptionInfoUpdater:");
        this.mCarrierServiceBindHelper.dump(fd, pw, args);
    }

    static {
        mContext = null;
        mIccId = new String[PROJECT_SIM_NUM];
        mInsertSimState = new int[PROJECT_SIM_NUM];
    }

    private static class QueryIccIdUserObj {
        public String reason;
        public int slotId;

        QueryIccIdUserObj(String reason, int slotId) {
            this.reason = reason;
            this.slotId = slotId;
        }
    }
}

