/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.ConnectivityMetricsLogger;
import android.os.Bundle;
import android.telephony.ServiceState;
import com.android.ims.ImsReasonInfo;
import com.android.ims.internal.ImsCallSession;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import java.util.ArrayList;
import java.util.Objects;

public class TelephonyEventLog
extends ConnectivityMetricsLogger {
    private static String TAG = "TelephonyEventLog";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final int TAG_SETTINGS = 1;
    public static final int TAG_SERVICE_STATE = 2;
    public static final int TAG_IMS_CONNECTION_STATE = 3;
    public static final int TAG_IMS_CAPABILITIES = 4;
    public static final int TAG_DATA_CALL_LIST = 5;
    public static final int TAG_PHONE_STATE = 8;
    public static final int TAG_RIL_REQUEST = 1001;
    public static final int TAG_RIL_RESPONSE = 1002;
    public static final int TAG_RIL_UNSOL_RESPONSE = 1003;
    public static final int TAG_RIL_TIMEOUT_RESPONSE = 1004;
    public static final int TAG_IMS_CALL_START = 2001;
    public static final int TAG_IMS_CALL_START_CONFERENCE = 2002;
    public static final int TAG_IMS_CALL_RECEIVE = 2003;
    public static final int TAG_IMS_CALL_ACCEPT = 2004;
    public static final int TAG_IMS_CALL_REJECT = 2005;
    public static final int TAG_IMS_CALL_TERMINATE = 2006;
    public static final int TAG_IMS_CALL_HOLD = 2007;
    public static final int TAG_IMS_CALL_RESUME = 2008;
    public static final int TAG_IMS_CALL_MERGE = 2009;
    public static final int TAG_IMS_CALL_UPDATE = 2010;
    public static final int TAG_IMS_CALL_PROGRESSING = 2011;
    public static final int TAG_IMS_CALL_STARTED = 2012;
    public static final int TAG_IMS_CALL_START_FAILED = 2013;
    public static final int TAG_IMS_CALL_TERMINATED = 2014;
    public static final int TAG_IMS_CALL_HELD = 2015;
    public static final int TAG_IMS_CALL_HOLD_FAILED = 2016;
    public static final int TAG_IMS_CALL_HOLD_RECEIVED = 2017;
    public static final int TAG_IMS_CALL_RESUMED = 2018;
    public static final int TAG_IMS_CALL_RESUME_FAILED = 2019;
    public static final int TAG_IMS_CALL_RESUME_RECEIVED = 2020;
    public static final int TAG_IMS_CALL_UPDATED = 2021;
    public static final int TAG_IMS_CALL_UPDATE_FAILED = 2022;
    public static final int TAG_IMS_CALL_MERGED = 2023;
    public static final int TAG_IMS_CALL_MERGE_FAILED = 2024;
    public static final int TAG_IMS_CALL_HANDOVER = 2025;
    public static final int TAG_IMS_CALL_HANDOVER_FAILED = 2026;
    public static final int TAG_IMS_CALL_TTY_MODE_RECEIVED = 2027;
    public static final int TAG_IMS_CONFERENCE_PARTICIPANTS_STATE_CHANGED = 2028;
    public static final int TAG_IMS_MULTIPARTY_STATE_CHANGED = 2029;
    public static final int TAG_IMS_CALL_STATE = 2030;
    public static final int SETTING_AIRPLANE_MODE = 1;
    public static final int SETTING_CELL_DATA_ENABLED = 2;
    public static final int SETTING_DATA_ROAMING_ENABLED = 3;
    public static final int SETTING_PREFERRED_NETWORK_MODE = 4;
    public static final int SETTING_WIFI_ENABLED = 5;
    public static final int SETTING_VO_LTE_ENABLED = 6;
    public static final int SETTING_VO_WIFI_ENABLED = 7;
    public static final int SETTING_WFC_MODE = 8;
    public static final int SETTING_VI_LTE_ENABLED = 9;
    public static final int SETTING_VI_WIFI_ENABLED = 10;
    public static final int IMS_CONNECTION_STATE_CONNECTED = 1;
    public static final int IMS_CONNECTION_STATE_PROGRESSING = 2;
    public static final int IMS_CONNECTION_STATE_DISCONNECTED = 3;
    public static final int IMS_CONNECTION_STATE_RESUMED = 4;
    public static final int IMS_CONNECTION_STATE_SUSPENDED = 5;
    public static final String DATA_KEY_PHONE_ID = "phoneId";
    public static final String DATA_KEY_PARAM1 = "param1";
    public static final String DATA_KEY_PARAM2 = "param2";
    public static final String DATA_KEY_REASONINFO_CODE = "code";
    public static final String DATA_KEY_REASONINFO_EXTRA_CODE = "extra-code";
    public static final String DATA_KEY_REASONINFO_EXTRA_MESSAGE = "extra-message";
    public static final String DATA_KEY_VOLTE = "VoLTE";
    public static final String DATA_KEY_VILTE = "ViLTE";
    public static final String DATA_KEY_VOWIFI = "VoWiFi";
    public static final String DATA_KEY_VIWIFI = "ViWiFi";
    public static final String DATA_KEY_UTLTE = "UTLTE";
    public static final String DATA_KEY_UTWIFI = "UTWiFi";
    public static final String DATA_KEY_RAT = "rat";
    public static final String DATA_KEY_DATA_PROFILE = "profile";
    public static final String DATA_KEY_APN = "apn";
    public static final String DATA_KEY_PROTOCOL = "protocol";
    public static final String DATA_KEY_DATA_DEACTIVATE_REASON = "reason";
    public static final String DATA_KEY_DATA_CALL_STATUSES = "statuses";
    public static final String DATA_KEY_DATA_CALL_CIDS = "cids";
    public static final String DATA_KEY_DATA_CALL_ACTIVES = "actives";
    public static final String DATA_KEY_DATA_CALL_TYPES = "types";
    public static final String DATA_KEY_DATA_CALL_IFNAMES = "ifnames";
    public static final String DATA_KEY_CLIR_MODE = "clirMode";
    public static final String DATA_KEY_RIL_CALL_RING_RESPONSE = "response";
    public static final String DATA_KEY_RIL_HANGUP_GSM_INDEX = "gsmIndex";
    public static final String DATA_KEY_RIL_ERROR = "error";
    public static final String DATA_KEY_DATA_CALL_STATUS = "status";
    public static final String DATA_KEY_DATA_CALL_RETRY = "retry";
    public static final String DATA_KEY_DATA_CALL_CID = "cid";
    public static final String DATA_KEY_DATA_CALL_ACTIVE = "active";
    public static final String DATA_KEY_DATA_CALL_TYPE = "type";
    public static final String DATA_KEY_DATA_CALL_IFNAME = "ifname";
    public static final String DATA_KEY_SMS_MESSAGE_REF = "messageRef";
    public static final String DATA_KEY_SMS_ACK_PDU = "ackPDU";
    public static final String DATA_KEY_SMS_ERROR_CODE = "errorCode";
    public static final String DATA_KEY_SRC_TECH = "src-tech";
    public static final String DATA_KEY_TARGET_TECH = "target-tech";
    public static final String SERVICE_STATE_VOICE_REG_STATE = "regSt";
    public static final String SERVICE_STATE_DATA_REG_STATE = "dataRegSt";
    public static final String SERVICE_STATE_VOICE_ROAMING_TYPE = "roamingType";
    public static final String SERVICE_STATE_DATA_ROAMING_TYPE = "dataRoamingType";
    public static final String SERVICE_STATE_VOICE_ALPHA_LONG = "alphaLong";
    public static final String SERVICE_STATE_VOICE_ALPHA_SHORT = "alphaShort";
    public static final String SERVICE_STATE_VOICE_NUMERIC = "operator";
    public static final String SERVICE_STATE_DATA_ALPHA_LONG = "dataAlphaLong";
    public static final String SERVICE_STATE_DATA_ALPHA_SHORT = "dataAlphaShort";
    public static final String SERVICE_STATE_DATA_NUMERIC = "dataOperator";
    public static final String SERVICE_STATE_VOICE_RAT = "rat";
    public static final String SERVICE_STATE_DATA_RAT = "dataRat";
    public static final String SERVICE_STATE_EMERGENCY_ONLY = "emergencyOnly";
    int mPhoneId;
    private int mVoiceRegState = -1;
    private int mDataRegState = -1;
    private int mVoiceRoamingType = -1;
    private int mDataRoamingType = -1;
    private String mVoiceOperatorAlphaShort;
    private String mVoiceOperatorNumeric;
    private String mDataOperatorAlphaShort;
    private String mDataOperatorNumeric;
    private int mRilVoiceRadioTechnology = -1;
    private int mRilDataRadioTechnology = -1;
    private boolean mEmergencyOnly = false;
    private Bundle mLastServiceStateBundle = null;
    private final boolean[] mImsCapabilities = new boolean[]{false, false, false, false, false, false};

    public TelephonyEventLog(int phoneId) {
        this.mPhoneId = phoneId;
    }

    private void writeEvent(int tag, Bundle data) {
        this.writeEvent(System.currentTimeMillis(), tag, -1, -1, data);
    }

    private void writeEvent(int tag, int param1, int param2) {
        this.writeEvent(System.currentTimeMillis(), tag, param1, param2, null);
    }

    private void writeEvent(int tag, int param1, int param2, Bundle data) {
        this.writeEvent(System.currentTimeMillis(), tag, param1, param2, data);
    }

    private void writeEvent(long timestamp, int tag, int param1, int param2, Bundle data) {
        Bundle b = data;
        if (b == null) {
            b = new Bundle();
        }
        b.putInt(DATA_KEY_PHONE_ID, this.mPhoneId);
        b.putInt(DATA_KEY_PARAM1, param1);
        b.putInt(DATA_KEY_PARAM2, param2);
        this.logEvent(timestamp, 4, tag, b);
    }

    public static boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private static boolean areBundlesEqual(Bundle first, Bundle second) {
        if (first == null || second == null) {
            return first == second;
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (String key : first.keySet()) {
            Object secondValue;
            Object firstValue;
            if (key == null || Objects.equals(firstValue = first.get(key), secondValue = second.get(key))) continue;
            return false;
        }
        return true;
    }

    public void writeServiceStateChanged(ServiceState serviceState) {
        Bundle b = new Bundle();
        this.mVoiceRegState = serviceState.getVoiceRegState();
        b.putInt(SERVICE_STATE_VOICE_REG_STATE, this.mVoiceRegState);
        this.mDataRegState = serviceState.getDataRegState();
        b.putInt(SERVICE_STATE_DATA_REG_STATE, this.mDataRegState);
        this.mVoiceRoamingType = serviceState.getVoiceRoamingType();
        b.putInt(SERVICE_STATE_VOICE_ROAMING_TYPE, this.mVoiceRoamingType);
        this.mDataRoamingType = serviceState.getDataRoamingType();
        b.putInt(SERVICE_STATE_DATA_ROAMING_TYPE, this.mDataRoamingType);
        if (serviceState.getVoiceOperatorAlphaShort() != null) {
            this.mVoiceOperatorAlphaShort = serviceState.getVoiceOperatorAlphaShort();
            b.putString(SERVICE_STATE_VOICE_ALPHA_SHORT, this.mVoiceOperatorAlphaShort);
        }
        if (serviceState.getVoiceOperatorNumeric() != null) {
            this.mVoiceOperatorNumeric = serviceState.getVoiceOperatorNumeric();
            b.putString(SERVICE_STATE_VOICE_NUMERIC, this.mVoiceOperatorNumeric);
        }
        if (serviceState.getDataOperatorAlphaShort() != null) {
            this.mDataOperatorAlphaShort = serviceState.getDataOperatorAlphaShort();
            b.putString(SERVICE_STATE_DATA_ALPHA_SHORT, this.mDataOperatorAlphaShort);
        }
        if (serviceState.getDataOperatorNumeric() != null) {
            this.mDataOperatorNumeric = serviceState.getDataOperatorNumeric();
            b.putString(SERVICE_STATE_DATA_NUMERIC, this.mDataOperatorNumeric);
        }
        this.mRilVoiceRadioTechnology = serviceState.getRilVoiceRadioTechnology();
        b.putInt("rat", this.mRilVoiceRadioTechnology);
        this.mRilDataRadioTechnology = serviceState.getRilDataRadioTechnology();
        b.putInt(SERVICE_STATE_DATA_RAT, this.mRilDataRadioTechnology);
        this.mEmergencyOnly = serviceState.isEmergencyOnly();
        b.putBoolean(SERVICE_STATE_EMERGENCY_ONLY, this.mEmergencyOnly);
        if (!TelephonyEventLog.areBundlesEqual(b, this.mLastServiceStateBundle)) {
            this.mLastServiceStateBundle = b;
            this.writeEvent(2, b);
        }
    }

    public void writeSetAirplaneMode(boolean enabled) {
        this.writeEvent(1, 1, enabled ? 1 : 0);
    }

    public void writeSetCellDataEnabled(boolean enabled) {
        this.writeEvent(1, 2, enabled ? 1 : 0);
    }

    public void writeSetDataRoamingEnabled(boolean enabled) {
        this.writeEvent(1, 3, enabled ? 1 : 0);
    }

    public void writeSetPreferredNetworkType(int mode) {
        this.writeEvent(1, 4, mode);
    }

    public void writeSetWifiEnabled(boolean enabled) {
        this.writeEvent(1, 5, enabled ? 1 : 0);
    }

    public void writeSetWfcMode(int mode) {
        this.writeEvent(1, 8, mode);
    }

    public void writeImsSetFeatureValue(int feature, int network, int value, int status) {
        switch (feature) {
            case 0: {
                this.writeEvent(1, 6, value);
                break;
            }
            case 2: {
                this.writeEvent(1, 7, value);
                break;
            }
            case 1: {
                this.writeEvent(1, 9, value);
                break;
            }
            case 3: {
                this.writeEvent(1, 10, value);
            }
        }
    }

    public void writeOnImsConnectionState(int state, ImsReasonInfo reasonInfo) {
        this.writeEvent(3, state, -1, this.imsReasonInfoToBundle(reasonInfo));
    }

    public void writeOnImsCapabilities(boolean[] capabilities) {
        boolean changed = false;
        for (int i = 0; i < capabilities.length; ++i) {
            if (this.mImsCapabilities[i] == capabilities[i]) continue;
            this.mImsCapabilities[i] = capabilities[i];
            changed = true;
        }
        if (changed) {
            Bundle b = new Bundle();
            b.putBoolean(DATA_KEY_VOLTE, capabilities[0]);
            b.putBoolean(DATA_KEY_VILTE, capabilities[1]);
            b.putBoolean(DATA_KEY_VOWIFI, capabilities[2]);
            b.putBoolean(DATA_KEY_VIWIFI, capabilities[3]);
            b.putBoolean(DATA_KEY_UTLTE, capabilities[4]);
            b.putBoolean(DATA_KEY_UTWIFI, capabilities[5]);
            this.writeEvent(4, b);
        }
    }

    public void writeRilSetupDataCall(int rilSerial, int radioTechnology, int profile, String apn, String user, String password, int authType, String protocol) {
        Bundle b = new Bundle();
        b.putInt("rat", radioTechnology);
        b.putInt(DATA_KEY_DATA_PROFILE, profile);
        b.putString(DATA_KEY_APN, apn);
        b.putString(DATA_KEY_PROTOCOL, protocol);
        this.writeEvent(1001, 27, rilSerial, b);
    }

    public void writeRilDeactivateDataCall(int rilSerial, int cid, int reason) {
        Bundle b = new Bundle();
        b.putInt(DATA_KEY_DATA_CALL_CID, cid);
        b.putInt(DATA_KEY_DATA_DEACTIVATE_REASON, reason);
        this.writeEvent(1001, 41, rilSerial, b);
    }

    public void writeRilDataCallList(ArrayList<DataCallResponse> dcsList) {
        Bundle b = new Bundle();
        int[] statuses = new int[dcsList.size()];
        int[] cids = new int[dcsList.size()];
        int[] actives = new int[dcsList.size()];
        String[] types = new String[dcsList.size()];
        String[] ifnames = new String[dcsList.size()];
        for (int i = 0; i < dcsList.size(); ++i) {
            DataCallResponse dcs = dcsList.get(i);
            statuses[i] = dcs.status;
            cids[i] = dcs.cid;
            actives[i] = dcs.active;
            types[i] = dcs.type;
            ifnames[i] = dcs.ifname;
        }
        b.putIntArray(DATA_KEY_DATA_CALL_STATUSES, statuses);
        b.putIntArray(DATA_KEY_DATA_CALL_CIDS, cids);
        b.putIntArray(DATA_KEY_DATA_CALL_ACTIVES, actives);
        b.putStringArray(DATA_KEY_DATA_CALL_TYPES, types);
        b.putStringArray(DATA_KEY_DATA_CALL_IFNAMES, ifnames);
        this.writeEvent(5, -1, -1, b);
    }

    public void writeRilDial(int rilSerial, int clirMode, UUSInfo uusInfo) {
        Bundle b = new Bundle();
        b.putInt(DATA_KEY_CLIR_MODE, clirMode);
        this.writeEvent(1001, 10, rilSerial, b);
    }

    public void writeRilCallRing(char[] response) {
        Bundle b = new Bundle();
        b.putCharArray(DATA_KEY_RIL_CALL_RING_RESPONSE, response);
        this.writeEvent(1003, 1018, -1, b);
    }

    public void writeRilHangup(int rilSerial, int req, int gsmIndex) {
        Bundle b = new Bundle();
        b.putInt(DATA_KEY_RIL_HANGUP_GSM_INDEX, gsmIndex);
        this.writeEvent(1001, req, rilSerial, b);
    }

    public void writeRilAnswer(int rilSerial) {
        this.writeEvent(1001, 40, rilSerial, null);
    }

    public void writeRilSrvcc(int rilSrvccState) {
        this.writeEvent(1003, 1039, rilSrvccState, null);
    }

    public void writeRilSendSms(int rilSerial, int req) {
        this.writeEvent(1001, req, rilSerial, null);
    }

    public void writeRilNewSms(int response) {
        this.writeEvent(1003, response, -1, null);
    }

    public void writeOnRilSolicitedResponse(int rilSerial, int rilError, int rilRequest, Object ret) {
        Bundle b = new Bundle();
        if (rilError != 0) {
            b.putInt(DATA_KEY_RIL_ERROR, rilError);
        }
        switch (rilRequest) {
            case 27: {
                DataCallResponse dataCall = (DataCallResponse)ret;
                b.putInt(DATA_KEY_DATA_CALL_STATUS, dataCall.status);
                b.putInt(DATA_KEY_DATA_CALL_RETRY, dataCall.suggestedRetryTime);
                b.putInt(DATA_KEY_DATA_CALL_CID, dataCall.cid);
                b.putInt(DATA_KEY_DATA_CALL_ACTIVE, dataCall.active);
                b.putString(DATA_KEY_DATA_CALL_TYPE, dataCall.type);
                b.putString(DATA_KEY_DATA_CALL_IFNAME, dataCall.ifname);
                this.writeEvent(1002, rilRequest, rilSerial, b);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 40: 
            case 41: {
                this.writeEvent(1002, rilRequest, rilSerial, b);
                break;
            }
            case 25: 
            case 26: 
            case 87: 
            case 113: {
                SmsResponse smsResponse = (SmsResponse)ret;
                b.putInt(DATA_KEY_SMS_MESSAGE_REF, smsResponse.mMessageRef);
                b.putString(DATA_KEY_SMS_ACK_PDU, smsResponse.mAckPdu);
                b.putInt(DATA_KEY_SMS_ERROR_CODE, smsResponse.mErrorCode);
                this.writeEvent(1002, rilRequest, rilSerial, b);
            }
        }
    }

    public void writeOnRilTimeoutResponse(int rilSerial, int rilRequest) {
        this.writeEvent(1004, rilRequest, rilSerial, null);
    }

    public void writePhoneState(PhoneConstants.State phoneState) {
        int state;
        switch (phoneState) {
            case IDLE: {
                state = 0;
                break;
            }
            case RINGING: {
                state = 1;
                break;
            }
            case OFFHOOK: {
                state = 2;
                break;
            }
            default: {
                state = -1;
            }
        }
        this.writeEvent(8, state, -1);
    }

    public void writeImsCallState(ImsCallSession session, Call.State callState) {
        int state;
        switch (callState) {
            case IDLE: {
                state = 0;
                break;
            }
            case ACTIVE: {
                state = 1;
                break;
            }
            case HOLDING: {
                state = 2;
                break;
            }
            case DIALING: {
                state = 3;
                break;
            }
            case ALERTING: {
                state = 4;
                break;
            }
            case INCOMING: {
                state = 5;
                break;
            }
            case WAITING: {
                state = 6;
                break;
            }
            case DISCONNECTED: {
                state = 7;
                break;
            }
            case DISCONNECTING: {
                state = 8;
                break;
            }
            default: {
                state = -1;
            }
        }
        this.writeEvent(2030, this.getCallId(session), state);
    }

    private void writeImsCallEvent(int tag, ImsCallSession session) {
        this.writeEvent(tag, this.getCallId(session), -1);
    }

    private void writeImsCallEvent(int tag, ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeEvent(tag, this.getCallId(session), -1, this.imsReasonInfoToBundle(reasonInfo));
    }

    private Bundle imsReasonInfoToBundle(ImsReasonInfo reasonInfo) {
        if (reasonInfo != null) {
            Bundle b = new Bundle();
            b.putInt(DATA_KEY_REASONINFO_CODE, reasonInfo.mCode);
            b.putInt(DATA_KEY_REASONINFO_EXTRA_CODE, reasonInfo.mExtraCode);
            b.putString(DATA_KEY_REASONINFO_EXTRA_MESSAGE, reasonInfo.mExtraMessage);
            return b;
        }
        return null;
    }

    public void writeOnImsCallStart(ImsCallSession session) {
        this.writeEvent(2001, this.getCallId(session), -1, null);
    }

    public void writeOnImsCallStartConference(ImsCallSession session) {
        this.writeEvent(2002, this.getCallId(session), -1, null);
    }

    public void writeOnImsCallReceive(ImsCallSession session) {
        this.writeImsCallEvent(2003, session);
    }

    public void writeOnImsCallAccept(ImsCallSession session) {
        this.writeImsCallEvent(2004, session);
    }

    public void writeOnImsCallReject(ImsCallSession session) {
        this.writeImsCallEvent(2005, session);
    }

    public void writeOnImsCallTerminate(ImsCallSession session) {
        this.writeImsCallEvent(2006, session);
    }

    public void writeOnImsCallHold(ImsCallSession session) {
        this.writeImsCallEvent(2007, session);
    }

    public void writeOnImsCallResume(ImsCallSession session) {
        this.writeImsCallEvent(2008, session);
    }

    public void writeOnImsCallProgressing(ImsCallSession session) {
        this.writeImsCallEvent(2011, session);
    }

    public void writeOnImsCallStarted(ImsCallSession session) {
        this.writeImsCallEvent(2012, session);
    }

    public void writeOnImsCallStartFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeImsCallEvent(2013, session, reasonInfo);
    }

    public void writeOnImsCallTerminated(ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeImsCallEvent(2014, session, reasonInfo);
    }

    public void writeOnImsCallHeld(ImsCallSession session) {
        this.writeImsCallEvent(2015, session);
    }

    public void writeOnImsCallHoldReceived(ImsCallSession session) {
        this.writeImsCallEvent(2017, session);
    }

    public void writeOnImsCallHoldFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeImsCallEvent(2016, session, reasonInfo);
    }

    public void writeOnImsCallResumed(ImsCallSession session) {
        this.writeImsCallEvent(2018, session);
    }

    public void writeOnImsCallResumeReceived(ImsCallSession session) {
        this.writeImsCallEvent(2020, session);
    }

    public void writeOnImsCallResumeFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        this.writeImsCallEvent(2019, session, reasonInfo);
    }

    public void writeOnImsCallHandover(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        Bundle b = this.imsHandoverToBundle(srcAccessTech, targetAccessTech, reasonInfo);
        this.writeEvent(2025, this.getCallId(session), -1, b);
    }

    public void writeOnImsCallHandoverFailed(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        Bundle b = this.imsHandoverToBundle(srcAccessTech, targetAccessTech, reasonInfo);
        this.writeEvent(2026, this.getCallId(session), -1, b);
    }

    private int getCallId(ImsCallSession session) {
        if (session == null) {
            return -1;
        }
        try {
            return Integer.parseInt(session.getCallId());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private Bundle imsHandoverToBundle(int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        Bundle b = new Bundle();
        b.putInt(DATA_KEY_SRC_TECH, srcAccessTech);
        b.putInt(DATA_KEY_TARGET_TECH, targetAccessTech);
        b.putInt(DATA_KEY_REASONINFO_CODE, reasonInfo.mCode);
        b.putInt(DATA_KEY_REASONINFO_EXTRA_CODE, reasonInfo.mExtraCode);
        b.putString(DATA_KEY_REASONINFO_EXTRA_MESSAGE, reasonInfo.mExtraMessage);
        return b;
    }
}

