/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import android.telephony.VisualVoicemailSmsFilterSettings;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.telephony.VisualVoicemailSmsParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class VisualVoicemailSmsFilter {
    private static final String TAG = "VvmSmsFilter";
    private static final String SYSTEM_VVM_CLIENT_PACKAGE = "com.android.phone";
    private static Map<String, List<Pattern>> sPatterns;

    public static boolean filter(Context context, byte[][] pdus, String format, int destPort, int subId) {
        String vvmClientPackage;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        VisualVoicemailSmsFilterSettings settings = telephonyManager.getVisualVoicemailSmsFilterSettings(vvmClientPackage = SYSTEM_VVM_CLIENT_PACKAGE, subId);
        if (settings == null) {
            return false;
        }
        String messageBody = VisualVoicemailSmsFilter.getFullMessage(pdus, format);
        if (messageBody == null) {
            Log.i(TAG, "Unparsable SMS received");
            String asciiMessage = VisualVoicemailSmsFilter.parseAsciiPduMessage(pdus);
            VisualVoicemailSmsParser.WrappedMessageData messageData = VisualVoicemailSmsParser.parseAlternativeFormat(asciiMessage);
            if (messageData != null) {
                VisualVoicemailSmsFilter.sendVvmSmsBroadcast(context, vvmClientPackage, subId, messageData, null);
            }
            return false;
        }
        String clientPrefix = settings.clientPrefix;
        VisualVoicemailSmsParser.WrappedMessageData messageData = VisualVoicemailSmsParser.parse(clientPrefix, messageBody);
        if (messageData != null) {
            VisualVoicemailSmsFilter.sendVvmSmsBroadcast(context, vvmClientPackage, subId, messageData, null);
            return true;
        }
        VisualVoicemailSmsFilter.buildPatternsMap(context);
        String mccMnc = telephonyManager.getSimOperator(subId);
        List<Pattern> patterns = sPatterns.get(mccMnc);
        if (patterns == null || patterns.isEmpty()) {
            return false;
        }
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(messageBody).matches()) continue;
            Log.w(TAG, "Incoming SMS matches pattern " + pattern + " but has illegal format, " + "still dropping as VVM SMS");
            VisualVoicemailSmsFilter.sendVvmSmsBroadcast(context, vvmClientPackage, subId, null, messageBody);
            return true;
        }
        return false;
    }

    private static void buildPatternsMap(Context context) {
        if (sPatterns != null) {
            return;
        }
        sPatterns = new ArrayMap<String, List<Pattern>>();
        for (String entry : context.getResources().getStringArray(17236043)) {
            String[] mccMncList = entry.split(";")[0].split(",");
            Pattern pattern = Pattern.compile(entry.split(";")[1]);
            for (String mccMnc : mccMncList) {
                if (!sPatterns.containsKey(mccMnc)) {
                    sPatterns.put(mccMnc, new ArrayList());
                }
                sPatterns.get(mccMnc).add(pattern);
            }
        }
    }

    private static void sendVvmSmsBroadcast(Context context, String vvmClientPackage, int subId, VisualVoicemailSmsParser.WrappedMessageData messageData, String messageBody) {
        Log.i(TAG, "VVM SMS received");
        Intent intent = new Intent("android.intent.action.VOICEMAIL_SMS_RECEIVED");
        if (messageData != null) {
            intent.putExtra("com.android.voicemail.extra.VOICEMAIL_SMS_PREFIX", messageData.prefix);
            intent.putExtra("com.android.voicemail.extra.VOICEMAIL_SMS_FIELDS", messageData.fields);
        }
        if (messageBody != null) {
            intent.putExtra("com.android.voicemail.extra.VOICEMAIL_SMS_MESSAGE_BODY", messageBody);
        }
        intent.putExtra("com.android.voicemail.extra.VOICEMAIL_SMS_SUBID", subId);
        intent.setPackage(vvmClientPackage);
        context.sendBroadcast(intent);
    }

    private static String getFullMessage(byte[][] pdus, String format) {
        StringBuilder builder = new StringBuilder();
        for (byte[] pdu : pdus) {
            SmsMessage message = SmsMessage.createFromPdu(pdu, format);
            if (message == null) {
                return null;
            }
            String body = message.getMessageBody();
            if (body == null) continue;
            builder.append(body);
        }
        return builder.toString();
    }

    private static String parseAsciiPduMessage(byte[][] pdus) {
        StringBuilder builder = new StringBuilder();
        for (byte[] pdu : pdus) {
            builder.append(new String(pdu, StandardCharsets.US_ASCII));
        }
        return builder.toString();
    }
}

