/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.content.res.Resources;
import android.os.Message;
import android.telephony.SmsCbMessage;
import com.android.internal.telephony.CellBroadcastHandler;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SmsConstants;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.WspTypeDecoder;
import com.android.internal.telephony.cdma.CdmaSMSDispatcher;
import com.android.internal.telephony.cdma.CdmaServiceCategoryProgramHandler;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.util.HexDump;
import java.util.Arrays;

public class CdmaInboundSmsHandler
extends InboundSmsHandler {
    private final CdmaSMSDispatcher mSmsDispatcher;
    private final CdmaServiceCategoryProgramHandler mServiceCategoryProgramHandler;
    private byte[] mLastDispatchedSmsFingerprint;
    private byte[] mLastAcknowledgedSmsFingerprint;
    private final boolean mCheckForDuplicatePortsInOmadmWapPush = Resources.getSystem().getBoolean(17956967);

    private CdmaInboundSmsHandler(Context context, SmsStorageMonitor storageMonitor, Phone phone, CdmaSMSDispatcher smsDispatcher) {
        super("CdmaInboundSmsHandler", context, storageMonitor, phone, CellBroadcastHandler.makeCellBroadcastHandler(context, phone));
        this.mSmsDispatcher = smsDispatcher;
        this.mServiceCategoryProgramHandler = CdmaServiceCategoryProgramHandler.makeScpHandler(context, phone.mCi);
        phone.mCi.setOnNewCdmaSms(this.getHandler(), 1, null);
    }

    @Override
    protected void onQuitting() {
        this.mPhone.mCi.unSetOnNewCdmaSms(this.getHandler());
        this.mCellBroadcastHandler.dispose();
        this.log("unregistered for 3GPP2 SMS");
        super.onQuitting();
    }

    public static CdmaInboundSmsHandler makeInboundSmsHandler(Context context, SmsStorageMonitor storageMonitor, Phone phone, CdmaSMSDispatcher smsDispatcher) {
        CdmaInboundSmsHandler handler = new CdmaInboundSmsHandler(context, storageMonitor, phone, smsDispatcher);
        handler.start();
        return handler;
    }

    @Override
    protected boolean is3gpp2() {
        return true;
    }

    @Override
    protected int dispatchMessageRadioSpecific(SmsMessageBase smsb) {
        boolean isBroadcastType;
        SmsMessage sms = (SmsMessage)smsb;
        boolean bl = isBroadcastType = 1 == sms.getMessageType();
        if (isBroadcastType) {
            this.log("Broadcast type message");
            SmsCbMessage cbMessage = sms.parseBroadcastSms();
            if (cbMessage != null) {
                this.mCellBroadcastHandler.dispatchSmsMessage(cbMessage);
            } else {
                this.loge("error trying to parse broadcast SMS");
            }
            return 1;
        }
        this.mLastDispatchedSmsFingerprint = sms.getIncomingSmsFingerprint();
        if (this.mLastAcknowledgedSmsFingerprint != null && Arrays.equals(this.mLastDispatchedSmsFingerprint, this.mLastAcknowledgedSmsFingerprint)) {
            return 1;
        }
        sms.parseSms();
        int teleService = sms.getTeleService();
        switch (teleService) {
            case 4099: 
            case 262144: {
                this.handleVoicemailTeleservice(sms);
                return 1;
            }
            case 4098: 
            case 4101: {
                if (!sms.isStatusReportMessage()) break;
                this.mSmsDispatcher.sendStatusReportMessage(sms);
                return 1;
            }
            case 4102: {
                this.mServiceCategoryProgramHandler.dispatchSmsMessage(sms);
                return 1;
            }
            case 4100: {
                break;
            }
            default: {
                this.loge("unsupported teleservice 0x" + Integer.toHexString(teleService));
                return 4;
            }
        }
        if (!this.mStorageMonitor.isStorageAvailable() && sms.getMessageClass() != SmsConstants.MessageClass.CLASS_0) {
            return 3;
        }
        if (4100 == teleService) {
            return this.processCdmaWapPdu(sms.getUserData(), sms.mMessageRef, sms.getOriginatingAddress(), sms.getTimestampMillis());
        }
        return this.dispatchNormalMessage(smsb);
    }

    @Override
    protected void acknowledgeLastIncomingSms(boolean success, int result, Message response) {
        int causeCode = CdmaInboundSmsHandler.resultToCause(result);
        this.mPhone.mCi.acknowledgeLastIncomingCdmaSms(success, causeCode, response);
        if (causeCode == 0) {
            this.mLastAcknowledgedSmsFingerprint = this.mLastDispatchedSmsFingerprint;
        }
        this.mLastDispatchedSmsFingerprint = null;
    }

    @Override
    protected void onUpdatePhoneObject(Phone phone) {
        super.onUpdatePhoneObject(phone);
        this.mCellBroadcastHandler.updatePhoneObject(phone);
    }

    private static int resultToCause(int rc) {
        switch (rc) {
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 35;
            }
            case 4: {
                return 4;
            }
        }
        return 39;
    }

    private void handleVoicemailTeleservice(SmsMessage sms) {
        int voicemailCount = sms.getNumOfVoicemails();
        this.log("Voicemail count=" + voicemailCount);
        if (voicemailCount < 0) {
            voicemailCount = -1;
        } else if (voicemailCount > 99) {
            voicemailCount = 99;
        }
        this.mPhone.setVoiceMessageCount(voicemailCount);
    }

    private int processCdmaWapPdu(byte[] pdu, int referenceNumber, String address, long timestamp) {
        int totalSegments;
        int segment;
        int msgType;
        int index = 0;
        if ((msgType = 0xFF & pdu[index++]) != 0) {
            this.log("Received a WAP SMS which is not WDP. Discard.");
            return 1;
        }
        if ((segment = 0xFF & pdu[index++]) >= (totalSegments = 0xFF & pdu[index++])) {
            this.loge("WDP bad segment #" + segment + " expecting 0-" + (totalSegments - 1));
            return 1;
        }
        int sourcePort = 0;
        int destinationPort = 0;
        if (segment == 0) {
            sourcePort = (0xFF & pdu[index++]) << 8;
            sourcePort |= 0xFF & pdu[index++];
            destinationPort = (0xFF & pdu[index++]) << 8;
            destinationPort |= 0xFF & pdu[index++];
            if (this.mCheckForDuplicatePortsInOmadmWapPush && CdmaInboundSmsHandler.checkDuplicatePortOmadmWapPush(pdu, index)) {
                index += 4;
            }
        }
        this.log("Received WAP PDU. Type = " + msgType + ", originator = " + address + ", src-port = " + sourcePort + ", dst-port = " + destinationPort + ", ID = " + referenceNumber + ", segment# = " + segment + '/' + totalSegments);
        byte[] userData = new byte[pdu.length - index];
        System.arraycopy((byte[])pdu, (int)index, (byte[])userData, (int)0, (int)(pdu.length - index));
        InboundSmsTracker tracker = TelephonyComponentFactory.getInstance().makeInboundSmsTracker(userData, timestamp, destinationPort, true, address, referenceNumber, segment, totalSegments, true, HexDump.toHexString(userData));
        return this.addTrackerToRawTableAndSendMessage(tracker, false);
    }

    private static boolean checkDuplicatePortOmadmWapPush(byte[] origPdu, int index) {
        byte[] omaPdu = new byte[origPdu.length - (index += 4)];
        System.arraycopy((byte[])origPdu, (int)index, (byte[])omaPdu, (int)0, (int)omaPdu.length);
        WspTypeDecoder pduDecoder = new WspTypeDecoder(omaPdu);
        int wspIndex = 2;
        if (!pduDecoder.decodeUintvarInteger(wspIndex)) {
            return false;
        }
        if (!pduDecoder.decodeContentType(wspIndex += pduDecoder.getDecodedDataLength())) {
            return false;
        }
        String mimeType = pduDecoder.getValueString();
        return "application/vnd.syncml.notification".equals(mimeType);
    }
}

