/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CdmaMmiCode
extends Handler
implements MmiCode {
    static final String LOG_TAG = "CdmaMmiCode";
    static final String ACTION_REGISTER = "**";
    static final String SC_PIN = "04";
    static final String SC_PIN2 = "042";
    static final String SC_PUK = "05";
    static final String SC_PUK2 = "052";
    static final int EVENT_SET_COMPLETE = 1;
    GsmCdmaPhone mPhone;
    Context mContext;
    UiccCardApplication mUiccApplication;
    String mAction;
    String mSc;
    String mSia;
    String mSib;
    String mSic;
    String mPoundString;
    String mDialingNumber;
    String mPwd;
    MmiCode.State mState = MmiCode.State.PENDING;
    CharSequence mMessage;
    static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    static final int MATCH_GROUP_POUND_STRING = 1;
    static final int MATCH_GROUP_ACTION = 2;
    static final int MATCH_GROUP_SERVICE_CODE = 3;
    static final int MATCH_GROUP_SIA = 5;
    static final int MATCH_GROUP_SIB = 7;
    static final int MATCH_GROUP_SIC = 9;
    static final int MATCH_GROUP_PWD_CONFIRM = 11;
    static final int MATCH_GROUP_DIALING_NUMBER = 12;

    public static CdmaMmiCode newFromDialString(String dialString, GsmCdmaPhone phone, UiccCardApplication app) {
        CdmaMmiCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new CdmaMmiCode(phone, app);
            ret.mPoundString = CdmaMmiCode.makeEmptyNull(m.group(1));
            ret.mAction = CdmaMmiCode.makeEmptyNull(m.group(2));
            ret.mSc = CdmaMmiCode.makeEmptyNull(m.group(3));
            ret.mSia = CdmaMmiCode.makeEmptyNull(m.group(5));
            ret.mSib = CdmaMmiCode.makeEmptyNull(m.group(7));
            ret.mSic = CdmaMmiCode.makeEmptyNull(m.group(9));
            ret.mPwd = CdmaMmiCode.makeEmptyNull(m.group(11));
            ret.mDialingNumber = CdmaMmiCode.makeEmptyNull(m.group(12));
        }
        return ret;
    }

    private static String makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    CdmaMmiCode(GsmCdmaPhone phone, UiccCardApplication app) {
        super(phone.getHandler().getLooper());
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mUiccApplication = app;
    }

    @Override
    public MmiCode.State getState() {
        return this.mState;
    }

    @Override
    public CharSequence getMessage() {
        return this.mMessage;
    }

    @Override
    public Phone getPhone() {
        return this.mPhone;
    }

    @Override
    public void cancel() {
        if (this.mState == MmiCode.State.COMPLETE || this.mState == MmiCode.State.FAILED) {
            return;
        }
        this.mState = MmiCode.State.CANCELLED;
        this.mPhone.onMMIDone(this);
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public boolean isPinPukCommand() {
        return this.mSc != null && (this.mSc.equals(SC_PIN) || this.mSc.equals(SC_PIN2) || this.mSc.equals(SC_PUK) || this.mSc.equals(SC_PUK2));
    }

    boolean isRegister() {
        return this.mAction != null && this.mAction.equals(ACTION_REGISTER);
    }

    @Override
    public boolean isUssdRequest() {
        Rlog.w(LOG_TAG, "isUssdRequest is not implemented in CdmaMmiCode");
        return false;
    }

    @Override
    public void processCode() {
        block11: {
            try {
                if (!this.isPinPukCommand()) break block11;
                String oldPinOrPuk = this.mSia;
                String newPinOrPuk = this.mSib;
                int pinLen = newPinOrPuk.length();
                if (this.isRegister()) {
                    if (!newPinOrPuk.equals(this.mSic)) {
                        this.handlePasswordError(17039530);
                        break block11;
                    }
                    if (pinLen < 4 || pinLen > 8) {
                        this.handlePasswordError(17039531);
                        break block11;
                    }
                    if (this.mSc.equals(SC_PIN) && this.mUiccApplication != null && this.mUiccApplication.getState() == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
                        this.handlePasswordError(17039533);
                        break block11;
                    }
                    if (this.mUiccApplication != null) {
                        Rlog.d(LOG_TAG, "process mmi service code using UiccApp sc=" + this.mSc);
                        if (this.mSc.equals(SC_PIN)) {
                            this.mUiccApplication.changeIccLockPassword(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                            break block11;
                        }
                        if (this.mSc.equals(SC_PIN2)) {
                            this.mUiccApplication.changeIccFdnPassword(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                            break block11;
                        }
                        if (this.mSc.equals(SC_PUK)) {
                            this.mUiccApplication.supplyPuk(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                            break block11;
                        }
                        if (this.mSc.equals(SC_PUK2)) {
                            this.mUiccApplication.supplyPuk2(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                            break block11;
                        }
                        throw new RuntimeException("Unsupported service code=" + this.mSc);
                    }
                    throw new RuntimeException("No application mUiccApplicaiton is null");
                }
                throw new RuntimeException("Ivalid register/action=" + this.mAction);
            }
            catch (RuntimeException exc) {
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.mContext.getText(17039519);
                this.mPhone.onMMIDone(this);
            }
        }
    }

    private void handlePasswordError(int res) {
        this.mState = MmiCode.State.FAILED;
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        sb.append(this.mContext.getText(res));
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    @Override
    public void handleMessage(Message msg) {
        if (msg.what == 1) {
            AsyncResult ar = (AsyncResult)msg.obj;
            this.onSetComplete(msg, ar);
        } else {
            Rlog.e(LOG_TAG, "Unexpected reply");
        }
    }

    private CharSequence getScString() {
        if (this.mSc != null && this.isPinPukCommand()) {
            return this.mContext.getText(17039546);
        }
        return "";
    }

    private void onSetComplete(Message msg, AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException.Error err = ((CommandException)ar.exception).getCommandError();
                if (err == CommandException.Error.PASSWORD_INCORRECT) {
                    if (this.isPinPukCommand()) {
                        if (this.mSc.equals(SC_PUK) || this.mSc.equals(SC_PUK2)) {
                            sb.append(this.mContext.getText(17039529));
                        } else {
                            sb.append(this.mContext.getText(17039528));
                        }
                        int attemptsRemaining = msg.arg1;
                        if (attemptsRemaining <= 0) {
                            Rlog.d(LOG_TAG, "onSetComplete: PUK locked, cancel as lock screen will handle this");
                            this.mState = MmiCode.State.CANCELLED;
                        } else if (attemptsRemaining > 0) {
                            Rlog.d(LOG_TAG, "onSetComplete: attemptsRemaining=" + attemptsRemaining);
                            sb.append(this.mContext.getResources().getQuantityString(0x1140000, attemptsRemaining, attemptsRemaining));
                        }
                    } else {
                        sb.append(this.mContext.getText(17039526));
                    }
                } else if (err == CommandException.Error.SIM_PUK2) {
                    sb.append(this.mContext.getText(17039528));
                    sb.append("\n");
                    sb.append(this.mContext.getText(17039534));
                } else if (err == CommandException.Error.REQUEST_NOT_SUPPORTED) {
                    if (this.mSc.equals(SC_PIN)) {
                        sb.append(this.mContext.getText(17039535));
                    }
                } else {
                    sb.append(this.mContext.getText(17039519));
                }
            } else {
                sb.append(this.mContext.getText(17039519));
            }
        } else if (this.isRegister()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17039524));
        } else {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.mContext.getText(17039519));
        }
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }
}

