/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.PendingIntent;
import android.content.Context;
import android.net.LinkProperties;
import android.net.NetworkAgent;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.ProxyInfo;
import android.os.AsyncResult;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Patterns;
import android.util.TimeUtils;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CarrierSignalAgent;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcController;
import com.android.internal.telephony.dataconnection.DcFailCause;
import com.android.internal.telephony.dataconnection.DcTesterFailBringUpAll;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class DataConnection
extends StateMachine {
    private static final boolean DBG = true;
    private static final boolean VDBG = true;
    private static final String NETWORK_TYPE = "MOBILE";
    private DcController mDcController;
    private DcTesterFailBringUpAll mDcTesterFailBringUpAll;
    private static AtomicInteger mInstanceNumber = new AtomicInteger(0);
    private AsyncChannel mAc;
    private DcTracker mDct = null;
    protected String[] mPcscfAddr;
    private ApnSetting mApnSetting;
    private ConnectionParams mConnectionParams;
    private DisconnectParams mDisconnectParams;
    private DcFailCause mDcFailCause;
    private Phone mPhone;
    private LinkProperties mLinkProperties = new LinkProperties();
    private long mCreateTime;
    private long mLastFailTime;
    private DcFailCause mLastFailCause;
    private static final String NULL_IP = "0.0.0.0";
    private Object mUserData;
    private int mRilRat = Integer.MAX_VALUE;
    private int mDataRegState = Integer.MAX_VALUE;
    private NetworkInfo mNetworkInfo;
    private NetworkAgent mNetworkAgent;
    int mTag;
    public int mCid;
    public HashMap<ApnContext, ConnectionParams> mApnContexts = null;
    PendingIntent mReconnectIntent = null;
    static final int BASE = 262144;
    static final int EVENT_CONNECT = 262144;
    static final int EVENT_SETUP_DATA_CONNECTION_DONE = 262145;
    static final int EVENT_GET_LAST_FAIL_DONE = 262146;
    static final int EVENT_DEACTIVATE_DONE = 262147;
    static final int EVENT_DISCONNECT = 262148;
    static final int EVENT_RIL_CONNECTED = 262149;
    static final int EVENT_DISCONNECT_ALL = 262150;
    static final int EVENT_DATA_STATE_CHANGED = 262151;
    static final int EVENT_TEAR_DOWN_NOW = 262152;
    static final int EVENT_LOST_CONNECTION = 262153;
    static final int EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED = 262155;
    static final int EVENT_DATA_CONNECTION_ROAM_ON = 262156;
    static final int EVENT_DATA_CONNECTION_ROAM_OFF = 262157;
    static final int EVENT_BW_REFRESH_RESPONSE = 262158;
    static final int EVENT_DATA_CONNECTION_VOICE_CALL_STARTED = 262159;
    static final int EVENT_DATA_CONNECTION_VOICE_CALL_ENDED = 262160;
    private static final int CMD_TO_STRING_COUNT = 17;
    private static String[] sCmdToString = new String[17];
    private int mId;
    private static final String TCP_BUFFER_SIZES_GPRS = "4092,8760,48000,4096,8760,48000";
    private static final String TCP_BUFFER_SIZES_EDGE = "4093,26280,70800,4096,16384,70800";
    private static final String TCP_BUFFER_SIZES_UMTS = "58254,349525,1048576,58254,349525,1048576";
    private static final String TCP_BUFFER_SIZES_1XRTT = "16384,32768,131072,4096,16384,102400";
    private static final String TCP_BUFFER_SIZES_EVDO = "4094,87380,262144,4096,16384,262144";
    private static final String TCP_BUFFER_SIZES_EHRPD = "131072,262144,1048576,4096,16384,524288";
    private static final String TCP_BUFFER_SIZES_HSDPA = "61167,367002,1101005,8738,52429,262114";
    private static final String TCP_BUFFER_SIZES_HSPA = "40778,244668,734003,16777,100663,301990";
    private static final String TCP_BUFFER_SIZES_LTE = "524288,1048576,2097152,262144,524288,1048576";
    private static final String TCP_BUFFER_SIZES_HSPAP = "122334,734003,2202010,32040,192239,576717";
    private boolean mRestrictedNetworkOverride = false;
    private DcDefaultState mDefaultState = new DcDefaultState();
    private DcInactiveState mInactiveState = new DcInactiveState();
    private DcActivatingState mActivatingState = new DcActivatingState();
    private DcActiveState mActiveState = new DcActiveState();
    private DcDisconnectingState mDisconnectingState = new DcDisconnectingState();
    private DcDisconnectionErrorCreatingConnection mDisconnectingErrorCreatingConnection = new DcDisconnectionErrorCreatingConnection();

    static String cmdToString(int cmd) {
        String value;
        if ((value = (cmd -= 262144) >= 0 && cmd < sCmdToString.length ? sCmdToString[cmd] : DcAsyncChannel.cmdToString(cmd + 262144)) == null) {
            value = "0x" + Integer.toHexString(cmd + 262144);
        }
        return value;
    }

    public static DataConnection makeDataConnection(Phone phone, int id2, DcTracker dct, DcTesterFailBringUpAll failBringUpAll, DcController dcc) {
        DataConnection dc = new DataConnection(phone, "DC-" + mInstanceNumber.incrementAndGet(), id2, dct, failBringUpAll, dcc);
        dc.start();
        dc.log("Made " + dc.getName());
        return dc;
    }

    void dispose() {
        this.log("dispose: call quiteNow()");
        this.quitNow();
    }

    NetworkCapabilities getCopyNetworkCapabilities() {
        return this.makeNetworkCapabilities();
    }

    LinkProperties getCopyLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    boolean getIsInactive() {
        return this.getCurrentState() == this.mInactiveState;
    }

    int getCid() {
        return this.mCid;
    }

    ApnSetting getApnSetting() {
        return this.mApnSetting;
    }

    void setLinkPropertiesHttpProxy(ProxyInfo proxy) {
        this.mLinkProperties.setHttpProxy(proxy);
    }

    public boolean isIpv4Connected() {
        boolean ret = false;
        List<InetAddress> addresses = this.mLinkProperties.getAddresses();
        for (InetAddress addr : addresses) {
            Inet4Address i4addr;
            if (!(addr instanceof Inet4Address) || (i4addr = (Inet4Address)addr).isAnyLocalAddress() || i4addr.isLinkLocalAddress() || i4addr.isLoopbackAddress() || i4addr.isMulticastAddress()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean isIpv6Connected() {
        boolean ret = false;
        List<InetAddress> addresses = this.mLinkProperties.getAddresses();
        for (InetAddress addr : addresses) {
            Inet6Address i6addr;
            if (!(addr instanceof Inet6Address) || (i6addr = (Inet6Address)addr).isAnyLocalAddress() || i6addr.isLinkLocalAddress() || i6addr.isLoopbackAddress() || i6addr.isMulticastAddress()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public UpdateLinkPropertyResult updateLinkProperty(DataCallResponse newState) {
        UpdateLinkPropertyResult result = new UpdateLinkPropertyResult(this.mLinkProperties);
        if (newState == null) {
            return result;
        }
        result.newLp = new LinkProperties();
        result.setupResult = this.setLinkProperties(newState, result.newLp);
        if (result.setupResult != DataCallResponse.SetupResult.SUCCESS) {
            this.log("updateLinkProperty failed : " + (Object)((Object)result.setupResult));
            return result;
        }
        result.newLp.setHttpProxy(this.mLinkProperties.getHttpProxy());
        this.checkSetMtu(this.mApnSetting, result.newLp);
        this.mLinkProperties = result.newLp;
        this.updateTcpBufferSizes(this.mRilRat);
        if (!result.oldLp.equals(result.newLp)) {
            this.log("updateLinkProperty old LP=" + result.oldLp);
            this.log("updateLinkProperty new LP=" + result.newLp);
        }
        if (!result.newLp.equals(result.oldLp) && this.mNetworkAgent != null) {
            this.mNetworkAgent.sendLinkProperties(this.mLinkProperties);
        }
        return result;
    }

    private void checkSetMtu(ApnSetting apn, LinkProperties lp) {
        if (lp == null) {
            return;
        }
        if (apn == null || lp == null) {
            return;
        }
        if (lp.getMtu() != 0) {
            this.log("MTU set by call response to: " + lp.getMtu());
            return;
        }
        if (apn != null && apn.mtu != 0) {
            lp.setMtu(apn.mtu);
            this.log("MTU set by APN to: " + apn.mtu);
            return;
        }
        int mtu = this.mPhone.getContext().getResources().getInteger(17694863);
        if (mtu != 0) {
            lp.setMtu(mtu);
            this.log("MTU set by config resource to: " + mtu);
        }
    }

    private DataConnection(Phone phone, String name, int id2, DcTracker dct, DcTesterFailBringUpAll failBringUpAll, DcController dcc) {
        super(name, dcc.getHandler());
        this.setLogRecSize(300);
        this.setLogOnlyTransitions(true);
        this.log("DataConnection created");
        this.mPhone = phone;
        this.mDct = dct;
        this.mDcTesterFailBringUpAll = failBringUpAll;
        this.mDcController = dcc;
        this.mId = id2;
        this.mCid = -1;
        ServiceState ss = this.mPhone.getServiceState();
        this.mRilRat = ss.getRilDataRadioTechnology();
        this.mDataRegState = this.mPhone.getServiceState().getDataRegState();
        int networkType = ss.getDataNetworkType();
        this.mNetworkInfo = new NetworkInfo(0, networkType, NETWORK_TYPE, TelephonyManager.getNetworkTypeName(networkType));
        this.mNetworkInfo.setRoaming(ss.getDataRoaming());
        this.mNetworkInfo.setIsAvailable(true);
        this.mNetworkInfo.setMetered(true);
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActivatingState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.addState(this.mDisconnectingState, this.mDefaultState);
        this.addState(this.mDisconnectingErrorCreatingConnection, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
        this.mApnContexts = new HashMap();
    }

    private void onConnect(ConnectionParams cp) {
        this.log("onConnect: carrier='" + this.mApnSetting.carrier + "' APN='" + this.mApnSetting.apn + "' proxy='" + this.mApnSetting.proxy + "' port='" + this.mApnSetting.port + "'");
        if (cp.mApnContext != null) {
            cp.mApnContext.requestLog("DataConnection.onConnect");
        }
        if (this.mDcTesterFailBringUpAll.getDcFailBringUp().mCounter > 0) {
            DataCallResponse response = new DataCallResponse();
            response.version = this.mPhone.mCi.getRilVersion();
            response.status = this.mDcTesterFailBringUpAll.getDcFailBringUp().mFailCause.getErrorCode();
            response.cid = 0;
            response.active = 0;
            response.type = "";
            response.ifname = "";
            response.addresses = new String[0];
            response.dnses = new String[0];
            response.gateways = new String[0];
            response.suggestedRetryTime = this.mDcTesterFailBringUpAll.getDcFailBringUp().mSuggestedRetryTime;
            response.pcscf = new String[0];
            response.mtu = 0;
            Message msg = this.obtainMessage(262145, cp);
            AsyncResult.forMessage(msg, response, null);
            this.sendMessage(msg);
            this.log("onConnect: FailBringUpAll=" + this.mDcTesterFailBringUpAll.getDcFailBringUp() + " send error response=" + response);
            --this.mDcTesterFailBringUpAll.getDcFailBringUp().mCounter;
            return;
        }
        this.mCreateTime = -1L;
        this.mLastFailTime = -1L;
        this.mLastFailCause = DcFailCause.NONE;
        Message msg = this.obtainMessage(262145, cp);
        msg.obj = cp;
        int authType = this.mApnSetting.authType;
        if (authType == -1) {
            authType = TextUtils.isEmpty(this.mApnSetting.user) ? 0 : 3;
        }
        String protocol = this.mPhone.getServiceState().getDataRoamingFromRegistration() ? this.mApnSetting.roamingProtocol : this.mApnSetting.protocol;
        this.mPhone.mCi.setupDataCall(cp.mRilRat, cp.mProfileId, this.mApnSetting.apn, this.mApnSetting.user, this.mApnSetting.password, authType, protocol, msg);
    }

    private void tearDownData(Object o) {
        String str;
        int discReason = 0;
        ApnContext apnContext = null;
        if (o != null && o instanceof DisconnectParams) {
            DisconnectParams dp = (DisconnectParams)o;
            apnContext = dp.mApnContext;
            if (TextUtils.equals(dp.mReason, "radioTurnedOff")) {
                discReason = 1;
            } else if (TextUtils.equals(dp.mReason, "pdpReset")) {
                discReason = 2;
            }
        }
        if (this.mPhone.mCi.getRadioState().isOn() || this.mPhone.getServiceState().getRilDataRadioTechnology() == 18) {
            str = "tearDownData radio is on, call deactivateDataCall";
            this.log(str);
            if (apnContext != null) {
                apnContext.requestLog(str);
            }
            this.mPhone.mCi.deactivateDataCall(this.mCid, discReason, this.obtainMessage(262147, this.mTag, 0, o));
        } else {
            str = "tearDownData radio is off sendMessage EVENT_DEACTIVATE_DONE immediately";
            this.log(str);
            if (apnContext != null) {
                apnContext.requestLog(str);
            }
            AsyncResult ar = new AsyncResult(o, null, null);
            this.sendMessage(this.obtainMessage(262147, this.mTag, 0, ar));
        }
    }

    private void notifyAllWithEvent(ApnContext alreadySent, int event, String reason) {
        this.mNetworkInfo.setDetailedState(this.mNetworkInfo.getDetailedState(), reason, this.mNetworkInfo.getExtraInfo());
        for (ConnectionParams cp : this.mApnContexts.values()) {
            ApnContext apnContext = cp.mApnContext;
            if (apnContext == alreadySent) continue;
            if (reason != null) {
                apnContext.setReason(reason);
            }
            Pair<ApnContext, Integer> pair = new Pair<ApnContext, Integer>(apnContext, cp.mConnectionGeneration);
            Message msg = this.mDct.obtainMessage(event, pair);
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
    }

    private void notifyAllOfConnected(String reason) {
        this.notifyAllWithEvent(null, 270336, reason);
    }

    private void notifyAllOfDisconnectDcRetrying(String reason) {
        this.notifyAllWithEvent(null, 270370, reason);
    }

    private void notifyAllDisconnectCompleted(DcFailCause cause) {
        this.notifyAllWithEvent(null, 270351, cause.toString());
    }

    private void notifyConnectCompleted(ConnectionParams cp, DcFailCause cause, boolean sendAll) {
        ApnContext alreadySent = null;
        if (cp != null && cp.mOnCompletedMsg != null) {
            Message connectionCompletedMsg = cp.mOnCompletedMsg;
            cp.mOnCompletedMsg = null;
            alreadySent = cp.mApnContext;
            long timeStamp = System.currentTimeMillis();
            connectionCompletedMsg.arg1 = this.mCid;
            if (cause == DcFailCause.NONE) {
                this.mCreateTime = timeStamp;
                AsyncResult.forMessage(connectionCompletedMsg);
            } else {
                this.mLastFailCause = cause;
                this.mLastFailTime = timeStamp;
                if (cause == null) {
                    cause = DcFailCause.UNKNOWN;
                }
                AsyncResult.forMessage(connectionCompletedMsg, (Object)cause, new Throwable(cause.toString()));
            }
            this.log("notifyConnectCompleted at " + timeStamp + " cause=" + (Object)((Object)cause) + " connectionCompletedMsg=" + DataConnection.msgToString(connectionCompletedMsg));
            connectionCompletedMsg.sendToTarget();
        }
        if (sendAll) {
            this.log("Send to all. " + alreadySent + " " + cause.toString());
            this.notifyAllWithEvent(alreadySent, 270371, cause.toString());
        }
    }

    private void notifyDisconnectCompleted(DisconnectParams dp, boolean sendAll) {
        this.log("NotifyDisconnectCompleted");
        ApnContext alreadySent = null;
        String reason = null;
        if (dp != null && dp.mOnCompletedMsg != null) {
            Message msg = dp.mOnCompletedMsg;
            dp.mOnCompletedMsg = null;
            if (msg.obj instanceof ApnContext) {
                alreadySent = (ApnContext)msg.obj;
            }
            reason = dp.mReason;
            this.log(String.format("msg=%s msg.obj=%s", msg.toString(), msg.obj instanceof String ? (String)msg.obj : "<no-reason>"));
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
        if (sendAll) {
            if (reason == null) {
                reason = DcFailCause.UNKNOWN.toString();
            }
            this.notifyAllWithEvent(alreadySent, 270351, reason);
        }
        this.log("NotifyDisconnectCompleted DisconnectParams=" + dp);
    }

    public int getDataConnectionId() {
        return this.mId;
    }

    private void clearSettings() {
        this.log("clearSettings");
        this.mCreateTime = -1L;
        this.mLastFailTime = -1L;
        this.mLastFailCause = DcFailCause.NONE;
        this.mCid = -1;
        this.mPcscfAddr = new String[5];
        this.mLinkProperties = new LinkProperties();
        this.mApnContexts.clear();
        this.mApnSetting = null;
        this.mDcFailCause = null;
    }

    private DataCallResponse.SetupResult onSetupConnectionCompleted(AsyncResult ar) {
        DataCallResponse.SetupResult result;
        DataCallResponse response = (DataCallResponse)ar.result;
        ConnectionParams cp = (ConnectionParams)ar.userObj;
        if (cp.mTag != this.mTag) {
            this.log("onSetupConnectionCompleted stale cp.tag=" + cp.mTag + ", mtag=" + this.mTag);
            result = DataCallResponse.SetupResult.ERR_Stale;
        } else if (ar.exception != null) {
            this.log("onSetupConnectionCompleted failed, ar.exception=" + ar.exception + " response=" + response);
            if (ar.exception instanceof CommandException && ((CommandException)ar.exception).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE) {
                result = DataCallResponse.SetupResult.ERR_BadCommand;
                result.mFailCause = DcFailCause.RADIO_NOT_AVAILABLE;
            } else if (response == null || response.version < 4) {
                result = DataCallResponse.SetupResult.ERR_GetLastErrorFromRil;
            } else {
                result = DataCallResponse.SetupResult.ERR_RilError;
                result.mFailCause = DcFailCause.fromInt(response.status);
            }
        } else if (response.status != 0) {
            result = DataCallResponse.SetupResult.ERR_RilError;
            result.mFailCause = DcFailCause.fromInt(response.status);
        } else {
            this.log("onSetupConnectionCompleted received successful DataCallResponse");
            this.mCid = response.cid;
            this.mPcscfAddr = response.pcscf;
            result = this.updateLinkProperty((DataCallResponse)response).setupResult;
        }
        return result;
    }

    private boolean isDnsOk(String[] domainNameServers) {
        if (!(!NULL_IP.equals(domainNameServers[0]) || !NULL_IP.equals(domainNameServers[1]) || this.mPhone.isDnsCheckDisabled() || this.mApnSetting.types[0].equals("mms") && this.isIpAddress(this.mApnSetting.mmsProxy))) {
            this.log(String.format("isDnsOk: return false apn.types[0]=%s APN_TYPE_MMS=%s isIpAddress(%s)=%s", this.mApnSetting.types[0], "mms", this.mApnSetting.mmsProxy, this.isIpAddress(this.mApnSetting.mmsProxy)));
            return false;
        }
        return true;
    }

    private void updateTcpBufferSizes(int rilRat) {
        String sizes = null;
        if (rilRat == 19) {
            rilRat = 14;
        }
        String ratName = ServiceState.rilRadioTechnologyToString(rilRat).toLowerCase(Locale.ROOT);
        if (rilRat == 7 || rilRat == 8 || rilRat == 12) {
            ratName = "evdo";
        }
        String[] configOverride = this.mPhone.getContext().getResources().getStringArray(17236019);
        for (int i = 0; i < configOverride.length; ++i) {
            String[] split = configOverride[i].split(":");
            if (!ratName.equals(split[0]) || split.length != 2) continue;
            sizes = split[1];
            break;
        }
        if (sizes == null) {
            switch (rilRat) {
                case 1: {
                    sizes = TCP_BUFFER_SIZES_GPRS;
                    break;
                }
                case 2: {
                    sizes = TCP_BUFFER_SIZES_EDGE;
                    break;
                }
                case 3: {
                    sizes = TCP_BUFFER_SIZES_UMTS;
                    break;
                }
                case 6: {
                    sizes = TCP_BUFFER_SIZES_1XRTT;
                    break;
                }
                case 7: 
                case 8: 
                case 12: {
                    sizes = TCP_BUFFER_SIZES_EVDO;
                    break;
                }
                case 13: {
                    sizes = TCP_BUFFER_SIZES_EHRPD;
                    break;
                }
                case 9: {
                    sizes = TCP_BUFFER_SIZES_HSDPA;
                    break;
                }
                case 10: 
                case 11: {
                    sizes = TCP_BUFFER_SIZES_HSPA;
                    break;
                }
                case 14: 
                case 19: {
                    sizes = TCP_BUFFER_SIZES_LTE;
                    break;
                }
                case 15: {
                    sizes = TCP_BUFFER_SIZES_HSPAP;
                    break;
                }
            }
        }
        this.mLinkProperties.setTcpBufferSizes(sizes);
    }

    private void setNetworkRestriction() {
        this.mRestrictedNetworkOverride = false;
        boolean noRestrictedRequests = true;
        for (ApnContext apnContext : this.mApnContexts.keySet()) {
            noRestrictedRequests &= apnContext.hasNoRestrictedRequests(true);
        }
        if (noRestrictedRequests) {
            return;
        }
        if (!this.mApnSetting.isMetered(this.mPhone.getContext(), this.mPhone.getSubId(), this.mPhone.getServiceState().getDataRoaming())) {
            return;
        }
        this.mRestrictedNetworkOverride = !this.mDct.isDataEnabled(true);
    }

    private NetworkCapabilities makeNetworkCapabilities() {
        NetworkCapabilities result = new NetworkCapabilities();
        result.addTransportType(0);
        if (this.mApnSetting != null) {
            String[] stringArray = this.mApnSetting.types;
            int n = stringArray.length;
            block41: for (int i = 0; i < n; ++i) {
                String type;
                switch (type = stringArray[i]) {
                    case "*": {
                        result.addCapability(12);
                        result.addCapability(0);
                        result.addCapability(1);
                        result.addCapability(3);
                        result.addCapability(4);
                        result.addCapability(5);
                        result.addCapability(7);
                        continue block41;
                    }
                    case "default": {
                        result.addCapability(12);
                        continue block41;
                    }
                    case "mms": {
                        result.addCapability(0);
                        continue block41;
                    }
                    case "supl": {
                        result.addCapability(1);
                        continue block41;
                    }
                    case "dun": {
                        ApnSetting securedDunApn = this.mDct.fetchDunApn();
                        if (securedDunApn != null && !securedDunApn.equals(this.mApnSetting)) continue block41;
                        result.addCapability(2);
                        continue block41;
                    }
                    case "fota": {
                        result.addCapability(3);
                        continue block41;
                    }
                    case "ims": {
                        result.addCapability(4);
                        continue block41;
                    }
                    case "cbs": {
                        result.addCapability(5);
                        continue block41;
                    }
                    case "ia": {
                        result.addCapability(7);
                        continue block41;
                    }
                    case "emergency": {
                        result.addCapability(10);
                        continue block41;
                    }
                }
            }
            if (!this.mApnSetting.isMetered(this.mPhone.getContext(), this.mPhone.getSubId(), this.mPhone.getServiceState().getDataRoaming())) {
                result.addCapability(11);
                this.mNetworkInfo.setMetered(false);
            } else {
                result.removeCapability(11);
                this.mNetworkInfo.setMetered(true);
            }
            result.maybeMarkCapabilitiesRestricted();
        }
        if (this.mRestrictedNetworkOverride) {
            result.removeCapability(13);
            result.removeCapability(2);
        }
        int up = 14;
        int down = 14;
        switch (this.mRilRat) {
            case 1: {
                up = 80;
                down = 80;
                break;
            }
            case 2: {
                up = 59;
                down = 236;
                break;
            }
            case 3: {
                up = 384;
                down = 384;
                break;
            }
            case 4: 
            case 5: {
                up = 14;
                down = 14;
                break;
            }
            case 7: {
                up = 153;
                down = 2457;
                break;
            }
            case 8: {
                up = 1843;
                down = 3174;
                break;
            }
            case 6: {
                up = 100;
                down = 100;
                break;
            }
            case 9: {
                up = 2048;
                down = 14336;
                break;
            }
            case 10: {
                up = 5898;
                down = 14336;
                break;
            }
            case 11: {
                up = 5898;
                down = 14336;
                break;
            }
            case 12: {
                up = 1843;
                down = 5017;
                break;
            }
            case 14: {
                up = 51200;
                down = 102400;
                break;
            }
            case 19: {
                up = 51200;
                down = 102400;
                break;
            }
            case 13: {
                up = 153;
                down = 2516;
                break;
            }
            case 15: {
                up = 11264;
                down = 43008;
                break;
            }
        }
        result.setLinkUpstreamBandwidthKbps(up);
        result.setLinkDownstreamBandwidthKbps(down);
        result.setNetworkSpecifier(Integer.toString(this.mPhone.getSubId()));
        return result;
    }

    private boolean isIpAddress(String address) {
        if (address == null) {
            return false;
        }
        return Patterns.IP_ADDRESS.matcher(address).matches();
    }

    private DataCallResponse.SetupResult setLinkProperties(DataCallResponse response, LinkProperties lp) {
        boolean okToUseSystemPropertyDns = false;
        String propertyPrefix = "net." + response.ifname + ".";
        String[] dnsServers = new String[]{SystemProperties.get(propertyPrefix + "dns1"), SystemProperties.get(propertyPrefix + "dns2")};
        okToUseSystemPropertyDns = this.isDnsOk(dnsServers);
        return response.setLinkProperties(lp, okToUseSystemPropertyDns);
    }

    private boolean initConnection(ConnectionParams cp) {
        ApnContext apnContext = cp.mApnContext;
        if (this.mApnSetting == null) {
            this.mApnSetting = apnContext.getApnSetting();
        }
        if (this.mApnSetting == null || !this.mApnSetting.canHandleType(apnContext.getApnType())) {
            this.log("initConnection: incompatible apnSetting in ConnectionParams cp=" + cp + " dc=" + this);
            return false;
        }
        ++this.mTag;
        this.mConnectionParams = cp;
        this.mConnectionParams.mTag = this.mTag;
        this.mApnContexts.put(apnContext, cp);
        this.log("initConnection:  RefCount=" + this.mApnContexts.size() + " mApnList=" + this.mApnContexts + " mConnectionParams=" + this.mConnectionParams);
        return true;
    }

    private boolean updateNetworkInfoSuspendState() {
        ServiceStateTracker sst;
        NetworkInfo.DetailedState oldState = this.mNetworkInfo.getDetailedState();
        if (this.mNetworkAgent == null) {
            Rlog.e(this.getName(), "Setting suspend state without a NetworkAgent");
        }
        if ((sst = this.mPhone.getServiceStateTracker()).getCurrentDataConnectionState() != 0) {
            this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, null, this.mNetworkInfo.getExtraInfo());
        } else {
            CallTracker ct;
            if (!sst.isConcurrentVoiceAndDataAllowed() && (ct = this.mPhone.getCallTracker()).getState() != PhoneConstants.State.IDLE) {
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, null, this.mNetworkInfo.getExtraInfo());
                return oldState != NetworkInfo.DetailedState.SUSPENDED;
            }
            this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, this.mNetworkInfo.getExtraInfo());
        }
        return oldState != this.mNetworkInfo.getDetailedState();
    }

    void tearDownNow() {
        this.log("tearDownNow()");
        this.sendMessage(this.obtainMessage(262152));
    }

    private long getSuggestedRetryDelay(AsyncResult ar) {
        DataCallResponse response = (DataCallResponse)ar.result;
        if (response.suggestedRetryTime < 0) {
            this.log("No suggested retry delay.");
            return -2L;
        }
        if (response.suggestedRetryTime == Integer.MAX_VALUE) {
            this.log("Modem suggested not retrying.");
            return -1L;
        }
        return response.suggestedRetryTime;
    }

    @Override
    protected String getWhatToString(int what) {
        return DataConnection.cmdToString(what);
    }

    private static String msgToString(Message msg) {
        String retVal;
        if (msg == null) {
            retVal = "null";
        } else {
            StringBuilder b = new StringBuilder();
            b.append("{what=");
            b.append(DataConnection.cmdToString(msg.what));
            b.append(" when=");
            TimeUtils.formatDuration(msg.getWhen() - SystemClock.uptimeMillis(), b);
            if (msg.arg1 != 0) {
                b.append(" arg1=");
                b.append(msg.arg1);
            }
            if (msg.arg2 != 0) {
                b.append(" arg2=");
                b.append(msg.arg2);
            }
            if (msg.obj != null) {
                b.append(" obj=");
                b.append(msg.obj);
            }
            b.append(" target=");
            b.append(msg.getTarget());
            b.append(" replyTo=");
            b.append(msg.replyTo);
            b.append("}");
            retVal = b.toString();
        }
        return retVal;
    }

    static void slog(String s) {
        Rlog.d("DC", s);
    }

    @Override
    protected void log(String s) {
        Rlog.d(this.getName(), s);
    }

    @Override
    protected void logd(String s) {
        Rlog.d(this.getName(), s);
    }

    @Override
    protected void logv(String s) {
        Rlog.v(this.getName(), s);
    }

    @Override
    protected void logi(String s) {
        Rlog.i(this.getName(), s);
    }

    @Override
    protected void logw(String s) {
        Rlog.w(this.getName(), s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e(this.getName(), s);
    }

    @Override
    protected void loge(String s, Throwable e) {
        Rlog.e(this.getName(), s, e);
    }

    public String toStringSimple() {
        return this.getName() + ": State=" + this.getCurrentState().getName() + " mApnSetting=" + this.mApnSetting + " RefCount=" + this.mApnContexts.size() + " mCid=" + this.mCid + " mCreateTime=" + this.mCreateTime + " mLastastFailTime=" + this.mLastFailTime + " mLastFailCause=" + (Object)((Object)this.mLastFailCause) + " mTag=" + this.mTag + " mLinkProperties=" + this.mLinkProperties + " linkCapabilities=" + this.makeNetworkCapabilities() + " mRestrictedNetworkOverride=" + this.mRestrictedNetworkOverride;
    }

    @Override
    public String toString() {
        return "{" + this.toStringSimple() + " mApnContexts=" + this.mApnContexts + "}";
    }

    private void dumpToLog() {
        this.dump(null, new PrintWriter(new StringWriter(0)){

            @Override
            public void println(String s) {
                DataConnection.this.logd(s);
            }

            @Override
            public void flush() {
            }
        }, null);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.print("DataConnection ");
        super.dump(fd, pw, args);
        pw.println(" mApnContexts.size=" + this.mApnContexts.size());
        pw.println(" mApnContexts=" + this.mApnContexts);
        pw.flush();
        pw.println(" mDataConnectionTracker=" + this.mDct);
        pw.println(" mApnSetting=" + this.mApnSetting);
        pw.println(" mTag=" + this.mTag);
        pw.println(" mCid=" + this.mCid);
        pw.println(" mConnectionParams=" + this.mConnectionParams);
        pw.println(" mDisconnectParams=" + this.mDisconnectParams);
        pw.println(" mDcFailCause=" + (Object)((Object)this.mDcFailCause));
        pw.flush();
        pw.println(" mPhone=" + this.mPhone);
        pw.flush();
        pw.println(" mLinkProperties=" + this.mLinkProperties);
        pw.flush();
        pw.println(" mDataRegState=" + this.mDataRegState);
        pw.println(" mRilRat=" + this.mRilRat);
        pw.println(" mNetworkCapabilities=" + this.makeNetworkCapabilities());
        pw.println(" mCreateTime=" + TimeUtils.logTimeOfDay(this.mCreateTime));
        pw.println(" mLastFailTime=" + TimeUtils.logTimeOfDay(this.mLastFailTime));
        pw.println(" mLastFailCause=" + (Object)((Object)this.mLastFailCause));
        pw.flush();
        pw.println(" mUserData=" + this.mUserData);
        pw.println(" mInstanceNumber=" + mInstanceNumber);
        pw.println(" mAc=" + this.mAc);
        pw.flush();
    }

    static {
        DataConnection.sCmdToString[0] = "EVENT_CONNECT";
        DataConnection.sCmdToString[1] = "EVENT_SETUP_DATA_CONNECTION_DONE";
        DataConnection.sCmdToString[2] = "EVENT_GET_LAST_FAIL_DONE";
        DataConnection.sCmdToString[3] = "EVENT_DEACTIVATE_DONE";
        DataConnection.sCmdToString[4] = "EVENT_DISCONNECT";
        DataConnection.sCmdToString[5] = "EVENT_RIL_CONNECTED";
        DataConnection.sCmdToString[6] = "EVENT_DISCONNECT_ALL";
        DataConnection.sCmdToString[7] = "EVENT_DATA_STATE_CHANGED";
        DataConnection.sCmdToString[8] = "EVENT_TEAR_DOWN_NOW";
        DataConnection.sCmdToString[9] = "EVENT_LOST_CONNECTION";
        DataConnection.sCmdToString[11] = "EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED";
        DataConnection.sCmdToString[12] = "EVENT_DATA_CONNECTION_ROAM_ON";
        DataConnection.sCmdToString[13] = "EVENT_DATA_CONNECTION_ROAM_OFF";
        DataConnection.sCmdToString[14] = "EVENT_BW_REFRESH_RESPONSE";
        DataConnection.sCmdToString[15] = "EVENT_DATA_CONNECTION_VOICE_CALL_STARTED";
        DataConnection.sCmdToString[16] = "EVENT_DATA_CONNECTION_VOICE_CALL_ENDED";
    }

    private class DcNetworkAgent
    extends NetworkAgent {
        public DcNetworkAgent(Looper l, Context c, String TAG, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score, NetworkMisc misc) {
            super(l, c, TAG, ni, nc, lp, score, misc);
        }

        @Override
        protected void unwanted() {
            if (DataConnection.this.mNetworkAgent != this) {
                this.log("DcNetworkAgent: unwanted found mNetworkAgent=" + DataConnection.this.mNetworkAgent + ", which isn't me.  Aborting unwanted");
                return;
            }
            if (DataConnection.this.mApnContexts == null) {
                return;
            }
            for (ConnectionParams cp : DataConnection.this.mApnContexts.values()) {
                ApnContext apnContext = cp.mApnContext;
                Pair<ApnContext, Integer> pair = new Pair<ApnContext, Integer>(apnContext, cp.mConnectionGeneration);
                this.log("DcNetworkAgent: [unwanted]: disconnect apnContext=" + apnContext);
                Message msg = DataConnection.this.mDct.obtainMessage(270351, pair);
                DisconnectParams dp = new DisconnectParams(apnContext, apnContext.getReason(), msg);
                DataConnection.this.sendMessage(DataConnection.this.obtainMessage(262148, dp));
            }
        }

        @Override
        protected void pollLceData() {
            if (DataConnection.this.mPhone.getLceStatus() == 1) {
                ((DataConnection)DataConnection.this).mPhone.mCi.pullLceData(DataConnection.this.obtainMessage(262158));
            }
        }

        @Override
        protected void networkStatus(int status, String redirectUrl) {
            if (!TextUtils.isEmpty(redirectUrl)) {
                this.log("validation status: " + status + " with redirection URL: " + redirectUrl);
                Message msg = DataConnection.this.mDct.obtainMessage(270380, redirectUrl);
                msg.sendToTarget();
            }
        }
    }

    private class DcDisconnectionErrorCreatingConnection
    extends State {
        private DcDisconnectionErrorCreatingConnection() {
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262147: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    if (cp.mTag == DataConnection.this.mTag) {
                        String str = "DcDisconnectionErrorCreatingConnection msg.what=EVENT_DEACTIVATE_DONE";
                        DataConnection.this.log(str);
                        if (cp.mApnContext != null) {
                            cp.mApnContext.requestLog(str);
                        }
                        DataConnection.this.mInactiveState.setEnterNotificationParams(cp, DcFailCause.UNACCEPTABLE_NETWORK_PARAMETER);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectionErrorCreatingConnection stale EVENT_DEACTIVATE_DONE dp.tag=" + cp.mTag + ", mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcDisconnectionErrorCreatingConnection not handled msg.what=" + DataConnection.this.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcDisconnectingState
    extends State {
        private DcDisconnectingState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    DataConnection.this.log("DcDisconnectingState msg.what=EVENT_CONNECT. Defer. RefCount = " + DataConnection.this.mApnContexts.size());
                    DataConnection.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262147: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    DisconnectParams dp = (DisconnectParams)ar.userObj;
                    String str = "DcDisconnectingState msg.what=EVENT_DEACTIVATE_DONE RefCount=" + DataConnection.this.mApnContexts.size();
                    DataConnection.this.log(str);
                    if (dp.mApnContext != null) {
                        dp.mApnContext.requestLog(str);
                    }
                    if (dp.mTag == DataConnection.this.mTag) {
                        DataConnection.this.mInactiveState.setEnterNotificationParams((DisconnectParams)ar.userObj);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectState stale EVENT_DEACTIVATE_DONE dp.tag=" + dp.mTag + " mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcDisconnectingState not handled msg.what=" + DataConnection.this.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcActiveState
    extends State {
        private DcActiveState() {
        }

        @Override
        public void enter() {
            DataConnection.this.log("DcActiveState: enter dc=" + DataConnection.this);
            boolean createNetworkAgent = true;
            if (DataConnection.this.hasMessages(262148) || DataConnection.this.hasMessages(262150) || DataConnection.this.hasDeferredMessages(262148) || DataConnection.this.hasDeferredMessages(262150)) {
                DataConnection.this.log("DcActiveState: skipping notifyAllOfConnected()");
                createNetworkAgent = false;
            } else {
                DataConnection.this.notifyAllOfConnected("connected");
            }
            DataConnection.this.mPhone.getCallTracker().registerForVoiceCallStarted(DataConnection.this.getHandler(), 262159, null);
            DataConnection.this.mPhone.getCallTracker().registerForVoiceCallEnded(DataConnection.this.getHandler(), 262160, null);
            DataConnection.this.mDcController.addActiveDcByCid(DataConnection.this);
            DataConnection.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, DataConnection.this.mNetworkInfo.getReason(), null);
            DataConnection.this.mNetworkInfo.setExtraInfo(((DataConnection)DataConnection.this).mApnSetting.apn);
            DataConnection.this.updateTcpBufferSizes(DataConnection.this.mRilRat);
            NetworkMisc misc = new NetworkMisc();
            CarrierSignalAgent carrierSignalAgent = DataConnection.this.mPhone.getCarrierSignalAgent();
            if (carrierSignalAgent.hasRegisteredCarrierSignalReceivers()) {
                misc.provisioningNotificationDisabled = true;
            }
            misc.subscriberId = DataConnection.this.mPhone.getSubscriberId();
            if (createNetworkAgent) {
                DataConnection.this.setNetworkRestriction();
                DataConnection.this.mNetworkAgent = new DcNetworkAgent(DataConnection.this.getHandler().getLooper(), DataConnection.this.mPhone.getContext(), "DcNetworkAgent", DataConnection.this.mNetworkInfo, DataConnection.this.makeNetworkCapabilities(), DataConnection.this.mLinkProperties, 50, misc);
            }
        }

        @Override
        public void exit() {
            DataConnection.this.log("DcActiveState: exit dc=" + this);
            String reason = DataConnection.this.mNetworkInfo.getReason();
            if (DataConnection.this.mDcController.isExecutingCarrierChange()) {
                reason = "carrierChange";
            } else if (DataConnection.this.mDisconnectParams != null && ((DataConnection)DataConnection.this).mDisconnectParams.mReason != null) {
                reason = ((DataConnection)DataConnection.this).mDisconnectParams.mReason;
            } else if (DataConnection.this.mDcFailCause != null) {
                reason = DataConnection.this.mDcFailCause.toString();
            }
            DataConnection.this.mPhone.getCallTracker().unregisterForVoiceCallStarted(DataConnection.this.getHandler());
            DataConnection.this.mPhone.getCallTracker().unregisterForVoiceCallEnded(DataConnection.this.getHandler());
            DataConnection.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, reason, DataConnection.this.mNetworkInfo.getExtraInfo());
            if (DataConnection.this.mNetworkAgent != null) {
                DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo);
                DataConnection.this.mNetworkAgent = null;
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 262144: {
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    DataConnection.this.mApnContexts.put(cp.mApnContext, cp);
                    DataConnection.this.log("DcActiveState: EVENT_CONNECT cp=" + cp + " dc=" + DataConnection.this);
                    DataConnection.this.notifyConnectCompleted(cp, DcFailCause.NONE, false);
                    retVal = true;
                    break;
                }
                case 262148: {
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    DataConnection.this.log("DcActiveState: EVENT_DISCONNECT dp=" + dp + " dc=" + DataConnection.this);
                    if (DataConnection.this.mApnContexts.containsKey(dp.mApnContext)) {
                        DataConnection.this.log("DcActiveState msg.what=EVENT_DISCONNECT RefCount=" + DataConnection.this.mApnContexts.size());
                        if (DataConnection.this.mApnContexts.size() == 1) {
                            DataConnection.this.mApnContexts.clear();
                            DataConnection.this.mDisconnectParams = dp;
                            DataConnection.this.mConnectionParams = null;
                            dp.mTag = DataConnection.this.mTag;
                            DataConnection.this.tearDownData(dp);
                            DataConnection.this.transitionTo(DataConnection.this.mDisconnectingState);
                        } else {
                            DataConnection.this.mApnContexts.remove(dp.mApnContext);
                            DataConnection.this.notifyDisconnectCompleted(dp, false);
                        }
                    } else {
                        DataConnection.this.log("DcActiveState ERROR no such apnContext=" + dp.mApnContext + " in this dc=" + DataConnection.this);
                        DataConnection.this.notifyDisconnectCompleted(dp, false);
                    }
                    retVal = true;
                    break;
                }
                case 262150: {
                    DataConnection.this.log("DcActiveState EVENT_DISCONNECT clearing apn contexts, dc=" + DataConnection.this);
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    DataConnection.this.mDisconnectParams = dp;
                    DataConnection.this.mConnectionParams = null;
                    dp.mTag = DataConnection.this.mTag;
                    DataConnection.this.tearDownData(dp);
                    DataConnection.this.transitionTo(DataConnection.this.mDisconnectingState);
                    retVal = true;
                    break;
                }
                case 262153: {
                    DataConnection.this.log("DcActiveState EVENT_LOST_CONNECTION dc=" + DataConnection.this);
                    DataConnection.this.mInactiveState.setEnterNotificationParams(DcFailCause.LOST_CONNECTION);
                    DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    retVal = true;
                    break;
                }
                case 262156: {
                    DataConnection.this.mNetworkInfo.setRoaming(true);
                    if (DataConnection.this.mNetworkAgent != null) {
                        DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo);
                    }
                    retVal = true;
                    break;
                }
                case 262157: {
                    DataConnection.this.mNetworkInfo.setRoaming(false);
                    if (DataConnection.this.mNetworkAgent != null) {
                        DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo);
                    }
                    retVal = true;
                    break;
                }
                case 262158: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        DataConnection.this.log("EVENT_BW_REFRESH_RESPONSE: error ignoring, e=" + ar.exception);
                    } else {
                        ArrayList capInfo = (ArrayList)ar.result;
                        int lceBwDownKbps = (Integer)capInfo.get(0);
                        NetworkCapabilities nc = DataConnection.this.makeNetworkCapabilities();
                        if (DataConnection.this.mPhone.getLceStatus() == 1) {
                            nc.setLinkDownstreamBandwidthKbps(lceBwDownKbps);
                            if (DataConnection.this.mNetworkAgent != null) {
                                DataConnection.this.mNetworkAgent.sendNetworkCapabilities(nc);
                            }
                        }
                    }
                    retVal = true;
                    break;
                }
                case 262159: 
                case 262160: {
                    if (DataConnection.this.updateNetworkInfoSuspendState() && DataConnection.this.mNetworkAgent != null) {
                        DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcActiveState not handled msg.what=" + DataConnection.this.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcActivatingState
    extends State {
        private DcActivatingState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            DataConnection.this.log("DcActivatingState: msg=" + DataConnection.msgToString(msg));
            switch (msg.what) {
                case 262144: 
                case 262155: {
                    DataConnection.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 262145: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    DataCallResponse.SetupResult result = DataConnection.this.onSetupConnectionCompleted(ar);
                    if (result != DataCallResponse.SetupResult.ERR_Stale && DataConnection.this.mConnectionParams != cp) {
                        DataConnection.this.loge("DcActivatingState: WEIRD mConnectionsParams:" + DataConnection.this.mConnectionParams + " != cp:" + cp);
                    }
                    DataConnection.this.log("DcActivatingState onSetupConnectionCompleted result=" + (Object)((Object)result) + " dc=" + DataConnection.this);
                    if (cp.mApnContext != null) {
                        cp.mApnContext.requestLog("onSetupConnectionCompleted result=" + (Object)((Object)result));
                    }
                    switch (result) {
                        case SUCCESS: {
                            DataConnection.this.mDcFailCause = DcFailCause.NONE;
                            DataConnection.this.transitionTo(DataConnection.this.mActiveState);
                            break;
                        }
                        case ERR_BadCommand: {
                            DataConnection.this.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                            break;
                        }
                        case ERR_UnacceptableParameter: {
                            DataConnection.this.tearDownData(cp);
                            DataConnection.this.transitionTo(DataConnection.this.mDisconnectingErrorCreatingConnection);
                            break;
                        }
                        case ERR_GetLastErrorFromRil: {
                            ((DataConnection)DataConnection.this).mPhone.mCi.getLastDataCallFailCause(DataConnection.this.obtainMessage(262146, cp));
                            break;
                        }
                        case ERR_RilError: {
                            long delay = DataConnection.this.getSuggestedRetryDelay(ar);
                            cp.mApnContext.setModemSuggestedDelay(delay);
                            String str = "DcActivatingState: ERR_RilError  delay=" + delay + " result=" + (Object)((Object)result) + " result.isRestartRadioFail=" + result.mFailCause.isRestartRadioFail() + " result.isPermanentFail=" + DataConnection.this.mDct.isPermanentFail(result.mFailCause);
                            DataConnection.this.log(str);
                            if (cp.mApnContext != null) {
                                cp.mApnContext.requestLog(str);
                            }
                            DataConnection.this.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                            break;
                        }
                        case ERR_Stale: {
                            DataConnection.this.loge("DcActivatingState: stale EVENT_SETUP_DATA_CONNECTION_DONE tag:" + cp.mTag + " != mTag:" + DataConnection.this.mTag);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown SetupResult, should not happen");
                        }
                    }
                    retVal = true;
                    break;
                }
                case 262146: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    if (cp.mTag == DataConnection.this.mTag) {
                        int rilFailCause;
                        if (DataConnection.this.mConnectionParams != cp) {
                            DataConnection.this.loge("DcActivatingState: WEIRD mConnectionsParams:" + DataConnection.this.mConnectionParams + " != cp:" + cp);
                        }
                        DcFailCause cause = DcFailCause.UNKNOWN;
                        if (ar.exception == null && (cause = DcFailCause.fromInt(rilFailCause = ((int[])ar.result)[0])) == DcFailCause.NONE) {
                            DataConnection.this.log("DcActivatingState msg.what=EVENT_GET_LAST_FAIL_DONE BAD: error was NONE, change to UNKNOWN");
                            cause = DcFailCause.UNKNOWN;
                        }
                        DataConnection.this.mDcFailCause = cause;
                        DataConnection.this.log("DcActivatingState msg.what=EVENT_GET_LAST_FAIL_DONE cause=" + (Object)((Object)cause) + " dc=" + DataConnection.this);
                        DataConnection.this.mInactiveState.setEnterNotificationParams(cp, cause);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.loge("DcActivatingState: stale EVENT_GET_LAST_FAIL_DONE tag:" + cp.mTag + " != mTag:" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcActivatingState not handled msg.what=" + DataConnection.this.getWhatToString(msg.what) + " RefCount=" + DataConnection.this.mApnContexts.size());
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcInactiveState
    extends State {
        private DcInactiveState() {
        }

        public void setEnterNotificationParams(ConnectionParams cp, DcFailCause cause) {
            DataConnection.this.log("DcInactiveState: setEnterNotificationParams cp,cause");
            DataConnection.this.mConnectionParams = cp;
            DataConnection.this.mDisconnectParams = null;
            DataConnection.this.mDcFailCause = cause;
        }

        public void setEnterNotificationParams(DisconnectParams dp) {
            DataConnection.this.log("DcInactiveState: setEnterNotificationParams dp");
            DataConnection.this.mConnectionParams = null;
            DataConnection.this.mDisconnectParams = dp;
            DataConnection.this.mDcFailCause = DcFailCause.NONE;
        }

        public void setEnterNotificationParams(DcFailCause cause) {
            DataConnection.this.mConnectionParams = null;
            DataConnection.this.mDisconnectParams = null;
            DataConnection.this.mDcFailCause = cause;
        }

        @Override
        public void enter() {
            ++DataConnection.this.mTag;
            DataConnection.this.log("DcInactiveState: enter() mTag=" + DataConnection.this.mTag);
            if (DataConnection.this.mConnectionParams != null) {
                DataConnection.this.log("DcInactiveState: enter notifyConnectCompleted +ALL failCause=" + (Object)((Object)DataConnection.this.mDcFailCause));
                DataConnection.this.notifyConnectCompleted(DataConnection.this.mConnectionParams, DataConnection.this.mDcFailCause, true);
            }
            if (DataConnection.this.mDisconnectParams != null) {
                DataConnection.this.log("DcInactiveState: enter notifyDisconnectCompleted +ALL failCause=" + (Object)((Object)DataConnection.this.mDcFailCause));
                DataConnection.this.notifyDisconnectCompleted(DataConnection.this.mDisconnectParams, true);
            }
            if (DataConnection.this.mDisconnectParams == null && DataConnection.this.mConnectionParams == null && DataConnection.this.mDcFailCause != null) {
                DataConnection.this.log("DcInactiveState: enter notifyAllDisconnectCompleted failCause=" + (Object)((Object)DataConnection.this.mDcFailCause));
                DataConnection.this.notifyAllDisconnectCompleted(DataConnection.this.mDcFailCause);
            }
            DataConnection.this.mDcController.removeActiveDcByCid(DataConnection.this);
            DataConnection.this.clearSettings();
        }

        @Override
        public void exit() {
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 266252: {
                    DataConnection.this.log("DcInactiveState: msg.what=RSP_RESET, ignore we're already reset");
                    retVal = true;
                    break;
                }
                case 262144: {
                    DataConnection.this.log("DcInactiveState: mag.what=EVENT_CONNECT");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    if (DataConnection.this.initConnection(cp)) {
                        DataConnection.this.onConnect(DataConnection.this.mConnectionParams);
                        DataConnection.this.transitionTo(DataConnection.this.mActivatingState);
                    } else {
                        DataConnection.this.log("DcInactiveState: msg.what=EVENT_CONNECT initConnection failed");
                        DataConnection.this.notifyConnectCompleted(cp, DcFailCause.UNACCEPTABLE_NETWORK_PARAMETER, false);
                    }
                    retVal = true;
                    break;
                }
                case 262148: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_DISCONNECT");
                    DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    retVal = true;
                    break;
                }
                case 262150: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_DISCONNECT_ALL");
                    DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj, false);
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcInactiveState nothandled msg.what=" + DataConnection.this.getWhatToString(msg.what));
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class DcDefaultState
    extends State {
        private DcDefaultState() {
        }

        @Override
        public void enter() {
            DataConnection.this.log("DcDefaultState: enter");
            DataConnection.this.mPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(DataConnection.this.getHandler(), 262155, null);
            DataConnection.this.mPhone.getServiceStateTracker().registerForDataRoamingOn(DataConnection.this.getHandler(), 262156, null);
            DataConnection.this.mPhone.getServiceStateTracker().registerForDataRoamingOff(DataConnection.this.getHandler(), 262157, null);
            DataConnection.this.mDcController.addDc(DataConnection.this);
        }

        @Override
        public void exit() {
            DataConnection.this.log("DcDefaultState: exit");
            DataConnection.this.mPhone.getServiceStateTracker().unregisterForDataRegStateOrRatChanged(DataConnection.this.getHandler());
            DataConnection.this.mPhone.getServiceStateTracker().unregisterForDataRoamingOn(DataConnection.this.getHandler());
            DataConnection.this.mPhone.getServiceStateTracker().unregisterForDataRoamingOff(DataConnection.this.getHandler());
            DataConnection.this.mDcController.removeDc(DataConnection.this);
            if (DataConnection.this.mAc != null) {
                DataConnection.this.mAc.disconnected();
                DataConnection.this.mAc = null;
            }
            DataConnection.this.mApnContexts = null;
            DataConnection.this.mReconnectIntent = null;
            DataConnection.this.mDct = null;
            DataConnection.this.mApnSetting = null;
            DataConnection.this.mPhone = null;
            DataConnection.this.mLinkProperties = null;
            DataConnection.this.mLastFailCause = null;
            DataConnection.this.mUserData = null;
            DataConnection.this.mDcController = null;
            DataConnection.this.mDcTesterFailBringUpAll = null;
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal = true;
            DataConnection.this.log("DcDefault msg=" + DataConnection.this.getWhatToString(msg.what) + " RefCount=" + DataConnection.this.mApnContexts.size());
            switch (msg.what) {
                case 69633: {
                    if (DataConnection.this.mAc != null) {
                        DataConnection.this.log("Disconnecting to previous connection mAc=" + DataConnection.this.mAc);
                        DataConnection.this.mAc.replyToMessage(msg, 69634, 3);
                        break;
                    }
                    DataConnection.this.mAc = new AsyncChannel();
                    DataConnection.this.mAc.connected(null, DataConnection.this.getHandler(), msg.replyTo);
                    DataConnection.this.log("DcDefaultState: FULL_CONNECTION reply connected");
                    DataConnection.this.mAc.replyToMessage(msg, 69634, 0, DataConnection.this.mId, "hi");
                    break;
                }
                case 69636: {
                    DataConnection.this.log("DcDefault: CMD_CHANNEL_DISCONNECTED before quiting call dump");
                    DataConnection.this.dumpToLog();
                    DataConnection.this.quit();
                    break;
                }
                case 266240: {
                    boolean val = DataConnection.this.getIsInactive();
                    DataConnection.this.log("REQ_IS_INACTIVE  isInactive=" + val);
                    DataConnection.this.mAc.replyToMessage(msg, 266241, val ? 1 : 0);
                    break;
                }
                case 266242: {
                    int cid = DataConnection.this.getCid();
                    DataConnection.this.log("REQ_GET_CID  cid=" + cid);
                    DataConnection.this.mAc.replyToMessage(msg, 266243, cid);
                    break;
                }
                case 266244: {
                    ApnSetting apnSetting = DataConnection.this.getApnSetting();
                    DataConnection.this.log("REQ_GET_APNSETTING  mApnSetting=" + apnSetting);
                    DataConnection.this.mAc.replyToMessage(msg, 266245, apnSetting);
                    break;
                }
                case 266246: {
                    LinkProperties lp = DataConnection.this.getCopyLinkProperties();
                    DataConnection.this.log("REQ_GET_LINK_PROPERTIES linkProperties" + lp);
                    DataConnection.this.mAc.replyToMessage(msg, 266247, lp);
                    break;
                }
                case 266248: {
                    ProxyInfo proxy = (ProxyInfo)msg.obj;
                    DataConnection.this.log("REQ_SET_LINK_PROPERTIES_HTTP_PROXY proxy=" + proxy);
                    DataConnection.this.setLinkPropertiesHttpProxy(proxy);
                    DataConnection.this.mAc.replyToMessage(msg, 266249);
                    if (DataConnection.this.mNetworkAgent == null) break;
                    DataConnection.this.mNetworkAgent.sendLinkProperties(DataConnection.this.mLinkProperties);
                    break;
                }
                case 266250: {
                    NetworkCapabilities nc = DataConnection.this.getCopyNetworkCapabilities();
                    DataConnection.this.log("REQ_GET_NETWORK_CAPABILITIES networkCapabilities" + nc);
                    DataConnection.this.mAc.replyToMessage(msg, 266251, nc);
                    break;
                }
                case 266252: {
                    DataConnection.this.log("DcDefaultState: msg.what=REQ_RESET");
                    DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    break;
                }
                case 262144: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_CONNECT, fail not expected");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    DataConnection.this.notifyConnectCompleted(cp, DcFailCause.UNKNOWN, false);
                    break;
                }
                case 262148: {
                    DataConnection.this.log("DcDefaultState deferring msg.what=EVENT_DISCONNECT RefCount=" + DataConnection.this.mApnContexts.size());
                    DataConnection.this.deferMessage(msg);
                    break;
                }
                case 262150: {
                    DataConnection.this.log("DcDefaultState deferring msg.what=EVENT_DISCONNECT_ALL RefCount=" + DataConnection.this.mApnContexts.size());
                    DataConnection.this.deferMessage(msg);
                    break;
                }
                case 262152: {
                    DataConnection.this.log("DcDefaultState EVENT_TEAR_DOWN_NOW");
                    ((DataConnection)DataConnection.this).mPhone.mCi.deactivateDataCall(DataConnection.this.mCid, 0, null);
                    break;
                }
                case 262153: {
                    String s = "DcDefaultState ignore EVENT_LOST_CONNECTION tag=" + msg.arg1 + ":mTag=" + DataConnection.this.mTag;
                    DataConnection.this.logAndAddLogRec(s);
                    break;
                }
                case 262155: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Pair drsRatPair = (Pair)ar.result;
                    DataConnection.this.mDataRegState = (Integer)drsRatPair.first;
                    if (DataConnection.this.mRilRat != (Integer)drsRatPair.second) {
                        DataConnection.this.updateTcpBufferSizes((Integer)drsRatPair.second);
                    }
                    DataConnection.this.mRilRat = (Integer)drsRatPair.second;
                    DataConnection.this.log("DcDefaultState: EVENT_DATA_CONNECTION_DRS_OR_RAT_CHANGED drs=" + DataConnection.this.mDataRegState + " mRilRat=" + DataConnection.this.mRilRat);
                    ServiceState ss = DataConnection.this.mPhone.getServiceState();
                    int networkType = ss.getDataNetworkType();
                    DataConnection.this.mNetworkInfo.setSubtype(networkType, TelephonyManager.getNetworkTypeName(networkType));
                    if (DataConnection.this.mNetworkAgent == null) break;
                    DataConnection.this.updateNetworkInfoSuspendState();
                    DataConnection.this.mNetworkAgent.sendNetworkCapabilities(DataConnection.this.makeNetworkCapabilities());
                    DataConnection.this.mNetworkAgent.sendNetworkInfo(DataConnection.this.mNetworkInfo);
                    DataConnection.this.mNetworkAgent.sendLinkProperties(DataConnection.this.mLinkProperties);
                    break;
                }
                case 262156: {
                    DataConnection.this.mNetworkInfo.setRoaming(true);
                    break;
                }
                case 262157: {
                    DataConnection.this.mNetworkInfo.setRoaming(false);
                    break;
                }
                default: {
                    DataConnection.this.log("DcDefaultState: shouldn't happen but ignore msg.what=" + DataConnection.this.getWhatToString(msg.what));
                }
            }
            return retVal;
        }
    }

    public static class UpdateLinkPropertyResult {
        public DataCallResponse.SetupResult setupResult = DataCallResponse.SetupResult.SUCCESS;
        public LinkProperties oldLp;
        public LinkProperties newLp;

        public UpdateLinkPropertyResult(LinkProperties curLp) {
            this.oldLp = curLp;
            this.newLp = curLp;
        }
    }

    public static class DisconnectParams {
        int mTag;
        public ApnContext mApnContext;
        String mReason;
        Message mOnCompletedMsg;

        DisconnectParams(ApnContext apnContext, String reason, Message onCompletedMsg) {
            this.mApnContext = apnContext;
            this.mReason = reason;
            this.mOnCompletedMsg = onCompletedMsg;
        }

        public String toString() {
            return "{mTag=" + this.mTag + " mApnContext=" + this.mApnContext + " mReason=" + this.mReason + " mOnCompletedMsg=" + DataConnection.msgToString(this.mOnCompletedMsg) + "}";
        }
    }

    public static class ConnectionParams {
        int mTag;
        ApnContext mApnContext;
        int mProfileId;
        int mRilRat;
        Message mOnCompletedMsg;
        final int mConnectionGeneration;

        ConnectionParams(ApnContext apnContext, int profileId, int rilRadioTechnology, Message onCompletedMsg, int connectionGeneration) {
            this.mApnContext = apnContext;
            this.mProfileId = profileId;
            this.mRilRat = rilRadioTechnology;
            this.mOnCompletedMsg = onCompletedMsg;
            this.mConnectionGeneration = connectionGeneration;
        }

        public String toString() {
            return "{mTag=" + this.mTag + " mApnContext=" + this.mApnContext + " mProfileId=" + this.mProfileId + " mRat=" + this.mRilRat + " mOnCompletedMsg=" + DataConnection.msgToString(this.mOnCompletedMsg) + "}";
        }
    }
}

