/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

public class SimTlv {
    byte[] mRecord;
    int mTlvOffset;
    int mTlvLength;
    int mCurOffset;
    int mCurDataOffset;
    int mCurDataLength;
    boolean mHasValidTlvObject;

    public SimTlv(byte[] record, int offset, int length) {
        this.mRecord = record;
        this.mTlvOffset = offset;
        this.mTlvLength = length;
        this.mCurOffset = offset;
        this.mHasValidTlvObject = this.parseCurrentTlvObject();
    }

    public boolean nextObject() {
        if (!this.mHasValidTlvObject) {
            return false;
        }
        this.mCurOffset = this.mCurDataOffset + this.mCurDataLength;
        this.mHasValidTlvObject = this.parseCurrentTlvObject();
        return this.mHasValidTlvObject;
    }

    public boolean isValidObject() {
        return this.mHasValidTlvObject;
    }

    public int getTag() {
        if (!this.mHasValidTlvObject) {
            return 0;
        }
        return this.mRecord[this.mCurOffset] & 0xFF;
    }

    public byte[] getData() {
        if (!this.mHasValidTlvObject) {
            return null;
        }
        byte[] ret = new byte[this.mCurDataLength];
        System.arraycopy((byte[])this.mRecord, (int)this.mCurDataOffset, (byte[])ret, (int)0, (int)this.mCurDataLength);
        return ret;
    }

    private boolean parseCurrentTlvObject() {
        block5: {
            try {
                if (this.mRecord[this.mCurOffset] == 0 || (this.mRecord[this.mCurOffset] & 0xFF) == 255) {
                    return false;
                }
                if ((this.mRecord[this.mCurOffset + 1] & 0xFF) < 128) {
                    this.mCurDataLength = this.mRecord[this.mCurOffset + 1] & 0xFF;
                    this.mCurDataOffset = this.mCurOffset + 2;
                    break block5;
                }
                if ((this.mRecord[this.mCurOffset + 1] & 0xFF) == 129) {
                    this.mCurDataLength = this.mRecord[this.mCurOffset + 2] & 0xFF;
                    this.mCurDataOffset = this.mCurOffset + 3;
                    break block5;
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return false;
            }
        }
        return this.mCurDataLength + this.mCurDataOffset <= this.mTlvOffset + this.mTlvLength;
    }
}

