/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.util.BitwiseInputStream;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class RuimRecords
extends IccRecords {
    static final String LOG_TAG = "RuimRecords";
    private boolean mOtaCommited = false;
    private String mMyMobileNumber;
    private String mMin2Min1;
    private String mPrlVersion;
    private byte[] mEFpl = null;
    private byte[] mEFli = null;
    boolean mCsimSpnDisplayCondition = false;
    private String mMdn;
    private String mMin;
    private String mHomeSystemId;
    private String mHomeNetworkId;
    private String mNai;
    private static final int EVENT_GET_IMSI_DONE = 3;
    private static final int EVENT_GET_DEVICE_IDENTITY_DONE = 4;
    private static final int EVENT_GET_ICCID_DONE = 5;
    private static final int EVENT_GET_CDMA_SUBSCRIPTION_DONE = 10;
    private static final int EVENT_UPDATE_DONE = 14;
    private static final int EVENT_GET_SST_DONE = 17;
    private static final int EVENT_GET_ALL_SMS_DONE = 18;
    private static final int EVENT_MARK_SMS_READ_DONE = 19;
    private static final int EVENT_SMS_ON_RUIM = 21;
    private static final int EVENT_GET_SMS_DONE = 22;
    private static final int EVENT_RUIM_REFRESH = 31;

    @Override
    public String toString() {
        return "RuimRecords: " + super.toString() + " m_ota_commited" + this.mOtaCommited + " mMyMobileNumber=" + "xxxx" + " mMin2Min1=" + this.mMin2Min1 + " mPrlVersion=" + this.mPrlVersion + " mEFpl=" + this.mEFpl + " mEFli=" + this.mEFli + " mCsimSpnDisplayCondition=" + this.mCsimSpnDisplayCondition + " mMdn=" + this.mMdn + " mMin=" + this.mMin + " mHomeSystemId=" + this.mHomeSystemId + " mHomeNetworkId=" + this.mHomeNetworkId;
    }

    public RuimRecords(UiccCardApplication app, Context c, CommandsInterface ci) {
        super(app, c, ci);
        this.mAdnCache = new AdnRecordCache(this.mFh);
        this.mRecordsRequested = false;
        this.mRecordsToLoad = 0;
        this.mCi.registerForIccRefresh(this, 31, null);
        this.resetRecords();
        this.mParentApp.registerForReady(this, 1, null);
        this.log("RuimRecords X ctor this=" + this);
    }

    @Override
    public void dispose() {
        this.log("Disposing RuimRecords " + this);
        this.mCi.unregisterForIccRefresh(this);
        this.mParentApp.unregisterForReady(this);
        this.resetRecords();
        super.dispose();
    }

    protected void finalize() {
        this.log("RuimRecords finalized");
    }

    protected void resetRecords() {
        this.mMncLength = -1;
        this.log("setting0 mMncLength" + this.mMncLength);
        this.mIccId = null;
        this.mFullIccId = null;
        this.mAdnCache.reset();
        this.mRecordsRequested = false;
    }

    @Override
    public String getIMSI() {
        return this.mImsi;
    }

    public String getMdnNumber() {
        return this.mMyMobileNumber;
    }

    public String getCdmaMin() {
        return this.mMin2Min1;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    @Override
    public String getNAI() {
        return this.mNai;
    }

    @Override
    public void setVoiceMailNumber(String alphaTag, String voiceNumber, Message onComplete) {
        AsyncResult.forMessage((Message)onComplete).exception = new IccException("setVoiceMailNumber not implemented");
        onComplete.sendToTarget();
        this.loge("method setVoiceMailNumber is not implemented");
    }

    @Override
    public void onRefresh(boolean fileChanged, int[] fileList) {
        if (fileChanged) {
            this.fetchRuimRecords();
        }
    }

    private int adjstMinDigits(int digits) {
        digits = (digits += 111) % 10 == 0 ? digits - 10 : digits;
        digits = digits / 10 % 10 == 0 ? digits - 100 : digits;
        digits = digits / 100 % 10 == 0 ? digits - 1000 : digits;
        return digits;
    }

    public String getRUIMOperatorNumeric() {
        if (this.mImsi == null) {
            return null;
        }
        if (this.mMncLength != -1 && this.mMncLength != 0) {
            return this.mImsi.substring(0, 3 + this.mMncLength);
        }
        int mcc = Integer.parseInt(this.mImsi.substring(0, 3));
        return this.mImsi.substring(0, 3 + MccTable.smallestDigitsMccForMnc(mcc));
    }

    private void onGetCSimEprlDone(AsyncResult ar) {
        byte[] data = (byte[])ar.result;
        this.log("CSIM_EPRL=" + IccUtils.bytesToHexString(data));
        if (data.length > 3) {
            int prlId = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
            this.mPrlVersion = Integer.toString(prlId);
        }
        this.log("CSIM PRL version=" + this.mPrlVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleMessage(Message msg) {
        boolean isRecordLoadResponse = false;
        if (this.mDestroyed.get()) {
            this.loge("Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        try {
            switch (msg.what) {
                case 1: {
                    this.onReady();
                    return;
                }
                case 4: {
                    this.log("Event EVENT_GET_DEVICE_IDENTITY_DONE Received");
                    return;
                }
                case 3: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.loge("Exception querying IMSI, Exception:" + ar.exception);
                        return;
                    } else {
                        this.mImsi = (String)ar.result;
                        if (this.mImsi != null && (this.mImsi.length() < 6 || this.mImsi.length() > 15)) {
                            this.loge("invalid IMSI " + this.mImsi);
                            this.mImsi = null;
                        }
                        String operatorNumeric = this.getRUIMOperatorNumeric();
                        this.log("NO update mccmnc=" + operatorNumeric);
                        return;
                    }
                }
                case 10: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    String[] localTemp = (String[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mMyMobileNumber = localTemp[0];
                        this.mMin2Min1 = localTemp[3];
                        this.mPrlVersion = localTemp[4];
                        this.log("MDN: " + this.mMyMobileNumber + " MIN: " + this.mMin2Min1);
                        return;
                    }
                }
                case 5: {
                    isRecordLoadResponse = true;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        return;
                    } else {
                        this.mIccId = IccUtils.bcdToString(data, 0, data.length);
                        this.mFullIccId = IccUtils.bchToString(data, 0, data.length);
                        this.log("iccid: " + SubscriptionInfo.givePrintableIccid(this.mFullIccId));
                        return;
                    }
                }
                case 14: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) return;
                    Rlog.i(LOG_TAG, "RuimRecords update failed", ar.exception);
                    return;
                }
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    Rlog.w(LOG_TAG, "Event not supported: " + msg.what);
                    return;
                }
                case 17: {
                    this.log("Event EVENT_GET_SST_DONE Received");
                    return;
                }
                case 31: {
                    isRecordLoadResponse = false;
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) return;
                    this.handleRuimRefresh((IccRefreshResponse)ar.result);
                    return;
                }
                default: {
                    super.handleMessage(msg);
                    return;
                }
            }
        }
        catch (RuntimeException exc) {
            Rlog.w(LOG_TAG, "Exception parsing RUIM record", exc);
            return;
        }
        finally {
            if (isRecordLoadResponse) {
                this.onRecordLoaded();
            }
        }
    }

    private static String[] getAssetLanguages(Context ctx) {
        String[] locales = ctx.getAssets().getLocales();
        String[] localeLangs = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            String localeStr = locales[i];
            int separator = localeStr.indexOf(45);
            localeLangs[i] = separator < 0 ? localeStr : localeStr.substring(0, separator);
        }
        return localeLangs;
    }

    @Override
    protected void onRecordLoaded() {
        --this.mRecordsToLoad;
        this.log("onRecordLoaded " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
        if (this.mRecordsToLoad == 0 && this.mRecordsRequested) {
            this.onAllRecordsLoaded();
        } else if (this.mRecordsToLoad < 0) {
            this.loge("recordsToLoad <0, programmer error suspected");
            this.mRecordsToLoad = 0;
        }
    }

    @Override
    protected void onAllRecordsLoaded() {
        this.log("record load complete");
        Resources resource = Resources.getSystem();
        if (resource.getBoolean(17957021)) {
            this.setSimLanguage(this.mEFli, this.mEFpl);
        }
        this.mRecordsLoadedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        if (!TextUtils.isEmpty(this.mMdn)) {
            int phoneId = this.mParentApp.getUiccCard().getPhoneId();
            int[] subIds = SubscriptionController.getInstance().getSubId(phoneId);
            if (subIds != null) {
                SubscriptionManager.from(this.mContext).setDisplayNumber(this.mMdn, subIds[0]);
            } else {
                this.log("Cannot call setDisplayNumber: invalid subId");
            }
        }
    }

    @Override
    public void onReady() {
        this.fetchRuimRecords();
        this.mCi.getCDMASubscription(this.obtainMessage(10));
    }

    private void fetchRuimRecords() {
        this.mRecordsRequested = true;
        this.log("fetchRuimRecords " + this.mRecordsToLoad);
        this.mCi.getIMSIForApp(this.mParentApp.getAid(), this.obtainMessage(3));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(12258, this.obtainMessage(5));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(12037, this.obtainMessage(100, new EfPlLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28474, this.obtainMessage(100, new EfCsimLiLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28481, this.obtainMessage(100, new EfCsimSpnLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixed(28484, 1, this.obtainMessage(100, new EfCsimMdnLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28450, this.obtainMessage(100, new EfCsimImsimLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFLinearFixedAll(28456, this.obtainMessage(100, new EfCsimCdmaHomeLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28506, 4, this.obtainMessage(100, new EfCsimEprlLoaded()));
        ++this.mRecordsToLoad;
        this.mFh.loadEFTransparent(28493, this.obtainMessage(100, new EfCsimMipUppLoaded()));
        ++this.mRecordsToLoad;
        this.log("fetchRuimRecords " + this.mRecordsToLoad + " requested: " + this.mRecordsRequested);
    }

    @Override
    public int getDisplayRule(String plmn) {
        return 0;
    }

    @Override
    public boolean isProvisioned() {
        if (SystemProperties.getBoolean("persist.radio.test-csim", false)) {
            return true;
        }
        if (this.mParentApp == null) {
            return false;
        }
        return this.mParentApp.getType() != IccCardApplicationStatus.AppType.APPTYPE_CSIM || this.mMdn != null && this.mMin != null;
    }

    @Override
    public void setVoiceMessageWaiting(int line, int countWaiting) {
        this.log("RuimRecords:setVoiceMessageWaiting - NOP for CDMA");
    }

    @Override
    public int getVoiceMessageCount() {
        this.log("RuimRecords:getVoiceMessageCount - NOP for CDMA");
        return 0;
    }

    private void handleRuimRefresh(IccRefreshResponse refreshResponse) {
        if (refreshResponse == null) {
            this.log("handleRuimRefresh received without input");
            return;
        }
        if (refreshResponse.aid != null && !refreshResponse.aid.equals(this.mParentApp.getAid())) {
            return;
        }
        switch (refreshResponse.refreshResult) {
            case 0: {
                this.log("handleRuimRefresh with SIM_REFRESH_FILE_UPDATED");
                this.mAdnCache.reset();
                this.fetchRuimRecords();
                break;
            }
            case 1: {
                this.log("handleRuimRefresh with SIM_REFRESH_INIT");
                this.onIccRefreshInit();
                break;
            }
            case 2: {
                this.log("handleRuimRefresh with SIM_REFRESH_RESET");
                break;
            }
            default: {
                this.log("handleRuimRefresh with unknown operation");
            }
        }
    }

    public String getMdn() {
        return this.mMdn;
    }

    public String getMin() {
        return this.mMin;
    }

    public String getSid() {
        return this.mHomeSystemId;
    }

    public String getNid() {
        return this.mHomeNetworkId;
    }

    public boolean getCsimSpnDisplayCondition() {
        return this.mCsimSpnDisplayCondition;
    }

    @Override
    protected void log(String s) {
        Rlog.d(LOG_TAG, "[RuimRecords] " + s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e(LOG_TAG, "[RuimRecords] " + s);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("RuimRecords: " + this);
        pw.println(" extends:");
        super.dump(fd, pw, args);
        pw.println(" mOtaCommited=" + this.mOtaCommited);
        pw.println(" mMyMobileNumber=" + this.mMyMobileNumber);
        pw.println(" mMin2Min1=" + this.mMin2Min1);
        pw.println(" mPrlVersion=" + this.mPrlVersion);
        pw.println(" mEFpl[]=" + Arrays.toString(this.mEFpl));
        pw.println(" mEFli[]=" + Arrays.toString(this.mEFli));
        pw.println(" mCsimSpnDisplayCondition=" + this.mCsimSpnDisplayCondition);
        pw.println(" mMdn=" + this.mMdn);
        pw.println(" mMin=" + this.mMin);
        pw.println(" mHomeSystemId=" + this.mHomeSystemId);
        pw.println(" mHomeNetworkId=" + this.mHomeNetworkId);
        pw.flush();
    }

    static /* synthetic */ byte[] access$002(RuimRecords x0, byte[] x1) {
        x0.mEFpl = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(RuimRecords x0, byte[] x1) {
        x0.mEFli = x1;
        return x1;
    }

    private class EfCsimMipUppLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimMipUppLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_CSIM_MIPUPP";
        }

        boolean checkLengthLegal(int length, int expectLength) {
            if (length < expectLength) {
                Log.e(RuimRecords.LOG_TAG, "CSIM MIPUPP format error, length = " + length + "expected length at least =" + expectLength);
                return false;
            }
            return true;
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            if (data.length < 1) {
                Log.e(RuimRecords.LOG_TAG, "MIPUPP read error");
                return;
            }
            BitwiseInputStream bitStream = new BitwiseInputStream(data);
            try {
                int mipUppLength = bitStream.read(8);
                if (!this.checkLengthLegal(mipUppLength <<= 3, 1)) {
                    return;
                }
                int retryInfoInclude = bitStream.read(1);
                --mipUppLength;
                if (retryInfoInclude == 1) {
                    if (!this.checkLengthLegal(mipUppLength, 11)) {
                        return;
                    }
                    bitStream.skip(11);
                    mipUppLength -= 11;
                }
                if (!this.checkLengthLegal(mipUppLength, 4)) {
                    return;
                }
                int numNai = bitStream.read(4);
                mipUppLength -= 4;
                for (int index = 0; index < numNai; ++index) {
                    if (!this.checkLengthLegal(mipUppLength, 4)) {
                        return;
                    }
                    int naiEntryIndex = bitStream.read(4);
                    if (!this.checkLengthLegal(mipUppLength -= 4, 8)) {
                        return;
                    }
                    int naiLength = bitStream.read(8);
                    mipUppLength -= 8;
                    if (naiEntryIndex == 0) {
                        if (!this.checkLengthLegal(mipUppLength, naiLength << 3)) {
                            return;
                        }
                        char[] naiCharArray = new char[naiLength];
                        for (int index1 = 0; index1 < naiLength; ++index1) {
                            naiCharArray[index1] = (char)(bitStream.read(8) & 0xFF);
                        }
                        RuimRecords.this.mNai = new String(naiCharArray);
                        if (Log.isLoggable(RuimRecords.LOG_TAG, 2)) {
                            Log.v(RuimRecords.LOG_TAG, "MIPUPP Nai = " + RuimRecords.this.mNai);
                        }
                        return;
                    }
                    if (!this.checkLengthLegal(mipUppLength, (naiLength << 3) + 102)) {
                        return;
                    }
                    bitStream.skip((naiLength << 3) + 101);
                    int mnAaaSpiIndicator = bitStream.read(1);
                    mipUppLength -= (naiLength << 3) + 102;
                    if (mnAaaSpiIndicator == 1) {
                        if (!this.checkLengthLegal(mipUppLength, 32)) {
                            return;
                        }
                        bitStream.skip(32);
                        mipUppLength -= 32;
                    }
                    if (!this.checkLengthLegal(mipUppLength, 5)) {
                        return;
                    }
                    bitStream.skip(4);
                    mipUppLength -= 4;
                    int mnHaSpiIndicator = bitStream.read(1);
                    --mipUppLength;
                    if (mnHaSpiIndicator != 1) continue;
                    if (!this.checkLengthLegal(mipUppLength, 32)) {
                        return;
                    }
                    bitStream.skip(32);
                    mipUppLength -= 32;
                }
            }
            catch (Exception e) {
                Log.e(RuimRecords.LOG_TAG, "MIPUPP read Exception error!");
                return;
            }
        }
    }

    private class EfCsimEprlLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimEprlLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_CSIM_EPRL";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            RuimRecords.this.onGetCSimEprlDone(ar);
        }
    }

    private class EfCsimCdmaHomeLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimCdmaHomeLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_CSIM_CDMAHOME";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            ArrayList dataList = (ArrayList)ar.result;
            RuimRecords.this.log("CSIM_CDMAHOME data size=" + dataList.size());
            if (dataList.isEmpty()) {
                return;
            }
            StringBuilder sidBuf = new StringBuilder();
            StringBuilder nidBuf = new StringBuilder();
            for (byte[] data : dataList) {
                if (data.length != 5) continue;
                int sid = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
                int nid = (data[3] & 0xFF) << 8 | data[2] & 0xFF;
                sidBuf.append(sid).append(',');
                nidBuf.append(nid).append(',');
            }
            sidBuf.setLength(sidBuf.length() - 1);
            nidBuf.setLength(nidBuf.length() - 1);
            RuimRecords.this.mHomeSystemId = sidBuf.toString();
            RuimRecords.this.mHomeNetworkId = nidBuf.toString();
        }
    }

    private class EfCsimImsimLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimImsimLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_CSIM_IMSIM";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            boolean provisioned;
            byte[] data = (byte[])ar.result;
            boolean bl = provisioned = (data[7] & 0x80) == 128;
            if (provisioned) {
                int first3digits = ((3 & data[2]) << 8) + (0xFF & data[1]);
                int second3digits = ((0xFF & data[5]) << 8 | 0xFF & data[4]) >> 6;
                int digit7 = 0xF & data[4] >> 2;
                if (digit7 > 9) {
                    digit7 = 0;
                }
                int last3digits = (3 & data[4]) << 8 | 0xFF & data[3];
                first3digits = RuimRecords.this.adjstMinDigits(first3digits);
                second3digits = RuimRecords.this.adjstMinDigits(second3digits);
                last3digits = RuimRecords.this.adjstMinDigits(last3digits);
                StringBuilder builder = new StringBuilder();
                builder.append(String.format(Locale.US, "%03d", first3digits));
                builder.append(String.format(Locale.US, "%03d", second3digits));
                builder.append(String.format(Locale.US, "%d", digit7));
                builder.append(String.format(Locale.US, "%03d", last3digits));
                RuimRecords.this.mMin = builder.toString();
                RuimRecords.this.log("min present=" + RuimRecords.this.mMin);
            } else {
                RuimRecords.this.log("min not present");
            }
        }
    }

    private class EfCsimMdnLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimMdnLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_CSIM_MDN";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            byte[] data = (byte[])ar.result;
            RuimRecords.this.log("CSIM_MDN=" + IccUtils.bytesToHexString(data));
            int mdnDigitsNum = 0xF & data[0];
            RuimRecords.this.mMdn = IccUtils.cdmaBcdToString(data, 1, mdnDigitsNum);
            RuimRecords.this.log("CSIM MDN=" + RuimRecords.this.mMdn);
        }
    }

    private class EfCsimSpnLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimSpnLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_CSIM_SPN";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            int numBytes;
            byte[] data = (byte[])ar.result;
            RuimRecords.this.log("CSIM_SPN=" + IccUtils.bytesToHexString(data));
            RuimRecords.this.mCsimSpnDisplayCondition = (1 & data[0]) != 0;
            byte encoding = data[1];
            byte language = data[2];
            byte[] spnData = new byte[32];
            int len = data.length - 3 < 32 ? data.length - 3 : 32;
            System.arraycopy((byte[])data, (int)3, (byte[])spnData, (int)0, (int)len);
            for (numBytes = 0; numBytes < spnData.length && (spnData[numBytes] & 0xFF) != 255; ++numBytes) {
            }
            if (numBytes == 0) {
                RuimRecords.this.setServiceProviderName("");
                return;
            }
            try {
                switch (encoding) {
                    case 0: 
                    case 8: {
                        RuimRecords.this.setServiceProviderName(new String(spnData, 0, numBytes, "ISO-8859-1"));
                        break;
                    }
                    case 3: 
                    case 9: {
                        RuimRecords.this.setServiceProviderName(GsmAlphabet.gsm7BitPackedToString(spnData, 0, numBytes * 8 / 7));
                        break;
                    }
                    case 2: {
                        String spn = new String(spnData, 0, numBytes, "US-ASCII");
                        if (TextUtils.isPrintableAsciiOnly(spn)) {
                            RuimRecords.this.setServiceProviderName(spn);
                            break;
                        }
                        RuimRecords.this.log("Some corruption in SPN decoding = " + spn);
                        RuimRecords.this.log("Using ENCODING_GSM_7BIT_ALPHABET scheme...");
                        RuimRecords.this.setServiceProviderName(GsmAlphabet.gsm7BitPackedToString(spnData, 0, numBytes * 8 / 7));
                        break;
                    }
                    case 4: {
                        RuimRecords.this.setServiceProviderName(new String(spnData, 0, numBytes, "utf-16"));
                        break;
                    }
                    default: {
                        RuimRecords.this.log("SPN encoding not supported");
                        break;
                    }
                }
            }
            catch (Exception e) {
                RuimRecords.this.log("spn decode error: " + e);
            }
            RuimRecords.this.log("spn=" + RuimRecords.this.getServiceProviderName());
            RuimRecords.this.log("spnCondition=" + RuimRecords.this.mCsimSpnDisplayCondition);
            RuimRecords.this.mTelephonyManager.setSimOperatorNameForPhone(RuimRecords.this.mParentApp.getPhoneId(), RuimRecords.this.getServiceProviderName());
        }
    }

    private class EfCsimLiLoaded
    implements IccRecords.IccRecordLoaded {
        private EfCsimLiLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_CSIM_LI";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            RuimRecords.access$102(RuimRecords.this, (byte[])ar.result);
            block9: for (int i = 0; i < RuimRecords.this.mEFli.length; i += 2) {
                switch (RuimRecords.this.mEFli[i + 1]) {
                    case 1: {
                        ((RuimRecords)RuimRecords.this).mEFli[i] = 101;
                        ((RuimRecords)RuimRecords.this).mEFli[i + 1] = 110;
                        continue block9;
                    }
                    case 2: {
                        ((RuimRecords)RuimRecords.this).mEFli[i] = 102;
                        ((RuimRecords)RuimRecords.this).mEFli[i + 1] = 114;
                        continue block9;
                    }
                    case 3: {
                        ((RuimRecords)RuimRecords.this).mEFli[i] = 101;
                        ((RuimRecords)RuimRecords.this).mEFli[i + 1] = 115;
                        continue block9;
                    }
                    case 4: {
                        ((RuimRecords)RuimRecords.this).mEFli[i] = 106;
                        ((RuimRecords)RuimRecords.this).mEFli[i + 1] = 97;
                        continue block9;
                    }
                    case 5: {
                        ((RuimRecords)RuimRecords.this).mEFli[i] = 107;
                        ((RuimRecords)RuimRecords.this).mEFli[i + 1] = 111;
                        continue block9;
                    }
                    case 6: {
                        ((RuimRecords)RuimRecords.this).mEFli[i] = 122;
                        ((RuimRecords)RuimRecords.this).mEFli[i + 1] = 104;
                        continue block9;
                    }
                    case 7: {
                        ((RuimRecords)RuimRecords.this).mEFli[i] = 104;
                        ((RuimRecords)RuimRecords.this).mEFli[i + 1] = 101;
                        continue block9;
                    }
                    default: {
                        ((RuimRecords)RuimRecords.this).mEFli[i] = 32;
                        ((RuimRecords)RuimRecords.this).mEFli[i + 1] = 32;
                    }
                }
            }
            RuimRecords.this.log("EF_LI=" + IccUtils.bytesToHexString(RuimRecords.this.mEFli));
        }
    }

    private class EfPlLoaded
    implements IccRecords.IccRecordLoaded {
        private EfPlLoaded() {
        }

        @Override
        public String getEfName() {
            return "EF_PL";
        }

        @Override
        public void onRecordLoaded(AsyncResult ar) {
            RuimRecords.access$002(RuimRecords.this, (byte[])ar.result);
            RuimRecords.this.log("EF_PL=" + IccUtils.bytesToHexString(RuimRecords.this.mEFpl));
        }
    }
}

