/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.inputmethodservice.AbstractInputMethodService;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionInspector;
import android.view.inputmethod.InputContentInfo;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputContextCallback;
import java.lang.ref.WeakReference;

public class InputConnectionWrapper
implements InputConnection {
    private static final int MAX_WAIT_TIME_MILLIS = 2000;
    private final IInputContext mIInputContext;
    private final WeakReference<AbstractInputMethodService> mInputMethodService;
    private final int mMissingMethods;

    public InputConnectionWrapper(WeakReference<AbstractInputMethodService> inputMethodService, IInputContext inputContext, int missingMethods) {
        this.mInputMethodService = inputMethodService;
        this.mIInputContext = inputContext;
        this.mMissingMethods = missingMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getTextAfterCursor(int length, int flags) {
        CharSequence value = null;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getTextAfterCursor(length, flags, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mTextAfterCursor;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getTextBeforeCursor(int length, int flags) {
        CharSequence value = null;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getTextBeforeCursor(length, flags, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mTextBeforeCursor;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getSelectedText(int flags) {
        if (this.isMethodMissing(1)) {
            return null;
        }
        CharSequence value = null;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getSelectedText(flags, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mSelectedText;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCursorCapsMode(int reqModes) {
        int value = 0;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getCursorCapsMode(reqModes, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mCursorCapsMode;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return 0;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText value = null;
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.getExtractedText(request, flags, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    value = callback.mExtractedText;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return null;
        }
        return value;
    }

    @Override
    public boolean commitText(CharSequence text, int newCursorPosition) {
        try {
            this.mIInputContext.commitText(text, newCursorPosition);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean commitCompletion(CompletionInfo text) {
        if (this.isMethodMissing(4)) {
            return false;
        }
        try {
            this.mIInputContext.commitCompletion(text);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        try {
            this.mIInputContext.commitCorrection(correctionInfo);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setSelection(int start, int end) {
        try {
            this.mIInputContext.setSelection(start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean performEditorAction(int actionCode) {
        try {
            this.mIInputContext.performEditorAction(actionCode);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean performContextMenuAction(int id2) {
        try {
            this.mIInputContext.performContextMenuAction(id2);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setComposingRegion(int start, int end) {
        if (this.isMethodMissing(2)) {
            return false;
        }
        try {
            this.mIInputContext.setComposingRegion(start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        try {
            this.mIInputContext.setComposingText(text, newCursorPosition);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean finishComposingText() {
        try {
            this.mIInputContext.finishComposingText();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean beginBatchEdit() {
        try {
            this.mIInputContext.beginBatchEdit();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean endBatchEdit() {
        try {
            this.mIInputContext.endBatchEdit();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean sendKeyEvent(KeyEvent event) {
        try {
            this.mIInputContext.sendKeyEvent(event);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean clearMetaKeyStates(int states) {
        try {
            this.mIInputContext.clearMetaKeyStates(states);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        try {
            this.mIInputContext.deleteSurroundingText(beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        if (this.isMethodMissing(16)) {
            return false;
        }
        try {
            this.mIInputContext.deleteSurroundingTextInCodePoints(beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean reportFullscreenMode(boolean enabled) {
        try {
            this.mIInputContext.reportFullscreenMode(enabled);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean performPrivateCommand(String action, Bundle data) {
        try {
            this.mIInputContext.performPrivateCommand(action, data);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestCursorUpdates(int cursorUpdateMode) {
        boolean result = false;
        if (this.isMethodMissing(8)) {
            return false;
        }
        try {
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.requestUpdateCursorAnchorInfo(cursorUpdateMode, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    result = callback.mRequestUpdateCursorAnchorInfoResult;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return false;
        }
        return result;
    }

    @Override
    public Handler getHandler() {
        return null;
    }

    @Override
    public void closeConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts) {
        boolean result = false;
        if (this.isMethodMissing(128)) {
            return false;
        }
        try {
            if ((flags & 1) != 0) {
                AbstractInputMethodService inputMethodService = (AbstractInputMethodService)this.mInputMethodService.get();
                if (inputMethodService == null) {
                    return false;
                }
                inputMethodService.exposeContent(inputContentInfo, this);
            }
            InputContextCallback callback = InputContextCallback.getInstance();
            this.mIInputContext.commitContent(inputContentInfo, flags, opts, callback.mSeq, callback);
            InputContextCallback inputContextCallback = callback;
            synchronized (inputContextCallback) {
                callback.waitForResultLocked();
                if (callback.mHaveValue) {
                    result = callback.mCommitContentResult;
                }
            }
            callback.dispose();
        }
        catch (RemoteException e) {
            return false;
        }
        return result;
    }

    private boolean isMethodMissing(int methodFlag) {
        return (this.mMissingMethods & methodFlag) == methodFlag;
    }

    public String toString() {
        return "InputConnectionWrapper{idHash=#" + Integer.toHexString(System.identityHashCode(this)) + " mMissingMethods=" + InputConnectionInspector.getMissingMethodFlagsAsString(this.mMissingMethods) + "}";
    }

    static class InputContextCallback
    extends IInputContextCallback.Stub {
        private static final String TAG = "InputConnectionWrapper.ICC";
        public int mSeq;
        public boolean mHaveValue;
        public CharSequence mTextBeforeCursor;
        public CharSequence mTextAfterCursor;
        public CharSequence mSelectedText;
        public ExtractedText mExtractedText;
        public int mCursorCapsMode;
        public boolean mRequestUpdateCursorAnchorInfoResult;
        public boolean mCommitContentResult;
        private static InputContextCallback sInstance = new InputContextCallback();
        private static int sSequenceNumber = 1;

        InputContextCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static InputContextCallback getInstance() {
            Class<InputContextCallback> clazz = InputContextCallback.class;
            synchronized (InputContextCallback.class) {
                InputContextCallback callback;
                if (sInstance != null) {
                    callback = sInstance;
                    sInstance = null;
                    callback.mHaveValue = false;
                } else {
                    callback = new InputContextCallback();
                }
                callback.mSeq = sSequenceNumber++;
                // ** MonitorExit[var0] (shouldn't be in output)
                return callback;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            Class<InputContextCallback> clazz = InputContextCallback.class;
            synchronized (InputContextCallback.class) {
                if (sInstance == null) {
                    this.mTextAfterCursor = null;
                    this.mTextBeforeCursor = null;
                    this.mExtractedText = null;
                    sInstance = this;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTextBeforeCursor(CharSequence textBeforeCursor, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mTextBeforeCursor = textBeforeCursor;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setTextBeforeCursor, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTextAfterCursor(CharSequence textAfterCursor, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mTextAfterCursor = textAfterCursor;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setTextAfterCursor, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSelectedText(CharSequence selectedText, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mSelectedText = selectedText;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setSelectedText, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCursorCapsMode(int capsMode, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mCursorCapsMode = capsMode;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setCursorCapsMode, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setExtractedText(ExtractedText extractedText, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mExtractedText = extractedText;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setExtractedText, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setRequestUpdateCursorAnchorInfoResult(boolean result, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mRequestUpdateCursorAnchorInfoResult = result;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setCursorAnchorInfoRequestResult, ignoring.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCommitContentResult(boolean result, int seq) {
            InputContextCallback inputContextCallback = this;
            synchronized (inputContextCallback) {
                if (seq == this.mSeq) {
                    this.mCommitContentResult = result;
                    this.mHaveValue = true;
                    this.notifyAll();
                } else {
                    Log.i(TAG, "Got out-of-sequence callback " + seq + " (expected " + this.mSeq + ") in setCommitContentResult, ignoring.");
                }
            }
        }

        void waitForResultLocked() {
            long startTime = SystemClock.uptimeMillis();
            long endTime = startTime + 2000L;
            while (!this.mHaveValue) {
                long remainingTime = endTime - SystemClock.uptimeMillis();
                if (remainingTime <= 0L) {
                    Log.w(TAG, "Timed out waiting on IInputContextCallback");
                    return;
                }
                try {
                    this.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

